/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.history;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.help.HelpSource;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.gui.FindProductListener;
import com.ibm.nzna.projects.qit.product.gui.ProductSearchDlg;
import com.ibm.nzna.projects.qit.product.history.ProductHistoryNavPanel;
import com.ibm.nzna.projects.qit.product.productEdit.ProductEditPanel;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ProductHistoryPanel
extends JPanel
implements QuestPanel,
ActionListener,
FindProductListener,
ProductConst,
AppConst,
Runnable,
HelpSource {
    private static final String THREAD_REFRESH_PREVIEW = "RP";
    private static final String timestamp = "CURRENT TIMESTAMP";
    private ToolBarButton pb_FIND = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_RESTORE = null;
    private ProductHistoryNavPanel productHistoryNavPanel = null;
    private JToolBar toolBar = null;
    private String commentHistory = null;
    private boolean draft = false;
    private boolean showChanges = false;
    private int startProdInd = 0;
    private boolean startDraft = false;
    private QuestPanel previousPanel = null;
    private ProductEditPanel editPanel = null;
    private ProductDraft productDraft = null;

    public boolean initialize() {
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_RESTORE = new ActionButton(Str.getStr(868), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(18005));
        this.productHistoryNavPanel = new ProductHistoryNavPanel(this);
        this.pb_FIND = new ToolBarButton(Str.getStr(470), ImageSystem.getImageIcon((Object)this, 7), Str.getStr(470));
        this.toolBar = new JToolBar();
        this.editPanel = new ProductEditPanel();
        this.pb_FIND.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_RESTORE.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.toolBar.add(this.pb_FIND);
        this.add(this.editPanel);
        this.toolBar.setBorder(null);
        this.toolBar.setOpaque(false);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Qit.getEnabled() && actionEvent.getSource() instanceof DButton) {
            DButton dButton = (DButton)actionEvent.getSource();
            if (dButton == this.pb_FIND) {
                this.findProductComplete(new ProductSearchDlg().getResult());
            } else if (dButton == this.pb_CLOSE) {
                GUISystem.getParentDefWin(this).closePanel(this, this.previousPanel);
            } else if (dButton == this.pb_RESTORE) {
                this.restore();
            }
        }
    }

    public void refresh() {
        new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = Thread.currentThread().getName();
        Qit.setEnabled(false);
        try {
            if (string.equals(THREAD_REFRESH_PREVIEW)) {
                this.refreshPreview();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        Qit.setEnabled(true);
    }

    public void findProductComplete(Vector vector) {
        ProductRow productRow = null;
        int n = 0;
        if (vector != null && vector.size() > 0 && (n = (productRow = (ProductRow)vector.elementAt(0)).readProduct(true)) == 0) {
            if (productRow.isDraft()) {
                ProductDraft productDraft = (ProductDraft)productRow.getProduct();
                this.productHistoryNavPanel.setProdInd(productDraft.getExistingProductInd(), false);
            } else if (!productRow.isDraft()) {
                Product product = productRow.getProduct();
                this.productHistoryNavPanel.setProdInd(product.getProductInd(), true);
            }
        }
    }

    public void setProduct(ProductDraft productDraft) {
        this.productDraft = productDraft;
        if (productDraft != null) {
            new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
        }
    }

    private final void refreshPreview() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        if (this.productDraft != null) {
            appDefaultWin.setStatus(14);
            this.editPanel.setEditable(false);
            this.editPanel.setProduct(this.productDraft);
        }
        appDefaultWin.setStatus(Str.getStr(1582), 2);
    }

    public void panelDeselected() {
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
    }

    public void panelSelected() {
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 1);
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public JComponent getJComponent() {
        return this;
    }

    public NavPanel getDefaultNavPanel() {
        return this.productHistoryNavPanel;
    }

    public boolean stop() {
        this.panelDeselected();
        this.removeAll();
        return Qit.getEnabled();
    }

    public boolean shutdown() {
        return Qit.getEnabled();
    }

    public void start() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        appDefaultWin.addActionComponent(this, this.pb_CLOSE);
        appDefaultWin.addActionComponent(this, this.pb_RESTORE);
        appDefaultWin.addToolbarButton(this.toolBar, 1);
        if (this.startProdInd != 0) {
            this.productHistoryNavPanel.setProdInd(this.startProdInd, this.startDraft);
        }
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 240);
    }

    public String getName() {
        return Str.getStr(18000);
    }

    public boolean bookmark() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void restore() {
        GUISystem.getParentDefWin(this).setStatus(1315);
        if (this.productDraft != null) {
            SQLMethod sQLMethod;
            block7: {
                sQLMethod = new SQLMethod(1, "ProductHistoryPanel.restore", 5);
                boolean bl = false;
                boolean bl2 = false;
                try {
                    Statement statement = sQLMethod.createStatement();
                    String string = null;
                    String string2 = null;
                    if (statement == null) break block7;
                    ResultSet resultSet = statement.executeQuery("SELECT LASTTOUCHEDBY, LASTTOUCHEDON " + "FROM PRODRAFT.PRODUCT " + "WHERE STOPDATE IS NULL AND " + "EXISTINGPRODUCTIND = " + this.productHistoryNavPanel.getProdInd());
                    if (resultSet.next()) {
                        string2 = resultSet.getString(1).trim();
                        String string3 = DateSystem.prettyDateFromStamp(resultSet.getString(2).trim());
                        GUISystem.printBox(Str.getStr(7), Str.getStr(18002) + " " + string2 + " " + Str.getStr(267) + " " + string3);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    resultSet.close();
                    if (bl) {
                        resultSet = statement.executeQuery("SELECT COMMENTS " + "FROM PRODRAFT.PRODUCT " + "WHERE PRODUCTIND = " + this.productDraft.getProductInd());
                        string = resultSet.next() ? resultSet.getString(1).trim() : "";
                        resultSet.close();
                        string = string + "\n<" + Str.getStr(18003) + " " + Str.getStr(266) + " " + UserSystem.getUserId() + " " + Str.getStr(267) + " " + DateSystem.getDate(2) + ">\n";
                        statement.executeUpdate("UPDATE PRODRAFT.PRODUCT " + "SET   STOPDATE      = NULL, " + "      COMMENTS       = '" + string + "', " + "      LASTTOUCHEDBY = '" + UserSystem.getUserId() + "', " + "      LASTTOUCHEDON = CURRENT TIMESTAMP " + "WHERE PRODUCTIND    = " + this.productDraft.getProductInd());
                        GUISystem.printBox(7, 18003);
                    }
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception, false);
                    GUISystem.printBox(6, 202);
                }
            }
            sQLMethod.close();
        } else {
            GUISystem.printBox(7, 358);
        }
        GUISystem.getParentDefWin(this).setStatus(null);
    }

    public String getHelpFilename() {
        return "Products/ProdHistory.html";
    }

    public ProductHistoryPanel(QuestPanel questPanel) {
        this.previousPanel = questPanel;
    }

    public ProductHistoryPanel(int n, boolean bl, QuestPanel questPanel) {
        this.startDraft = bl;
        this.startProdInd = n;
        this.previousPanel = questPanel;
    }
}

