/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.gui.BrandMappingRow;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class BrandMapDlg
extends JDialog
implements ActionListener,
AppConst,
ProductConst {
    private BrandMappingRow mapRow = null;
    private DButton pb_OK = new DButton(Str.getStr(1));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private JLabel st_OBRAND = new JLabel("OBrand");
    private JLabel st_OFAMILY = new JLabel("OFamily");
    private JLabel st_OSERIES = new JLabel("OSeries");
    private JLabel st_BRAND = new JLabel(Str.getStr(145));
    private JLabel st_FAMILY = new JLabel(Str.getStr(149));
    private JComboBox cb_OBRAND = new JComboBox();
    private JComboBox cb_OFAMILY = new JComboBox();
    private JComboBox cb_OSERIES = new JComboBox();
    private JComboBox cb_BRAND = new JComboBox();
    private JComboBox cb_FAMILY = new JComboBox();
    private HotLinkLabel pb_NEW_OBRAND = new HotLinkLabel(Str.getStr(171));
    private HotLinkLabel pb_NEW_OFAMILY = new HotLinkLabel(Str.getStr(171));
    private HotLinkLabel pb_NEW_OSERIES = new HotLinkLabel(Str.getStr(171));

    private final void initialize() {
        Container container = this.getContentPane();
        this.setResizable(false);
        this.pb_NEW_OBRAND.showSelection(false);
        this.pb_NEW_OFAMILY.showSelection(false);
        this.pb_NEW_OSERIES.showSelection(false);
        this.cb_OBRAND.setModel(new DefaultComboBoxModel());
        this.cb_OFAMILY.setModel(new DefaultComboBoxModel());
        this.cb_OSERIES.setModel(new DefaultComboBoxModel());
        this.cb_BRAND.setModel(new DefaultComboBoxModel());
        this.cb_FAMILY.setModel(new DefaultComboBoxModel());
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.cb_OBRAND.addActionListener(this);
        this.cb_OFAMILY.addActionListener(this);
        this.cb_OSERIES.addActionListener(this);
        this.cb_BRAND.addActionListener(this);
        this.cb_FAMILY.addActionListener(this);
        this.pb_NEW_OBRAND.addActionListener(this);
        this.pb_NEW_OFAMILY.addActionListener(this);
        this.pb_NEW_OSERIES.addActionListener(this);
        WinUtil.setJComboBoxData(this.cb_OBRAND, TypeCategory.getCategories("opicmbrand"));
        WinUtil.setJComboBoxData(this.cb_OFAMILY, this.createEmptyList());
        WinUtil.setJComboBoxData(this.cb_OSERIES, this.createEmptyList());
        WinUtil.setJComboBoxData(this.cb_BRAND, Brands.getBrands());
        WinUtil.setJComboBoxData(this.cb_FAMILY, this.createEmptyList());
        container.setLayout(null);
        container.add(this.st_OBRAND);
        container.add(this.cb_OBRAND);
        container.add(this.pb_NEW_OBRAND);
        container.add(this.st_OFAMILY);
        container.add(this.cb_OFAMILY);
        container.add(this.pb_NEW_OFAMILY);
        container.add(this.st_OSERIES);
        container.add(this.cb_OSERIES);
        container.add(this.pb_NEW_OSERIES);
        container.add(this.st_BRAND);
        container.add(this.cb_BRAND);
        container.add(this.st_FAMILY);
        container.add(this.cb_FAMILY);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
        if (this.mapRow != null) {
            if (this.mapRow.oBrand != null) {
                this.cb_OBRAND.setSelectedItem(this.mapRow.oBrand);
            }
            if (this.mapRow.oFamily != null) {
                this.cb_OFAMILY.setSelectedItem(this.mapRow.oFamily);
            }
            if (this.mapRow.oSeries != null) {
                this.cb_OSERIES.setSelectedItem(this.mapRow.oSeries);
            }
            if (this.mapRow.brand != null) {
                this.cb_BRAND.setSelectedItem(this.mapRow.brand);
            }
            if (this.mapRow.family != null) {
                this.cb_FAMILY.setSelectedItem(this.mapRow.family);
            }
            this.cb_OBRAND.setEnabled(this.mapRow.oBrand == null);
            this.cb_OFAMILY.setEnabled(this.mapRow.oFamily == null);
            this.cb_OSERIES.setEnabled(this.mapRow.oSeries == null);
        }
        ((Component)this).setSize(400, 200);
        WinUtil.centerWindow(this);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 35;
        int n3 = 5;
        super.doLayout();
        this.st_OBRAND.setBounds(n2, n3, 100, n);
        this.cb_OBRAND.setBounds(n2 + 100, n3, 200, n);
        this.pb_NEW_OBRAND.setBounds(n2 + 305, n3, 70, n);
        this.st_OFAMILY.setBounds(n2, n3 += n + 5, 100, n);
        this.cb_OFAMILY.setBounds(n2 + 100, n3, 200, n);
        this.pb_NEW_OFAMILY.setBounds(n2 + 305, n3, 70, n);
        this.st_OSERIES.setBounds(n2, n3 += n + 5, 100, n);
        this.cb_OSERIES.setBounds(n2 + 100, n3, 200, n);
        this.pb_NEW_OSERIES.setBounds(n2 + 305, n3, 70, n);
        this.st_BRAND.setBounds(n2, n3 += n + 5, 100, n);
        this.cb_BRAND.setBounds(n2 + 100, n3, 200, n);
        this.st_FAMILY.setBounds(n2, n3 += n + 5, 100, n);
        this.cb_FAMILY.setBounds(n2 + 100, n3, 200, n);
        n3 += n + 5;
        this.pb_OK.setBounds(5, dimension.height - 60, 75, 25);
        this.pb_CANCEL.setBounds(85, dimension.height - 60, 75, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_OBRAND) {
            if (this.selectionValid(this.cb_OBRAND)) {
                this.refreshOFamilies((TypeCategoryRec)this.cb_OBRAND.getSelectedItem());
            }
        } else if (actionEvent.getSource() == this.cb_OFAMILY) {
            if (this.selectionValid(this.cb_OFAMILY)) {
                this.refreshOSeries((TypeCategoryRec)this.cb_OFAMILY.getSelectedItem());
            }
        } else if (actionEvent.getSource() == this.cb_BRAND) {
            if (this.selectionValid(this.cb_BRAND)) {
                this.refreshFamilies((TypeCategoryRec)this.cb_BRAND.getSelectedItem());
            }
        } else if (actionEvent.getSource() == this.pb_OK) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_NEW_OBRAND) {
            this.createNewOBrand();
        } else if (actionEvent.getSource() == this.pb_NEW_OFAMILY) {
            if (this.selectionValid(this.cb_OBRAND)) {
                this.createNewOFamily();
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Please select an OPIC/M Brand first");
            }
        } else if (actionEvent.getSource() == this.pb_NEW_OSERIES) {
            if (this.selectionValid(this.cb_OFAMILY)) {
                this.createNewOSeries();
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Please select an OPIC/M Family first");
            }
        }
    }

    private final Vector createEmptyList() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(Str.getStr(17086));
        return vector;
    }

    private final boolean selectionValid(JComboBox jComboBox) {
        return jComboBox.getSelectedItem() instanceof TypeCategoryRec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshOFamilies(TypeCategoryRec typeCategoryRec) {
        ((DefaultComboBoxModel)this.cb_OFAMILY.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.cb_OSERIES.getModel()).removeAllElements();
        if (typeCategoryRec != null) {
            WinUtil.setJComboBoxData(this.cb_OFAMILY, TypeCategory.getChildCategories(typeCategoryRec.getInd(), "opicmfamily"));
            try {
                WinUtil.setJComboBoxData(this.cb_OSERIES, TypeCategory.getChildCategories(((TypeCategoryRec)this.cb_OFAMILY.getSelectedItem()).getInd(), "opicmseries"));
            }
            catch (Exception exception) {
                WinUtil.setJComboBoxData(this.cb_OSERIES, this.createEmptyList());
            }
        } else {
            WinUtil.setJComboBoxData(this.cb_OFAMILY, this.createEmptyList());
            WinUtil.setJComboBoxData(this.cb_OSERIES, this.createEmptyList());
        }
        this.doLayout();
    }

    private final void refreshOSeries(TypeCategoryRec typeCategoryRec) {
        ((DefaultComboBoxModel)this.cb_OSERIES.getModel()).removeAllElements();
        if (typeCategoryRec != null) {
            WinUtil.setJComboBoxData(this.cb_OSERIES, TypeCategory.getChildCategories(typeCategoryRec.getInd(), "opicmseries"));
        } else {
            WinUtil.setJComboBoxData(this.cb_OSERIES, this.createEmptyList());
        }
        this.doLayout();
    }

    private final void refreshFamilies(TypeCategoryRec typeCategoryRec) {
        ((DefaultComboBoxModel)this.cb_FAMILY.getModel()).removeAllElements();
        if (typeCategoryRec != null) {
            WinUtil.setJComboBoxData(this.cb_FAMILY, TypeCategory.getChildCategories(typeCategoryRec.getInd(), "family"));
        } else {
            WinUtil.setJComboBoxData(this.cb_FAMILY, this.createEmptyList());
        }
        this.doLayout();
    }

    private final boolean saveData() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_OBRAND.getSelectedItem();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)this.cb_OFAMILY.getSelectedItem();
        TypeCategoryRec typeCategoryRec3 = (TypeCategoryRec)this.cb_OSERIES.getSelectedItem();
        TypeCategoryRec typeCategoryRec4 = (TypeCategoryRec)this.cb_BRAND.getSelectedItem();
        TypeCategoryRec typeCategoryRec5 = (TypeCategoryRec)this.cb_FAMILY.getSelectedItem();
        boolean bl = false;
        if (typeCategoryRec != null && typeCategoryRec2 != null && typeCategoryRec3 != null && typeCategoryRec4 != null && typeCategoryRec5 != null) {
            StatusWin statusWin = new StatusWin(GUISystem.getParentDefWin(this));
            ((Component)statusWin).setVisible(true);
            statusWin.setText("Creating OPIC/M Brand/Family/Series Mapping");
            this.mapRow.oBrand = typeCategoryRec;
            this.mapRow.oFamily = typeCategoryRec2;
            this.mapRow.oSeries = typeCategoryRec3;
            this.mapRow.brand = typeCategoryRec4;
            this.mapRow.family = typeCategoryRec5;
            bl = this.saveMappingToDatabase();
            if (bl) {
                statusWin.setText("Converting all current misfits ...");
                bl = this.convertMisfits(statusWin);
            }
            statusWin.dispose();
        } else {
            GUISystem.printBox((JDialog)this, "Info", "Please select a value for all fields");
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean saveMappingToDatabase() {
        SQLMethod sQLMethod = new SQLMethod(1, "saveMappingToDatabase", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("DELETE FROM OPICM.BRANDFAMILYMAP WHERE OPICMTYPECATIND = " + this.mapRow.oSeries.getInd());
            statement.executeUpdate("INSERT INTO OPICM.BRANDFAMILYMAP VALUES ( " + this.mapRow.oSeries.getInd() + ", " + this.mapRow.family.getInd() + ")");
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox((JDialog)this, 6, 202);
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean convertMisfits(StatusWin statusWin) {
        Vector vector = this.getMisfits(statusWin);
        boolean bl = true;
        if (vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ProductDraft productDraft = null;
            int n3 = 0;
            int n4 = 0;
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_BRAND.getSelectedItem();
            TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)this.cb_FAMILY.getSelectedItem();
            TypeCategoryRec typeCategoryRec3 = TypeCategory.getDraftCategoryFromDescription("Default", "project", this.mapRow.family.getInd());
            if (typeCategoryRec3 == null) {
                statusWin.setText("Creating Default Project");
                typeCategoryRec3 = TypeCategory.createDraftTypeCategory(this.mapRow.family.getInd(), "Default", "project", 0, "N", UserSystem.getUserId());
                TypeCategory.writeToDatabase();
            }
            while (n < n2 && bl) {
                statusWin.setText("Reading Misfit " + (n + 1) + " of " + n2);
                productDraft = new ProductDraft((Integer)vector.elementAt(n));
                n4 = productDraft.readFromDatabase();
                switch (n4) {
                    case 0: {
                        int n5 = 0;
                        TypeCategoryRec typeCategoryRec4 = productDraft.getProject();
                        if (typeCategoryRec4.getParentCatInd() != typeCategoryRec2.getInd()) {
                            typeCategoryRec4.setParentCatInd(typeCategoryRec2.getInd());
                            productDraft.setProject(typeCategoryRec4);
                        }
                        productDraft.setBrand(TypeCategory.getDraftCategory(typeCategoryRec.getInd()));
                        productDraft.setFamily(TypeCategory.getDraftCategory(typeCategoryRec2.getInd()));
                        productDraft.setMisfit(false);
                        statusWin.setText("Saving Misfit " + (n + 1) + " of " + n2);
                        n5 = productDraft.writeToDatabase();
                        if (n5 != 0) {
                            LogSystem.log(1, "Couldn't save draft to database. ProductInd:" + (Integer)vector.elementAt(n) + ". rc:" + n5);
                            break;
                        }
                        ++n3;
                        try {
                            productDraft.checkOut(null);
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, exception, false);
                        }
                        break;
                    }
                    default: {
                        LogSystem.log(1, "Couldn't read in misfit productInd " + (Integer)vector.elementAt(n) + ". rc:" + bl);
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
            GUISystem.printBox((JDialog)this, "Info", "Converted " + n3 + " misfits of " + n2);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector getMisfits(StatusWin statusWin) {
        Vector<Integer> vector = new Vector<Integer>(1);
        SQLMethod sQLMethod = new SQLMethod(1, "getMisfits", 5);
        try {
            int n = 0;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND " + "FROM PRODRAFT.CATEGORY A, " + "     PRODRAFT.PRODUCT B " + "WHERE A.TYPECATIND = " + this.mapRow.oSeries.getInd() + " AND " + "      A.PRODUCTIND = B.PRODUCTIND AND " + "      B.MISFIT = 'Y'");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    return vector;
                }
                vector.addElement(new Integer(resultSet.getInt(1)));
                statusWin.setText("Found Misfits ... " + ++n);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            vector = new Vector(1);
            GUISystem.printBox((JDialog)this, 6, 202);
        }
        return vector;
    }

    private final void createNewOBrand() {
        String string = new SingleEntryDlg((Dialog)this, Str.getStr(171), Str.getStr(17042), "", new MaskDocument(0, 254)).getResult();
        if (string != null && string.length() > 0) {
            TypeCategoryRec typeCategoryRec = TypeCategory.createTypeCategory(0, string, "opicmbrand", 0, "N", UserSystem.getUserId());
            TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), 0, string, "opicmbrand", 0, "N", UserSystem.getUserId());
            if (typeCategoryRec != null && TypeCategory.writeToDatabase() == 0) {
                ((DefaultComboBoxModel)this.cb_OBRAND.getModel()).addElement(typeCategoryRec);
                this.cb_OBRAND.setSelectedItem(typeCategoryRec);
            }
        }
    }

    private final void createNewOFamily() {
        String string = new SingleEntryDlg((Dialog)this, Str.getStr(171), Str.getStr(17043), "", new MaskDocument(0, 254)).getResult();
        if (string != null && string.length() > 0) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_OBRAND.getSelectedItem();
            TypeCategoryRec typeCategoryRec2 = TypeCategory.createTypeCategory(typeCategoryRec.getInd(), string, "opicmfamily", 0, "N", UserSystem.getUserId());
            TypeCategory.createDraftTypeCategory(typeCategoryRec2.getInd(), typeCategoryRec.getInd(), string, "opicmfamily", 0, "N", UserSystem.getUserId());
            if (typeCategoryRec2 != null && TypeCategory.writeToDatabase() == 0) {
                ((DefaultComboBoxModel)this.cb_OFAMILY.getModel()).addElement(typeCategoryRec2);
                this.cb_OFAMILY.setSelectedItem(typeCategoryRec2);
            }
        }
    }

    private final void createNewOSeries() {
        String string = new SingleEntryDlg((Dialog)this, Str.getStr(171), Str.getStr(17044), "", new MaskDocument(0, 254)).getResult();
        if (string != null && string.length() > 0) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_OFAMILY.getSelectedItem();
            TypeCategoryRec typeCategoryRec2 = TypeCategory.createTypeCategory(typeCategoryRec.getInd(), string, "opicmseries", 0, "N", UserSystem.getUserId());
            TypeCategory.createDraftTypeCategory(typeCategoryRec2.getInd(), typeCategoryRec.getInd(), string, "opicmseries", 0, "N", UserSystem.getUserId());
            if (typeCategoryRec2 != null && TypeCategory.writeToDatabase() == 0) {
                ((DefaultComboBoxModel)this.cb_OSERIES.getModel()).addElement(typeCategoryRec2);
                this.cb_OSERIES.setSelectedItem(typeCategoryRec2);
            }
        }
    }

    public BrandMapDlg(Frame frame, BrandMappingRow brandMappingRow) {
        super(frame, Str.getStr(17089), true);
        this.mapRow = brandMappingRow;
        this.initialize();
        ((Component)this).setVisible(true);
    }
}

