/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.gui.CountryMappingRow;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class CountryMapDlg
extends JDialog
implements ActionListener,
AppConst,
ProductConst {
    private CountryMappingRow mapRow = null;
    private DButton pb_OK = new DButton(Str.getStr(1));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private JLabel st_OGEOGRAPHY = new JLabel("OGeography");
    private JLabel st_OCOUNTRY = new JLabel("OCountry");
    private JLabel st_COUNTRY = new JLabel(Str.getStr(94));
    private JComboBox cb_OGEOGRAPHY = new JComboBox();
    private JComboBox cb_OCOUNTRY = new JComboBox();
    private JComboBox cb_COUNTRY = new JComboBox();
    private HotLinkLabel pb_NEW_GEOGRAPHY = new HotLinkLabel(Str.getStr(171));
    private HotLinkLabel pb_NEW_COUNTRY = new HotLinkLabel(Str.getStr(171));

    private final void initialize() {
        Container container = this.getContentPane();
        this.setResizable(false);
        this.cb_OGEOGRAPHY.setModel(new DefaultComboBoxModel());
        this.cb_OCOUNTRY.setModel(new DefaultComboBoxModel());
        this.cb_COUNTRY.setModel(new DefaultComboBoxModel());
        this.pb_NEW_GEOGRAPHY.showSelection(false);
        this.pb_NEW_COUNTRY.showSelection(false);
        WinUtil.setJComboBoxData(this.cb_OGEOGRAPHY, TypeCategory.getCategories("opicmgeo"));
        WinUtil.setJComboBoxData(this.cb_COUNTRY, TypeList.getInstance().getTypeList(3));
        WinUtil.setJComboBoxData(this.cb_OCOUNTRY, this.createEmptyList());
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.cb_OGEOGRAPHY.addActionListener(this);
        this.pb_NEW_GEOGRAPHY.addActionListener(this);
        this.pb_NEW_COUNTRY.addActionListener(this);
        container.setLayout(null);
        container.add(this.st_OGEOGRAPHY);
        container.add(this.cb_OGEOGRAPHY);
        container.add(this.pb_NEW_GEOGRAPHY);
        container.add(this.st_OCOUNTRY);
        container.add(this.cb_OCOUNTRY);
        container.add(this.pb_NEW_COUNTRY);
        container.add(this.st_COUNTRY);
        container.add(this.cb_COUNTRY);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
        if (this.mapRow != null) {
            if (this.mapRow.oGeo != null) {
                this.cb_OGEOGRAPHY.setSelectedItem(this.mapRow.oGeo);
            }
            if (this.mapRow.oCountry != null) {
                this.cb_OCOUNTRY.setSelectedItem(this.mapRow.oCountry);
            }
            if (this.mapRow.countryRec != null) {
                this.cb_COUNTRY.setSelectedItem(this.mapRow.countryRec);
            }
            this.cb_OGEOGRAPHY.setEnabled(this.mapRow.oGeo == null);
            this.cb_OCOUNTRY.setEnabled(this.mapRow.oCountry == null);
        }
        ((Component)this).setSize(400, 200);
        WinUtil.centerWindow(this);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 35;
        int n3 = 5;
        super.doLayout();
        this.st_OGEOGRAPHY.setBounds(n2, n3, 100, n);
        this.cb_OGEOGRAPHY.setBounds(n2 + 100, n3, 200, n);
        this.pb_NEW_GEOGRAPHY.setBounds(n2 + 305, n3, 70, n);
        this.st_OCOUNTRY.setBounds(n2, n3 += n + 5, 100, n);
        this.cb_OCOUNTRY.setBounds(n2 + 100, n3, 200, n);
        this.pb_NEW_COUNTRY.setBounds(n2 + 305, n3, 70, n);
        this.st_COUNTRY.setBounds(n2, n3 += n + 5, 100, n);
        this.cb_COUNTRY.setBounds(n2 + 100, n3, 200, n);
        n3 += n + 5;
        this.pb_OK.setBounds(5, dimension.height - 60, 75, 25);
        this.pb_CANCEL.setBounds(85, dimension.height - 60, 75, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_OGEOGRAPHY) {
            this.refreshOCountries((TypeCategoryRec)this.cb_OGEOGRAPHY.getSelectedItem());
        } else if (actionEvent.getSource() == this.pb_OK) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_NEW_GEOGRAPHY) {
            this.createNewGeography();
        } else if (actionEvent.getSource() == this.pb_NEW_COUNTRY) {
            this.createNewCountry();
        }
    }

    private final Vector createEmptyList() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(Str.getStr(17086));
        return vector;
    }

    private final boolean selectionValid(JComboBox jComboBox) {
        return jComboBox.getSelectedItem() instanceof TypeCategoryRec;
    }

    private final void refreshOCountries(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null) {
            WinUtil.setJComboBoxData(this.cb_OCOUNTRY, TypeCategory.getChildCategories(typeCategoryRec.getInd()));
        } else {
            WinUtil.setJComboBoxData(this.cb_OCOUNTRY, this.createEmptyList());
        }
        this.getContentPane().add(this.cb_OCOUNTRY);
        this.doLayout();
    }

    private final boolean saveData() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_OGEOGRAPHY.getSelectedItem();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)this.cb_OCOUNTRY.getSelectedItem();
        TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)this.cb_COUNTRY.getSelectedItem();
        boolean bl = false;
        if (typeCategoryRec != null && typeCategoryRec2 != null && typeCountryCodeRec != null) {
            StatusWin statusWin = new StatusWin(GUISystem.getParentDefWin(this));
            ((Component)statusWin).setVisible(true);
            statusWin.setText("Creating OPIC/M Geo/Country Mapping");
            this.mapRow.oGeo = typeCategoryRec;
            this.mapRow.oCountry = typeCategoryRec2;
            this.mapRow.countryRec = typeCountryCodeRec;
            bl = this.saveMappingToDatabase();
            if (bl) {
                statusWin.setText("Converting all current misfits ...");
                bl = this.convertMisfits(statusWin);
            }
            statusWin.dispose();
        } else {
            GUISystem.printBox((JDialog)this, "Info", "Please select a value for all fields");
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean saveMappingToDatabase() {
        SQLMethod sQLMethod = new SQLMethod(1, "saveMappingToDatabase", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("DELETE FROM OPICM.GEOCOUNTRYMAP WHERE TYPECATIND = " + this.mapRow.oCountry.getInd());
            statement.executeUpdate("INSERT INTO OPICM.GEOCOUNTRYMAP VALUES ( " + this.mapRow.oCountry.getInd() + ", " + this.mapRow.countryRec.getInd() + ")");
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox((JDialog)this, 6, 202);
        }
        sQLMethod.close();
        return bl;
    }

    private final void createNewGeography() {
        String string = new SingleEntryDlg((Dialog)this, Str.getStr(171), Str.getStr(148), "", new MaskDocument(0, 254)).getResult();
        if (string != null && string.length() > 0) {
            TypeCategoryRec typeCategoryRec = TypeCategory.createTypeCategory(0, string, "opicmgeo", 0, "N", UserSystem.getUserId());
            TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), 0, string, "opicmgeo", 0, "N", UserSystem.getUserId());
            if (typeCategoryRec != null && TypeCategory.writeToDatabase() == 0) {
                ((DefaultComboBoxModel)this.cb_OGEOGRAPHY.getModel()).addElement(typeCategoryRec);
                this.cb_OGEOGRAPHY.setSelectedItem(typeCategoryRec);
            }
        }
    }

    private final void createNewCountry() {
        String string = new SingleEntryDlg((Dialog)this, Str.getStr(171), Str.getStr(94), "", new MaskDocument(0, 254)).getResult();
        if (string != null && string.length() > 0) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_OGEOGRAPHY.getSelectedItem();
            TypeCategoryRec typeCategoryRec2 = TypeCategory.createTypeCategory(typeCategoryRec.getInd(), string, "opicmcountry", 0, "N", UserSystem.getUserId());
            TypeCategory.createDraftTypeCategory(typeCategoryRec2.getInd(), typeCategoryRec.getInd(), string, "opicmcountry", 0, "N", UserSystem.getUserId());
            if (typeCategoryRec2 != null && TypeCategory.writeToDatabase() == 0) {
                ((DefaultComboBoxModel)this.cb_OCOUNTRY.getModel()).addElement(typeCategoryRec2);
                this.cb_OCOUNTRY.setSelectedItem(typeCategoryRec2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean convertMisfits(StatusWin statusWin) {
        Vector vector = this.getMisfits(statusWin);
        boolean bl = true;
        if (vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ProductDraft productDraft = null;
            int n3 = 0;
            int n4 = 0;
            while (n < n2 && bl) {
                statusWin.setText("Reading Misfit " + (n + 1) + " of " + n2);
                productDraft = new ProductDraft((Integer)vector.elementAt(n));
                n4 = productDraft.readFromDatabase();
                switch (n4) {
                    case 0: {
                        int n5 = 0;
                        LocaleRec localeRec = productDraft.getLocale();
                        localeRec.addCountry(this.mapRow.countryRec);
                        productDraft.setLocale(localeRec);
                        statusWin.setText("Saving Misfit " + (n + 1) + " of " + n2);
                        n5 = productDraft.writeToDatabase();
                        try {
                            productDraft.checkOut(null);
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, exception, false);
                        }
                        if (n5 != 0) {
                            LogSystem.log(1, "Couldn't save draft to database. ProductInd:" + (Integer)vector.elementAt(n) + ". rc:" + n5);
                            break;
                        }
                        ++n3;
                        break;
                    }
                    default: {
                        LogSystem.log(1, "Couldn't read in misfit productInd " + (Integer)vector.elementAt(n) + ". rc:" + bl);
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
            GUISystem.printBox((JDialog)this, "Info", "Converted " + n3 + " misfits of " + n2);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector getMisfits(StatusWin statusWin) {
        Vector<Integer> vector = new Vector<Integer>(1);
        SQLMethod sQLMethod = new SQLMethod(1, "getMisfits", 5);
        try {
            int n = 0;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND " + "FROM PRODRAFT.CATEGORY A, " + "     PRODRAFT.PRODUCT B " + "WHERE A.TYPECATIND = " + this.mapRow.oCountry.getInd() + " AND " + "      A.PRODUCTIND = B.PRODUCTIND AND " + "      B.MISFIT = 'Y'");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    return vector;
                }
                vector.addElement(new Integer(resultSet.getInt(1)));
                statusWin.setText("Found Misfits ... " + ++n);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            vector = new Vector(1);
            GUISystem.printBox((JDialog)this, 6, 202);
        }
        return vector;
    }

    public CountryMapDlg(Frame frame, CountryMappingRow countryMappingRow) {
        super(frame, Str.getStr(17089), true);
        this.mapRow = countryMappingRow;
        this.initialize();
        ((Component)this).setVisible(true);
    }
}

