/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.customview.CustomView;
import com.ibm.nzna.projects.qit.customview.CustomViewListener;
import com.ibm.nzna.projects.qit.customview.CustomViewSystem;
import com.ibm.nzna.projects.qit.gui.NavList;
import com.ibm.nzna.projects.qit.gui.NavListGroup;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.manager.ProductManagementPanel;
import com.ibm.nzna.shared.gui.HotLinkGroup;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CustomViewPanel
extends JPanel
implements CustomViewListener,
NavPanel,
ProductConst,
AppConst,
ActionListener {
    private NavListGroup customQueryView = null;
    private NavList navList = null;
    private Vector customViewComponents = new Vector(1, 1);
    private ProductManagementPanel productManagementPanel = null;

    public void initialize() {
        JScrollPane jScrollPane = null;
        this.navList = new NavList();
        jScrollPane = new JScrollPane(this.navList);
        this.createCustomQueryViews();
        this.setOpaque(false);
        CustomViewSystem.addCustomViewListener(this);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jScrollPane, "Center");
    }

    public void start() {
    }

    public void stop() {
        CustomViewSystem.removeCustomViewListener(this);
        this.removeAll();
    }

    public String getTitle() {
        return Str.getStr(714);
    }

    public JComponent getJComponent() {
        return this;
    }

    private final void createCustomQueryViews() {
        Vector vector = null;
        this.customQueryView = new NavListGroup(Str.getStr(1031));
        this.navList.add(this.customQueryView);
        vector = CustomViewSystem.getViews(7);
        this.addCustomQueries(this.customQueryView, vector);
        this.customQueryView.addActionListener(this);
    }

    private final void addCustomQueries(NavListGroup navListGroup, Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            HotLinkLabel hotLinkLabel = null;
            HotLinkGroup hotLinkGroup = new HotLinkGroup();
            while (n < n2) {
                hotLinkLabel = new HotLinkLabel(((CustomView)vector.elementAt(n)).getDescript(), null, "CUSTOM_VIEW");
                navListGroup.add(hotLinkLabel);
                hotLinkGroup.add(hotLinkLabel);
                this.customViewComponents.addElement(hotLinkLabel);
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() instanceof HotLinkLabel && (string = ((HotLinkLabel)actionEvent.getSource()).getActionCommand()).equals("CUSTOM_VIEW")) {
            this.productManagementPanel.setCustomView(((HotLinkLabel)actionEvent.getSource()).getText());
        }
    }

    public void customViewRemoved(CustomView customView) {
        HotLinkLabel hotLinkLabel = this.hotLinkFromCustomView(customView);
        if (hotLinkLabel != null) {
            hotLinkLabel.getParent().remove(hotLinkLabel);
        }
        this.revalidate();
    }

    public void customViewAdded(CustomView customView) {
        HotLinkLabel hotLinkLabel = null;
        switch (customView.getViewType()) {
            case 7: {
                hotLinkLabel = new HotLinkLabel(customView.getDescript(), null, "CUSTOM_VIEW");
                this.customQueryView.add(hotLinkLabel);
                break;
            }
        }
        if (hotLinkLabel != null) {
            this.customViewComponents.addElement(hotLinkLabel);
        }
        this.revalidate();
    }

    public void customViewUpdated(CustomView customView) {
        HotLinkLabel hotLinkLabel = this.hotLinkFromCustomView(customView);
        if (hotLinkLabel != null) {
            hotLinkLabel.setText(customView.getDescript());
        }
        this.revalidate();
    }

    public HotLinkLabel hotLinkFromCustomView(CustomView customView) {
        int n = 0;
        int n2 = this.customViewComponents.size();
        HotLinkLabel hotLinkLabel = null;
        while (hotLinkLabel != null && n < n2) {
            if (((HotLinkLabel)this.customViewComponents.elementAt(n)).getText().equals(customView.getDescript())) {
                hotLinkLabel = (HotLinkLabel)this.customViewComponents.elementAt(n);
            }
            ++n;
        }
        return hotLinkLabel;
    }

    public CustomViewPanel(ProductManagementPanel productManagementPanel) {
        this.productManagementPanel = productManagementPanel;
        this.initialize();
    }
}

