/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager;

import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.ThemeSystem;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkHotLinkTree;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.gui.ProductDateCompare;
import com.ibm.nzna.projects.qit.product.manager.CustomViewPanel;
import com.ibm.nzna.projects.qit.product.manager.PMViewPanel;
import com.ibm.nzna.projects.qit.product.manager.ProductManagementPanel;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ProductNavPanel
extends JPanel
implements ActionListener,
NavPanel,
ProductConst,
AppConst {
    private JTabbedPane tabbedPane = null;
    private BookmarkHotLinkTree bookmarkTree = null;
    private PMViewPanel pmViewPanel = null;
    private CustomViewPanel customViewPanel = null;
    private ProductManagementPanel productManagementPanel = null;
    private String query = null;

    public void initialize() {
        JScrollPane jScrollPane = null;
        Color color = ThemeSystem.getColor("NAVPANEL_BG_COLOR");
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.bookmarkTree = new BookmarkHotLinkTree(true);
        this.pmViewPanel = new PMViewPanel(this.productManagementPanel);
        this.customViewPanel = new CustomViewPanel(this.productManagementPanel);
        this.tabbedPane.setBorder(GUISystem.emptyBorder);
        this.bookmarkTree.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.tabbedPane.addTab(Str.getStr(714), this.pmViewPanel);
        jScrollPane = new JScrollPane(this.bookmarkTree);
        this.tabbedPane.addTab(Str.getStr(1017), jScrollPane);
        this.tabbedPane.addTab(Str.getStr(669), this.customViewPanel);
        jScrollPane.setBorder(GUISystem.emptyBorder);
        this.add((Component)this.tabbedPane, "Center");
    }

    public void start() {
    }

    public String getTitle() {
        return Str.getStr(17030);
    }

    public JComponent getJComponent() {
        return this;
    }

    public void stop() {
        this.removeAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Bookmark bookmark;
        if (actionEvent.getSource() instanceof Bookmark && (bookmark = (Bookmark)actionEvent.getSource()).isFolder()) {
            Vector vector = BookmarkSystem.getBookmarks(bookmark.getDescript());
            if (vector != null && vector.size() > 0) {
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                int n2 = vector.size();
                Vector<ProductManagementPanel> vector2 = new Vector<ProductManagementPanel>(1);
                vector2.addElement(this.productManagementPanel);
                while (n < n2) {
                    if (((Bookmark)vector.elementAt(n)).getBookmarkType() == 2) {
                        bl2 = true;
                    } else if (((Bookmark)vector.elementAt(n)).getBookmarkType() == 12) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl && bl2) {
                    if (GUISystem.printBox(8, 17092)) {
                        bl = false;
                    } else {
                        bl2 = false;
                    }
                } else if (!bl && !bl2) {
                    GUISystem.printBox(7, 17093);
                }
                if (bl2) {
                    Vector vector3 = new Vector(10);
                    int n3 = 0;
                    n = 0;
                    while (n < n2) {
                        if (((Bookmark)vector.elementAt(n)).getBookmarkType() == 2) {
                            vector3.addElement(vector.elementAt(n));
                        }
                        ++n;
                    }
                    int n4 = vector3.size();
                    this.query = "SELECT DISTINCT(A.PRODUCTIND), 0, A.PRODNUM,        A.DESCRIPTION, A.CREATEDON, A.CREATEDBY, A.CREATEDBY,        A.CREATEDBY, A.LASTTOUCHEDBY, A.LASTTOUCHEDON, A.CHECKEDOUTBY FROM PRODUCT.PRODUCT A WHERE A.PUBLISH = 'Y' AND       A.PRODUCTIND IN ( ";
                    while (n3 < n4) {
                        Integer n5 = (Integer)((Bookmark)vector3.elementAt(n3)).getObject();
                        this.query = this.query + " " + n5;
                        if (n3 < n4 - 1) {
                            this.query = this.query + ",";
                        }
                        ++n3;
                    }
                    this.query = this.query + ") ";
                    LogSystem.log(1, "Bookmark View Kicked off. SQL:" + this.query);
                    this.getBookMarkList(this.query);
                } else if (bl) {
                    Vector vector4 = new Vector(10);
                    n = 0;
                    while (n < n2) {
                        if (((Bookmark)vector.elementAt(n)).getBookmarkType() == 12) {
                            vector4.addElement(vector.elementAt(n));
                        }
                        ++n;
                    }
                }
            } else {
                GUISystem.printBox(7, 17093);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector getBookMarkList(String string) {
        this.query = string;
        String string2 = null;
        SQLMethod sQLMethod = new SQLMethod(1, "getBookMarkList", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        Vector<ProductDateCompare> vector2 = new Vector<ProductDateCompare>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                ProductRow productRow = new ProductRow(resultSet.getInt(1), 0, resultSet.getString(3), resultSet.getString(4), DateSystem.prettyDateFromStamp(resultSet.getString(5).trim()), UserSystem.getNameFromUserId(resultSet.getString(6).trim()), "", "", UserSystem.getNameFromUserId(resultSet.getString(9).trim()), DateSystem.prettyDateFromStamp(resultSet.getString(10).trim()), false);
                if (resultSet.getString(11) != null) {
                    productRow.setImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 241));
                }
                vector.addElement(productRow);
            }
            resultSet.close();
            string2 = "SELECT PRODUCTIND, ACTUAL FROM PRODUCT.DATES WHERE TYPEDATEIND =2 AND PRODUCTIND IN ( ";
            int n = 0;
            while (n < vector.size()) {
                string2 = string2 + " " + ((ProductRow)vector.elementAt(n)).getProductInd();
                if (n < vector.size() - 1) {
                    string2 = string2 + ",";
                }
                ++n;
            }
            string2 = string2 + ")";
            ResultSet resultSet2 = statement.executeQuery(string2);
            while (resultSet2.next()) {
                vector2.addElement(new ProductDateCompare(resultSet2.getInt(1), resultSet2.getString(2)));
            }
            resultSet2.close();
            System.out.println("size" + vector2.size());
            Vector vector3 = this.getFilteredRows(vector, vector2);
            if (vector3 != null && vector3.size() > 0) {
                this.productManagementPanel.setProductList(Str.getStr(927), vector3);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private final Vector getFilteredRows(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        Vector<ProductRow> vector4 = new Vector<ProductRow>(vector);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                ProductRow productRow = (ProductRow)vector.elementAt(n);
                int n2 = productRow.getProductInd();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    ProductDateCompare productDateCompare = (ProductDateCompare)vector2.elementAt(n3);
                    int n4 = productDateCompare.getProductInd();
                    if (n2 == n4) {
                        int n5 = vector.indexOf(vector.elementAt(n));
                        vector4.removeElementAt(n5);
                        String string = DateSystem.prettyDateFromDBDate(productDateCompare.getActualDate());
                        productRow.setActualDate(string);
                        vector4.insertElementAt(productRow, n5);
                    }
                    ++n3;
                }
                ++n;
            }
        }
        return vector4;
    }

    public ProductNavPanel(ProductManagementPanel productManagementPanel) {
        this.productManagementPanel = productManagementPanel;
    }
}

