/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager.views;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.manager.views.PMNavView;
import com.ibm.nzna.projects.qit.product.manager.views.PMView;
import com.ibm.nzna.projects.qit.product.manager.views.ViewUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.gui.ViewTreeNode;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ViewBrandADate
implements PMView,
ProductConst,
PMNavView,
AppConst {
    private static final String LEVEL_DATE = "DATE";
    private static final String LEVEL_FAMILY = "FAMILY";
    private static final String LEVEL_MACHINE = "MACHINE";
    private static final String LEVEL_MODEL = "MODEL";
    private DefaultMutableTreeNode root = null;
    private TypeCategoryRec brandRec = null;

    public String getName() {
        return Str.getStr(17056);
    }

    public String getShortName() {
        return "SHORT NAME!";
    }

    public void setBrand(TypeCategoryRec typeCategoryRec) {
        this.brandRec = typeCategoryRec;
    }

    public DefaultTreeModel getJTreeModel() {
        DefaultTreeModel defaultTreeModel = null;
        ViewTreeNode viewTreeNode = null;
        Vector vector = this.readDistinctDates();
        this.root = new DefaultMutableTreeNode("");
        defaultTreeModel = new DefaultTreeModel(this.root);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                viewTreeNode = new ViewTreeNode(DateSystem.prettyDateFromDBDate(vector.elementAt(n).toString()), "");
                viewTreeNode.setViewLevel(LEVEL_DATE);
                viewTreeNode.setDataObject(vector.elementAt(n));
                viewTreeNode.add(new StringTreeNode(Str.getStr(14)));
                defaultTreeModel.insertNodeInto(viewTreeNode, this.root, 0);
                ++n;
            }
        }
        return defaultTreeModel;
    }

    public void refreshViewTree(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        if (viewTreeNode.getViewLevel().equals(LEVEL_DATE)) {
            this.refreshFamiliesUnderDate(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_FAMILY)) {
            this.refreshMachinesUnderFamily(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_MACHINE)) {
            this.refreshModelsUnderMachine(defaultTreeModel, viewTreeNode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector readDistinctDates() {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctDates", 5);
        Vector<String> vector = new Vector<String>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT DISTINCT ( ACTUAL ) " + "FROM PRODUCT.DATES A,        " + "     PRODUCT.CATEGORY B, " + "     PRODUCT.PRODUCT C " + "WHERE TYPEDATEIND = " + 2 + " AND " + "      A.PRODUCTIND = B.PRODUCTIND AND " + "      A.PRODUCTIND = C.PRODUCTIND AND " + "      C.PUBLISH    = 'Y' AND " + "      B.TYPECATIND = " + this.brandRec.getInd() + " AND " + "      ACTUAL IS NOT NULL " + "ORDER BY ACTUAL DESC FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                vector.addElement(resultSet.getString(1));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector readDistinctFamilies(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctFamilies ( " + string + " )", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT ( B.TYPECATIND ) " + "FROM PRODUCT.DATES A,        " + "     PRODUCT.CATEGORY B, " + "     PRODUCT.TYPECATEGORY C, " + "     PRODUCT.PRODUCT D " + "WHERE TYPEDATEIND = " + 2 + " AND " + "      ACTUAL       = '" + string + "' AND " + "      A.PRODUCTIND = B.PRODUCTIND AND " + "      B.TYPECATIND = C.TYPECATIND AND " + "      C.CATEGORYLEVEL = '" + "family" + "' AND " + "      C.PARENTCATIND  = " + this.brandRec.getInd() + " AND " + "      D.PRODUCTIND    = A.PRODUCTIND AND " + "      D.PUBLISH       = 'Y' " + "FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    new QuickSort(vector);
                    break;
                }
                vector.addElement(TypeCategory.getCategory(resultSet.getInt(1)));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector readDistinctMachines(String string, TypeCategoryRec typeCategoryRec) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctMachines ( " + string + " )", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT ( B.TYPECATIND ) " + "FROM PRODUCT.DATES A, " + "     PRODUCT.CATEGORY B, " + "     PRODUCT.TYPECATEGORY C, " + "     PRODUCT.TYPECATCHILD D, " + "     PRODUCT.PRODUCT E " + "WHERE TYPEDATEIND = " + 2 + " AND " + "      ACTUAL       = '" + string + "' AND " + "      A.PRODUCTIND = B.PRODUCTIND AND " + "      B.TYPECATIND = C.TYPECATIND AND " + "      C.CATEGORYLEVEL IN ( '" + "subcategory" + "', '" + "machine" + "' ) AND " + "      C.TYPECATIND = D.TYPECATIND AND " + "      D.PARENTCATIND  = " + typeCategoryRec.getInd() + " AND " + "      E.PRODUCTIND    = A.PRODUCTIND AND " + "      E.PUBLISH       = 'Y' " + "FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    new QuickSort(vector);
                    resultSet.close();
                    break;
                }
                vector.addElement(TypeCategory.getCategory(resultSet.getInt(1)));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector readDistinctModels(String string, TypeCategoryRec typeCategoryRec, TypeCategoryRec typeCategoryRec2) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctModels ( " + string + " )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            boolean bl = typeCategoryRec2.getCategoryLevel().equals("subcategory");
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND, A.PRODNUM,       A.DESCRIPTION,   A.CREATEDON, " + "       A.CREATEDBY,  A.LASTTOUCHEDON, A.LASTTOUCHEDBY, C.DESCRIPTION, " + "       A.CHECKEDOUTBY " + "FROM PRODUCT.PRODUCT A, " + "     PRODUCT.CATEGORY B, " + "     PRODUCT.TYPECATEGORY C, " + "     PRODUCT.DATES D " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.PUBLISH    = 'Y' AND " + "      B.TYPECATIND IN (SELECT TYPECATIND " + "                       FROM PRODUCT.TYPECATEGORY " + "                       WHERE PARENTCATIND = " + typeCategoryRec2.getInd() + ") AND " + "      C.TYPECATIND  = B.TYPECATIND AND " + "      D.PRODUCTIND  = A.PRODUCTIND AND " + "      D.ACTUAL      = '" + string + "' AND " + "      D.TYPEDATEIND = " + 2 + " FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    new QuickSort(vector);
                    break;
                }
                ProductRow productRow = new ProductRow(resultSet.getInt(1), 0, bl ? resultSet.getString(8) : resultSet.getString(2), resultSet.getString(3), DateSystem.prettyDateFromStamp(resultSet.getString(4).trim()), UserSystem.getNameFromUserId(resultSet.getString(5).trim()), DateSystem.prettyDateFromDBDate(string), "", UserSystem.getNameFromUserId(resultSet.getString(7).trim()), DateSystem.prettyDateFromStamp(resultSet.getString(6).trim()), false);
                if (resultSet.getString(9) != null) {
                    productRow.setImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 241));
                }
                productRow.setColumnOrderData(0, 1);
                productRow.setColumnOrderData(1, 2);
                productRow.setColumnOrderData(2, 3);
                productRow.setColumnOrderData(4, 4);
                productRow.setColumnOrderData(3, 9);
                productRow.setColumnOrderData(6, 6);
                productRow.setColumnOrderData(7, 7);
                vector.addElement(productRow);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        ViewUtil.readProjectForProducts("PRODUCT", vector, false);
        return vector;
    }

    private final void refreshFamiliesUnderDate(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        String string = (String)viewTreeNode.getDataObject();
        Vector vector = this.readDistinctFamilies(string);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_FAMILY);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                viewTreeNode.add(viewTreeNode2);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private final void refreshMachinesUnderFamily(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode.getDataObject();
        String string = (String)((ViewTreeNode)viewTreeNode.getParent()).getDataObject();
        Vector vector = this.readDistinctMachines(string, typeCategoryRec);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_MACHINE);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                viewTreeNode.add(viewTreeNode2);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private final void refreshModelsUnderMachine(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        ViewTreeNode viewTreeNode2 = (ViewTreeNode)viewTreeNode.getParent();
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode2.getDataObject();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)viewTreeNode.getDataObject();
        String string = (String)((ViewTreeNode)viewTreeNode2.getParent()).getDataObject();
        Vector vector = this.readDistinctModels(string, typeCategoryRec, typeCategoryRec2);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            MutableTreeWrapper mutableTreeWrapper = null;
            while (n < n2) {
                mutableTreeWrapper = new MutableTreeWrapper();
                mutableTreeWrapper.setDataObject(vector.elementAt(n));
                viewTreeNode.add(mutableTreeWrapper);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    public int getTitlePadding() {
        return 80;
    }

    public TypeCategoryRec getBrand() {
        return this.brandRec;
    }

    public String getFullSQL() {
        return "SELECT A.PRODUCTIND, A.PRODNUM,       A.DESCRIPTION,   A.CREATEDON, " + "       A.CREATEDBY,  A.LASTTOUCHEDON, A.LASTTOUCHEDBY, C.DESCRIPTION, " + "       A.CHECKEDOUTBY " + "FROM PRODUCT.PRODUCT A, " + "     PRODUCT.CATEGORY B, " + "     PRODUCT.TYPECATEGORY C, " + "     PRODUCT.DATES D " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.PUBLISH    = 'Y' AND " + "      B.TYPECATIND IN (SELECT TYPECATIND " + "                       FROM PRODUCT.TYPECATEGORY " + "                       WHERE PARENTCATIND = " + this.brandRec.getInd() + ") AND " + "      C.TYPECATIND  = B.TYPECATIND AND " + "      D.PRODUCTIND  = A.PRODUCTIND AND " + "      D.ACTUAL      IS NOT NULL AND " + "      D.TYPEDATEIND = " + 2 + " FOR FETCH ONLY";
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[]{"", Str.getStr(334), Str.getStr(100), Str.getStr(17051), Str.getStr(17019), Str.getStr(266), Str.getStr(267)};
        if (Brands.isBrandOption(this.brandRec)) {
            stringArray[1] = Str.getStr(293);
        }
        return stringArray;
    }

    public int[] getColumnWidths() {
        int[] nArray = new int[]{15, PropertySystem.getBool(207) ? 100 : 0, PropertySystem.getBool(208) ? 250 : 0, PropertySystem.getBool(209) ? 150 : 0, PropertySystem.getBool(213) ? 150 : 0, PropertySystem.getBool(211) ? 120 : 0, PropertySystem.getBool(212) ? 160 : 0};
        return nArray;
    }
}

