/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager.views;

import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.manager.views.PMNavView;
import com.ibm.nzna.projects.qit.product.manager.views.PMView;
import com.ibm.nzna.projects.qit.product.manager.views.ViewUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.gui.ViewTreeNode;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ViewBrandDraftCreate
implements PMView,
ProductConst,
PMNavView,
AppConst {
    private static final String LEVEL_FAMILY = "FAMILY";
    private static final String LEVEL_PROJECT = "PROJECT";
    private static final String LEVEL_MACHINE = "MACHINE";
    private static final String LEVEL_MODEL = "MODEL";
    private DefaultMutableTreeNode root = null;
    private TypeCategoryRec brandRec = null;

    public String getName() {
        return Str.getStr(17115);
    }

    public String getShortName() {
        return "SHORT NAME!";
    }

    public void setBrand(TypeCategoryRec typeCategoryRec) {
        this.brandRec = typeCategoryRec;
    }

    public DefaultTreeModel getJTreeModel() {
        DefaultTreeModel defaultTreeModel = null;
        ViewTreeNode viewTreeNode = null;
        Vector vector = this.readDistinctFamilies();
        this.root = new DefaultMutableTreeNode("");
        defaultTreeModel = new DefaultTreeModel(this.root);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                viewTreeNode = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode.setViewLevel(LEVEL_FAMILY);
                viewTreeNode.setDataObject(vector.elementAt(n));
                viewTreeNode.add(new StringTreeNode(Str.getStr(14)));
                defaultTreeModel.insertNodeInto(viewTreeNode, this.root, 0);
                ++n;
            }
        }
        return defaultTreeModel;
    }

    public void refreshViewTree(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        if (viewTreeNode.getViewLevel().equals(LEVEL_FAMILY)) {
            this.refreshProjectsUnderFamily(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_PROJECT)) {
            this.refreshMachinesUnderProject(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_MACHINE)) {
            this.refreshModelsUnderMachine(defaultTreeModel, viewTreeNode);
        }
    }

    private Vector readDistinctFamilies() {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctFamilies", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT ( A.TYPECATIND ), B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM, B.CATEGORYLEVEL " + "FROM PRODRAFT.CATEGORY A, " + "     PRODRAFT.TYPECATEGORY B, " + "     PRODRAFT.PRODUCT C " + "WHERE A.TYPECATIND = B.TYPECATIND AND " + "      A.PRODUCTIND = C.PRODUCTIND AND " + "      C.PUBLISH    = 'Y' AND " + "      C.RECYCLED   = 'N' AND " + "      C.TEMPLATE   = 'N' AND " + "      C.STOPDATE   IS NULL AND " + "      C.MISFIT     = 'N' AND " + "      C.WORKIND       = " + 1 + " AND " + "      B.CATEGORYLEVEL = '" + "family" + "' AND " + "      B.PARENTCATIND  = " + this.brandRec.getInd() + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec.setDescript(resultSet.getString(2).trim());
                typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec.setOrderNum(resultSet.getInt(4));
                typeCategoryRec.setCategoryLevel(resultSet.getString(5).trim());
                vector.addElement(typeCategoryRec);
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctProjects(TypeCategoryRec typeCategoryRec) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctProjects ( " + typeCategoryRec + " )", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT ( A.TYPECATIND ), B.DESCRIPTION, B.PARENTCATIND, B.ORDERNUM, B.CATEGORYLEVEL " + "FROM PRODRAFT.CATEGORY A, " + "     PRODRAFT.TYPECATEGORY B, " + "     PRODRAFT.TYPECATEGORY C, " + "     PRODRAFT.PRODUCT D " + "WHERE A.TYPECATIND    = B.TYPECATIND AND " + "      A.PRODUCTIND    = D.PRODUCTIND AND " + "      D.PUBLISH       = 'Y' AND " + "      D.RECYCLED      = 'N' AND " + "      D.STOPDATE      IS NULL AND " + "      D.TEMPLATE      = 'N' AND " + "      D.MISFIT        = 'N' AND " + "      B.CATEGORYLEVEL = '" + "project" + "' AND " + "      B.PARENTCATIND  = C.TYPECATIND AND " + "      C.TYPECATIND    = " + typeCategoryRec.getInd() + " AND " + "      D.WORKIND       = " + 1 + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                TypeCategoryRec typeCategoryRec2 = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec2.setDescript(resultSet.getString(2).trim());
                typeCategoryRec2.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec2.setOrderNum(resultSet.getInt(4));
                typeCategoryRec2.setCategoryLevel(resultSet.getString(5).trim());
                vector.addElement(typeCategoryRec2);
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctMachines(TypeCategoryRec typeCategoryRec, TypeCategoryRec typeCategoryRec2) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctMachines ( " + typeCategoryRec + "," + typeCategoryRec2 + " )", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT ( A.TYPECATIND ), B.DESCRIPTION, B.PARENTCATIND, B.ORDERNUM, B.CATEGORYLEVEL " + "FROM PRODRAFT.CATEGORY A, " + "     PRODRAFT.TYPECATEGORY B, " + "     PRODRAFT.TYPECATEGORY C, " + "     PRODRAFT.PRODUCT D " + "WHERE A.TYPECATIND    = B.TYPECATIND AND " + "      A.PRODUCTIND    = D.PRODUCTIND AND " + "      D.PUBLISH       = 'Y' AND " + "      D.RECYCLED      = 'N' AND " + "      D.STOPDATE      IS NULL AND " + "      D.WORKIND       = " + 1 + " AND " + "      D.TEMPLATE      = 'N' AND " + "      D.MISFIT        = 'N' AND " + "      B.CATEGORYLEVEL IN ('" + "machine" + "','" + "subcategory" + "') AND " + "      B.PARENTCATIND  = C.TYPECATIND AND " + "      C.TYPECATIND    = " + typeCategoryRec2.getInd() + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                TypeCategoryRec typeCategoryRec3 = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec3.setDescript(resultSet.getString(2).trim());
                typeCategoryRec3.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec3.setOrderNum(resultSet.getInt(4));
                typeCategoryRec3.setCategoryLevel(resultSet.getString(5).trim());
                vector.addElement(typeCategoryRec3);
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctModels(TypeCategoryRec typeCategoryRec, TypeCategoryRec typeCategoryRec2, TypeCategoryRec typeCategoryRec3) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctModels ( " + typeCategoryRec + "," + typeCategoryRec2 + "," + typeCategoryRec3 + " )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            boolean bl = typeCategoryRec3.getCategoryLevel().equals("subcategory");
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND,  A.PRODNUM,       A.DESCRIPTION,   A.CREATEDON, " + "       A.CREATEDBY,   A.LASTTOUCHEDON, A.LASTTOUCHEDBY, A.CHECKEDOUTBY " + "FROM PRODRAFT.PRODUCT A, " + "     PRODRAFT.CATEGORY C, " + "     PRODRAFT.TYPECATEGORY B " + "WHERE A.PRODUCTIND = C.PRODUCTIND AND " + "      A.WORKIND    = " + 1 + " AND " + "      A.PUBLISH    = 'Y' AND " + "      A.RECYCLED   = 'N' AND " + "      A.TEMPLATE   = 'N' AND " + "      A.MISFIT     = 'N' AND " + "      A.STOPDATE IS NULL AND " + "      B.TYPECATIND = C.TYPECATIND AND " + "      B.PARENTCATIND = " + typeCategoryRec3.getInd() + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                ProductRow productRow = new ProductRow(resultSet.getInt(1), 0, resultSet.getString(2), resultSet.getString(3), DateSystem.prettyDateFromStamp(resultSet.getString(4).trim()), UserSystem.getNameFromUserId(resultSet.getString(5).trim()), null, null, UserSystem.getNameFromUserId(resultSet.getString(7).trim()), DateSystem.prettyDateFromStamp(resultSet.getString(6).trim()), true);
                if (resultSet.getString(8) != null) {
                    productRow.setImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 241));
                }
                vector.addElement(productRow);
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        ViewUtil.readAnnounceDatesForProducts("PRODRAFT", vector, false);
        return vector;
    }

    private void refreshProjectsUnderFamily(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode.getDataObject();
        Vector vector = this.readDistinctProjects(typeCategoryRec);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_PROJECT);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                viewTreeNode.add(viewTreeNode2);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private void refreshMachinesUnderProject(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode.getDataObject();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)((ViewTreeNode)viewTreeNode.getParent()).getDataObject();
        Vector vector = this.readDistinctMachines(typeCategoryRec2, typeCategoryRec);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_MACHINE);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                viewTreeNode.add(viewTreeNode2);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private void refreshModelsUnderMachine(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        ViewTreeNode viewTreeNode2 = (ViewTreeNode)viewTreeNode.getParent();
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode2.getDataObject();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)viewTreeNode.getDataObject();
        TypeCategoryRec typeCategoryRec3 = (TypeCategoryRec)((ViewTreeNode)viewTreeNode2.getParent()).getDataObject();
        Vector vector = this.readDistinctModels(typeCategoryRec3, typeCategoryRec, typeCategoryRec2);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            MutableTreeWrapper mutableTreeWrapper = null;
            while (n < n2) {
                mutableTreeWrapper = new MutableTreeWrapper();
                mutableTreeWrapper.setDataObject(vector.elementAt(n));
                viewTreeNode.add(mutableTreeWrapper);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    public int getTitlePadding() {
        return 80;
    }

    public String getFullSQL() {
        return "SELECT A.PRODUCTIND, A.PRODNUM,       A.DESCRIPTION,   A.CREATEDON, " + "       A.CREATEDBY,  A.LASTTOUCHEDON, A.LASTTOUCHEDBY, C.DESCRIPTION, " + "       A.CHECKEDOUTBY " + "FROM PRODRAFT.PRODUCT A, " + "     PRODRAFT.CATEGORY B, " + "     PRODRAFT.TYPECATEGORY C, " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.WORKIND    = " + 1 + " AND " + "      A.TEMPLATE   = 'N' AND " + "      A.PUBLISH    = 'Y' AND " + "      A.MISFIT     = 'N' AND " + "      A.RECYCLED   = 'N' AND " + "      A.STOPDATE   IS NULL AND " + "      B.TYPECATIND IN (SELECT TYPECATIND " + "                       FROM PRODUCT.TYPECATEGORY " + "                       WHERE PARENTCATIND = " + this.brandRec.getInd() + ") AND " + "      C.TYPECATIND  = B.TYPECATIND AND " + " FOR FETCH ONLY";
    }

    public TypeCategoryRec getBrand() {
        return this.brandRec;
    }

    private boolean vecContainsProduct(int n, Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3 && !bl) {
                if (((ProductRow)vector.elementAt(n2)).getProductInd() == n) {
                    bl = true;
                }
                ++n2;
            }
        }
        return bl;
    }
}

