/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.prodedit;

import com.ibm.nzna.projects.common.quest.status.Status;
import com.ibm.nzna.projects.common.quest.type.TypeStatusRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.popup.PopUpConst;
import com.ibm.nzna.projects.qit.gui.popup.PopUpDlg;
import com.ibm.nzna.projects.qit.gui.popup.PopUpListener;
import com.ibm.nzna.projects.qit.gui.popup.PopUpPanel;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.projects.qit.product.prodedit.ProdSaveAsDlgGUI;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ProdSaveAsDlg
extends JDialog
implements PopUpConst,
ProductConstants,
FocusListener,
ActionListener,
PopUpListener,
AppConst {
    private ProdSaveAsDlgGUI gui = null;
    private ProductRec oldProdRec = null;
    private ProductRec newProdRec = null;
    private PopUpDlg popUpDlg = null;

    public void windowDoneInit() {
        this.refreshData();
        this.gui.ef_PRODNUM.requestFocus();
    }

    private void refreshData() {
        if (this.oldProdRec != null) {
            StatusRec statusRec = (StatusRec)this.oldProdRec.getFieldData(6);
            this.gui.ef_PRODNUM.setText((String)this.oldProdRec.getFieldData(4));
            this.gui.ef_MACHINE.setText(((MachineRec)this.oldProdRec.getFieldData(2)).getMachine());
            this.gui.ef_MODEL.setText((String)this.oldProdRec.getFieldData(3));
            this.gui.mle_DESCRIPT.setText((String)this.oldProdRec.getFieldData(5));
            if (statusRec != null) {
                this.gui.cnr_STATUS.setSelectedValue(statusRec.getTypeStatus(), true);
                this.gui.ef_STATUSDATE.setText(statusRec.getDate());
            }
        }
    }

    public void createControls() {
        this.gui = new ProdSaveAsDlgGUI(this.getContentPane());
        this.getContentPane().setLayout(null);
        this.gui.createControls();
        this.gui.pb_COUNTRY.addActionListener(this);
        this.gui.pb_SAVENEW.addActionListener(this);
        this.gui.pb_SAVE.addActionListener(this);
        this.gui.pb_CANCEL.addActionListener(this);
        this.gui.ef_PRODNUM.addActionListener(this);
        this.gui.ef_MACHINE.addActionListener(this);
        this.gui.ef_STATUSDATE.addActionListener(this);
        this.gui.ef_MODEL.addActionListener(this);
        this.gui.ef_MODEL.addFocusListener(this);
        this.gui.ef_MACHINE.addFocusListener(this);
        if (this.oldProdRec.isOption()) {
            this.gui.st_PRODUCTNUMBER.setText(Str.getStr(293));
            this.gui.st_MACHINETYPE.setText(Str.getStr(335));
            this.gui.ef_MACHINE.setDocument(new MaskDocument(0, 20));
            this.gui.mle_DESCRIPT.setDocument(new MaskDocument(0, 40));
            this.gui.st_MODEL.setVisible(false);
            this.gui.ef_MODEL.setVisible(false);
        }
        this.refreshList();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        super.doLayout();
        this.gui.layoutControls(dimension.width, dimension.height);
    }

    private void refreshList() {
        Status.refreshList(this.gui.cnr_STATUS, 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof DButton) {
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.gui.pb_CANCEL == dButton) {
                this.dispose();
            } else if (this.gui.pb_COUNTRY == dButton) {
                this.initializePopUp();
                this.showPopUp(7, 3, this.newProdRec.getFieldData(7), 0, Str.getStr(298), Str.getStr(298), this).setRequired(true);
            } else if (this.gui.pb_SAVE == dButton) {
                if (this.saveData() && this.saveProduct()) {
                    this.dispose();
                    GUISystem.printBox(7, 752);
                }
            } else if (this.gui.pb_SAVENEW == dButton && this.saveData()) {
                this.saveProduct();
            }
        } else if (actionEvent.getSource() instanceof JTextField) {
            this.autoSetProductNumber();
            if (this.saveData()) {
                this.saveProduct();
            }
        }
    }

    private boolean saveData() {
        String string = this.gui.ef_PRODNUM.getText();
        String string2 = this.gui.ef_MACHINE.getText();
        String string3 = this.gui.mle_DESCRIPT.getText();
        String string4 = this.gui.ef_MODEL.getText();
        TypeStatusRec typeStatusRec = (TypeStatusRec)this.gui.cnr_STATUS.getSelectedValue();
        String string5 = this.gui.ef_STATUSDATE.getText();
        boolean bl = false;
        JLabel jLabel = null;
        this.gui.st_DESCRIPTION.setForeground(Color.black);
        this.gui.st_PRODUCTNUMBER.setForeground(Color.black);
        this.gui.st_STATUS.setForeground(Color.black);
        this.gui.st_STATUSDATE.setForeground(Color.black);
        this.gui.st_MODEL.setForeground(Color.black);
        if (this.gui.st_MACHINE != null) {
            this.gui.st_MACHINE.setForeground(Color.black);
        }
        if (string == null || string.length() == 0) {
            jLabel = this.gui.st_PRODUCTNUMBER;
        } else if (string2 == null || string2.length() < 4) {
            if (!this.newProdRec.isOption()) {
                jLabel = this.gui.st_MACHINE;
            }
        } else if (string4 == null || string4.length() < 3) {
            if (!this.newProdRec.isOption()) {
                jLabel = this.gui.st_MODEL;
            }
        } else if (string3 == null || string3.length() < 1) {
            jLabel = this.gui.st_DESCRIPTION;
        } else if (typeStatusRec == null) {
            jLabel = this.gui.st_STATUS;
        } else if (string5 == null || string5.length() < 10) {
            jLabel = this.gui.st_STATUSDATE;
        }
        if (jLabel == null) {
            String string6 = (String)this.oldProdRec.getFieldData(4);
            String string7 = ((MachineRec)this.oldProdRec.getFieldData(2)).getMachine();
            String string8 = (String)this.oldProdRec.getFieldData(3);
            this.newProdRec.setFieldData(4, string);
            this.newProdRec.setFieldData(5, string3);
            this.newProdRec.setFieldData(2, string2);
            this.newProdRec.setFieldData(3, string4);
            this.newProdRec.setFieldData(6, new StatusRec(typeStatusRec.getInd(), string5));
            this.newProdRec.updateRecStatus(0);
            this.newProdRec.updateRecStatus(2);
            if (string.equals(string6)) {
                jLabel = this.gui.st_PRODUCTNUMBER;
            } else if (string2.equals(string7) && string4.equals(string8) && !this.newProdRec.isOption()) {
                jLabel = this.gui.st_MODEL;
            }
        }
        if (jLabel != null) {
            ((Component)jLabel).setForeground(Color.red);
            if (jLabel == this.gui.st_DESCRIPTION) {
                this.gui.mle_DESCRIPT.requestFocus();
            } else if (jLabel == this.gui.st_PRODUCTNUMBER) {
                this.gui.ef_PRODNUM.requestFocus();
            } else if (jLabel == this.gui.st_MACHINE) {
                this.gui.ef_MACHINE.requestFocus();
            } else if (jLabel == this.gui.st_MODEL) {
                this.gui.ef_MODEL.requestFocus();
            } else if (jLabel == this.gui.st_STATUS) {
                this.gui.cnr_STATUS.requestFocus();
            } else if (jLabel == this.gui.st_STATUSDATE) {
                this.gui.ef_STATUSDATE.requestFocus();
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void popupAction(int n, PopUpDlg popUpDlg, int n2, Object object) {
        this.getContentPane().setEnabled(true);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!(this.oldProdRec.isOption() || focusEvent.getSource() != this.gui.ef_MACHINE && focusEvent.getSource() != this.gui.ef_MODEL)) {
            this.autoSetProductNumber();
        }
    }

    private boolean saveProduct() {
        boolean bl = false;
        this.setTitle(Str.getStr(731) + " " + Str.getStr(342));
        if (this.newProdRec.saveToDatabase(true)) {
            this.oldProdRec = null;
            this.oldProdRec = (ProductRec)this.newProdRec.clone();
            this.getContentPane().setEnabled(true);
            this.gui.ef_MACHINE.requestFocus();
            this.setTitle(Str.getStr(731) + " " + Str.getStr(752) + "(" + this.newProdRec.getFieldData(4) + ")");
            bl = true;
        } else {
            this.setTitle(Str.getStr(731));
        }
        return bl;
    }

    private void autoSetProductNumber() {
        if (!this.oldProdRec.isOption()) {
            String string = this.gui.ef_MACHINE.getText();
            String string2 = this.gui.ef_MODEL.getText();
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                this.gui.ef_PRODNUM.setText(string + "-" + string2);
            }
        }
    }

    public void initializePopUp() {
        if (this.popUpDlg == null) {
            this.popUpDlg = new PopUpDlg(GUISystem.getParentDefWin(this));
        }
    }

    public PopUpPanel showPopUp(int n, int n2, int n3, Object object, int n4, String string, String string2, PopUpListener popUpListener) {
        return this.popUpDlg.refreshPopUp(n2, n3, object, n4, string, string2, popUpListener);
    }

    public PopUpPanel showPopUp(int n, int n2, Object object, int n3, String string, String string2, PopUpListener popUpListener) {
        return this.showPopUp(0, n, n2, object, n3, string, string2, popUpListener);
    }

    public ProdSaveAsDlg(Frame frame, ProductRec productRec) {
        super(frame, Str.getStr(731), true);
        this.oldProdRec = productRec;
        this.setResizable(false);
        this.newProdRec = (ProductRec)this.oldProdRec.clone();
        this.createControls();
        this.windowDoneInit();
        ((Component)this).setSize(320, 270);
        WinUtil.centerChildInParent(this, frame);
        ((Component)this).setVisible(true);
    }
}

