/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.ValueLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class DatabaseInfoPanel
extends ListPanel
implements Authority,
ActionListener,
ProductPropertyListener,
AppConst,
ProductConst {
    public ValueLabel activeProductInd = new ValueLabel(Str.getStr(17068), new JLabel("" + 0));
    public ValueLabel draftProductInd = new ValueLabel(Str.getStr(17069), new JLabel("" + 0));
    public ValueLabel lastTouchedBy = new ValueLabel(Str.getStr(266), new JLabel("-"));
    public ValueLabel lastTouchedOn = new ValueLabel(Str.getStr(267), new JLabel("-"));
    public ValueLabel createdOn = new ValueLabel(Str.getStr(17028), new JLabel("-"));
    public ValueLabel createdBy = new ValueLabel(Str.getStr(17027), new JLabel("-"));
    public ValueLabel OPICMKey = new ValueLabel("OPIC/M Key", new JLabel("-"));
    public ValueLabel draftCreatedBy = new ValueLabel("Draft Created By", new JLabel("-"));
    public ValueLabel draftCreatedOn = new ValueLabel("Draft Created On", new JLabel("-"));
    public JCheckBox ck_ALLOW_OPICM = new JCheckBox("Allow OPIC/M to update");
    public Product product = null;

    private final void setValueLabelProperties(ValueLabel valueLabel) {
        valueLabel.setDescriptionWidth(150);
    }

    public void setProduct(Product product) {
        if (this.product != product) {
            if (this.product != null) {
                this.product.removeProductPropertyListener(this);
            }
            this.product = product;
            product.addProductPropertyListener(this);
        }
        this.refresh();
    }

    public void productChanged(Product product, int n) {
        this.setProduct(product);
    }

    private final void refresh() {
        if (this.product instanceof ProductDraft) {
            this.activeProductInd.setValue("" + ((ProductDraft)this.product).getExistingProductInd());
            this.draftProductInd.setValue("" + ((ProductDraft)this.product).getProductInd());
            this.draftCreatedOn.setValue(DateSystem.prettyDateFromStamp(((ProductDraft)this.product).getStartDate()));
            this.draftCreatedBy.setValue(UserSystem.getNameFromUserId(((ProductDraft)this.product).getDraftCreatedBy()));
            if (((ProductDraft)this.product).getOPICMKey() != null) {
                this.OPICMKey.setValue(((ProductDraft)this.product).getOPICMKey());
            } else {
                this.OPICMKey.setValue("NA");
            }
        } else {
            this.activeProductInd.setValue("" + this.product.getProductInd());
            this.draftProductInd.setValue("NA");
            this.draftCreatedOn.setValue("NA");
            this.draftCreatedBy.setValue("NA");
            this.OPICMKey.setValue("NA");
        }
        if (this.product.getLastTouchedOn() != null) {
            this.lastTouchedOn.setValue(DateSystem.prettyDateFromStamp(this.product.getLastTouchedOn()));
        } else {
            this.lastTouchedOn.setValue("-");
        }
        this.lastTouchedBy.setValue(UserSystem.getNameFromUserId(this.product.getLastTouchedBy()));
        this.createdOn.setValue(DateSystem.prettyDateFromStamp(this.product.getCreatedOn()));
        this.createdBy.setValue(UserSystem.getNameFromUserId(this.product.getCreatedBy()));
        this.ck_ALLOW_OPICM.setSelected(this.product.getOPICMImport());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ck_ALLOW_OPICM) {
            this.product.setOPICMImport(this.ck_ALLOW_OPICM.isSelected());
        }
    }

    public void setEditable(boolean bl) {
        this.ck_ALLOW_OPICM.setEnabled(bl);
    }

    public DatabaseInfoPanel() {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(550, GUISystem.getRowHeight() * 15));
        this.setValueLabelProperties(this.activeProductInd);
        this.setValueLabelProperties(this.draftProductInd);
        this.setValueLabelProperties(this.lastTouchedBy);
        this.setValueLabelProperties(this.lastTouchedOn);
        this.setValueLabelProperties(this.draftCreatedOn);
        this.setValueLabelProperties(this.draftCreatedBy);
        this.setValueLabelProperties(this.createdOn);
        this.setValueLabelProperties(this.createdBy);
        this.setValueLabelProperties(this.OPICMKey);
        this.ck_ALLOW_OPICM.setBackground(Color.white);
        this.setPadding(3);
        this.ck_ALLOW_OPICM.addActionListener(this);
        this.add(this.activeProductInd);
        this.add(this.createdOn);
        this.add(this.createdBy);
        this.add(new JLabel("______________________________"));
        this.add(this.draftProductInd);
        this.add(this.draftCreatedBy);
        this.add(this.draftCreatedOn);
        this.add(new JLabel("______________________________"));
        this.add(this.lastTouchedBy);
        this.add(this.lastTouchedOn);
        this.add(new JLabel("______________________________"));
        this.add(this.OPICMKey);
        if (UserSystem.hasBPMAuth()) {
            this.add(this.ck_ALLOW_OPICM);
        }
    }
}

