/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.product.CreateProductDraft;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productEdit.ProductEditor;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;

public class EditProduct
implements AppConst,
ProductConst {
    public static void editProduct(ProductRow productRow) {
        int n = 0;
        LogSystem.log(1, "Starting Read of product for Edit. Product Row Draft:" + productRow.isDraft());
        n = productRow.readProduct(true);
        switch (n) {
            case 0: {
                if (productRow.getProduct() instanceof ProductDraft) {
                    EditProduct.editProduct((ProductDraft)productRow.getProduct());
                    break;
                }
                EditProduct.editProduct(productRow.getProduct());
                break;
            }
            case 100: {
                GUISystem.printBox(7, 17067);
                break;
            }
            default: {
                LogSystem.log(1, "Cannot Read Product For Editing. SQLCode returned from ProductRow.readProduct: " + n);
                GUISystem.printBox(7, 202);
                break;
            }
        }
        LogSystem.log(1, "editProduct Method Complete");
    }

    public static void editProduct(Product product) {
        ProductDraft productDraft = EditProduct.createDraft(product);
        if (productDraft != null) {
            EditProduct.editProduct(productDraft);
        }
    }

    public static ProductDraft createDraft(Product product) {
        CreateProductDraft createProductDraft = ProductDraft.createProductDraft(product);
        ProductDraft productDraft = null;
        switch (createProductDraft.getReturnCode()) {
            case 0: {
                GUISystem.printBox(7, 202);
                break;
            }
            case 1: {
                if (GUISystem.printBox(Str.getStr(8), UserSystem.getNameFromUserId(createProductDraft.getProductDraft().getLastTouchedBy()) + " " + Str.getStr(1488))) {
                    productDraft = createProductDraft.getProductDraft();
                }
                productDraft.updateRecStatus(0);
                productDraft.updateRecStatus(1);
                break;
            }
            case 2: {
                if (!GUISystem.printBox(Str.getStr(8), UserSystem.getNameFromUserId(product.getLastTouchedBy()) + " " + Str.getStr(1660) + createProductDraft.getProductDraft().getComment())) break;
                productDraft = createProductDraft.getProductDraft();
                break;
            }
            case 4: {
                productDraft = createProductDraft.getProductDraft();
                break;
            }
        }
        return productDraft;
    }

    public static void editProduct(ProductDraft productDraft) {
        QuestPanel questPanel = null;
        if (productDraft.getDescription() == null) {
            productDraft.readFromDatabase();
        }
        if (!productDraft.getMisfit()) {
            EditProduct.setDefaultValues(productDraft);
            questPanel = WindowSystem.findQuestPanel(productDraft);
            if (questPanel != null) {
                WindowSystem.showPanel(questPanel);
            } else {
                WindowSystem.createPanel(new ProductEditor(productDraft));
            }
        } else {
            GUISystem.printBox("Info", "You cannot edit a Misfit Product");
        }
    }

    public static void setDefaultValues(ProductDraft productDraft) {
        if (productDraft.getCreatedOn() == null) {
            productDraft.setCreatedOn(new CDate(1).today());
        }
        if (productDraft.getCreatedBy() == null) {
            productDraft.setCreatedBy(UserSystem.getUserId());
        }
        if (productDraft.getDraftCreatedBy() == null) {
            productDraft.setDraftCreatedBy(UserSystem.getUserId());
        }
        if (productDraft.getLastTouchedBy() == null) {
            productDraft.setLastTouchedBy(UserSystem.getUserId());
        }
        if (productDraft.getInput() == null) {
            productDraft.setInput(UserSystem.getUserId());
        }
    }
}

