/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.dbgui.LocaleDlg;
import com.ibm.nzna.projects.qit.dbgui.LocaleDlgListener;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LocalePanel
extends DPanel
implements ProductPropertyListener,
ListSelectionListener,
DocConst,
LocaleDlgListener,
ActionListener,
AppConst {
    private JList locale = new JList();
    private JScrollPane scroll = new JScrollPane(this.locale);
    public JLabel help = new JLabel(Str.getStr(11005));
    private DButton select = new DButton(Str.getStr(404));
    private DButton remove = new DButton(Str.getStr(96));
    private DButton worldWide = new DButton(Str.getStr(210));
    private ListPanel buttonPanel = new ListPanel();
    private Product product = null;

    public void setProduct(Product product) {
        if (this.product != product) {
            if (this.product != null) {
                this.product.removeProductPropertyListener(this);
            }
            this.product = product;
            product.addProductPropertyListener(this);
        }
        this.populateList(product.getLocale());
    }

    public void populateList(LocaleRec localeRec) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        defaultListModel.clear();
        if (localeRec != null) {
            if (this.isEnabled()) {
                this.worldWide.setEnabled(!localeRec.isWorldWide());
                this.select.setEnabled(!localeRec.isWorldWide());
                this.help.setVisible(localeRec.isWorldWide());
            }
            if (localeRec.isWorldWide()) {
                Vector vector = new Vector(1);
                defaultListModel.addElement("<html><body><font size=5 face=\"Helvetica, Arial\"><b>" + Str.getStr(210) + "</b></font></body></html>");
            } else {
                int n;
                int n2;
                Vector vector = localeRec.getGeoListContainingAll();
                Vector vector2 = localeRec.getSingleCountryList();
                if (vector != null && vector.size() > 0) {
                    n2 = 0;
                    n = vector.size();
                    while (n2 < n) {
                        if (((TypeGeoRec)vector.elementAt(n2)).valid()) {
                            TypeGeoRec typeGeoRec = (TypeGeoRec)((TypeGeoRec)vector.elementAt(n2)).clone();
                            typeGeoRec.setEnhanceOutput(true);
                            defaultListModel.addElement(typeGeoRec);
                        }
                        ++n2;
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n2 = 0;
                    n = vector2.size();
                    while (n2 < n) {
                        defaultListModel.addElement(vector2.elementAt(n2));
                        ++n2;
                    }
                }
            }
            if (defaultListModel.size() == 0) {
                defaultListModel.addElement("<html><body><font size=1 face=\"Helvetica, Arial\">No Countries or Geographies, press 'Select' to<br>add countries or geographies</font></body></html>");
            }
        }
        this.locale.setModel(defaultListModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.select) {
            LocaleDlg localeDlg = new LocaleDlg(GUISystem.getParentDefWin(this));
            localeDlg.setLocaleDlgListener(this);
            localeDlg.waitForUser();
        } else if (actionEvent.getSource() == this.remove) {
            this.removeItem();
        } else if (actionEvent.getSource() == this.worldWide) {
            LocaleRec localeRec = this.product.getLocale();
            if (localeRec == null) {
                localeRec = new LocaleRec();
            }
            localeRec.setWorldWide(true);
            this.populateList(localeRec);
            this.product.setLocale(localeRec);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void localeDlgAddCountries(Object[] objectArray) {
        try {
            LocaleRec localeRec = this.product.getLocale();
            if (localeRec == null) {
                localeRec = new LocaleRec();
            }
            int n = 0;
            while (true) {
                if (n >= objectArray.length) {
                    this.product.setPropertyChangeEnabled(false);
                    this.product.setLocale(localeRec);
                    this.populateList(localeRec);
                    this.product.setPropertyChangeEnabled(true);
                    return;
                }
                localeRec.addCountry((TypeCountryCodeRec)objectArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void localeDlgAddGeo(TypeGeoRec typeGeoRec) {
        try {
            LocaleRec localeRec = this.product.getLocale();
            if (localeRec == null) {
                localeRec = new LocaleRec();
                this.product.setLocale(localeRec);
            }
            this.product.setPropertyChangeEnabled(false);
            localeRec.addGeography(typeGeoRec);
            this.product.setLocale(localeRec);
            this.populateList(localeRec);
            this.product.setPropertyChangeEnabled(true);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEnabled()) {
            this.remove.setEnabled(this.locale.getSelectedValue() != null);
        }
    }

    private final void removeItem() {
        Object[] objectArray = this.locale.getSelectedValues();
        LocaleRec localeRec = this.product.getLocale();
        if (objectArray != null && objectArray.length > 0 && localeRec != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof TypeGeoRec) {
                    localeRec.removeGeography((TypeGeoRec)objectArray[n]);
                } else if (objectArray[n] instanceof TypeCountryCodeRec) {
                    localeRec.removeCountry((TypeCountryCodeRec)objectArray[n]);
                } else if (objectArray[n] instanceof String) {
                    localeRec.setWorldWide(false);
                }
                ++n;
            }
            this.product.setPropertyChangeEnabled(false);
            this.product.setLocale(localeRec);
            this.populateList(localeRec);
            this.product.setPropertyChangeEnabled(true);
        }
    }

    public void setEditable(boolean bl) {
        super.setEnabled(bl);
        this.worldWide.setEnabled(bl);
        this.remove.setEnabled(bl);
        this.select.setEnabled(bl);
    }

    public void productChanged(Product product, int n) {
        if (n == 13) {
            this.populateList(product.getLocale());
        }
    }

    public LocalePanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = GUISystem.getRequiredJLabel();
        this.setBackground(Color.white);
        this.buttonPanel.setBackground(Color.white);
        this.locale.setModel(new DefaultListModel());
        this.remove.setEnabled(false);
        this.help.setVisible(false);
        jPanel.setBackground(Color.white);
        this.select.addActionListener(this);
        this.remove.addActionListener(this);
        this.worldWide.addActionListener(this);
        this.locale.addListSelectionListener(this);
        jPanel.setLayout(new BorderLayout());
        this.buttonPanel.add(this.select);
        this.buttonPanel.add(this.remove);
        this.buttonPanel.add(this.worldWide);
        this.buttonPanel.setPreferredSize(new Dimension(75, 100));
        this.setPreferredSize(new Dimension(500, 200));
        this.setLayout(new BorderLayout());
        this.add((Component)jLabel, "North");
        this.add((Component)this.scroll, "Center");
        this.add((Component)jPanel, "East");
        jPanel.add((Component)this.buttonPanel, "Center");
        jPanel.add((Component)this.help, "South");
        jPanel.setPreferredSize(new Dimension(75, 200));
        jPanel.setMaximumSize(new Dimension(75, 200));
        jPanel.setMinimumSize(new Dimension(75, 200));
        jLabel.setText("Required For Publish");
    }
}

