/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeCustomerRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeOfferingRec;
import com.ibm.nzna.projects.common.quest.type.TypeWarrantyRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class OtherInfoPanel
extends DPanel
implements ActionListener,
FocusListener,
ProductPropertyListener,
AppConst,
ProductConst {
    public JLabel st_BASE = new JLabel(Str.getStr(17070));
    public JTextField ef_BASE = new JTextField(new MaskDocument(0, 7), "", 0);
    public JLabel st_OFFERING = new JLabel("*" + Str.getStr(17023));
    public JLabel st_CUSTOMER = new JLabel("*" + Str.getStr(17024));
    public JLabel st_WARRANTY = new JLabel("*" + Str.getStr(17022));
    public JLabel st_INPUT = new JLabel(Str.getStr(17025));
    public JLabel st_SOURCE = new JLabel(Str.getStr(283));
    public JComboBox cb_OFFERING = new JComboBox(TypeList.getInstance().getTypeList(24));
    public JComboBox cb_CUSTOMER = new JComboBox(TypeList.getInstance().getTypeList(25));
    public JComboBox cb_WARRANTY;
    public JLabel stt_INPUT;
    public JTextField ef_SOURCE;
    public Product product;
    private boolean processActions;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        this.st_BASE.setBounds(n, n2, 100, n3);
        this.ef_BASE.setBounds(n + 140, n2, 100, n3);
        this.st_OFFERING.setBounds(n, n2 += n3, 100, n3);
        this.cb_OFFERING.setBounds(n + 140, n2, 200, n3);
        this.st_CUSTOMER.setBounds(n, n2 += n3, 100, n3);
        this.cb_CUSTOMER.setBounds(n + 140, n2, 200, n3);
        this.st_WARRANTY.setBounds(n, n2 += n3, 100, n3);
        this.cb_WARRANTY.setBounds(n + 140, n2, dimension.width - (n + 140), n3);
        this.st_INPUT.setBounds(n, n2 += n3, 100, n3);
        this.stt_INPUT.setBounds(n + 140, n2, 100, n3);
        this.st_SOURCE.setBounds(n, n2 += n3, 100, n3);
        this.ef_SOURCE.setBounds(n + 140, n2, 200, n3);
        n2 += n3;
    }

    public void setProduct(Product product) {
        if (this.product != product) {
            if (this.product != null) {
                this.product.removeProductPropertyListener(this);
            }
            this.product = product;
            product.addProductPropertyListener(this);
        }
        this.refresh();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refresh() {
        String string = this.product.getSource();
        this.processActions = false;
        try {
            if (this.product.getBaseModel() != null) {
                this.ef_BASE.setText(this.product.getBaseModel());
            }
            this.cb_CUSTOMER.setSelectedItem(TypeList.getInstance().objectFromInd(this.product.getCustomer(), 25));
            this.cb_WARRANTY.setSelectedItem(TypeList.getInstance().objectFromInd(this.product.getWarranty(), 26));
            this.cb_OFFERING.setSelectedItem(TypeList.getInstance().objectFromInd(this.product.getOffering(), 24));
            if (this.product instanceof ProductDraft && ((ProductDraft)this.product).isOPICM() && string.indexOf("(OPIC/M)") == -1) {
                string = "(OPIC/M) " + string;
            }
            this.stt_INPUT.setText(this.product.getInput());
            this.ef_SOURCE.setText(string);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Could not populate the 'Other Info'. Please report this problem to the 1-888-IBM-HELP desk");
        }
        this.processActions = true;
    }

    public void productChanged(Product product, int n) {
        if (n == 1 || n == 9 || n == 20 || n == 14) {
            product.setPropertyChangeEnabled(false);
            this.refresh();
            product.setPropertyChangeEnabled(true);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.ef_BASE) {
            this.product.setBaseModel(this.ef_BASE.getText());
        } else if (focusEvent.getSource() == this.ef_SOURCE) {
            String string = this.ef_SOURCE.getText();
            if (this.product instanceof ProductDraft && ((ProductDraft)this.product).isOPICM() && string.indexOf("(OPIC/M)") == -1) {
                string = "(OPIC/M) " + string;
            }
            this.product.setSource(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.processActions) {
            if (actionEvent.getSource() == this.cb_WARRANTY) {
                this.product.setWarranty(((TypeWarrantyRec)this.cb_WARRANTY.getSelectedItem()).getInd());
            }
            if (actionEvent.getSource() == this.cb_OFFERING) {
                this.product.setOffering(((TypeOfferingRec)this.cb_OFFERING.getSelectedItem()).getInd());
            }
            if (actionEvent.getSource() == this.cb_CUSTOMER) {
                this.product.setCustomer(((TypeCustomerRec)this.cb_CUSTOMER.getSelectedItem()).getInd());
            }
        }
    }

    protected void setEditable(boolean bl) {
        this.cb_CUSTOMER.setEnabled(bl);
        this.cb_OFFERING.setEnabled(bl);
        this.cb_WARRANTY.setEnabled(bl);
        this.ef_BASE.setEnabled(bl);
    }

    public OtherInfoPanel() {
        TypeList.getInstance();
        this.cb_WARRANTY = new JComboBox(TypeList.getLongWarrantyList());
        this.stt_INPUT = new JLabel();
        this.ef_SOURCE = new JTextField();
        this.product = null;
        this.processActions = true;
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(650, GUISystem.getRowHeight() * 6));
        this.ef_BASE.addFocusListener(this);
        this.ef_SOURCE.addFocusListener(this);
        this.cb_WARRANTY.addActionListener(this);
        this.cb_CUSTOMER.addActionListener(this);
        this.ef_SOURCE.addActionListener(this);
        this.cb_OFFERING.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_BASE);
        this.add(this.ef_BASE);
        this.add(this.st_OFFERING);
        this.add(this.cb_OFFERING);
        this.add(this.st_CUSTOMER);
        this.add(this.cb_CUSTOMER);
        this.add(this.st_WARRANTY);
        this.add(this.cb_WARRANTY);
        this.add(this.st_INPUT);
        this.add(this.stt_INPUT);
        this.add(this.st_SOURCE);
        this.add(this.ef_SOURCE);
    }
}

