/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductComment;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productEdit.DatabaseInfoPanel;
import com.ibm.nzna.projects.qit.product.productEdit.DatePanel;
import com.ibm.nzna.projects.qit.product.productEdit.DescriptionPanel;
import com.ibm.nzna.projects.qit.product.productEdit.LocalePanel;
import com.ibm.nzna.projects.qit.product.productEdit.OtherInfoPanel;
import com.ibm.nzna.projects.qit.product.productEdit.ProductEditPanelListener;
import com.ibm.nzna.projects.qit.product.productEdit.ProductInfoPanel;
import com.ibm.nzna.projects.qit.product.productEdit.SaveProductDlg;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.JTextAreaCounter;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.gui.form.FormComponent;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ProductEditPanel
extends JPanel
implements PropertyListener,
ProductPropertyListener,
FocusListener,
Runnable,
AppConst,
ProductConst {
    private static final String THREAD_CREATE_FORM = "CF";
    private static final String THREAD_FIRE_REFRESH_COMPLETE = "RFC";
    public static final String FORM_PRODUCT_PARTNUM = "";
    public static final String FORM_DESCRIPTION = Str.getStr(100);
    public static final String FORM_PRODUCT_INFORMATION = Str.getStr(17016);
    public static final String FORM_COMMENT = Str.getStr(290);
    public static final String FORM_COMMENT_HISTORY = Str.getStr(303);
    public static final String FORM_DATES = Str.getStr(17015);
    public static final String FORM_OTHER_INFORMATION = Str.getStr(17014);
    public static final String FORM_LOCATION = Str.getStr(437);
    public static final String FORM_XREF = Str.getStr(17041);
    public static final String FORM_DATABASE_INFORMATION = Str.getStr(263);
    private Vector listeners = new Vector();
    public JLabel st_PROD_PARTNUM = null;
    public LocalePanel localePanel = null;
    public OtherInfoPanel otherInfoPanel = null;
    private ListPanel dataPanel = null;
    private JScrollPane scrollPane = null;
    public DescriptionPanel description = null;
    public DatabaseInfoPanel databaseInfoPanel = null;
    private NoTabJTextArea currentComment = null;
    private NoTabJTextArea currentCommentHistory = null;
    private JLabel commentHistoryLabel = null;
    public DatePanel datePanel = null;
    public ProductInfoPanel productInformation = null;
    public JScrollPane commentHistoryScroll = null;
    private Vector focusGUI = new Vector(1);
    private boolean editable = true;
    private Product product = null;

    public void setProduct(Product product) {
        if (this.product != null) {
            this.product.removeProductPropertyListener(this);
        }
        this.product = product;
        if (product != null) {
            product.addProductPropertyListener(this);
            new Thread((Runnable)this, THREAD_CREATE_FORM).start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEditable(boolean bl) {
        this.editable = bl;
        try {
            if (this.localePanel != null) {
                this.localePanel.setEditable(bl);
            }
            if (this.otherInfoPanel != null) {
                this.otherInfoPanel.setEditable(bl);
            }
            if (this.description != null) {
                this.description.setEditable(bl);
            }
            if (this.currentComment != null) {
                this.currentComment.setEditable(bl);
            }
            if (this.datePanel != null) {
                this.datePanel.setEditable(bl);
            }
            if (this.productInformation != null) {
                this.productInformation.setEditable(bl);
            }
            if (this.databaseInfoPanel != null) {
                this.databaseInfoPanel.setEditable(bl);
            }
            if (!(this.product instanceof ProductDraft)) return;
            if (!((ProductDraft)this.product).isOPICM()) return;
            this.localePanel.setEditable(false);
            this.datePanel.setEditable(false);
            this.productInformation.setEditable(false);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public int saveProduct() {
        boolean bl = false;
        boolean bl2 = true;
        if (bl2) {
            ((ProductDraft)this.product).setComment(this.currentComment.getText());
            SaveProductDlg saveProductDlg = new SaveProductDlg(GUISystem.getParentDefWin(this), (ProductDraft)this.product, this.currentComment.getText());
            if (saveProductDlg.getReturnCode() == 5) {
                this.setProduct(saveProductDlg.getProduct());
            }
            return saveProductDlg.getReturnCode();
        }
        return 0;
    }

    private final void initialize() {
        PropertySystem.addPropertyListener(202, this);
        if (PropertySystem.get(202) == null) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(FORM_PRODUCT_PARTNUM);
            vector.addElement(FORM_DESCRIPTION);
            vector.addElement(FORM_PRODUCT_INFORMATION);
            vector.addElement(FORM_COMMENT);
            vector.addElement(FORM_COMMENT_HISTORY);
            vector.addElement(FORM_DATES);
            vector.addElement(FORM_OTHER_INFORMATION);
            vector.addElement(FORM_LOCATION);
            vector.addElement(FORM_DATABASE_INFORMATION);
            PropertySystem.put(202, vector);
        }
        this.dataPanel = new ListPanel();
        this.scrollPane = new JScrollPane(this.dataPanel);
        this.dataPanel.setBackground(Color.white);
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.setBorder(GUISystem.emptyBorder);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(GUISystem.getRowHeight());
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_CREATE_FORM)) {
            this.addFormComponents();
        } else if (string.equals(THREAD_FIRE_REFRESH_COMPLETE)) {
            this.fireRefreshComplete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addFormComponents() {
        Vector vector = (Vector)PropertySystem.get(202);
        int n = 0;
        int n2 = vector.size();
        String string = null;
        JComponent jComponent = null;
        try {
            this.removeAllFocusListeners();
            try {
                this.dataPanel.removeAll();
            }
            catch (Exception exception) {
            }
            if (this.dataPanel == null) {
                this.dataPanel = new ListPanel();
            }
            while (true) {
                block30: {
                    block32: {
                        Object object;
                        block31: {
                            block29: {
                                if (n >= n2) {
                                    this.setEditable(this.editable);
                                    this.revalidate();
                                    new Thread((Runnable)this, THREAD_FIRE_REFRESH_COMPLETE).start();
                                    return;
                                }
                                string = (String)vector.elementAt(n);
                                jComponent = null;
                                if (!string.equals(FORM_PRODUCT_PARTNUM)) break block29;
                                object = FORM_PRODUCT_PARTNUM;
                                if (this.product != null && this.product.getBrand() != null) {
                                    object = Brands.getOptionBrand().getInd() == this.product.getBrand().getInd() ? this.product.getPartNumber().toString() : this.product.getProdNum();
                                }
                                jComponent = object != null ? (this.st_PROD_PARTNUM = new JLabel((String)object)) : (this.st_PROD_PARTNUM = new JLabel(FORM_PRODUCT_PARTNUM));
                                this.st_PROD_PARTNUM.setBackground(Color.white);
                                this.st_PROD_PARTNUM.setForeground(new Color(0, 0, 150));
                                this.st_PROD_PARTNUM.setFont(FontSystem.largeTitleFont);
                                this.dataPanel.add(this.st_PROD_PARTNUM);
                                break block30;
                            }
                            if (!string.equals(FORM_DESCRIPTION)) break block31;
                            this.description = new DescriptionPanel();
                            jComponent = new FormComponent(Str.getStr(100), this.description);
                            this.description.setProduct(this.product);
                            break block30;
                        }
                        if (!string.equals(FORM_COMMENT)) break block32;
                        if (this.product != null && this.product instanceof ProductDraft) {
                            object = new JPanel();
                            JPanel jPanel = new JPanel();
                            int n3 = 1024;
                            String string2 = null;
                            JTextAreaCounter jTextAreaCounter = null;
                            try {
                                string2 = ((ProductDraft)this.product).getOriginalComments();
                            }
                            catch (Exception exception) {
                                string2 = FORM_PRODUCT_PARTNUM;
                            }
                            if (string2 != null) {
                                n3 -= string2.length();
                            }
                            this.currentCommentHistory = new NoTabJTextArea();
                            this.currentComment = new NoTabJTextArea();
                            this.currentComment.setFont(FontSystem.defaultFont);
                            this.currentComment.setDocument(new MaskDocument(0, n3));
                            this.currentCommentHistory.setFont(FontSystem.defaultFont);
                            this.currentCommentHistory.setBackground(new Color(240, 240, 240));
                            this.currentComment.setEditable(this.editable);
                            jTextAreaCounter = new JTextAreaCounter(this.currentComment);
                            ((Container)object).setLayout(new BorderLayout());
                            jPanel.setLayout(new BorderLayout());
                            jPanel.setBackground(Color.white);
                            ((Container)object).add((Component)this.currentCommentHistory, "North");
                            ((Container)object).add((Component)this.currentComment, "Center");
                            jPanel.add(new JScrollPane((Component)object));
                            jPanel.add((Component)jTextAreaCounter, "South");
                            jComponent = new FormComponent(Str.getStr(290), jPanel);
                            ((FormComponent)jComponent).setPreferredSize(new Dimension(470, GUISystem.getRowHeight() * 5 + 22));
                            if (((ProductDraft)this.product).getComment() != null) {
                                this.currentComment.setText(((ProductDraft)this.product).getComment().toString());
                            }
                            if (string2 != null) {
                                this.currentCommentHistory.setText(string2);
                            }
                        }
                        break block30;
                    }
                    if (string.equals(FORM_DATES)) {
                        this.datePanel = new DatePanel();
                        jComponent = new FormComponent(Str.getStr(17015), this.datePanel);
                        this.datePanel.setProduct(this.product);
                    } else if (string.equals(FORM_PRODUCT_INFORMATION)) {
                        this.productInformation = new ProductInfoPanel();
                        jComponent = new FormComponent(Str.getStr(17016), this.productInformation);
                        if (this.product != null) {
                            this.productInformation.setProduct(this.product);
                        }
                    } else if (string.equals(FORM_LOCATION)) {
                        this.localePanel = new LocalePanel();
                        jComponent = new FormComponent(Str.getStr(437), this.localePanel);
                        this.localePanel.setProduct(this.product);
                    } else if (string.equals(FORM_OTHER_INFORMATION)) {
                        this.otherInfoPanel = new OtherInfoPanel();
                        jComponent = new FormComponent(Str.getStr(17014), this.otherInfoPanel);
                        this.otherInfoPanel.setProduct(this.product);
                    } else if (string.equals(FORM_DATABASE_INFORMATION)) {
                        this.databaseInfoPanel = new DatabaseInfoPanel();
                        jComponent = new FormComponent(Str.getStr(263), this.databaseInfoPanel);
                        this.databaseInfoPanel.setProduct(this.product);
                    } else if (string.equals(FORM_COMMENT_HISTORY) && this.product instanceof ProductDraft) {
                        this.commentHistoryLabel = new JLabel(this.getCommentHistoryAsText((ProductDraft)this.product));
                        this.commentHistoryLabel.setOpaque(false);
                        this.commentHistoryScroll = new JScrollPane(this.commentHistoryLabel);
                        this.commentHistoryScroll.setOpaque(false);
                        jComponent = new FormComponent(Str.getStr(303), this.commentHistoryScroll);
                        ((FormComponent)jComponent).setPreferredSize(new Dimension(470, GUISystem.getRowHeight() * 5 + 22));
                    }
                }
                if (jComponent != null) {
                    if (jComponent instanceof FormComponent && jComponent != this.st_PROD_PARTNUM) {
                        GUISystem.setPropertiesOnFormComponent((FormComponent)jComponent);
                    }
                    this.dataPanel.add(jComponent);
                    this.addComponentFocus(jComponent);
                } else {
                    LogSystem.log(1, "Cannot add FormComponent:" + string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void addComponentFocus(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JCheckBox || componentArray[n] instanceof JRadioButton || componentArray[n] instanceof JList || componentArray[n] instanceof JTextArea || componentArray[n] instanceof JTextField || componentArray[n] instanceof JButton) {
                    componentArray[n].addFocusListener(this);
                    this.focusGUI.addElement(componentArray[n]);
                } else if (componentArray[n] instanceof Container) {
                    this.addComponentFocus((Container)componentArray[n]);
                }
                ++n;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        boolean bl = true;
        Component component = (Component)focusEvent.getSource();
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = this.scrollPane.getViewport().getViewRect();
        while (bl) {
            Container container = component.getParent();
            Rectangle rectangle3 = container.getBounds();
            boolean bl2 = bl = container != this.dataPanel;
            if (!bl) continue;
            rectangle.y += rectangle3.y;
            component = container;
        }
        if (!rectangle2.contains(rectangle.x, rectangle.y)) {
            this.scrollPane.getViewport().setViewPosition(new Point(rectangle.x, rectangle.y));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void productChanged(Product product, int n) {
        if (n == 4 || n == 3 || n == 22) {
            String string = product.getProdNum();
            if (string == null) {
                string = product.getPartNumber() != null ? product.getPartNumber().toString() : FORM_PRODUCT_PARTNUM;
            }
            this.st_PROD_PARTNUM.setText(string);
        }
    }

    private final void removeAllFocusListeners() {
        int n = 0;
        int n2 = this.focusGUI.size();
        while (n < n2) {
            ((Component)this.focusGUI.elementAt(n)).removeFocusListener(this);
            ++n;
        }
        this.focusGUI.removeAllElements();
    }

    public DPanel getFormPanel() {
        return this.dataPanel;
    }

    public void propertyChanged(int n, Object object) {
        this.addFormComponents();
    }

    public void free() {
        PropertySystem.removePropertyListener(202, this);
        this.product.removeProductPropertyListener(this);
    }

    public void addProductEditPanelListener(ProductEditPanelListener productEditPanelListener) {
        this.listeners.addElement(productEditPanelListener);
    }

    public void removeProductEditPanelListener(ProductEditPanelListener productEditPanelListener) {
        this.listeners.removeElement(productEditPanelListener);
    }

    public void fireRefreshComplete() {
        if (this.listeners.size() > 0) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((ProductEditPanelListener)this.listeners.elementAt(n)).refreshComplete();
                ++n;
            }
        }
    }

    public JPanel getContentPanel() {
        return this.dataPanel;
    }

    public Product getProduct() {
        return this.product;
    }

    public String getCommentHistoryAsText(ProductDraft productDraft) {
        Vector vector = productDraft.getCommentHistory();
        StringBuffer stringBuffer = new StringBuffer("<html><body bgcolor=white><font size=2 face=\"Helvetica, Arial\">");
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ProductComment productComment = (ProductComment)vector.elementAt(n);
                stringBuffer.append("<font size=2 face=\"Helvetica, Arial\"><b>");
                if (productComment.toString().indexOf("saved this product but made no comment") != -1) {
                    stringBuffer.append(productComment.toString());
                } else {
                    stringBuffer.append("On ");
                    stringBuffer.append(DateSystem.prettyDateFromStamp(productComment.getLastTouchedOn()));
                    stringBuffer.append(" ");
                    stringBuffer.append(UserSystem.getNameFromUserId(productComment.getLastTouchedBy()));
                    stringBuffer.append(" wrote:</b></font><br>");
                    stringBuffer.append(productComment.toString());
                }
                if (n < n2 - 1) {
                    stringBuffer.append("<hr><br><br>");
                }
                ++n;
            }
        }
        stringBuffer.append("<br><br><br></body></html>");
        return stringBuffer.toString();
    }

    public ProductEditPanel() {
        this.initialize();
    }

    public ProductEditPanel(Product product) {
        this.initialize();
        this.setProduct(product);
    }
}

