/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.ValueLabel;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ProductInfoPanel
extends DPanel
implements FocusListener,
Runnable,
DataLengths,
ProductPropertyListener,
ActionListener,
AppConst,
ProductConst {
    private static final String THREAD_REFRESH = "REFRESH";
    private static final String THREAD_SAVE_MODEL = "saveModel";
    private boolean processActions = false;
    private ValueLabel st_PRODUCT_TYPE = new ValueLabel(Str.getStr(17045), new JLabel(""));
    private JComboBox cb_BRAND = null;
    private JComboBox cb_FAMILY = null;
    private JComboBox cb_MACHINE = null;
    private JTextField ef_MODEL = null;
    private JComboBox cb_PROJECT = null;
    public JLabel st_BRAND = null;
    public JLabel st_FAMILY = null;
    public JLabel st_MACHINE = null;
    public JLabel st_MODEL = null;
    public JLabel st_PROJECT = null;
    private HotLinkLabel pb_NEW_PROJECT = new HotLinkLabel(Str.getStr(171));
    private HotLinkLabel pb_NEW_MACHINE = new HotLinkLabel(Str.getStr(171));
    private Product product = null;
    private boolean enableInput = true;
    private boolean thread = true;
    private boolean isOption = false;

    public void setProduct(Product product) {
        if (this.product != product) {
            if (this.product != null) {
                this.product.removeProductPropertyListener(this);
            }
            this.product = product;
            product.addProductPropertyListener(this);
        }
        this.isOption = product.getProductType() == 2;
        new Thread((Runnable)this, THREAD_REFRESH).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        try {
            this.st_PRODUCT_TYPE.setBounds(n, n2, dimension.width - n * 2, n3);
            this.st_BRAND.setBounds(n, n2 += n3, 75, n3);
            this.cb_BRAND.setBounds(n + 75, n2, 150, n3);
            this.st_FAMILY.setBounds(n, n2 += n3, 75, n3);
            this.cb_FAMILY.setBounds(n + 75, n2, 170, n3);
            this.st_PROJECT.setBounds(n, n2 += n3, 75, n3);
            this.cb_PROJECT.setBounds(n + 75, n2, 250, n3);
            this.pb_NEW_PROJECT.setBounds(n + 75 + 255, n2, 70, n3);
            this.st_MACHINE.setBounds(n, n2 += n3, 75, n3);
            this.cb_MACHINE.setBounds(n + 75, n2, 150, n3);
            this.pb_NEW_MACHINE.setBounds(n + 75 + 155, n2, 70, n3);
            this.st_MODEL.setBounds(n, n2 += n3, 75, n3);
            this.ef_MODEL.setBounds(n + 75, n2, 75, n3);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.processActions) {
            if (actionEvent.getSource() == this.cb_BRAND && this.comboBoxHasValidData(this.cb_BRAND)) {
                System.out.println("Set Brand to :" + (TypeCategoryRec)this.cb_BRAND.getSelectedItem());
                this.product.setBrand((TypeCategoryRec)this.cb_BRAND.getSelectedItem());
                this.product.setFamily(null);
                this.product.setMachine(null);
                this.product.setSubCategory(null);
                this.product.setProject(null);
                this.product.setModel(null);
                new Thread((Runnable)this, THREAD_REFRESH).start();
            }
            if (actionEvent.getSource() == this.cb_FAMILY && this.comboBoxHasValidData(this.cb_FAMILY)) {
                this.product.setFamily((TypeCategoryRec)this.cb_FAMILY.getSelectedItem());
                this.product.setMachine(null);
                this.product.setSubCategory(null);
                this.product.setProject(null);
                this.product.setModel(null);
                new Thread((Runnable)this, THREAD_REFRESH).start();
            }
            if (actionEvent.getSource() == this.cb_PROJECT && this.comboBoxHasValidData(this.cb_PROJECT)) {
                this.product.setProject((TypeCategoryRec)this.cb_PROJECT.getSelectedItem());
                this.product.setMachine(null);
                this.product.setSubCategory(null);
                this.product.setModel(null);
                new Thread((Runnable)this, THREAD_REFRESH).start();
            }
            if (actionEvent.getSource() == this.cb_MACHINE && this.comboBoxHasValidData(this.cb_MACHINE)) {
                if (this.isOption) {
                    this.product.setSubCategory((TypeCategoryRec)this.cb_MACHINE.getSelectedItem());
                } else {
                    this.product.setMachine((TypeCategoryRec)this.cb_MACHINE.getSelectedItem());
                }
                this.product.setModel(null);
                new Thread((Runnable)this, THREAD_REFRESH).start();
            } else if (actionEvent.getSource() == this.ef_MODEL) {
                this.saveModelField();
            } else if (actionEvent.getSource() == this.pb_NEW_PROJECT) {
                if (this.cb_FAMILY.getSelectedItem() != null && !(this.cb_FAMILY.getSelectedItem() instanceof String)) {
                    TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_FAMILY.getSelectedItem();
                    String string = null;
                    string = new SingleEntryDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(171), Str.getStr(17019), "", new MaskDocument(0, 50)).getResult();
                    if (string != null) {
                        if (!this.duplicateProject(string, typeCategoryRec)) {
                            TypeCategoryRec typeCategoryRec2 = TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), string, "project", 0, "N", UserSystem.getUserId());
                            TypeCategory.writeToDatabase();
                            ((DefaultComboBoxModel)this.cb_PROJECT.getModel()).addElement(typeCategoryRec2);
                            this.cb_PROJECT.setSelectedItem(typeCategoryRec2);
                        } else {
                            GUISystem.printBox("Info", "That Project already exists under the family " + typeCategoryRec.toString());
                        }
                    }
                } else {
                    GUISystem.printBox(7, 17074);
                }
            } else if (actionEvent.getSource() == this.pb_NEW_MACHINE) {
                if (this.cb_PROJECT.getSelectedItem() != null && !(this.cb_PROJECT.getSelectedItem() instanceof String)) {
                    TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_PROJECT.getSelectedItem();
                    String string = null;
                    int n = this.isOption ? 25 : 4;
                    String string2 = this.isOption ? Str.getStr(1662) : Str.getStr(340);
                    String string3 = this.isOption ? "subcategory" : "machine";
                    string = new SingleEntryDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(171), string2, "", new MaskDocument(0, n)).getResult();
                    if (string != null) {
                        if (!this.duplicateMachine(string, typeCategoryRec)) {
                            TypeCategoryRec typeCategoryRec3 = TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), string, string3, 0, "N", UserSystem.getUserId());
                            typeCategoryRec3.writeToDatabase();
                            if (this.isOption) {
                                this.product.setSubCategory(typeCategoryRec3);
                            } else {
                                this.product.setMachine(typeCategoryRec3);
                            }
                            this.refresh();
                            this.cb_MACHINE.setSelectedItem(typeCategoryRec3);
                            this.enableInput();
                        } else {
                            GUISystem.printBox("Info", "That machine already exists under the project " + typeCategoryRec.toString());
                        }
                    }
                } else {
                    GUISystem.printBox(7, 17075);
                }
            }
        }
    }

    private final void refresh() {
        this.processActions = false;
        this.st_PRODUCT_TYPE.setValue(TypeList.getInstance().objectFromInd(this.product.getProductType(), 23).toString());
        if (this.isOption) {
            Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
            vector.addElement(Brands.getOptionBrand());
            WinUtil.setJComboBoxData(this.cb_BRAND, vector);
            this.product.setBrand(Brands.getOptionBrand());
        } else {
            Vector vector = Brands.getBrands();
            int n = this.product.getProductType();
            if (n == 1) {
                vector.removeElement(Brands.getOptionBrand());
                vector.removeElement(Brands.getMonitorBrand());
                vector.removeElement(Brands.getCrossBrand());
                WinUtil.setJComboBoxData(this.cb_BRAND, this.createDisplayVec(vector));
            } else if (n == 3) {
                WinUtil.setJComboBoxData(this.cb_BRAND, this.createDisplayVec(vector));
                this.product.setBrand(Brands.getMonitorBrand());
            }
        }
        if (this.product.getBrand() != null) {
            this.cb_BRAND.setSelectedItem(this.product.getBrand());
        }
        if (this.comboBoxHasValidData(this.cb_BRAND)) {
            WinUtil.setJComboBoxData(this.cb_FAMILY, this.createDisplayVec(Brands.getFamilies((TypeCategoryRec)this.cb_BRAND.getSelectedItem())));
            if (this.product.getFamily() != null) {
                this.cb_FAMILY.setSelectedItem(this.product.getFamily());
            }
        }
        if (this.comboBoxHasValidData(this.cb_FAMILY)) {
            WinUtil.setJComboBoxData(this.cb_PROJECT, this.createDisplayVec(TypeCategory.getChildDraftCategories(((TypeCategoryRec)this.cb_FAMILY.getSelectedItem()).getInd(), "project")));
            if (this.product.getProject() != null) {
                this.cb_PROJECT.setSelectedItem(this.product.getProject());
            }
        }
        if (this.comboBoxHasValidData(this.cb_PROJECT)) {
            WinUtil.setJComboBoxData(this.cb_MACHINE, this.createDisplayVec(TypeCategory.getChildDraftCategories(((TypeCategoryRec)this.cb_PROJECT.getSelectedItem()).getInd(), this.isOption ? "subcategory" : "machine")));
            if (this.isOption) {
                if (this.product.getSubCategory() != null) {
                    this.cb_MACHINE.setSelectedItem(this.product.getSubCategory());
                }
            } else if (this.product.getMachine() != null) {
                this.cb_MACHINE.setSelectedItem(this.product.getMachine());
            }
        }
        if (this.isOption) {
            this.ef_MODEL.setDocument(new MaskDocument(1, 7));
            if (this.product.getPartNumber() != null) {
                this.ef_MODEL.setText(this.product.getPartNumber().toString());
            } else {
                this.ef_MODEL.setText("");
            }
            this.st_MODEL.setText("*" + Str.getStr(293));
            this.st_MACHINE.setText("*" + Str.getStr(1662));
        } else {
            this.ef_MODEL.setDocument(new MaskDocument(1, 3));
            this.st_MACHINE.setText("*" + Str.getStr(340));
            this.st_MODEL.setText("*" + Str.getStr(341));
            if (this.product.getModel() != null) {
                this.ef_MODEL.setText(this.product.getModel().toString());
            } else {
                this.ef_MODEL.setText("");
            }
        }
        this.processActions = true;
        this.enableInput();
    }

    public void productChanged(Product product, int n) {
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_REFRESH)) {
            this.refresh();
        } else if (string.equals(THREAD_SAVE_MODEL)) {
            this.saveModelField();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.ef_MODEL) {
            if (this.thread) {
                new Thread((Runnable)this, THREAD_SAVE_MODEL).start();
            } else {
                this.saveModelField();
            }
        }
    }

    private final void enableInput() {
        if (this.enableInput) {
            if (this.product != null && this.product.getProductType() == 3) {
                this.cb_BRAND.setEnabled(false);
            } else if (this.isOption) {
                this.cb_BRAND.setEnabled(false);
            }
            this.cb_FAMILY.setEnabled(this.comboBoxHasValidData(this.cb_BRAND));
            this.cb_PROJECT.setEnabled(this.comboBoxHasValidData(this.cb_FAMILY));
            this.cb_MACHINE.setEnabled(this.comboBoxHasValidData(this.cb_PROJECT));
            this.ef_MODEL.setEnabled(this.comboBoxHasValidData(this.cb_MACHINE));
            this.pb_NEW_MACHINE.setEnabled(this.cb_MACHINE.isEnabled());
            this.pb_NEW_PROJECT.setEnabled(this.cb_PROJECT.isEnabled());
        } else {
            this.ef_MODEL.setEnabled(false);
            this.cb_BRAND.setEnabled(false);
            this.cb_FAMILY.setEnabled(false);
            this.cb_PROJECT.setEnabled(false);
            this.cb_MACHINE.setEnabled(false);
        }
        this.pb_NEW_PROJECT.setEnabled(this.cb_PROJECT.isEnabled());
        this.pb_NEW_MACHINE.setEnabled(this.cb_MACHINE.isEnabled());
    }

    public void setEditable(boolean bl) {
        this.enableInput = bl;
        this.enableInput();
    }

    private final Vector createDisplayVec(Vector vector) {
        if (vector == null) {
            vector = new Vector<String>(1);
        }
        vector.insertElementAt(Str.getStr(17086), 0);
        return vector;
    }

    private final boolean duplicateProject(String string, TypeCategoryRec typeCategoryRec) {
        if (string != null && string.length() > 0) {
            return TypeCategory.getDraftCategoryFromDescription(string, "project", typeCategoryRec.getInd()) != null && TypeCategory.getCategoryFromDescription(string, "project", typeCategoryRec.getInd()) != null;
        }
        return false;
    }

    private final boolean duplicateModel(String string, TypeCategoryRec typeCategoryRec) {
        boolean bl = false;
        bl = TypeCategory.getDraftCategoryFromDescription(string, "model", typeCategoryRec.getInd()) != null;
        return bl;
    }

    private final boolean duplicatePart(String string) {
        return TypeCategory.getDraftCategoryFromDescription(string, "partnum") != null;
    }

    private final boolean duplicateMachine(String string, TypeCategoryRec typeCategoryRec) {
        return TypeCategory.getDraftCategoryFromDescription(string, "machine", typeCategoryRec.getInd()) != null && TypeCategory.getDraftCategoryFromDescription(string, "subcategory", typeCategoryRec.getInd()) != null;
    }

    private final boolean comboBoxHasValidData(JComboBox jComboBox) {
        return jComboBox.getSelectedItem() != null && !(jComboBox.getSelectedItem() instanceof String);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void printDebugInfo() {
        try {
            if (this.product.getBrand() != null) {
                System.out.println("Brand:" + this.product.getBrand() + " " + this.product.getBrand().getInd() + " draft:" + this.product.getBrand().getIsDraft());
            } else {
                System.out.println("product.getBrand() is null");
            }
            if (this.product.getFamily() != null) {
                System.out.println("Family:" + this.product.getFamily() + " " + this.product.getFamily().getInd() + " draft:" + this.product.getFamily().getIsDraft());
            } else {
                System.out.println("product.getFamily() is null");
            }
            if (this.product.getProject() != null) {
                System.out.println("Project:" + this.product.getProject() + " " + this.product.getProject().getInd() + " draft:" + this.product.getProject().getIsDraft());
            } else {
                System.out.println("product.getProject() is null");
            }
            if (this.product.getSubCategory() != null) {
                System.out.println("SubCategory:" + this.product.getSubCategory() + " " + this.product.getSubCategory().getInd() + " draft:" + this.product.getSubCategory().getIsDraft());
            } else {
                System.out.println("product.getSubCategory() is null");
            }
            if (this.product.getPartNumber() != null) {
                System.out.println("Part:" + this.product.getPartNumber() + " " + this.product.getPartNumber().getInd() + " draft:" + this.product.getPartNumber().getIsDraft());
            } else {
                System.out.println("product.getPartNumber() is null");
            }
            if (this.product.getMachine() != null) {
                System.out.println("Machine:" + this.product.getMachine() + " " + this.product.getMachine().getInd() + " draft:" + this.product.getMachine().getIsDraft());
            } else {
                System.out.println("product.getMachine() is null");
            }
            if (this.product.getModel() != null) {
                System.out.println("Model:" + this.product.getModel() + " " + this.product.getModel().getInd() + " draft:" + this.product.getModel().getIsDraft());
                return;
            }
            System.out.println("product.getModel() is null");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void saveModelField() {
        if (this.comboBoxHasValidData(this.cb_MACHINE)) {
            String string = this.ef_MODEL.getText();
            String string2 = this.isOption ? "partnum" : "model";
            String string3 = this.isOption ? "Part Number" : "Model";
            String string4 = this.isOption ? "Sub Category" : "Machine";
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_MACHINE.getSelectedItem();
            if (this.product.getModel() == null || !this.product.getModel().toString().equals(string)) {
                if (string != null && string.length() > 0) {
                    boolean bl = false;
                    GUISystem.getParentDefWin(this).setStatus("Checking " + string3);
                    bl = this.isOption ? this.duplicatePart(string) : this.duplicateModel(string, typeCategoryRec);
                    if (!bl) {
                        TypeCategoryRec typeCategoryRec2 = new TypeCategoryRec(string, string2);
                        typeCategoryRec2.setParentCatInd(typeCategoryRec.getInd());
                        if (this.isOption) {
                            this.product.setPartNumber(typeCategoryRec2);
                        } else {
                            this.product.setModel(typeCategoryRec2);
                        }
                    } else {
                        if (this.isOption) {
                            GUISystem.printBox("Info", "That " + string3 + " already exists. Please choose another");
                        } else {
                            GUISystem.printBox("Info", "That " + string3 + " already exists under the " + string4 + ", Please choose another");
                        }
                        this.ef_MODEL.setText("");
                        this.ef_MODEL.requestFocus();
                    }
                } else {
                    GUISystem.printBox("Info", "The " + string3 + " cannot be blank. Please specify a valid " + string3);
                    if (this.isOption) {
                        if (this.product.getPartNumber() != null) {
                            this.ef_MODEL.setText(this.product.getPartNumber().toString());
                        }
                    } else if (this.product.getModel() != null) {
                        this.ef_MODEL.setText(this.product.getModel().toString());
                    }
                }
            }
        }
        GUISystem.getParentDefWin(this).setStatus(null);
    }

    public void setThreading(boolean bl) {
        this.thread = bl;
    }

    public ProductInfoPanel() {
        this.cb_BRAND = new JComboBox();
        this.cb_FAMILY = new JComboBox();
        this.cb_PROJECT = new JComboBox();
        this.ef_MODEL = new JTextField(new MaskDocument(1, 3), "", 0);
        this.cb_MACHINE = new JComboBox();
        this.st_BRAND = new JLabel("*" + Str.getStr(145));
        this.st_FAMILY = new JLabel("*" + Str.getStr(149));
        this.st_PROJECT = new JLabel("*" + Str.getStr(17019));
        this.st_MODEL = new JLabel("*" + Str.getStr(341));
        this.st_MACHINE = new JLabel("*" + Str.getStr(340));
        this.setPreferredSize(new Dimension(550, 110));
        this.setBackground(Color.white);
        this.pb_NEW_PROJECT.showSelection(false);
        this.pb_NEW_MACHINE.showSelection(false);
        this.cb_BRAND.setModel(new DefaultComboBoxModel());
        this.cb_FAMILY.setModel(new DefaultComboBoxModel());
        this.cb_PROJECT.setModel(new DefaultComboBoxModel());
        this.cb_MACHINE.setModel(new DefaultComboBoxModel());
        this.st_PRODUCT_TYPE.setDescriptionWidth(75);
        this.cb_BRAND.addActionListener(this);
        this.pb_NEW_PROJECT.addActionListener(this);
        this.pb_NEW_MACHINE.addActionListener(this);
        this.cb_MACHINE.addActionListener(this);
        this.cb_FAMILY.addActionListener(this);
        this.cb_PROJECT.addActionListener(this);
        this.ef_MODEL.addFocusListener(this);
        this.ef_MODEL.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_PRODUCT_TYPE);
        this.add(this.st_BRAND);
        this.add(this.cb_BRAND);
        this.add(this.st_FAMILY);
        this.add(this.cb_FAMILY);
        this.add(this.st_PROJECT);
        this.add(this.cb_PROJECT);
        this.add(this.pb_NEW_PROJECT);
        this.add(this.st_MACHINE);
        this.add(this.cb_MACHINE);
        this.add(this.pb_NEW_MACHINE);
        this.add(this.st_MODEL);
        this.add(this.ef_MODEL);
        this.enableInput();
    }
}

