/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCancelRec;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.ProductTemplateSystem;
import com.ibm.nzna.projects.qit.product.productEdit.ProductSaveCheck;
import com.ibm.nzna.projects.qit.product.productEdit.ProductSaveStatusPanel;
import com.ibm.nzna.projects.qit.product.productEdit.ProductSaver;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.JTextAreaCounter;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SaveProductDlg
extends JDialog
implements DataLengths,
ListSelectionListener,
MouseListener,
ProductConst,
ActionListener,
AppConst,
Authority {
    public static final int SAVE_CANCEL = 0;
    public static final int SAVE_SAVED = 1;
    public static final int SAVE_PUBLISHED = 2;
    public static final int SAVE_TEMPLATE = 3;
    public static final int SAVE_CANCEL_DRAFT = 4;
    public static final int SAVE_NEW_PRODUCT = 5;
    private Color buttonHighlightBackground = null;
    private Color buttonDefaultBackground = null;
    private ProductSaveStatusPanel statusPanel = null;
    private JPanel templatePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JTextAreaCounter commentCounter = null;
    private JPanel saveNewPanel = new JPanel();
    private JTextField ef_SAVE_NEW_MODEL = new JTextField();
    private JLabel st_SAVE_NEW_HELP = new JLabel(Str.getStr(17098));
    private DButton pb_OK_SAVE_NEW = new DButton(Str.getStr(1));
    private DButton pb_PUBLISH = new DButton(Str.getStr(520));
    private DButton pb_SAVE = new DButton("Save As Draft");
    private DButton pb_CANCEL_DRAFT = new DButton(Str.getStr(1483));
    private JLabel st_TEMPLATE_NAME = new JLabel(Str.getStr(17085));
    private JLabel st_COMMENTS = new JLabel(Str.getStr(290));
    private JTextField ef_TEMPLATE_NAME = new JTextField(new MaskDocument(0, 254), "", 0);
    private DButton pb_SAVE_AS_NEW = new DButton(Str.getStr(17077));
    private DButton pb_SAVE_AS_TEMPLATE = new DButton(Str.getStr(519));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private NoTabJTextArea mle_OLD_COMMENTS = new NoTabJTextArea();
    private NoTabJTextArea mle_COMMENTS = new NoTabJTextArea();
    private JPanel commentPanel = new JPanel();
    private JScrollPane commentScroll = new JScrollPane(this.commentPanel);
    private JPanel cancelPanel = new JPanel();
    private JList lb_CANCEL = new JList(TypeList.getInstance().getTypeList(28));
    private JScrollPane scr_CANCEL = new JScrollPane(this.lb_CANCEL);
    private DButton pb_OK_CANCEL = new DButton(Str.getStr(1));
    private int returnCode = 0;
    private DButton pb_SAVE_TEMPLATE_NOW = new DButton(Str.getStr(1));
    private ProductDraft product = null;
    private JLabel st_IMAGE = null;
    private ImageIcon wizardImage = null;
    private String comments = null;

    private final void initialize() {
        int n = 1024;
        String string = this.product.getOriginalComments();
        if (string != null) {
            n -= string.length();
        }
        this.wizardImage = ImageSystem.getImageIcon((Object)this, 177);
        this.st_IMAGE = new JLabel(this.wizardImage);
        this.mle_OLD_COMMENTS.setEditable(false);
        this.mle_OLD_COMMENTS.setBackground(new Color(230, 230, 230));
        this.mle_OLD_COMMENTS.setFont(this.pb_PUBLISH.getFont());
        this.mle_COMMENTS.setFont(this.pb_PUBLISH.getFont());
        this.buttonDefaultBackground = this.pb_SAVE.getBackground();
        this.buttonHighlightBackground = this.buttonDefaultBackground.brighter();
        if (this.product.getWorkRequired() == 3) {
            this.pb_PUBLISH.setText("Publish (Delete Active Product)");
        }
        if (this.product.getProductType() == 2) {
            this.st_SAVE_NEW_HELP.setText(Str.getStr(17099));
            this.ef_SAVE_NEW_MODEL.setDocument(new MaskDocument(1, 7));
        } else {
            this.ef_SAVE_NEW_MODEL.setDocument(new MaskDocument(1, 3));
        }
        this.mle_COMMENTS.setDocument(new MaskDocument(0, n));
        this.commentCounter = new JTextAreaCounter(this.mle_COMMENTS);
        this.pb_PUBLISH.setEnabled(UserSystem.hasAuthority(5));
        this.pb_CANCEL_DRAFT.setEnabled(UserSystem.hasAuthority(5));
        this.pb_OK_CANCEL.setEnabled(false);
        this.pb_SAVE_AS_NEW.setEnabled(this.product.getWorkRequired() == 2);
        this.lb_CANCEL.addListSelectionListener(this);
        this.pb_SAVE_TEMPLATE_NOW.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_PUBLISH.addActionListener(this);
        this.pb_CANCEL_DRAFT.addActionListener(this);
        this.pb_SAVE_AS_TEMPLATE.addActionListener(this);
        this.pb_SAVE_AS_NEW.addActionListener(this);
        this.pb_SAVE.addActionListener(this);
        this.pb_SAVE_AS_NEW.addMouseListener(this);
        this.pb_PUBLISH.addMouseListener(this);
        this.pb_CANCEL_DRAFT.addMouseListener(this);
        this.pb_SAVE_AS_TEMPLATE.addMouseListener(this);
        this.pb_SAVE.addMouseListener(this);
        this.pb_OK_CANCEL.addActionListener(this);
        this.ef_SAVE_NEW_MODEL.addActionListener(this);
        this.pb_OK_SAVE_NEW.addActionListener(this);
        this.mainPanel.setLayout(null);
        this.templatePanel.setLayout(null);
        this.commentPanel.setLayout(new BorderLayout());
        this.commentPanel.add((Component)this.mle_OLD_COMMENTS, "North");
        this.commentPanel.add(this.mle_COMMENTS);
        this.cancelPanel.setLayout(null);
        this.cancelPanel.add(this.scr_CANCEL);
        this.cancelPanel.add(this.pb_OK_CANCEL);
        this.mainPanel.add(this.st_COMMENTS);
        this.mainPanel.add(this.commentScroll);
        this.mainPanel.add(this.commentCounter);
        this.mainPanel.add(this.pb_SAVE);
        this.mainPanel.add(this.pb_SAVE_AS_TEMPLATE);
        this.mainPanel.add(this.pb_SAVE_AS_NEW);
        this.mainPanel.add(this.pb_CANCEL_DRAFT);
        this.mainPanel.add(this.pb_PUBLISH);
        this.templatePanel.add(this.st_TEMPLATE_NAME);
        this.templatePanel.add(this.ef_TEMPLATE_NAME);
        this.templatePanel.add(this.pb_SAVE_TEMPLATE_NOW);
        this.saveNewPanel.setLayout(null);
        this.saveNewPanel.add(this.st_SAVE_NEW_HELP);
        this.saveNewPanel.add(this.ef_SAVE_NEW_MODEL);
        this.saveNewPanel.add(this.pb_OK_SAVE_NEW);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.mainPanel);
        this.getContentPane().add(this.templatePanel);
        this.getContentPane().add(this.cancelPanel);
        this.getContentPane().add(this.saveNewPanel);
        this.getContentPane().add(this.pb_CANCEL);
        this.getContentPane().add(this.st_IMAGE);
        this.setResizable(false);
        this.templatePanel.setVisible(false);
        this.cancelPanel.setVisible(false);
        this.saveNewPanel.setVisible(false);
        if (this.product.getOriginalComments() != null) {
            this.mle_OLD_COMMENTS.setText(this.product.getOriginalComments());
        }
        this.mle_COMMENTS.setText(this.product.getComment().toString());
        this.ef_TEMPLATE_NAME.setText(this.product.getDescription());
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = this.wizardImage.getImage().getWidth(this) + 15;
        int n3 = 5;
        super.doLayout();
        this.st_IMAGE.setBounds(5, (dimension.height - 40) / 2 - this.wizardImage.getImage().getHeight(this) / 2, this.wizardImage.getImage().getWidth(this), this.wizardImage.getImage().getHeight(this));
        this.mainPanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        this.templatePanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        this.cancelPanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        this.saveNewPanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        if (this.statusPanel != null) {
            this.statusPanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        }
        this.pb_CANCEL.setBounds(n2, dimension.height - 68, 80, 25);
        n2 = 0;
        n3 = 0;
        dimension = this.mainPanel.getSize();
        this.st_COMMENTS.setBounds(n2, n3, dimension.width, n);
        this.commentScroll.setBounds(n2, n3 += n, dimension.width - 15, n * 5);
        this.commentCounter.setBounds(n2, n3 += n * 5, dimension.width - 15, 14);
        this.pb_SAVE.setBounds(n2, n3 += 16, 168, 25);
        this.pb_SAVE_AS_TEMPLATE.setBounds(n2 + 173, n3, 168, 25);
        this.pb_SAVE_AS_NEW.setBounds(n2, n3 += 28, 168, 25);
        this.pb_CANCEL_DRAFT.setBounds(n2 + 173, n3, 168, 25);
        this.pb_PUBLISH.setBounds(n2, n3 += 28, dimension.width - 16, 25);
        n3 += 28;
        n2 = 5;
        n3 = 5;
        this.st_TEMPLATE_NAME.setBounds(n2, n3, dimension.width - 15, n);
        this.ef_TEMPLATE_NAME.setBounds(n2, n3 += n, dimension.width - 15, n);
        this.pb_SAVE_TEMPLATE_NOW.setBounds(n2, n3 += n + 5, 80, 25);
        n2 = 5;
        n3 = 5;
        dimension = this.cancelPanel.getSize();
        this.scr_CANCEL.setBounds(n2, n3, dimension.width - n2 * 2, n * 10);
        this.pb_OK_CANCEL.setBounds(n2, n3 += n * 10, 80, 24);
        n2 = 5;
        n3 = 5;
        dimension = this.saveNewPanel.getSize();
        this.st_SAVE_NEW_HELP.setBounds(n2, n3, dimension.width - n2 * 2, n);
        this.ef_SAVE_NEW_MODEL.setBounds(n2, n3 += n, dimension.width - n2 * 2, n);
        this.pb_OK_SAVE_NEW.setBounds(n2, n3 += n + 5, 70, 25);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CANCEL) {
            if (this.mainPanel.isVisible()) {
                this.dispose();
            } else {
                this.mainPanel.setVisible(true);
                this.templatePanel.setVisible(false);
                this.validate();
            }
        } else if (actionEvent.getSource() == this.pb_SAVE) {
            if (ProductSaveCheck.checkDraft(this.product, this)) {
                this.saveComment();
                this.createSavePanel();
                if (ProductSaver.saveDraft(this.product, this.statusPanel)) {
                    this.returnCode = 1;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.pb_PUBLISH) {
            if (ProductSaveCheck.checkPublish(this.product, this)) {
                this.saveComment();
                this.createSavePanel();
                if (ProductSaver.publishDraft(this.product, this.statusPanel)) {
                    this.returnCode = 2;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.pb_SAVE_AS_TEMPLATE) {
            if (this.canSaveAsTemplate()) {
                this.mainPanel.setVisible(false);
                this.templatePanel.setVisible(true);
                this.saveNewPanel.setVisible(false);
                this.cancelPanel.setVisible(false);
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Templates cannot have graphics or file attachments. Please remove any graphic and file attachment and try again");
            }
            this.validate();
        } else if (actionEvent.getSource() == this.pb_SAVE_TEMPLATE_NOW) {
            String string = this.ef_TEMPLATE_NAME.getText();
            if (string != null && string.length() > 0) {
                this.product.setDescription(string);
                this.product.setTemplate(true);
                this.saveComment();
                this.createSavePanel();
                if (ProductSaver.saveDraft(this.product, this.statusPanel)) {
                    this.returnCode = 3;
                    ProductTemplateSystem.addTemplate(this.product);
                    GUISystem.printBox((JDialog)this, "Info", "A new Product Template is now available");
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Please supply the name for this template");
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL_DRAFT) {
            this.mainPanel.setVisible(false);
            this.templatePanel.setVisible(false);
            this.saveNewPanel.setVisible(false);
            this.cancelPanel.setVisible(true);
            this.validate();
        } else if (actionEvent.getSource() == this.pb_OK_CANCEL) {
            TypeCancelRec typeCancelRec = (TypeCancelRec)this.lb_CANCEL.getSelectedValue();
            if (typeCancelRec != null) {
                this.product.setTypeCancelInd(typeCancelRec.getInd());
                this.product.setStopDate(new CDate(1).today());
                this.createSavePanel();
                if (ProductSaver.saveDraft(this.product, this.statusPanel)) {
                    this.returnCode = 3;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.pb_SAVE_AS_NEW) {
            if (ProductSaveCheck.checkDraft(this.product, this)) {
                this.mainPanel.setVisible(false);
                this.templatePanel.setVisible(false);
                this.saveNewPanel.setVisible(true);
                this.cancelPanel.setVisible(false);
            }
        } else if (actionEvent.getSource() == this.ef_SAVE_NEW_MODEL || actionEvent.getSource() == this.pb_OK_SAVE_NEW) {
            String string = this.ef_SAVE_NEW_MODEL.getText();
            if (string.length() > 0) {
                String string2;
                boolean bl = this.product.getProductType() == 2;
                TypeCategoryRec typeCategoryRec = bl ? this.product.getSubCategory() : this.product.getMachine();
                String string3 = bl ? "partnum" : "model";
                String string4 = bl ? "Sub Category" : "Machine";
                String string5 = string2 = bl ? "Part Number" : "Model";
                if (TypeCategory.getCategoryFromDescription(string, string3, typeCategoryRec.getInd()) == null && TypeCategory.getDraftCategoryFromDescription(string, string3, typeCategoryRec.getInd()) == null) {
                    ProductDraft productDraft = null;
                    TypeCategoryRec typeCategoryRec2 = new TypeCategoryRec(string, string3);
                    typeCategoryRec2.setParentCatInd(typeCategoryRec.getInd());
                    productDraft = this.product.createNew(typeCategoryRec2);
                    if (ProductSaveCheck.checkDraft(productDraft, this)) {
                        this.product.setCheckedOutBy(null);
                        this.product = productDraft;
                        this.saveComment();
                        this.createSavePanel();
                        if (ProductSaver.saveDraft(this.product, this.statusPanel)) {
                            this.returnCode = 5;
                            GUISystem.printBox((JDialog)this, "Info", "A new Product Draft has been created");
                            this.dispose();
                        } else {
                            this.destroySavePanel();
                        }
                    }
                } else {
                    GUISystem.printBox((JDialog)this, "Info", "That " + string2 + " already exists under the " + string4 + ", Please choose another");
                }
            } else {
                GUISystem.printBox("Info", "Please select a model/part number for this new product");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ((DButton)mouseEvent.getSource()).setBackground(this.buttonHighlightBackground);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ((DButton)mouseEvent.getSource()).setBackground(this.buttonDefaultBackground);
    }

    private final void createSavePanel() {
        this.statusPanel = new ProductSaveStatusPanel(this.product);
        this.getContentPane().add(this.statusPanel);
        this.mainPanel.setVisible(false);
        this.templatePanel.setVisible(false);
        this.pb_CANCEL.setEnabled(false);
        this.validate();
    }

    private final void destroySavePanel() {
        this.getContentPane().remove(this.statusPanel);
        this.statusPanel = null;
        this.mainPanel.setVisible(true);
        this.pb_CANCEL.setEnabled(true);
        this.validate();
    }

    private final void saveComment() {
        String string = this.mle_COMMENTS.getText();
        if (string == null || string.length() == 0) {
            String string2 = new CDate(14).today();
            string = "On " + string2 + " " + UserSystem.getUserName() + " " + "saved this product but made no comment\n";
        }
        this.product.setComment(string);
    }

    private final boolean canSaveAsTemplate() {
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.lb_CANCEL) {
            this.pb_OK_CANCEL.setEnabled(this.lb_CANCEL.getSelectedValue() != null);
        }
    }

    public ProductDraft getProduct() {
        return this.product;
    }

    public SaveProductDlg(AppDefaultWin appDefaultWin, ProductDraft productDraft, String string) {
        super(appDefaultWin, Str.getStr(515), true);
        this.product = productDraft;
        this.comments = string;
        this.initialize();
        ((Component)this).setSize(495, 305);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }
}

