/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit.dateEdit;

import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDateRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.CDate;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ProductDateTableModel
extends AbstractTableModel
implements AppConst {
    private Vector productDates = null;
    private Vector typeDates = TypeList.getInstance().getTypeList(27);
    private Vector uniqueCountries = null;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public int getColumnCount() {
        return this.typeDates.size() + 1;
    }

    public int getRowCount() {
        if (this.uniqueCountries == null) {
            this.uniqueCountries = this.getUniqueCountries();
        }
        if (this.uniqueCountries != null) {
            return this.uniqueCountries.size();
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        try {
            TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)this.uniqueCountries.elementAt(n);
            if (typeCountryCodeRec != null) {
                if (n2 == 0) {
                    return typeCountryCodeRec.toString();
                }
                TypeDateRec typeDateRec = (TypeDateRec)this.typeDates.elementAt(n2 - 1);
                ProductDate productDate = this.getProductDateFromCountryType(typeCountryCodeRec.getInd(), typeDateRec.getInd());
                if (productDate != null) {
                    if (productDate.getActualDate() != null) {
                        productDate.setToString("<html><body>" + this.convertDate(productDate.getActualDate()) + "</body></html>");
                    } else if (productDate.getTargetDate() != null) {
                        productDate.setToString("<html><body><font color=red>" + this.convertDate(productDate.getTargetDate()) + "</font></body></html>");
                    }
                    return productDate;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected ProductDate getProductDateFromCountryType(int n, int n2) {
        ProductDate productDate = null;
        if (this.productDates != null && this.productDates.size() > 0) {
            int n3 = 0;
            int n4 = this.productDates.size();
            while (productDate == null && n3 < n4) {
                if (((ProductDate)this.productDates.elementAt(n3)).getCountryCodeInd() == n && ((ProductDate)this.productDates.elementAt(n3)).getDateType() == n2) {
                    productDate = (ProductDate)this.productDates.elementAt(n3);
                }
                ++n3;
            }
        }
        return productDate;
    }

    public Class getColumnClass(int n) {
        try {
            return this.getValueAt(0, n).getClass();
        }
        catch (Exception exception) {
            return class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ProductDateTableModel.class$("java.lang.Object"));
        }
    }

    public void setProductDates(Vector vector) {
        this.productDates = vector;
        this.uniqueCountries = this.getUniqueCountries();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return Str.getStr(94);
            }
        }
        return this.typeDates.elementAt(n - 1).toString();
    }

    private Vector getUniqueCountries() {
        Vector<TypeCountryCodeRec> vector = new Vector<TypeCountryCodeRec>(1);
        if (this.productDates != null && this.productDates.size() > 0) {
            int n = 0;
            int n2 = this.productDates.size();
            ProductDate productDate = null;
            TypeCountryCodeRec typeCountryCodeRec = null;
            while (n < n2) {
                productDate = (ProductDate)this.productDates.elementAt(n);
                typeCountryCodeRec = (TypeCountryCodeRec)TypeList.getInstance().objectFromInd(productDate.getCountryCodeInd(), 3);
                if (!vector.contains(typeCountryCodeRec)) {
                    vector.addElement(typeCountryCodeRec);
                }
                ++n;
            }
        }
        new QuickSort(vector);
        return vector;
    }

    public void addCountry(TypeCountryCodeRec typeCountryCodeRec) {
        if (this.uniqueCountries == null) {
            this.uniqueCountries = this.getUniqueCountries();
        }
        this.uniqueCountries.insertElementAt(typeCountryCodeRec, 0);
        new QuickSort(this.uniqueCountries);
    }

    public TypeCountryCodeRec getCountryForRow(int n) {
        if (this.uniqueCountries != null) {
            return (TypeCountryCodeRec)this.uniqueCountries.elementAt(n);
        }
        return null;
    }

    public void addDate(ProductDate productDate) {
        if (this.productDates == null) {
            this.productDates = new Vector(1);
        }
        this.productDates.addElement(productDate);
    }

    public TypeDateRec getDateTypeFromColumn(int n) {
        if (n > 0) {
            return (TypeDateRec)this.typeDates.elementAt(n - 1);
        }
        return null;
    }

    public Vector getDates() {
        return this.productDates;
    }

    public boolean contains(TypeCountryCodeRec typeCountryCodeRec) {
        if (this.uniqueCountries == null) {
            return false;
        }
        return this.uniqueCountries.contains(typeCountryCodeRec);
    }

    private String convertDate(String string) {
        return CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 13);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ProductDateTableModel() {
    }

    public ProductDateTableModel(Vector vector) {
        this.setProductDates(vector);
    }
}

