/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit.wizard;

import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.CreateWizardWin;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productEdit.wizard.DescriptionStep;
import com.ibm.nzna.projects.qit.product.productEdit.wizard.ProductInfoStep;
import com.ibm.nzna.shared.gui.wizard.InfoStep;
import com.ibm.nzna.shared.gui.wizard.Wizard;
import com.ibm.nzna.shared.gui.wizard.WizardEvent;
import com.ibm.nzna.shared.gui.wizard.WizardListener;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import javax.swing.JDialog;

public class NewProductWizard
extends JDialog
implements ProductConst,
AppConst,
WizardListener,
PropertyListener {
    private Wizard wizardPanel = null;
    private boolean rc = false;
    private InfoStep welcomeStep = null;
    private InfoStep finishStep = null;
    private Frame parentFrame = (Frame)this.getParent();
    private DescriptionStep descriptionStep = null;
    private ProductInfoStep productInfoStep = null;

    public boolean getResult() {
        this.wizardPanel.setCurrentStep(this.welcomeStep);
        GUISystem.setPropertiesOnPanel(this.getContentPane());
        ((Component)this).setVisible(true);
        return this.rc;
    }

    public void cancelPerformed(WizardEvent wizardEvent) {
        this.rc = false;
        this.dispose();
    }

    public void finishPerformed(WizardEvent wizardEvent) {
        this.rc = true;
        this.dispose();
    }

    public void nextPerformed(WizardEvent wizardEvent) {
        WizardStep wizardStep = this.wizardPanel.getCurrentStep();
        this.wizardPanel.setVisible(false);
        if (wizardStep == this.welcomeStep) {
            this.wizardPanel.setCurrentStep(this.descriptionStep);
        } else if (wizardStep == this.descriptionStep) {
            this.wizardPanel.setCurrentStep(this.productInfoStep);
        } else if (wizardStep == this.productInfoStep) {
            this.wizardPanel.setCurrentStep(this.finishStep);
        }
        GUISystem.setPropertiesOnPanel(this.getContentPane());
        this.wizardPanel.setVisible(true);
        this.adjustButtons();
    }

    public void backPerformed(WizardEvent wizardEvent) {
        WizardStep wizardStep = this.wizardPanel.getCurrentStep();
        if (wizardStep == this.descriptionStep) {
            this.wizardPanel.setCurrentStep(this.welcomeStep);
        } else if (wizardStep == this.productInfoStep) {
            this.wizardPanel.setCurrentStep(this.descriptionStep);
        } else if (wizardStep == this.finishStep) {
            this.wizardPanel.setCurrentStep(this.productInfoStep);
        }
        this.adjustButtons();
    }

    private final void adjustButtons() {
        WizardStep wizardStep = this.wizardPanel.getCurrentStep();
        if (wizardStep == this.welcomeStep) {
            this.wizardPanel.showButtons(true, false, true, false);
        } else if (wizardStep == this.finishStep) {
            this.wizardPanel.showButtons(false, true, false, true);
        } else {
            this.wizardPanel.showButtons(true, true, true, false);
        }
    }

    public void propertyChanged(int n, Object object) {
        if (n == 1) {
            this.setText();
        }
    }

    private final void setText() {
        this.wizardPanel.setNextText(Str.getStr(47));
        this.wizardPanel.setBackText(Str.getStr(34));
        this.wizardPanel.setFinishText(Str.getStr(48));
        this.wizardPanel.setCancelText(Str.getStr(2));
        this.setTitle(Str.getStr(17121));
        this.welcomeStep.setMessage("<html><body><center><font size=2 face=\"Helvetica, Arial\">Welcome to the new Product Wizard. This wizard allows you to create a new Product Draft. Press 'Next' to continue.</font></center></body></html>");
        this.finishStep.setMessage("<html><body><font size=2 face=\"Helvetica, Arial\">Your new Product Draft has been started. You will now see your new Draft in the Product Editor. When you see the Product Editor you can choose to enter more information or to save.<br><br>Press 'Finish' to continue</font><body></html>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NewProductWizard(ProductDraft productDraft) {
        super(new Frame(), "", true);
        CreateWizardWin createWizardWin = new CreateWizardWin(this.parentFrame, 6);
        WinUtil.centerWindow(createWizardWin);
        try {
            this.wizardPanel = new Wizard(ImageSystem.getImageIcon((Object)this, "skins" + File.separator + PropertySystem.getString(21) + File.separator + "large_export.gif"));
            createWizardWin.setValue(1);
        }
        catch (Exception exception) {
            this.wizardPanel = new Wizard();
        }
        this.welcomeStep = new InfoStep("Press Next to begin", "<html><body><font size=2 face=\"Helvetica, Arial\"><b>New Product Wizard</b></font></body></html>");
        createWizardWin.setValue(2);
        this.descriptionStep = new DescriptionStep(this.wizardPanel, productDraft);
        createWizardWin.setValue(3);
        this.productInfoStep = new ProductInfoStep(this.wizardPanel, productDraft);
        createWizardWin.setValue(4);
        this.finishStep = new InfoStep("", "<html><body><font size=2 face=\"Helvetica, Arial\"><b>New Product Wizard</b>&nbsp;&nbsp;&nbsp;Complete!</font></body></html>");
        createWizardWin.setValue(5);
        this.setText();
        this.wizardPanel.addWizardListener(this);
        PropertySystem.addPropertyListener(1, this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.wizardPanel);
        createWizardWin.setValue(6);
        GUISystem.setPropertiesOnPanel(this.getContentPane());
        ((Component)this).setSize(495, 375);
        createWizardWin.dispose();
        WinUtil.centerWindow(this);
    }
}

