/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productExport;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productExport.ProductExportProperty;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DList;
import com.ibm.nzna.shared.gui.wizard.Wizard;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProductFieldsStep
extends WizardStep
implements ListSelectionListener,
ActionListener,
AppConst,
ProductConst {
    private ProductExportProperty exportProperty = null;
    private JLabel st_AVAILABLE = new JLabel(Str.getStr(17110));
    private JLabel st_EXPORTED = new JLabel(Str.getStr(17109));
    private DList lb_AVAILABLE = new DList();
    private DList lb_EXPORTED = new DList();
    private JScrollPane scr_AVAILABLE = new JScrollPane(this.lb_AVAILABLE);
    private JScrollPane scr_EXPORTED = new JScrollPane(this.lb_EXPORTED);
    private DButton pb_ADD = new DButton(">>");
    private DButton pb_REMOVE = new DButton("<<");
    private JTextArea mle_OUTPUT = new JTextArea("");
    private DefaultListModel availableModel = new DefaultListModel();
    private DefaultListModel exportedModel = new DefaultListModel();
    private DButton pb_UP = new DButton(Str.getStr(1044));
    private DButton pb_DOWN = new DButton(Str.getStr(1045));
    private JScrollPane scr_OUTPUT = new JScrollPane(this.mle_OUTPUT);

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 5;
        int n3 = 5;
        int n4 = dimension.width / 2;
        this.st_AVAILABLE.setBounds(n2, n3, 150, n);
        this.st_EXPORTED.setBounds(n4 + 20, n3, 150, n);
        this.scr_AVAILABLE.setBounds(n2, n3 += n, n4 - n2 - 20, dimension.height - 90);
        this.scr_EXPORTED.setBounds(n4 + 20, n3, n4 - n2 - 20, dimension.height - 110);
        this.pb_UP.setBounds(n4 + 40, dimension.height - 80, 60, n);
        this.pb_DOWN.setBounds(n4 + 105, dimension.height - 80, 60, n);
        this.pb_ADD.setBounds(n4 - 15, n3 += n * 3, 30, 25);
        this.pb_REMOVE.setBounds(n4 - 15, n3 += 30, 30, 25);
        n3 = dimension.height - 60;
        this.scr_OUTPUT.setBounds(n2, n3, dimension.width - n2 * 2, dimension.height - n3 - 5);
    }

    public boolean saveInfo() {
        Vector vector = WinUtil.getListData(this.lb_EXPORTED);
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            this.exportProperty.setFieldNames(vector);
            bl = true;
        } else {
            GUISystem.printBox(WinUtil.getParentJDialog(this), Str.getStr(7), Str.getStr(17111));
        }
        return bl;
    }

    public void refreshInfo() {
    }

    public String getTitle() {
        return Str.getStr(17102);
    }

    private final void populateAvailable() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(Str.getStr(334));
        vector.addElement(Str.getStr(17037));
        vector.addElement(Str.getStr(100));
        vector.addElement(Str.getStr(145));
        vector.addElement(Str.getStr(149));
        vector.addElement(Str.getStr(340));
        vector.addElement(Str.getStr(341));
        vector.addElement(Str.getStr(1665));
        vector.addElement(Str.getStr(17015));
        vector.addElement(Str.getStr(17041));
        vector.addElement(Str.getStr(94));
        vector.addElement(Str.getStr(17028));
        vector.addElement(Str.getStr(17027));
        vector.addElement(Str.getStr(267));
        vector.addElement(Str.getStr(266));
        new QuickSort(vector);
        WinUtil.setListData(vector, this.availableModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_ADD || actionEvent.getSource() == this.lb_AVAILABLE) {
            this.addFields();
        } else if (actionEvent.getSource() == this.pb_REMOVE || actionEvent.getSource() == this.lb_EXPORTED) {
            this.removeFields();
        } else if (actionEvent.getSource() == this.pb_UP) {
            WinUtil.moveItemUp(this.lb_EXPORTED);
        } else if (actionEvent.getSource() == this.pb_DOWN) {
            WinUtil.moveItemDown(this.lb_EXPORTED);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.pb_ADD.setEnabled(this.lb_AVAILABLE.getSelectedValue() != null);
        this.pb_REMOVE.setEnabled(this.lb_EXPORTED.getSelectedValue() != null);
        if (listSelectionEvent.getSource() == this.lb_AVAILABLE) {
            this.mle_OUTPUT.setText(this.getFieldDescription((String)this.lb_AVAILABLE.getSelectedValue()));
        }
    }

    private final void addFields() {
        Object[] objectArray = this.lb_AVAILABLE.getSelectedValues();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.exportedModel.addElement(objectArray[n]);
                this.availableModel.removeElement(objectArray[n]);
                ++n;
            }
        }
    }

    private final void removeFields() {
        Object[] objectArray = this.lb_EXPORTED.getSelectedValues();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.exportedModel.removeElement(objectArray[n]);
                this.availableModel.addElement(objectArray[n]);
                ++n;
            }
        }
        Vector vector = WinUtil.getListData(this.lb_AVAILABLE);
        new QuickSort(vector);
        WinUtil.setListData(vector, this.availableModel);
    }

    private final String getFieldDescription(String string) {
        String string2 = null;
        string2 = string.equals(Str.getStr(17015)) ? "When exporting dates, each value will read 'Date Name: Date: Country'. For example, if a producthas a GA Date of 1/1/2001 in Russia, the value in the file written would read 'GA Date: 1/1/2001:Russia'" : (string.equals(Str.getStr(17041)) ? "When exported Cross Reference Product Numbers, each value will read 'Cross Reference Name: number'. For example, if a product has a Cross Reference Product Number for 'CRU' set to '123456' then the file written would be 'CRU: 123456'" : (string.equals(Str.getStr(94)) ? "When exporting countries, each country will be separated by a semi-colon (;)" : (string.equals(Str.getStr(17028)) ? "This is the date that the product or product draft was created on" : (string.equals(Str.getStr(17027)) ? "This is the person who created the product or product draft" : (string.equals(Str.getStr(100)) ? "This is the description of the product" : (string.equals(Str.getStr(145)) ? "This is the IBM Brand (Aptiva, Options etc..) that the product belongs to" : (string.equals(Str.getStr(149)) ? "This is the IBM Family (Thinkpad 380, Hard Drives etc..) that the product belongs to" : (string.equals(Str.getStr(340)) ? "This is the machine type of the product (Only for Systems and Monitors)" : (string.equals(Str.getStr(1665)) ? "This is the Sub Category of the Option (Only for options)" : (string.equals(Str.getStr(341)) ? "This is the product's model number. (Only for Systems and Monitors)" : (string.equals(Str.getStr(293)) ? "This is the product's part number. (Only for Options)" : (string.equals(Str.getStr(267)) ? "This is the date that the product or product draft was last changed" : (string.equals(Str.getStr(266)) ? "This is the person who last saved the product or product draft" : "The " + string + " of the product")))))))))))));
        return string2;
    }

    public ProductFieldsStep(Wizard wizard, ProductExportProperty productExportProperty) {
        this.setWizard(wizard);
        this.exportProperty = productExportProperty;
        this.mle_OUTPUT.setBorder(GUISystem.loweredBorder);
        this.mle_OUTPUT.setFont(this.pb_REMOVE.getFont());
        this.mle_OUTPUT.setEditable(false);
        this.mle_OUTPUT.setWrapStyleWord(true);
        this.mle_OUTPUT.setLineWrap(true);
        this.lb_AVAILABLE.setModel(this.availableModel);
        this.lb_EXPORTED.setModel(this.exportedModel);
        this.populateAvailable();
        this.lb_AVAILABLE.addListSelectionListener(this);
        this.lb_EXPORTED.addListSelectionListener(this);
        this.pb_UP.addActionListener(this);
        this.pb_DOWN.addActionListener(this);
        this.pb_ADD.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.lb_AVAILABLE.addActionListener(this);
        this.lb_EXPORTED.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_AVAILABLE);
        this.add(this.st_EXPORTED);
        this.add(this.scr_AVAILABLE);
        this.add(this.pb_ADD);
        this.add(this.pb_REMOVE);
        this.add(this.scr_EXPORTED);
        this.add(this.pb_UP);
        this.add(this.pb_DOWN);
        this.add(this.scr_OUTPUT);
    }
}

