/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.promail;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.bookmark.AddBookmarkDlg;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.doc.docedit.DocumentSaver;
import com.ibm.nzna.projects.qit.doc.docedit.EditDocument;
import com.ibm.nzna.projects.qit.doc.gui.DocumentTable;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocDlg;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocListener;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.DateRangeEntryDlg;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.SingleDateEntryDlg;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.gui.SingleMLEDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.promail.ProMailConst;
import com.ibm.nzna.projects.qit.promail.ProMailNavPanel;
import com.ibm.nzna.projects.qit.promail.ProMailPreviewPane;
import com.ibm.nzna.projects.qit.promail.ProMailSQL;
import com.ibm.nzna.projects.qit.promail.ProMailSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ProMailPanel
extends JPanel
implements ProMailConst,
AppConst,
Authority,
QuestPanel,
ActionListener,
SelectDocListener,
ListSelectionListener,
Runnable {
    private static final String THREAD_SEARCH = "Search";
    private static final String THREAD_REFRESHPREVIEW = "RP";
    private static final String[] listTitle = new String[]{" ", Str.getStr(264), Str.getStr(318), Str.getStr(265), Str.getStr(280), Str.getStr(267), Str.getStr(266)};
    private JTitle st_TITLE = null;
    private DocumentTable documents = null;
    private JSplitPane splitPane = null;
    private ProMailPreviewPane previewPane = null;
    private ActionButton pb_SEND = null;
    private ActionButton pb_CANCEL = null;
    private ActionButton pb_EDIT = null;
    private ActionButton pb_CLOSE = null;
    private JMenuItem mnu_EDIT_FOOTER = null;
    private JMenuItem mnu_EDIT_HEADER = null;
    private JSeparator mnu_SEPARATOR = new JSeparator();
    private ToolBarButton pb_FIND = null;
    private JToolBar toolBar = null;
    private ProMailNavPanel proMailNavPanel = null;
    private DocumentRow previewDocument = null;
    private AppDefaultWin parentWin = null;
    private boolean inThread = false;
    private int view = 0;
    private String startDate = new CDate(2).today();
    private String stopDate = CDate.addDaysToDate(this.startDate, 30, 2);
    private String docId = "";

    public final boolean initialize() {
        this.st_TITLE = new JTitle("");
        this.documents = new DocumentTable();
        this.previewPane = new ProMailPreviewPane();
        this.splitPane = new JSplitPane(0);
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_CANCEL = new ActionButton(Str.getStr(2), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(780));
        this.pb_SEND = new ActionButton(Str.getStr(516), ImageSystem.getImageIcon((Object)this, 62), Str.getStr(781));
        this.pb_EDIT = new ActionButton(Str.getStr(50), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(782));
        this.mnu_EDIT_FOOTER = new JMenuItem(Str.getStr(784));
        this.mnu_EDIT_HEADER = new JMenuItem(Str.getStr(783));
        this.pb_FIND = new ToolBarButton(Str.getStr(470), ImageSystem.getImageIcon((Object)this, 7), Str.getStr(470));
        this.toolBar = new JToolBar();
        this.proMailNavPanel = new ProMailNavPanel(this);
        this.st_TITLE.setFont(FontSystem.largeTitleFont);
        this.documents.setColumnTitle(3, Str.getStr(280));
        this.pb_CLOSE.addActionListener(this);
        this.pb_SEND.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.mnu_EDIT_FOOTER.addActionListener(this);
        this.mnu_EDIT_HEADER.addActionListener(this);
        this.documents.addListSelectionListener(this);
        this.documents.addActionListener(this);
        this.pb_FIND.addActionListener(this);
        this.toolBar.add(new ToolBarSeparator());
        this.toolBar.add(this.pb_FIND);
        this.toolBar.setBorder(null);
        this.toolBar.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.splitPane.setTopComponent(this.documents);
        this.splitPane.setBottomComponent(this.previewPane);
        this.add((Component)this.st_TITLE, "North");
        this.add((Component)this.splitPane, "Center");
        return true;
    }

    public final void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_SEND);
        this.parentWin.addActionComponent(this, this.pb_EDIT);
        this.parentWin.addActionComponent(this, this.pb_CANCEL);
        this.parentWin.getAppDefaultMenuBar().addEditMenuItem(this.mnu_SEPARATOR);
        this.parentWin.getAppDefaultMenuBar().addEditMenuItem(this.mnu_EDIT_HEADER);
        this.parentWin.getAppDefaultMenuBar().addEditMenuItem(this.mnu_EDIT_FOOTER);
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 1);
        this.splitPane.setDividerLocation(0.6);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, null);
        } else if (actionEvent.getSource() == this.mnu_EDIT_HEADER) {
            this.editHeader();
        } else if (actionEvent.getSource() == this.mnu_EDIT_FOOTER) {
            this.editFooter();
        } else if (actionEvent.getSource() == this.pb_FIND) {
            new SelectDocDlg().getInstance().addSelectDocListener(this);
        } else if (actionEvent.getSource() == this.pb_EDIT || actionEvent.getSource() == this.documents) {
            this.edit();
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.cancel();
        } else if (actionEvent.getSource() == this.pb_SEND) {
            this.send();
        }
    }

    public final boolean bookmark() {
        Vector vector = this.documents.getSelection();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Bookmark bookmark = new Bookmark();
                bookmark.setDescript(((Document)vector.elementAt(n)).getTitle());
                bookmark.setObject(new Integer(((Document)vector.elementAt(n)).getDocInd()), 3);
                bookmark.updateRecStatus(2);
                new AddBookmarkDlg((Frame)GUISystem.getParentDefWin(this), bookmark);
                ++n;
            }
        } else {
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1028));
        }
        return true;
    }

    public final boolean stop() {
        if (!this.inThread) {
            this.removeAll();
            this.panelDeselected();
            return true;
        }
        return false;
    }

    public final boolean shutdown() {
        return !this.inThread;
    }

    public final ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 49);
    }

    public final NavPanel getDefaultNavPanel() {
        return this.proMailNavPanel;
    }

    public final void selectDocComplete(Vector vector) {
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            Vector vector2 = new Vector(n2);
            while (n < n2) {
                if (vector.elementAt(n) instanceof Document) {
                    vector2.addElement(vector.elementAt(n));
                } else if (vector.elementAt(n) instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)vector.elementAt(n);
                }
                ++n;
            }
            this.setDocList(vector2);
        }
    }

    public final void panelSelected() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        appDefaultWin.getAppDefaultMenuBar().addEditMenuItem(this.mnu_SEPARATOR);
        appDefaultWin.getAppDefaultMenuBar().addEditMenuItem(this.mnu_EDIT_HEADER);
        appDefaultWin.getAppDefaultMenuBar().addEditMenuItem(this.mnu_EDIT_FOOTER);
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 1);
    }

    public final void panelDeselected() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        appDefaultWin.getAppDefaultMenuBar().removeEditMenuItem(this.mnu_SEPARATOR);
        appDefaultWin.getAppDefaultMenuBar().removeEditMenuItem(this.mnu_EDIT_HEADER);
        appDefaultWin.getAppDefaultMenuBar().removeEditMenuItem(this.mnu_EDIT_FOOTER);
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
    }

    public final boolean copyText() {
        return false;
    }

    public final boolean cutText() {
        return false;
    }

    public final boolean pasteText() {
        return false;
    }

    public final JComponent getJComponent() {
        return this;
    }

    public final void refresh() {
        this.setView(this.view);
    }

    public final void setDocList(Vector vector) {
        this.documents.removeAll();
        this.documents.setData(vector);
    }

    public final String getName() {
        return Str.getStr(208);
    }

    private final void editHeader() {
        if (UserSystem.hasAuthority(19)) {
            SingleMLEDlg singleMLEDlg = new SingleMLEDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(783), Str.getStr(799), ProMailSystem.getHeader());
            String string = singleMLEDlg.getResult();
            if (string != null && string.length() > 0 && ProMailSQL.saveHeader(string)) {
                GUISystem.printBox(7, 788);
            }
        } else {
            GUISystem.printBox(7, 787);
        }
    }

    private final void editFooter() {
        if (UserSystem.hasAuthority(19)) {
            SingleMLEDlg singleMLEDlg = new SingleMLEDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(784), Str.getStr(800), ProMailSystem.getFooter());
            String string = singleMLEDlg.getResult();
            if (string != null && string.length() > 0 && ProMailSQL.saveFooter(string)) {
                GUISystem.printBox(7, 789);
            }
        } else {
            GUISystem.printBox(7, 787);
        }
    }

    protected final void setView(int n) {
        this.view = n;
        if (n > 0) {
            new Thread((Runnable)this, THREAD_SEARCH).start();
        }
    }

    public final void run() {
        String string = Thread.currentThread().getName();
        this.inThread = true;
        if (string.equals(THREAD_SEARCH)) {
            this.search();
        } else if (string.equals(THREAD_REFRESHPREVIEW)) {
            this.refreshPreview((DocumentRow)this.documents.getSelectedItem());
        }
        this.inThread = false;
    }

    private final void search() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        this.refreshPreview(null);
        switch (this.view) {
            case 5: {
                appDefaultWin.setStatus(14);
                this.setDocList(ProMailSQL.readAllProMail(this.proMailNavPanel.getBrand()));
                appDefaultWin.setStatus(null);
                break;
            }
            case 1: {
                String string = new SingleDateEntryDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(280), Str.getStr(280), this.startDate).getResult();
                if (string == null || string.length() <= 0) break;
                if (CDate.checkDate(string, 2) == 0) {
                    appDefaultWin.setStatus(14);
                    this.startDate = string;
                    this.setDocList(ProMailSQL.readProMailFromDate(string, this.proMailNavPanel.getBrand()));
                    appDefaultWin.setStatus(null);
                    break;
                }
                GUISystem.printBox(7, 414);
                break;
            }
            case 2: {
                DateRangeEntryDlg dateRangeEntryDlg = new DateRangeEntryDlg(GUISystem.getParentDefWin(this), Str.getStr(280), Str.getStr(280), this.startDate, this.stopDate);
                if (!dateRangeEntryDlg.getResult()) break;
                appDefaultWin.setStatus(14);
                this.startDate = dateRangeEntryDlg.getFromDate();
                this.stopDate = dateRangeEntryDlg.getToDate();
                this.setDocList(ProMailSQL.readProMailFromDateRange(this.startDate, this.stopDate, this.proMailNavPanel.getBrand()));
                appDefaultWin.setStatus(null);
                break;
            }
            case 3: {
                String string = new SingleEntryDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(265), Str.getStr(265), this.docId, "VVVV-VVVVV").getResult();
                if (string == null || string.length() <= 0) break;
                appDefaultWin.setStatus(14);
                this.docId = string;
                this.setDocList(ProMailSQL.readProMailFromDocId(string, this.proMailNavPanel.getBrand()));
                appDefaultWin.setStatus(null);
                break;
            }
            case 4: {
                appDefaultWin.setStatus(14);
                this.startDate = new CDate(2).today();
                this.setDocList(ProMailSQL.readProMailFromDateRange(this.startDate, this.startDate, this.proMailNavPanel.getBrand()));
                appDefaultWin.setStatus(null);
                break;
            }
        }
    }

    private final void refreshPreview(DocumentRow documentRow) {
        this.parentWin.setStatus(142);
        this.previewPane.setDocument(documentRow);
        this.previewDocument = documentRow;
        this.parentWin.setStatus(null);
    }

    public final void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            this.refreshPreview(null);
            new Thread((Runnable)this, THREAD_REFRESHPREVIEW).start();
        }
    }

    private final void edit() {
        if (this.documents.getSelectedItem() != null) {
            EditDocument.editDocument((DocumentRow)this.documents.getSelectedItem());
        } else {
            GUISystem.printBox(7, 358);
        }
    }

    private final void cancel() {
        Vector vector = this.documents.getSelection();
        if (vector != null && vector.size() > 0 && GUISystem.printBox(8, 785)) {
            int n = 0;
            int n2 = vector.size();
            String string = new SingleMLEDlg((Frame)this.parentWin, Str.getStr(290), Str.getStr(1306), "").getResult();
            while (n < n2) {
                this.cancelDoc((DocumentRow)vector.elementAt(n), string);
                ++n;
            }
        }
    }

    private final void send() {
        Vector vector = this.documents.getSelection();
        if (vector != null && vector.size() > 0 && GUISystem.printBox(8, 786)) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.sendDoc((DocumentRow)vector.elementAt(n));
                ++n;
            }
        }
        this.documents.repaint();
    }

    private final void cancelDoc(DocumentRow documentRow, String string) {
        StatusWin statusWin = new StatusWin(GUISystem.getParentDefWin(this));
        int n = 0;
        statusWin.setText(Str.getStr(1297) + " '" + documentRow.getTitle());
        n = documentRow.readDocument(true);
        if (n == 0) {
            DocumentDraft documentDraft = EditDocument.createDraft(documentRow.getDocument());
            if (documentDraft != null) {
                EditDocument.setDefaultValues(documentDraft);
                documentDraft.setWorkRequired(2);
                documentDraft.setEMailable(false);
                statusWin.setText(Str.getStr(342) + " " + documentRow.getTitle());
                if (!DocumentSaver.saveDraft(documentDraft, null)) {
                    GUISystem.printBox(7, 202);
                } else {
                    this.cancelPublishedDoc(documentRow);
                }
            }
        } else {
            GUISystem.printBox(7, 202);
            LogSystem.log(1, "Could not read document. rc:" + n);
        }
        statusWin.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void cancelPublishedDoc(DocumentRow documentRow) {
        SQLMethod sQLMethod;
        block3: {
            String string = "cancelDoc";
            sQLMethod = new SQLMethod(1, string, 5);
            AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
            try {
                if (sQLMethod == null) break block3;
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS " + "SET   EMAILABLE   = 'N', " + "      DBUSER      = '" + UserSystem.getUserId() + "', " + "      CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE DOCIND      = " + documentRow.getDocumentInd());
                this.documents.remove(documentRow);
                if (this.previewDocument == documentRow) {
                    this.previewPane.setDocument(null);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendDoc(DocumentRow documentRow) {
        AppDefaultWin appDefaultWin;
        SQLMethod sQLMethod;
        block3: {
            String string = "sendDoc";
            sQLMethod = new SQLMethod(1, string, 5);
            appDefaultWin = GUISystem.getParentDefWin(this);
            appDefaultWin.setStatus(Str.getStr(802) + " '" + documentRow.getTitle() + "'");
            try {
                if (sQLMethod == null) break block3;
                String string2 = new CDate(2).today();
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("UPDATE TIGRIS.DOCUMENTS " + "SET   EMAILABLE     = 'Y', " + "      EMAILABLEDATE = '" + string2 + "', " + "      DBUSER        = '" + UserSystem.getUserId() + "', " + "      CHANGEDTIME   = CURRENT TIMESTAMP " + "WHERE DOCIND        = " + documentRow.getDocumentInd());
                documentRow.getDocument().setLastTouchedBy(UserSystem.getUserId());
                documentRow.getDocument().setEMailableDate(string2);
                if (documentRow == this.previewDocument) {
                    this.previewPane.setDocument(null);
                    this.previewPane.setDocument(documentRow);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
        }
        sQLMethod.close();
        appDefaultWin.setStatus(null);
    }
}

