/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.recyclebin;

import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.ActionDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.LinkDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.LinkGroupDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.QuestionDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.SymptomDisplayRec;
import com.ibm.nzna.projects.qit.storedProc.sqlRunner.QITSqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class RecycleSQL
implements AppConst {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Vector readRecycledProducts() {
        SQLMethod sQLMethod = new SQLMethod(1, "readRecycledProducts", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ProductRow productRow = null;
            boolean bl = false;
            if (statement != null) {
                ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND, EXISTINGPRODUCTIND, PRODNUM, DESCRIPTION, LASTTOUCHEDBY, LASTTOUCHEDON " + "FROM PRODRAFT.PRODUCT " + "WHERE RECYCLED = 'Y' " + "ORDER BY LASTTOUCHEDON FOR FETCH ONLY");
                while (true) {
                    if (!resultSet.next()) {
                        resultSet.close();
                        break;
                    }
                    productRow = new ProductRow(resultSet.getInt(1), resultSet.getInt(2), resultSet.getString(3), resultSet.getString(4).trim(), "", "", "", "", UserSystem.getNameFromUserId(resultSet.getString(5).trim()), DateSystem.prettyDateFromStamp(resultSet.getString(6).trim()), true);
                    System.out.println("TEST:" + UserSystem.getNameFromUserId(resultSet.getString(5).trim()));
                    productRow.setColumnOrderData(1, 2);
                    productRow.setColumnOrderData(2, 3);
                    productRow.setColumnOrderData(3, 6);
                    productRow.setColumnOrderData(4, 7);
                    if (resultSet.getString(3) == null || resultSet.getString(3).trim().equals("NULL")) {
                        bl = true;
                    }
                    vector.addElement(productRow);
                }
            }
            if (bl) {
                RecycleSQL.readPartNumbers(vector);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(6, 202);
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Vector readRecycledDocuments() {
        Vector<DocumentRow> vector = new Vector<DocumentRow>(1);
        String string = "readRecycle";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            DocumentRow documentRow = null;
            ResultSet resultSet = statement.executeQuery("SELECT DOCIND,  EXISTINGDOCIND, TITLE, OWNER, DOCCLASSIND, " + "       LNDOCID, WORKIND,        CHANGEDTIME,  DBUSER " + "FROM QUEST.DOCUMENTS " + "WHERE RECYCLED = 'Y' ORDER BY CHANGEDTIME");
            while (true) {
                if (!resultSet.next()) {
                    RecycleSQL.adjustDocumentRows(vector);
                    break;
                }
                documentRow = new DocumentRow("" + resultSet.getInt(1), "" + resultSet.getInt(2), resultSet.getString(3).trim(), resultSet.getString(4), resultSet.getInt(5), resultSet.getString(6), resultSet.getInt(7), resultSet.getString(8).trim(), resultSet.getString(8).trim(), resultSet.getString(9).trim(), true);
                vector.addElement(documentRow);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        System.gc();
        return vector;
    }

    protected static void restoreProducts(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE PRODRAFT.PRODUCT SET RECYCLED = 'N' WHERE PRODUCTIND IN ( ";
        while (n < n2) {
            string = string + "" + ((ProductRow)vector.elementAt(n)).getProductInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void restoreQuestions(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE OADRAFT.QUESTION SET RECYCLED = 'N' WHERE QUESTIONIND IN ( ";
        while (n < n2) {
            string = string + "" + ((QuestionDisplayRec)vector.elementAt(n)).getQuestionInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void restoreLinkGroups(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE OADRAFT.LINKGROUP SET RECYCLED = 'N' WHERE LINKGROUPIND IN ( ";
        while (n < n2) {
            string = string + "" + ((LinkGroupDisplayRec)vector.elementAt(n)).getLinkGroupInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void restoreLinks(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE OADRAFT.LINK SET RECYCLED = 'N' WHERE LINKIND IN ( ";
        while (n < n2) {
            string = string + "" + ((LinkDisplayRec)vector.elementAt(n)).getLinkInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void restoreSymptoms(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE OADRAFT.SYMPTOM SET RECYCLED = 'N' WHERE SYMPTOMIND IN ( ";
        while (n < n2) {
            string = string + "" + ((SymptomDisplayRec)vector.elementAt(n)).getSymptomInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void restoreActions(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE OADRAFT.ACTION SET RECYCLED = 'N' WHERE ACTIONIND IN ( ";
        while (n < n2) {
            string = string + "" + ((ActionDisplayRec)vector.elementAt(n)).getActionInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void restoreDocuments(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "UPDATE QUEST.DOCUMENTS SET RECYCLED = 'N' WHERE DOCIND IN ( ";
        while (n < n2) {
            string = string + "" + ((DocumentRow)vector.elementAt(n)).getDocumentInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        SqlRunner.runSingleSQL(1, string + ")");
    }

    protected static void deleteProducts(Vector vector) {
        String string = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((ProductRow)vector.elementAt(n)).getProductInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        if (string.length() > 0) {
            QITSqlRunner.sqlRunner("DELETE FROM PRODRAFT.DATES        WHERE PRODUCTIND IN (" + string + ")" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.COUNTRY      WHERE PRODUCTIND IN (" + string + ")" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.GEO          WHERE PRODUCTIND IN (" + string + ")" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.XREF         WHERE PRODUCTIND IN (" + string + ")" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.CATEGORY     WHERE PRODUCTIND IN (" + string + ")" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.TYPECATCHILD WHERE TYPECATIND IN (SELECT TYPECATIND FROM PRODRAFT.TYPECATEGORY WHERE CATEGORYLEVEL in ( 'model', 'partnumber' ) and typecatind in (select typecatind from prodraft.category where PRODUCTIND IN (" + string + ")))" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.TYPECATEGORY WHERE TYPECATIND IN (SELECT TYPECATIND FROM PRODRAFT.TYPECATEGORY WHERE CATEGORYLEVEL in ( 'model', 'partnumber' ) and typecatind in (select typecatind from prodraft.category where PRODUCTIND IN (" + string + ")))" + SqlRunner.END_DELIM + "DELETE FROM PRODRAFT.PRODUCT      WHERE PRODUCTIND IN (" + string + ")" + SqlRunner.END_DELIM);
        }
    }

    protected static void deleteDocuments(Vector vector) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((DocumentRow)vector.elementAt(n)).getDocumentInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        string2 = "DELETE FROM QUEST.DOCBRAND       WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCCATEGORY    WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.CATEGORY       WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCBODY        WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCBODYHISTORY WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCCOUNTRY     WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCGRAPHIC     WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCMEDIA       WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCSTATUS      WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.PRODDOCS       WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM + "DELETE FROM QUEST.DOCUMENTS      WHERE DOCIND IN ( " + string + ")" + SqlRunner.END_DELIM;
        QITSqlRunner.sqlRunner(string2);
    }

    protected static void deleteSymptoms(Vector vector) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((SymptomDisplayRec)vector.elementAt(n)).getSymptomInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        string2 = "UPDATE OADRAFT.SYMPTOM SET STOPDATE = CURRENT DATE WHERE SYMPTOMIND IN ( " + string + " )" + SqlRunner.END_DELIM;
        QITSqlRunner.sqlRunner(string2);
    }

    protected static void deleteLinkGroups(Vector vector) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((LinkGroupDisplayRec)vector.elementAt(n)).getLinkGroupInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        string2 = "UPDATE OADRAFT.LINKGROUP SET STOPDATE = CURRENT DATE WHERE LINKGROUPIND IN ( " + string + " )" + SqlRunner.END_DELIM;
        QITSqlRunner.sqlRunner(string2);
    }

    protected static void deleteLinks(Vector vector) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((LinkDisplayRec)vector.elementAt(n)).getLinkInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        string2 = "UPDATE OADRAFT.LINK SET STOPDATE = CURRENT DATE WHERE LINKIND IN ( " + string + " )" + SqlRunner.END_DELIM;
        QITSqlRunner.sqlRunner(string2);
    }

    protected static void deleteActions(Vector vector) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((ActionDisplayRec)vector.elementAt(n)).getActionInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        string2 = "UPDATE OADRAFT.ACTION SET STOPDATE = CURRENT DATE WHERE ACTIONIND IN ( " + string + " )" + SqlRunner.END_DELIM;
        QITSqlRunner.sqlRunner(string2);
    }

    protected static void deleteQuestions(Vector vector) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + "" + ((QuestionDisplayRec)vector.elementAt(n)).getQuestionInd();
            if (n != n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        string2 = "UPDATE OADRAFT.QUESTION SET STOPDATE = CURRENT DATE WHERE QUESTIONIND IN ( " + string + " )" + SqlRunner.END_DELIM;
        QITSqlRunner.sqlRunner(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readRecycledQuestions() {
        Vector<QuestionDisplayRec> vector;
        SQLMethod sQLMethod;
        block4: {
            sQLMethod = new SQLMethod(1, "readRecycledQuestions", 5);
            vector = new Vector<QuestionDisplayRec>(1);
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement == null) break block4;
                ResultSet resultSet = statement.executeQuery("SELECT A.QUESTIONIND, A.DOCCLASSIND, B.TITLE, A.CHANGEDTIME, A.DBUSER " + "FROM OADRAFT.QUESTION A,     " + "     OADRAFT.QUESTIONTITLE B " + "WHERE A.RECYCLED = 'Y' AND " + "      A.QUESTIONIND = B.QUESTIONIND AND " + "      B.SORTORDER IN (SELECT MAX(SORTORDER) FROM OADRAFT.QUESTIONTITLE WHERE QUESTIONIND = A.QUESTIONIND) " + "ORDER BY CHANGEDTIME FOR FETCH ONLY");
                while (true) {
                    if (!resultSet.next()) {
                        resultSet.close();
                        break;
                    }
                    vector.addElement(new QuestionDisplayRec(resultSet.getInt(1), resultSet.getInt(2), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim()));
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readRecycledActions() {
        Vector<ActionDisplayRec> vector;
        SQLMethod sQLMethod;
        block4: {
            sQLMethod = new SQLMethod(1, "readRecycledActions", 5);
            vector = new Vector<ActionDisplayRec>(1);
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement == null) break block4;
                ResultSet resultSet = statement.executeQuery("SELECT A.ACTIONIND, A.DOCCLASSIND, B.TITLE, A.CHANGEDTIME, A.DBUSER " + "FROM OADRAFT.ACTION A,     " + "     OADRAFT.ACTIONTITLE B " + "WHERE A.RECYCLED = 'Y' AND " + "      A.ACTIONIND = B.ACTIONIND AND " + "      B.SORTORDER IN (SELECT MAX(SORTORDER) FROM OADRAFT.ACTIONTITLE WHERE ACTIONIND = A.ACTIONIND) " + "ORDER BY CHANGEDTIME FOR FETCH ONLY");
                while (true) {
                    if (!resultSet.next()) {
                        resultSet.close();
                        break;
                    }
                    vector.addElement(new ActionDisplayRec(resultSet.getInt(1), resultSet.getInt(2), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim()));
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readRecycledSymptoms() {
        Vector<SymptomDisplayRec> vector;
        SQLMethod sQLMethod;
        block4: {
            sQLMethod = new SQLMethod(1, "readRecycledSymptoms", 5);
            vector = new Vector<SymptomDisplayRec>(1);
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement == null) break block4;
                ResultSet resultSet = statement.executeQuery("SELECT A.SYMPTOMIND, A.STATUSIND, A.DOCCLASSIND, B.TITLE, A.CHANGEDTIME, A.DBUSER " + "FROM OADRAFT.SYMPTOM A,     " + "     OADRAFT.SYMPTOMTITLE B " + "WHERE A.RECYCLED = 'Y' AND " + "      A.SYMPTOMIND = B.SYMPTOMIND AND " + "      B.SORTORDER IN (SELECT MAX(SORTORDER) FROM OADRAFT.SYMPTOMTITLE WHERE SYMPTOMIND = A.SYMPTOMIND) " + "ORDER BY CHANGEDTIME FOR FETCH ONLY");
                while (true) {
                    if (!resultSet.next()) {
                        resultSet.close();
                        break;
                    }
                    vector.addElement(new SymptomDisplayRec(resultSet.getInt(1), resultSet.getInt(2), resultSet.getInt(3), resultSet.getString(4).trim(), resultSet.getString(5).trim(), resultSet.getString(6).trim()));
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readRecycledLinks() {
        Vector<LinkDisplayRec> vector;
        SQLMethod sQLMethod;
        block4: {
            sQLMethod = new SQLMethod(1, "readRecycledLinks", 5);
            vector = new Vector<LinkDisplayRec>(1);
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement == null) break block4;
                ResultSet resultSet = statement.executeQuery("SELECT A.LINKIND, B.TITLE, A.VALID, A.LINKTYPEIND, A.DBUSER, A.CHANGEDTIME " + "FROM OADRAFT.LINK A,     " + "     OADRAFT.LINKTITLE B " + "WHERE A.RECYCLED = 'Y' AND " + "      A.LINKIND = B.LINKIND AND " + "      B.SORTORDER IN (SELECT MAX(SORTORDER) FROM OADRAFT.LINKTITLE WHERE LINKIND = A.LINKIND) " + "ORDER BY CHANGEDTIME FOR FETCH ONLY");
                while (true) {
                    if (!resultSet.next()) {
                        resultSet.close();
                        break;
                    }
                    vector.addElement(new LinkDisplayRec(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim().equals("Y"), resultSet.getInt(4), 0, "", "", resultSet.getString(5).trim(), resultSet.getString(6).trim()));
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
        }
        sQLMethod.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector readRecycledLinkGroups() {
        Vector<LinkGroupDisplayRec> vector;
        SQLMethod sQLMethod;
        block4: {
            sQLMethod = new SQLMethod(1, "readRecycledLinkGroups", 5);
            vector = new Vector<LinkGroupDisplayRec>(1);
            try {
                Statement statement = sQLMethod.createStatement();
                if (statement == null) break block4;
                ResultSet resultSet = statement.executeQuery("SELECT A.LINKGROUPIND, B.TITLE, A.CHANGEDTIME, A.DBUSER " + "FROM OADRAFT.LINKGROUP A,     " + "     OADRAFT.LINKGROUPTITLE B " + "WHERE A.RECYCLED = 'Y' AND " + "      A.LINKGROUPIND = B.LINKGROUPIND AND " + "      B.SORTORDER IN (SELECT MAX(SORTORDER) FROM OADRAFT.LINKGROUPTITLE WHERE LINKGROUPIND = A.LINKGROUPIND) " + "ORDER BY CHANGEDTIME FOR FETCH ONLY");
                while (true) {
                    if (!resultSet.next()) {
                        resultSet.close();
                        break;
                    }
                    vector.addElement(new LinkGroupDisplayRec(resultSet.getInt(1), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim()));
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(6, 202);
            }
        }
        sQLMethod.close();
        return vector;
    }

    private static final void adjustDocumentRows(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        DocumentRow documentRow = null;
        while (n < n2) {
            documentRow = (DocumentRow)vector.elementAt(n);
            n3 = documentRow.getDocClassInd();
            switch (n3) {
                case 1: {
                    documentRow.setDocClassImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 102));
                    break;
                }
                case 2: {
                    documentRow.setDocClassImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 103));
                    break;
                }
                case 3: {
                    documentRow.setDocClassImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 104));
                    break;
                }
            }
            documentRow.setLastTouchedBy(UserSystem.getNameFromUserId(documentRow.getLastTouchedBy()));
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void readPartNumbers(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        SQLMethod sQLMethod = new SQLMethod(1, "readOptionPartNumbers", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string = "SELECT B.PRODUCTIND, A.DESCRIPTION FROM PRODRAFT.TYPECATEGORY A, PRODRAFT.CATEGORY B WHERE A.TYPECATIND = B.TYPECATIND AND PRODUCTIND IN (";
            int n3 = 0;
            while (n < n2) {
                if (((ProductRow)vector.elementAt(n)).getProductNumber() == null || ((ProductRow)vector.elementAt(n)).getProductNumber().trim().equals("NULL")) {
                    string = string + ((ProductRow)vector.elementAt(n)).getProductInd() + ",";
                    ++n3;
                }
                ++n;
            }
            if (n3 <= 0) return;
            string = string.substring(0, string.length() - 1) + ") FOR FETCH ONLY";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                ProductRow productRow = RecycleSQL.getProductRowFromInd(resultSet.getInt(1), vector);
                if (productRow == null) continue;
                productRow.setProdNum(resultSet.getString(2).trim());
            }
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private static final ProductRow getProductRowFromInd(int n, Vector vector) {
        ProductRow productRow = null;
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3 && productRow == null) {
            if (((ProductRow)vector.elementAt(n2)).getProductInd() == n) {
                productRow = (ProductRow)vector.elementAt(n2);
            }
            ++n2;
        }
        return productRow;
    }
}

