/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.sample;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.sample.SampleNavPanel;
import com.ibm.nzna.projects.qit.sample.SampleRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class SamplePanel
extends JPanel
implements Runnable,
ActionListener,
AppConst,
QuestPanel {
    private static String THREAD_REFRESH_DATA = "REFRESH_DATA";
    private String[] titles = new String[]{Str.getStr(1335), Str.getStr(318)};
    private MultiList documentList = null;
    private ActionButton pb_SAVE = null;
    private ActionButton pb_CLOSE = null;
    private ToolBarButton pb_PROPERTY = null;
    private JToolBar toolBar = null;
    private SampleNavPanel navPanel = null;
    private AppDefaultWin parentWin = null;

    public boolean initialize() {
        boolean bl = false;
        this.navPanel = new SampleNavPanel(this);
        this.documentList = new MultiList(GUISystem.getFontUtil());
        this.pb_SAVE = new ActionButton(Str.getStr(515), ImageSystem.getImageIcon((Object)this, 62), Str.getStr(515));
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(28));
        this.pb_PROPERTY = new ToolBarButton(Str.getStr(1320), ImageSystem.getImageIcon((Object)this, 98), Str.getStr(1320));
        this.toolBar = new JToolBar();
        this.toolBar.setOpaque(false);
        this.toolBar.setBorder(GUISystem.emptyBorder);
        this.documentList.setColumnHeadings(this.titles);
        this.documentList.setColumnWidth(0, 150);
        this.documentList.setColumnWidth(1, 500);
        this.pb_SAVE.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_PROPERTY.addActionListener(this);
        this.toolBar.add(this.pb_PROPERTY);
        this.toolBar.add(new ToolBarSeparator());
        this.setLayout(new BorderLayout());
        this.add((Component)this.documentList, "Center");
        bl = true;
        return bl;
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_SAVE);
        this.showToolbar();
    }

    public void panelSelected() {
        this.showToolbar();
    }

    public void panelDeselected() {
        this.parentWin.removeToolbarButton(this.toolBar);
    }

    private void showToolbar() {
        this.parentWin.addToolbarButton(this.toolBar, 2);
    }

    public String getName() {
        return Str.getStr(645);
    }

    public boolean bookmark() {
        GUISystem.printBox("Hey Hey Hey", "This is a sample and doesn't support bookmarks!");
        return false;
    }

    public void refresh() {
        GUISystem.printBox("Hey Hey Hey", "You just selected 'Refresh' button! We will now put data in our list");
        new Thread((Runnable)this, THREAD_REFRESH_DATA).start();
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public JComponent getJComponent() {
        return this;
    }

    public boolean shutdown() {
        return true;
    }

    public boolean stop() {
        return true;
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 43);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            this.parentWin.closePanel(this, null);
        } else if (actionEvent.getSource() == this.pb_SAVE) {
            GUISystem.printBox("Hey Hey Hey", "You pushed the Save! Button!");
        } else if (actionEvent.getSource() == this.pb_PROPERTY) {
            GUISystem.printBox("Properties", "You just selected to show the properties of this thing!");
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_REFRESH_DATA)) {
            this.refreshData();
        }
    }

    private void refreshData() {
        SQLMethod sQLMethod = new SQLMethod(1, "refreshData", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            Vector<SampleRec> vector = new Vector<SampleRec>();
            if (statement != null) {
                ResultSet resultSet = null;
                resultSet = statement.executeQuery("SELECT DOCIND, TITLE FROM TIGRIS.DOCUMENTS WHERE CHANGEDTIME > '2001-02-04-07.00.00.000000'");
                while (resultSet.next()) {
                    vector.addElement(new SampleRec(resultSet.getInt(1), resultSet.getString(2).trim()));
                }
                resultSet.close();
                this.documentList.removeAll();
                this.documentList.add(vector);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
    }
}

