/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.storedProc.readUsers;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Clob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.qit.app.BrandMgrRec;
import com.ibm.nzna.projects.qit.app.UserRec;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ReadUsers
extends StoredProc {
    private StoredProcRec returnRec = new StoredProcRec();
    private Vector returnVec = null;
    private Connection con = null;
    private String userList = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readUsers(Clob clob, Blob blob, Blob blob2) throws Exception {
        try {
            this.userList = this.userList;
            this.con = this.getConnection();
            this.getStringFromClob(clob);
            if (this.userList.equals("UNIQUE_USERS")) {
                this.readUniqueUserIds();
            } else {
                this.returnVec = ReadUsers.readUsers(this.con, this.userList);
            }
            blob = Lob.newBlob();
            StoredProcUtil.setObjectInBlob(blob, this.returnVec);
            this.set(2, blob);
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
            StoredProcUtil.setObjectInBlob(blob, new Vector(1));
            this.set(2, blob);
        }
        this.con.commit();
        this.con.close();
        blob2 = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob2, this.returnRec);
        this.set(3, blob2);
    }

    public static Vector readUsers(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        String string2 = null;
        ResultSet resultSet = null;
        UserRec userRec = null;
        Vector<UserRec> vector = new Vector<UserRec>(1, 10);
        string2 = "SELECT A.USERID,      A.NAME,          A.MANAGER,   A.MANAGERUSERID, " + "       A.PHONENUM,    A.BACKUPUSERID,  A.EMAILADDR, A.PASSWORD,      " + "       B.LANGUAGEIND, C.EMAILADDR " + "FROM TIGRIS.USERID A, " + "     TIGRIS.USERLANGUAGE B, " + "     TIGRIS.USERID C " + "WHERE A.USERID in ( " + string + " ) AND " + "      A.USERID = B.USERID AND " + "      C.USERID = A.MANAGERUSERID " + "ORDER BY A.USERID FOR FETCH ONLY";
        resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            userRec = new UserRec(resultSet.getString(1).trim(), resultSet.getString(2).trim());
            userRec.setIsManager(resultSet.getString(3).trim().equals("Y"));
            userRec.setManagerUserId(resultSet.getString(4).trim());
            userRec.setPhone(resultSet.getString(5).trim());
            userRec.setBackUp(resultSet.getString(6).trim());
            userRec.setEMail(resultSet.getString(7).trim());
            userRec.setPassword(userRec.decryptPassword(resultSet.getString(8).trim()));
            userRec.setLanguage(resultSet.getInt(9));
            userRec.setManagerEMail(resultSet.getString(9).trim());
            vector.addElement(userRec);
        }
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                userRec = (UserRec)vector.elementAt(n);
                ReadUsers.readUserCountry(connection, userRec);
                ReadUsers.readUserTeams(connection, userRec);
                ReadUsers.readUserBrands(connection, userRec);
                ++n;
            }
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    private static final void readUserCountry(Connection connection, UserRec userRec) throws Exception {
        Statement statement = connection.createStatement();
        String string = null;
        ResultSet resultSet = null;
        string = "SELECT COUNTRYCODEIND FROM TIGRIS.USERIDCOUNTRY WHERE USERID = '" + userRec.getUserId() + "'";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            userRec.addCountry(resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    private static final void readUserTeams(Connection connection, UserRec userRec) throws Exception {
        Statement statement = connection.createStatement();
        String string = null;
        ResultSet resultSet = null;
        string = "SELECT USERGROUP FROM TIGRIS.USERIDUSERGROUP WHERE USERID = '" + userRec.getUserId() + "'";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            userRec.addTeam(resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    private static final void readUserBrands(Connection connection, UserRec userRec) throws Exception {
        Statement statement = connection.createStatement();
        String string = null;
        ResultSet resultSet = null;
        string = "SELECT BRANDIND, TYPEBRANDMGR FROM TIGRIS.USERIDBRAND WHERE USERID = '" + userRec.getUserId() + "'";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            userRec.addBrandMgrRec(new BrandMgrRec(resultSet.getString(2).trim(), resultSet.getInt(1)));
        }
        resultSet.close();
        statement.close();
    }

    private final void readUniqueUserIds() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT USERID FROM TIGRIS.USERID FOR FETCH ONLY");
        this.returnVec = new Vector(500, 1);
        while (resultSet.next()) {
            this.returnVec.addElement(resultSet.getString(1).trim());
        }
        resultSet.close();
        statement.close();
    }

    private final boolean getStringFromClob(Clob clob) throws Exception {
        Reader reader = clob.getReader();
        int n = 256;
        char[] cArray = new char[n];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1 && reader != null) {
            n2 = reader.read(cArray);
            if (n2 <= -1) continue;
            stringBuffer.append(new String(cArray).substring(0, n2));
        }
        if (stringBuffer.length() > 0) {
            this.userList = stringBuffer.toString();
            return true;
        }
        return false;
    }
}

