/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.storedProc.sqlRunner;

import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;

public class QITSqlRunner
extends SqlRunner
implements AppConst {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sqlRunner(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "sqlRunner", 5);
        int n = 0;
        Qit.setEnabled(false);
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.sqlRunner", 2);
            String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
            LogSystem.log(1, "Starting to send statements to EXT SQLRUNNER");
            LogSystem.log(1, string2);
            callableStatement.registerOutParameter(1, -4);
            callableStatement.registerOutParameter(2, -4);
            callableStatement.setBytes(1, string.getBytes());
            LogSystem.log(2, "Running SQLRunner:");
            LogSystem.log(2, Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n    "));
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
                GUISystem.printBox(6, 202);
                n = storedProcRec.sqlCode;
            }
            callableStatement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
            n = -1;
        }
        sQLMethod.close();
        Qit.setEnabled(true);
        if (n == 0) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int sqlRunnerCode(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "sqlRunner", 5);
        int n = 0;
        Qit.setEnabled(false);
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.sqlRunner", 2);
            String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
            LogSystem.log(1, "Starting to send statements to EXT SQLRUNNER");
            LogSystem.log(1, string2);
            callableStatement.registerOutParameter(1, -4);
            callableStatement.registerOutParameter(2, -4);
            callableStatement.setBytes(1, string.getBytes());
            LogSystem.log(2, "Running SQLRunner:");
            LogSystem.log(2, Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n    "));
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
                n = storedProcRec.sqlCode;
            }
            callableStatement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n = -1;
        }
        sQLMethod.close();
        Qit.setEnabled(true);
        return n;
    }
}

