/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.wordproc;

import com.ibm.nzna.projects.qit.wordproc.WPHTMLGeneratorListener;
import com.ibm.nzna.shared.util.Text;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import lotus.wp.WordProcessor;
import lotus.wp.ifx.Bookmark;
import lotus.wp.ifx.Link;
import lotus.wp.ifx.ParagraphStyle;
import lotus.wp.ifx.Table;
import lotus.wp.ifx.TableCell;
import lotus.wp.ifx.TextElement;
import lotus.wp.ifx.WPEnumeration;
import lotus.wp.ifx.WPImage;

public class WPHTMLGenerator
implements Runnable {
    static WordProcessor wp = null;
    static TextElement curElement = null;
    static ParagraphStyle curParagraph = null;
    static int inBold = 0;
    static int inItalic = 0;
    static int inFont = 0;
    static String curChar = null;
    static boolean continueGenerating = true;
    static String curFontName = "Helvetica, Arial";
    static int curFontSize = 12;
    static Color curFontColor = Color.black;
    static int tableCount = 0;
    static int graphicCount = 0;
    static int passes = 0;
    static boolean firstFontChange = true;
    static boolean insideBulletList = false;
    static boolean insideOrderedList = false;
    static boolean processNextBreak = true;
    static String curAlignment = "left";
    static int inPre = 0;
    static WPHTMLGeneratorListener statusListener = null;

    public void run() {
        if (wp != null) {
            WPHTMLGenerator.generateHTML(wp, null);
        }
    }

    public static String generateHTML(WordProcessor wordProcessor, WPHTMLGeneratorListener wPHTMLGeneratorListener) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = true;
        wp = wordProcessor;
        wp.setRefreshEnabled(false);
        wp.setVisible(false);
        WPHTMLGenerator.applyAnchorsToTables();
        wp.setRefreshEnabled(true);
        wp.setRefreshEnabled(false);
        curElement = null;
        curParagraph = null;
        inBold = 0;
        inItalic = 0;
        inFont = 0;
        curChar = null;
        continueGenerating = true;
        curFontName = "Helvetica, Arial";
        curFontSize = 12;
        tableCount = 0;
        graphicCount = 0;
        firstFontChange = true;
        insideBulletList = false;
        insideOrderedList = false;
        curAlignment = "left";
        statusListener = wPHTMLGeneratorListener;
        WPHTMLGenerator.notifyListener("Pass " + passes + " Starting");
        stringBuffer.append("<font face=\"Helvetica, Arial\" size=3 color=\"black\">");
        wp.gotoBeginningOfDocument(false);
        if (wp.getCharacter() == null || wp.getCharacter().length() == 0) {
            wp.insertText(" ");
            wp.gotoBeginningOfDocument(false);
        }
        while (continueGenerating) {
            WPHTMLGenerator.handleParagraphAlign(stringBuffer);
            if (WPHTMLGenerator.handleGraphics(stringBuffer, true)) continue;
            curChar = wp.getCharacter();
            WPHTMLGenerator.gotoNextChar("generateHTML, normal step");
            continueGenerating = WPHTMLGenerator.generateElementHTMLText(stringBuffer, true, true, false);
        }
        WPHTMLGenerator.closeTags(stringBuffer);
        if (inFont > 0) {
            if (curFontName.equals("Courier")) {
                stringBuffer.append("</pre>");
                --inPre;
            }
            stringBuffer.append("</font>");
        }
        stringBuffer.append("</font>");
        WPHTMLGenerator.saveFile("output.html", stringBuffer.toString());
        if ((WPHTMLGenerator.missedTables() || WPHTMLGenerator.missedGraphics()) && passes < 2) {
            ++passes;
            continueGenerating = true;
            stringBuffer = new StringBuffer(WPHTMLGenerator.generateHTML(wp, wPHTMLGeneratorListener));
        }
        WPHTMLGenerator.removeAnchorsFromTables();
        wp.setVisible(true);
        wp.setRefreshEnabled(true);
        string = stringBuffer.toString();
        string = Text.replaceAllStrInStr(string, "<br>\n<center>", "<center>");
        string = Text.replaceAllStrInStr(string, "<br>\n</center>", "</center>");
        string = Text.replaceAllStrInStr(string, "</center><br>", "</center>");
        string = Text.replaceAllStrInStr(string, "</div><br>", "</div>");
        string = Text.replaceAllStrInStr(string, "<center></center>", "");
        string = Text.replaceAllStrInStr(string, "<div align=\"right\"></div>", "");
        return string;
    }

    private static final boolean generateElementHTMLText(StringBuffer stringBuffer, boolean bl, boolean bl2, boolean bl3) {
        Bookmark bookmark;
        boolean bl4 = true;
        boolean bl5 = true;
        WPHTMLGenerator.notifyListener("Parsing normal text");
        curElement = wp.findSelectedTextElement();
        curParagraph = curElement.getParagraphStyle();
        if (bl3) {
            WPHTMLGenerator.handleParagraphAlign(stringBuffer);
        }
        boolean bl6 = bl4 = !WPHTMLGenerator.handleGraphics(stringBuffer, true);
        if (wp.findCurrentObject("bookmark") != null) {
            bookmark = (Bookmark)wp.findCurrentObject("bookmark");
            String string = bookmark.getName();
            if (string.indexOf("TABLE-") >= 0) {
                if (bl2) {
                    boolean bl7 = bl4 = !WPHTMLGenerator.generateTableHTMLText(stringBuffer, wp.findTable(string.substring(string.indexOf("-") + 1)));
                }
                if (bl4) {
                    WPHTMLGenerator.gotoNextChar("After generating HTML Table Text, processText was TRUE");
                }
            } else if (bl) {
                WPHTMLGenerator.generateLinkHTMLText(stringBuffer, bl3);
            }
        }
        if (bl4) {
            if (curChar != null && curChar.length() > 0) {
                WPHTMLGenerator.handleBold(stringBuffer);
                WPHTMLGenerator.handleItalic(stringBuffer);
                WPHTMLGenerator.handleLists(stringBuffer);
                WPHTMLGenerator.handleFontName(stringBuffer);
                WPHTMLGenerator.handleFontSize(stringBuffer);
                WPHTMLGenerator.handleFontColor(stringBuffer);
                stringBuffer.append(curChar);
            } else {
                bookmark = null;
                bl5 = WPHTMLGenerator.gotoNextChar("generateHTML, Closing Paragraph");
                bookmark = wp.findSelectedTextElement();
                if (bl5) {
                    WPHTMLGenerator.closeTags(stringBuffer);
                    WPHTMLGenerator.handleGraphics(stringBuffer, false);
                    if (insideOrderedList || insideBulletList) {
                        if (bookmark.getParagraphStyle().getName().startsWith("OLLI") || bookmark.getParagraphStyle().getName().startsWith("ULLI")) {
                            stringBuffer.append("\n<LI>");
                        }
                    } else if (bl3) {
                        if (!curAlignment.equals("left")) {
                            if (curAlignment.equals("center")) {
                                stringBuffer.append("</center>\n");
                            } else if (curAlignment.equals("right")) {
                                stringBuffer.append("</div>\n");
                            } else {
                                WPHTMLGenerator.handleLineBreak(stringBuffer);
                            }
                            curAlignment = "left";
                        } else if (bookmark.getAlignment().equals(curAlignment) || bookmark.getAlignment().equals("center")) {
                            WPHTMLGenerator.handleLineBreak(stringBuffer);
                        }
                    } else {
                        WPHTMLGenerator.handleLineBreak(stringBuffer);
                    }
                    WPHTMLGenerator.gotoPreviousChar("GenerateHTML - Closing Paragraph");
                }
            }
        }
        return bl5;
    }

    private static final void closeTags(StringBuffer stringBuffer) {
        if (inItalic > 0) {
            stringBuffer.insert(stringBuffer.length(), "</i>");
        }
        if (inBold > 0) {
            stringBuffer.insert(stringBuffer.length(), "</b>");
        }
        inBold = 0;
        inItalic = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void insertImage(StringBuffer stringBuffer) {
        String string;
        WPImage wPImage;
        block6: {
            wPImage = (WPImage)wp.findCurrentObject("image");
            if (wPImage == null) return;
            ++graphicCount;
            if (wPImage.getImageName().indexOf("doclink.gif") != -1) {
                stringBuffer.append("<img src=\"###IMAGELOC###doclink.gif\">");
                return;
            }
            string = wPImage.getImageName();
            try {
                if (string.indexOf("/") >= 0) {
                    string = string.substring(string.lastIndexOf("/") + 1, string.length());
                }
                if (string.indexOf("\\") >= 0) {
                    string = string.substring(string.lastIndexOf("\\") + 1, string.length());
                }
            }
            catch (Exception exception) {
                if (string.indexOf("/") >= 0) {
                    string = string.substring(string.lastIndexOf("/"), string.length());
                }
                if (string.indexOf("\\") < 0) break block6;
                string = string.substring(string.lastIndexOf("\\"), string.length());
            }
        }
        stringBuffer.append("<img src=\"./");
        stringBuffer.append(string);
        stringBuffer.append("\" WIDTH=" + wPImage.getWidth() + " HEIGHT=" + wPImage.getHeight() + " BORDER=0>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveFile(String string, String string2) {
        boolean bl = false;
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static void insertTable(WordProcessor wordProcessor, String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(new String("<TABLE NAME=\"" + string + "\">"));
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("<tr>");
            int n4 = 0;
            while (n4 < n2) {
                stringBuffer.append("<td><font face=\"Helvetica, Arial\", size=2></td>");
                ++n4;
            }
            stringBuffer.append("</tr>");
            ++n3;
        }
        stringBuffer.append("</TABLE>");
        WPHTMLGenerator.saveFile("c:\\t.html", stringBuffer.toString());
        wordProcessor.insertDocument("file:/c:/t.html");
        WPHTMLGenerator.deleteFile("c:\\t.html");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void deleteFile(String string) {
        try {
            File file = new File(string);
            if (file == null) return;
            file.delete();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean generateTableHTMLText(StringBuffer stringBuffer, Table table) {
        boolean bl = true;
        WPHTMLGenerator.notifyListener("Handling Table");
        if (table == null) return bl;
        String string = null;
        int n = 0;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        String string2 = table.getName();
        int n2 = table.getTableWidth();
        int n3 = table.getRowCount();
        int n4 = table.getColumnCount();
        TableCell tableCell = null;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        String string3 = table.getAlignment();
        String string4 = WPHTMLGenerator.stripLastBreak(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append(string4);
        ++tableCount;
        curAlignment = "left";
        if (insideOrderedList) {
            stringBuffer.append("</OL>");
            insideOrderedList = false;
        }
        if (insideBulletList) {
            stringBuffer.append("</UL>");
            insideBulletList = false;
        }
        if (!curElement.getAlignment().equals("left")) {
            if (curElement.getAlignment().equals("right")) {
                stringBuffer.append("</div>");
            } else if (curElement.getAlignment().equals("center")) {
                stringBuffer.append("</center>");
            }
            curAlignment = "left";
        }
        if (string3.equals("center")) {
            stringBuffer.append("<center>");
        } else if (string3.equals("right")) {
            stringBuffer.append("<div align=\"right\">");
        }
        wp.gotoObject("table", string2);
        stringBuffer.append("\n<table name=\"" + string2 + "\" ");
        if (n2 == 0) {
            stringBuffer.append("width=\"%100\" ");
        } else if (n2 < 0) {
            stringBuffer.append("width=\"%" + Math.abs(n2) + "\" ");
        } else {
            stringBuffer.append("width=\"" + n2 + "\" ");
        }
        stringBuffer.append("border=" + table.getBorderWidth());
        stringBuffer.append(">\n");
        n6 = 0;
        while (n6 < n4) {
            stringBuffer.append("<COL ");
            WPHTMLGenerator.convertWidth(n2, table.findTableCellByPosition(n5, n6).getColumnWidth(), stringBuffer);
            stringBuffer.append("></COL>\n");
            ++n6;
        }
        n5 = 0;
        while (n5 < n3) {
            stringBuffer.append("<tr>\n");
            n = 0;
            n6 = 0;
            while (n6 < n4) {
                boolean bl3 = true;
                tableCell = table.findTableCellByPosition(n5, n6);
                if (tableCell != null) {
                    stringBuffer3 = new StringBuffer();
                    stringBuffer3.append("<td ");
                    string = WPHTMLGenerator.getTableCellAlignment(tableCell);
                    stringBuffer3.append("align=\"" + string + "\" ");
                    stringBuffer3.append("valign=\"top\" ");
                    stringBuffer3.append("width=\"" + tableCell.getColumnWidth() + "\">\n");
                    stringBuffer2 = new StringBuffer("");
                    wp.gotoObject("tablecell", tableCell.getName());
                    try {
                        while (bl3) {
                            curChar = wp.getCharacter();
                            if (!WPHTMLGenerator.handleGraphics(stringBuffer, true)) {
                                WPHTMLGenerator.gotoNextChar("generateTableHTMLText, normal step inside of cell");
                            }
                            if (((TableCell)wp.findCurrentObject("tablecell")).getName().equals(tableCell.getName())) {
                                if (wp.findCurrentObject("link") != null) {
                                    WPHTMLGenerator.generateLinkHTMLText(stringBuffer2, false);
                                    bl3 = ((TableCell)wp.findCurrentObject("tablecell")).getName().equals(tableCell.getName());
                                    boolean bl4 = bl = bl3 && n5 == n3 - 1 && n6 == n4 - 1;
                                }
                                if (!bl3) continue;
                                ++n;
                                WPHTMLGenerator.generateElementHTMLText(stringBuffer2, true, false, false);
                                continue;
                            }
                            bl3 = false;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    if (stringBuffer2.toString().indexOf("<br>") != -1) {
                        stringBuffer3.append("<WP_CELL_BR>");
                    }
                    stringBuffer3.append("<font face=\"" + curFontName + "\" size=" + WPHTMLGenerator.getFontSize() + ">");
                    stringBuffer.append(stringBuffer3.toString());
                    stringBuffer.append(stringBuffer2.toString().trim());
                    if (curAlignment.equals("center")) {
                        stringBuffer.append("</center>");
                    } else if (curAlignment.equals("right")) {
                        stringBuffer.append("</div>");
                    }
                    curAlignment = "left";
                    WPHTMLGenerator.closeTags(stringBuffer);
                    if (n > 0) {
                        stringBuffer.append("</font></td>\n");
                    } else {
                        stringBuffer.append("&nbsp;</font></td>\n");
                    }
                }
                ++n6;
            }
            stringBuffer.append("</tr>\n");
            ++n5;
        }
        stringBuffer.append("</table>\n");
        if (string3.equals("center")) {
            stringBuffer.append("</center>");
        } else if (string3.equals("right")) {
            stringBuffer.append("</div>");
        }
        try {
            wp.gotoObject("bookmark", "TABLE-" + string2);
            while (true) {
                if (!((Table)wp.findCurrentObject("table")).getName().equals(table.getName())) {
                    return bl;
                }
                WPHTMLGenerator.gotoNextChar("generateTableHTMLText, Advancing after table");
            }
        }
        catch (Exception exception) {
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void generateLinkHTMLText(StringBuffer stringBuffer, boolean bl) {
        block5: {
            Link link = (Link)wp.findCurrentObject("link");
            boolean bl2 = true;
            WPHTMLGenerator.notifyListener("Handling Link");
            stringBuffer.append("<a href=\"");
            stringBuffer.append(link.getDestination());
            stringBuffer.append("\">");
            WPHTMLGenerator.gotoPreviousChar("GenerateLinkHTMLText, Checking for Image");
            WPHTMLGenerator.handleGraphics(stringBuffer, false);
            if (curChar != null && curChar.length() > 0) {
                stringBuffer.append(curChar);
                WPHTMLGenerator.gotoNextChar("generateLinkHTMLText, Stepping after first character in Link");
            }
            try {
                while (bl2) {
                    curChar = wp.getCharacter();
                    WPHTMLGenerator.gotoNextChar("generateLinkHTMLText, Stepping in link");
                    if (wp.findCurrentObject("link") != null && ((Link)wp.findCurrentObject("link")).getDestination().equals(link.getDestination())) {
                        WPHTMLGenerator.generateElementHTMLText(stringBuffer, false, true, bl);
                        continue;
                    }
                    if (wp.findCurrentObject("link") != null) continue;
                    bl2 = false;
                }
            }
            catch (Exception exception) {
                if (exception instanceof NullPointerException) break block5;
                exception.printStackTrace();
            }
        }
        stringBuffer.append("</a>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void applyAnchorsToTables() {
        WPEnumeration wPEnumeration = wp.enumerateTables();
        String string = null;
        WPHTMLGenerator.notifyListener("Adding anchors to tables");
        while (wPEnumeration.hasMoreNames()) {
            string = wPEnumeration.nextName();
            try {
                if (wp.gotoObject("bookmark", "TABLE-" + string) || !wp.gotoObject("table", string)) continue;
                WPHTMLGenerator.gotoPreviousChar("applyAnchorsToTables");
                wp.gotoNextCharacter(true);
                wp.insertBookmark("TABLE-" + string);
            }
            catch (Exception exception) {
            }
        }
    }

    private static final void removeAnchorsFromTables() {
        WPEnumeration wPEnumeration = wp.enumerateTables();
        String string = null;
        WPHTMLGenerator.notifyListener("Removing anchors from tables");
        while (wPEnumeration.hasMoreNames()) {
            string = wPEnumeration.nextName();
            wp.deleteBookmark("TABLE-" + string);
        }
    }

    private static final String getFontName() {
        String string = curElement.getFontName();
        curFontName = string.indexOf("ourie") > 0 || string.indexOf("onospac") > 0 ? "Courier" : "Helvetica, Arial";
        return curFontName;
    }

    private static final int getFontSize() {
        int n;
        curFontSize = n = curElement.getFontSize();
        switch (n) {
            case 12: {
                return 3;
            }
            case 10: {
                return 2;
            }
            case 8: {
                return 1;
            }
        }
        return 3;
    }

    private static final boolean missedTables() {
        WPEnumeration wPEnumeration = wp.enumerateTables();
        int n = 0;
        while (wPEnumeration.hasMoreNames()) {
            if (wPEnumeration.nextName() == null) continue;
            ++n;
        }
        return tableCount != n;
    }

    private static final boolean missedGraphics() {
        WPEnumeration wPEnumeration = wp.enumerateImages();
        int n = 0;
        while (wPEnumeration.hasMoreNames()) {
            if (wPEnumeration.nextName() == null) continue;
            ++n;
        }
        return graphicCount != n;
    }

    private static final String stripLastBreak(String string) {
        int n = string.lastIndexOf("<br>");
        int n2 = n + 4;
        if (n >= 0 && n2 >= 0) {
            return string.substring(0, n) + string.substring(n2);
        }
        return string;
    }

    private static final void convertWidth(int n, int n2, StringBuffer stringBuffer) {
        if (n < 0) {
            n /= 100;
            n *= 624;
        }
        if (n == 0) {
            n = 624;
        }
        n2 = Math.abs(n2 * 100 / n);
        stringBuffer.append("WIDTH=\"" + n2 + "%\"");
    }

    private static final String getTableCellAlignment(TableCell tableCell) {
        String string = "left";
        boolean bl = true;
        wp.gotoObject("tablecell", tableCell.getName());
        while (bl) {
            if (!wp.findSelectedTextElement().getAlignment().equals("left")) {
                bl = false;
                string = wp.findSelectedTextElement().getAlignment();
            }
            WPHTMLGenerator.gotoNextChar("getTableCellAlignment");
            if (wp.findCurrentObject("tablecell") == tableCell) continue;
            bl = false;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean gotoPreviousChar(String string) {
        boolean bl = false;
        try {
            return wp.gotoPreviousCharacter(false);
        }
        catch (Exception exception) {
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean gotoNextChar(String string) {
        boolean bl = false;
        try {
            return wp.gotoNextCharacter(false);
        }
        catch (Exception exception) {
        }
        return bl;
    }

    private static final boolean handleGraphics(StringBuffer stringBuffer, boolean bl) {
        boolean bl2 = false;
        if (wp.findCurrentObject("image") != null) {
            if (curChar != null && curChar.length() > 0) {
                stringBuffer.append(curChar);
            }
            WPHTMLGenerator.insertImage(stringBuffer);
            if (bl) {
                WPHTMLGenerator.gotoNextChar("GenerateElementHTMLText, Stepping after image");
            }
            curChar = "";
            bl2 = true;
        }
        return bl2;
    }

    private static final void handleBold(StringBuffer stringBuffer) {
        if (curElement.getBold()) {
            if (inBold == 0) {
                stringBuffer.append("<b>");
                ++inBold;
            }
        } else if (inBold > 0 && --inBold == 0) {
            stringBuffer.append("</b>");
        }
    }

    private static final void handleItalic(StringBuffer stringBuffer) {
        if (curElement.getItalic()) {
            if (inItalic == 0) {
                stringBuffer.append("<i>");
                ++inItalic;
            }
        } else if (inItalic > 0 && --inItalic == 0) {
            stringBuffer.append("</i>");
        }
    }

    private static final void handleLists(StringBuffer stringBuffer) {
        if (curParagraph.getName().startsWith("OLLI")) {
            if (insideBulletList) {
                insideBulletList = false;
                stringBuffer.append("\n</UL>\n");
            }
            if (!insideOrderedList) {
                String string = stringBuffer.toString();
                stringBuffer.setLength(0);
                stringBuffer.append(WPHTMLGenerator.stripLastBreak(string));
                stringBuffer.append("\n<OL><LI>\n");
                insideOrderedList = true;
            }
        } else if (curParagraph.getName().startsWith("ULLI")) {
            if (insideOrderedList) {
                insideOrderedList = false;
                stringBuffer.append("\n</OL>\n");
            }
            if (!insideBulletList) {
                String string = stringBuffer.toString();
                stringBuffer.setLength(0);
                stringBuffer.append(WPHTMLGenerator.stripLastBreak(string));
                stringBuffer.append("\n<UL>\n<LI>");
                insideBulletList = true;
            }
        } else {
            if (insideOrderedList) {
                insideOrderedList = false;
                stringBuffer.append("\n</OL>\n");
            }
            if (insideBulletList) {
                insideBulletList = false;
                stringBuffer.append("\n</UL>\n");
            }
        }
    }

    private static final void handleFontName(StringBuffer stringBuffer) {
        if (curElement.getFontName().indexOf(curFontName) == -1 && curFontName.indexOf(curElement.getFontName()) == -1 && curElement.getFontName().indexOf("imes") == -1 && curElement.getFontName().indexOf("erif") == -1) {
            inFont = 1;
            if (!firstFontChange) {
                if (curFontName.indexOf("rier") != -1) {
                    stringBuffer.append("</pre>");
                    --inPre;
                }
                stringBuffer.append("</font>");
            } else {
                firstFontChange = false;
            }
            if (WPHTMLGenerator.getFontName().equals("Courier")) {
                stringBuffer.append("<pre>");
                ++inPre;
            }
            stringBuffer.append("<font face=\"" + WPHTMLGenerator.getFontName() + "\" size=" + WPHTMLGenerator.getFontSize() + " color=\"" + WPHTMLGenerator.getFontColor() + "\">");
        }
    }

    private static final void handleFontSize(StringBuffer stringBuffer) {
        if (curElement.getFontSize() != curFontSize) {
            inFont = 1;
            if (!firstFontChange) {
                stringBuffer.append("</font><font size=" + WPHTMLGenerator.getFontSize() + " face=\"" + WPHTMLGenerator.getFontName() + "\" color=\"" + WPHTMLGenerator.getFontColor() + "\" >");
            } else {
                stringBuffer.append("<font size=" + WPHTMLGenerator.getFontSize() + " face=\"" + WPHTMLGenerator.getFontName() + "\" color=\"" + WPHTMLGenerator.getFontColor() + "\">");
                firstFontChange = false;
            }
        }
    }

    private static final void handleParagraphAlign(StringBuffer stringBuffer) {
        if (curElement == null) {
            curElement = wp.findSelectedTextElement();
        }
        if (curElement != null && !curElement.getAlignment().equals(curAlignment)) {
            if (curAlignment.equals("center")) {
                stringBuffer.append("</center>");
            } else if (curAlignment.equals("right")) {
                stringBuffer.append("</div>");
            }
            curAlignment = curElement.getAlignment();
            if (curAlignment.equals("center")) {
                stringBuffer.append("<center>");
            } else if (curAlignment.equals("right")) {
                stringBuffer.append("<div align=\"right\">");
            }
        }
    }

    private static final void handleFontColor(StringBuffer stringBuffer) {
        if (curElement.getTextColor() != curFontColor) {
            curFontColor = curElement.getTextColor();
            inFont = 1;
            if (!firstFontChange) {
                stringBuffer.append("</font><font color=\"" + WPHTMLGenerator.getFontColor() + "\" size=" + WPHTMLGenerator.getFontSize() + " face=\"" + WPHTMLGenerator.getFontName() + "\" >");
            } else {
                stringBuffer.append("<font color=\"" + WPHTMLGenerator.getFontColor() + "\" size=" + WPHTMLGenerator.getFontSize() + " face=\"" + WPHTMLGenerator.getFontName() + "\">");
                firstFontChange = false;
            }
        }
    }

    private static final String getFontColor() {
        Color color = wp.findSelectedTextElement().getTextColor();
        String string = "black";
        if (color.equals(Color.green)) {
            string = "green";
        } else if (color.equals(Color.gray)) {
            string = "gray";
        } else if (color.getRed() == 0 && color.getBlue() == 255 && color.getGreen() == 0) {
            string = "blue";
        } else if (color.getRed() == 255 && color.getBlue() == 0 && color.getGreen() == 0) {
            string = "red";
        }
        return string;
    }

    private static final void handleLineBreak(StringBuffer stringBuffer) {
        if (processNextBreak) {
            if (inPre == 0) {
                stringBuffer.append("<br>\n");
            } else {
                stringBuffer.append("<WP_PRE_BR>\n");
            }
        } else {
            processNextBreak = true;
        }
    }

    private static final void notifyListener(String string) {
        if (statusListener != null) {
            statusListener.HTMLGeneratorStatus(string);
        }
    }

    public WPHTMLGenerator(WordProcessor wordProcessor) {
        wp = wordProcessor;
        new Thread(this).start();
    }
}

