/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.wordproc;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.DocRec;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocDlg;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.wordproc.HTMLParse;
import com.ibm.nzna.projects.qit.wordproc.StampedGraphicDlg;
import com.ibm.nzna.projects.qit.wordproc.StampedGraphicDlgListener;
import com.ibm.nzna.projects.qit.wordproc.TablePropertyDlg;
import com.ibm.nzna.projects.qit.wordproc.WPHTMLGeneratorListener;
import com.ibm.nzna.projects.qit.wordproc.WordProcUtil;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import lotus.wp.WordProcessor;
import lotus.wp.WordProcessorBean;
import lotus.wp.ifx.Link;
import lotus.wp.ifx.ParagraphStyle;
import lotus.wp.ifx.Position;
import lotus.wp.ifx.SearchOptions;
import lotus.wp.ifx.Table;
import lotus.wp.ifx.TableCell;
import lotus.wp.ifx.TextElement;
import lotus.wp.ifx.WPEnumeration;

public class WordProcPanel
extends JPanel
implements StampedGraphicDlgListener,
WPHTMLGeneratorListener,
ProductConstants,
DocConst,
AppConst,
KeyListener,
ActionListener,
Runnable {
    private static final Insets taskBarButtonMargin = new Insets(0, 0, 0, 0);
    private static final String THREAD_INITIALIZE = "Init";
    private static final String THREAD_SPELLCHECK = "SPELLCHECK";
    private static final String THREAD_SAVECONTENTANDEXIT = "SAVECONTENTANDEXIT";
    private static final String THREAD_SAVECONTENT = "SAVECONTENT";
    private static final String THREAD_AUTOSAVE = "AUTOSAVE";
    private static final String THREAD_SETCONTENT = "SETCONTENT";
    private static final String THREAD_WAITANDSETCONTENT = "WAITANDSETCONTENT";
    private WordProcessorBean wordProc = null;
    private JToolBar toolBar = null;
    private Panel actionBar = null;
    private Panel toolBarPanel = null;
    private Panel cardPanel = null;
    private Panel fontBar = null;
    private Browser pnl_PREVIEW = null;
    private TextArea mle_EDITTAGS = null;
    protected DButton pb_CLOSE = null;
    protected DButton pb_TABLE = null;
    protected DButton pb_TABLEPROP = null;
    protected DButton pb_CENTERALIGN = null;
    protected DButton pb_LEFTALIGN = null;
    protected DButton pb_RIGHTALIGN = null;
    protected DButton pb_SAVE = null;
    protected DButton pb_LINK = null;
    protected DButton pb_IMPORTGRAPHIC = null;
    protected DButton pb_BOLD = null;
    protected DButton pb_ITALIC = null;
    protected DButton pb_UNDERLINE = null;
    protected DButton pb_STRIKETHROUGH = null;
    protected DButton pb_CLEAR = null;
    protected DButton pb_HORIZLINE = null;
    protected DButton pb_CUT = null;
    protected DButton pb_COPY = null;
    protected DButton pb_PASTE = null;
    protected DButton pb_UNDO = null;
    protected DButton pb_BULLETLIST = null;
    protected DButton pb_NUMERICLIST = null;
    protected DButton pb_FIND = null;
    protected DButton pb_FINDAGAIN = null;
    protected DButton pb_DOCLINK = null;
    protected DButton pb_SPELL = null;
    protected DButton pb_RESTARTWP = null;
    protected DButton pb_PREVIEW = null;
    protected DButton pb_LINKTARGET = null;
    protected DButton pb_IMPORTHTML = null;
    protected DButton pb_DELETEROW = null;
    protected DButton pb_DELETECOL = null;
    protected DButton pb_INSERTROW = null;
    protected DButton pb_INSERTCOL = null;
    protected DButton pb_STAMPEDGRAPHIC = null;
    protected DButton pb_HELV = null;
    protected DButton pb_COURIER = null;
    protected DButton pb_HELV10 = null;
    protected DButton pb_MONO10 = null;
    protected DButton pb_DEFAULT = null;
    protected DButton pb_BLACK = null;
    protected DButton pb_RED = null;
    protected DButton pb_BLUE = null;
    protected DButton pb_PROPERTY = null;
    protected DButton pb_COMMENTS = null;
    protected DButton pb_DELCOMMENTS = null;
    protected DButton pb_EDITTAGS = null;
    private MenuBar menuBar = null;
    private Menu MNU_FILE = null;
    private MenuItem MNU_QUIT = null;
    private Menu MNU_HELP = null;
    private MenuItem MNU_GENERIC = null;
    private MenuItem MNU_PANEL = null;
    private MenuItem MNU_INDEX = null;
    private MenuItem MNU_USERPREF = null;
    private Menu MNU_EDIT = null;
    private MenuItem MNU_CUT = null;
    private Menu MNU_COPY = null;
    private MenuItem MNU_COPYASTEXT = null;
    private MenuItem MNU_COPYASDOC = null;
    private Menu MNU_PASTE = null;
    private MenuItem MNU_PASTEASTEXT = null;
    private MenuItem MNU_PASTEASDOC = null;
    private MenuItem MNU_PASTEASPRODUCT = null;
    private MenuItem MNU_CLEARDOC = null;
    private MenuItem MNU_SELECTALL = null;
    private Menu MNU_STYLES = null;
    private Menu MNU_HEADING = null;
    private Menu MNU_BODY = null;
    private MenuItem MNU_MAINHEAD = null;
    private MenuItem MNU_SUBHEAD = null;
    private MenuItem MNU_SUBSUBHEAD = null;
    private MenuItem MNU_DEFAULTBODY = null;
    private MenuItem MNU_MONOBODY = null;
    private MenuItem MNU_WARNINGBODY = null;
    private MenuItem MNU_STANDARDS = null;
    private String htmlText = null;
    private DocRec docRec = null;
    private int fieldId = 0;
    private boolean wordProcStarted = false;
    private boolean processKey = false;
    private TextElement curSelectedText = null;
    private ParagraphStyle curParagraph = null;
    private boolean inPreviewMode = false;
    private boolean changed = false;
    private String prevFindString = null;
    private boolean nextLinkAsTarget = false;
    private boolean currentlySaving = false;
    private Thread autoSaveThread = null;
    private boolean continueAutoSave = true;
    private String autoSaveContent = null;
    private boolean enabled = true;
    private boolean editingTags = false;
    private StampedGraphicDlg stampedGraphicDlg = null;
    private boolean isBold = false;
    private boolean isItalic = false;
    private boolean isUnderlined = false;
    private boolean isStriked = false;

    private void initialize() {
        this.initializeMenu();
        this.initializeToolbars();
        this.mle_EDITTAGS = new TextArea();
        this.toolBarPanel = new Panel();
        this.cardPanel = new Panel();
        if (!this.wordProcStarted) {
            this.createWordProcessor();
        }
        this.toolBarPanel.setBackground(Color.lightGray);
        this.cardPanel.setBackground(Color.lightGray);
        this.actionBar.setBackground(Color.lightGray);
        this.fontBar.setBackground(Color.lightGray);
        this.cardPanel.setBackground(Color.lightGray);
        this.toolBar.setBackground(Color.lightGray);
        this.toolBar.setBorder(null);
        this.pnl_PREVIEW = new Browser();
        this.setLayout(new BorderLayout());
        this.toolBarPanel.setLayout(new BorderLayout(0, 0));
        this.cardPanel.setLayout(new CardLayout(2, 2));
        this.fontBar.setLayout(new FlowLayout(0));
        this.toolBarPanel.add((Component)this.toolBar, "North");
        this.toolBarPanel.add((Component)this.fontBar, "Center");
        this.toolBarPanel.add((Component)this.actionBar, "South");
        this.add((Component)this.toolBarPanel, "North");
        this.add((Component)this.cardPanel, "Center");
        this.cardPanel.add((Component)this.wordProc, "wordProc");
        this.cardPanel.add((Component)((Object)this.pnl_PREVIEW), "pnl_PREVIEW");
        this.cardPanel.add((Component)this.mle_EDITTAGS, "mle_EDITTAGS");
        this.invalidate();
        this.refreshData(this.docRec, this.fieldId, THREAD_SETCONTENT);
        new Thread((Runnable)this, THREAD_AUTOSAVE);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_INITIALIZE)) {
            this.initialize();
        } else if (string.equals(THREAD_SPELLCHECK)) {
            this.spellCheck(true);
        } else if (string.equals(THREAD_SAVECONTENT)) {
            this.saveContent();
        } else if (string.equals(THREAD_SAVECONTENTANDEXIT)) {
            if (this.saveContent()) {
                this.windowClosing(null);
            }
        } else if (string.equals(THREAD_AUTOSAVE)) {
            this.processAutoSave();
        } else if (string.equals(THREAD_SETCONTENT)) {
            this.setContent();
        } else if (string.equals(THREAD_WAITANDSETCONTENT)) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setContent();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.enabled) {
            if (windowEvent == null) {
                Rectangle rectangle = this.getBounds();
                QuestUtil.writeObjectToDisk("wpframe.loc", rectangle);
                MainWindow.getInstance().requestFocus();
                MainWindow.getInstance().toFront();
                this.finalize();
            } else {
                this.checkClose();
            }
        }
    }

    public void finalize() {
        try {
            if (this.wordProcStarted) {
                WordProcUtil.destroyWordProcessor(this.wordProc);
                this.wordProcStarted = false;
            }
            this.continueAutoSave = false;
            if (this.autoSaveThread != null) {
                this.autoSaveThread.interrupt();
            }
            this.remove(this.toolBar);
            this.toolBar = null;
            this.actionBar = null;
            this.wordProc = null;
            this.curSelectedText = null;
            this.curParagraph = null;
            super.finalize();
            System.gc();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void initializeToolbars() {
        this.toolBar = new JToolBar();
        this.actionBar = new Panel();
        this.fontBar = new Panel();
        this.toolBar.setBackground(Color.lightGray);
        this.actionBar.setLayout(new FlowLayout(0));
        this.actionBar.setBackground(Color.lightGray);
        this.pb_STAMPEDGRAPHIC = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 63));
        this.pb_TABLE = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 64));
        this.pb_TABLEPROP = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 65));
        this.pb_CENTERALIGN = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 66));
        this.pb_RIGHTALIGN = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 67));
        this.pb_LEFTALIGN = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 68));
        this.pb_LINK = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 69));
        this.pb_LINKTARGET = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 70));
        this.pb_IMPORTGRAPHIC = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 71));
        this.pb_HORIZLINE = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 72));
        this.pb_CUT = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 73));
        this.pb_COPY = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 74));
        this.pb_PASTE = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 75));
        this.pb_UNDO = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 76));
        this.pb_FIND = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 77));
        this.pb_FINDAGAIN = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 78));
        this.pb_DOCLINK = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 79));
        this.pb_SPELL = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 80));
        this.pb_BOLD = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 81));
        this.pb_ITALIC = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 82));
        this.pb_UNDERLINE = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 83));
        this.pb_STRIKETHROUGH = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 84));
        this.pb_BULLETLIST = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 85));
        this.pb_NUMERICLIST = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 86));
        this.pb_IMPORTHTML = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 87));
        this.pb_INSERTROW = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 88));
        this.pb_INSERTCOL = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 90));
        this.pb_DELETECOL = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 91));
        this.pb_DELETEROW = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 92));
        this.pb_COMMENTS = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 93));
        this.pb_DELCOMMENTS = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 94));
        this.pb_BLACK = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 95));
        this.pb_RED = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 96));
        this.pb_BLUE = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 97));
        this.pb_PROPERTY = this.newToolBarButton(ImageSystem.getImageIcon((Object)this, 98));
        this.pb_RESTARTWP = new DButton(Str.getStr(551));
        this.pb_HELV10 = new DButton(Str.getStr(552));
        this.pb_MONO10 = new DButton(Str.getStr(553));
        this.pb_DEFAULT = new DButton(Str.getStr(554));
        this.pb_RESTARTWP.addActionListener(this);
        this.pb_HELV10.addActionListener(this);
        this.pb_MONO10.addActionListener(this);
        this.pb_DEFAULT.addActionListener(this);
        this.toolBar.add(this.pb_UNDO);
        this.toolBar.add(this.pb_COMMENTS);
        this.toolBar.add(this.pb_DELCOMMENTS);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_PROPERTY);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_IMPORTHTML);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_CUT);
        this.toolBar.add(this.pb_COPY);
        this.toolBar.add(this.pb_PASTE);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_FIND);
        this.toolBar.add(this.pb_FINDAGAIN);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_SPELL);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_IMPORTGRAPHIC);
        this.toolBar.add(this.pb_STAMPEDGRAPHIC);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_BULLETLIST);
        this.toolBar.add(this.pb_NUMERICLIST);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_BOLD);
        this.toolBar.add(this.pb_ITALIC);
        this.toolBar.add(this.pb_STRIKETHROUGH);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_HORIZLINE);
        this.toolBar.add(this.pb_LINK);
        this.toolBar.add(this.pb_DOCLINK);
        this.toolBar.add(this.pb_LINKTARGET);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_TABLE);
        this.toolBar.add(this.pb_TABLEPROP);
        this.toolBar.add(this.pb_INSERTROW);
        this.toolBar.add(this.pb_INSERTCOL);
        this.toolBar.add(this.pb_DELETEROW);
        this.toolBar.add(this.pb_DELETECOL);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pb_LEFTALIGN);
        this.toolBar.add(this.pb_CENTERALIGN);
        this.toolBar.add(this.pb_RIGHTALIGN);
        this.toolBar.addSeparator();
        this.fontBar.add(this.pb_HELV10);
        this.fontBar.add(this.pb_DEFAULT);
        this.fontBar.add(this.pb_MONO10);
        this.fontBar.add(this.pb_BLACK);
        this.fontBar.add(this.pb_BLUE);
        this.fontBar.add(this.pb_RED);
        this.pb_STAMPEDGRAPHIC.setToolTipText(Str.getStr(550));
        this.pb_IMPORTHTML.setToolTipText(Str.getStr(559));
        this.pb_UNDO.setToolTipText(Str.getStr(567));
        this.pb_CUT.setToolTipText(Str.getStr(53));
        this.pb_COPY.setToolTipText(Str.getStr(54));
        this.pb_PASTE.setToolTipText(Str.getStr(55));
        this.pb_FIND.setToolTipText(Str.getStr(470));
        this.pb_FINDAGAIN.setToolTipText(Str.getStr(568));
        this.pb_SPELL.setToolTipText(Str.getStr(569));
        this.pb_BOLD.setToolTipText(Str.getStr(570));
        this.pb_ITALIC.setToolTipText(Str.getStr(571));
        this.pb_STRIKETHROUGH.setToolTipText(Str.getStr(572));
        this.pb_HORIZLINE.setToolTipText(Str.getStr(573));
        this.pb_LINK.setToolTipText(Str.getStr(574));
        this.pb_LINKTARGET.setToolTipText(Str.getStr(575));
        this.pb_DOCLINK.setToolTipText(Str.getStr(576));
        this.pb_IMPORTGRAPHIC.setToolTipText(Str.getStr(577));
        this.pb_BULLETLIST.setToolTipText(Str.getStr(578));
        this.pb_NUMERICLIST.setToolTipText(Str.getStr(579));
        this.pb_TABLE.setToolTipText(Str.getStr(580));
        this.pb_TABLEPROP.setToolTipText(Str.getStr(581));
        this.pb_LEFTALIGN.setToolTipText(Str.getStr(582));
        this.pb_RIGHTALIGN.setToolTipText(Str.getStr(583));
        this.pb_CENTERALIGN.setToolTipText(Str.getStr(584));
        this.pb_RESTARTWP.setToolTipText(Str.getStr(551));
        this.pb_DELETEROW.setToolTipText(Str.getStr(585));
        this.pb_INSERTROW.setToolTipText(Str.getStr(586));
        this.pb_INSERTCOL.setToolTipText(Str.getStr(588));
        this.pb_DELETECOL.setToolTipText(Str.getStr(587));
        this.pb_COMMENTS.setToolTipText(Str.getStr(589));
        this.pb_DELCOMMENTS.setToolTipText(Str.getStr(590));
        this.pb_PROPERTY.setToolTipText(Str.getStr(51));
        this.pb_SAVE = new DButton(Str.getStr(515), ImageSystem.getImageIcon((Object)this, 62));
        this.pb_CLOSE = new DButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8));
        this.pb_CLEAR = new DButton(Str.getStr(471), ImageSystem.getImageIcon((Object)this, 59));
        this.pb_PREVIEW = new DButton(Str.getStr(75), ImageSystem.getImageIcon((Object)this, 62));
        this.pb_EDITTAGS = new DButton(Str.getStr(591), ImageSystem.getImageIcon((Object)this, 56));
        this.pb_SAVE.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_PREVIEW.addActionListener(this);
        this.pb_CLEAR.addActionListener(this);
        this.pb_EDITTAGS.addActionListener(this);
        this.actionBar.add(this.pb_SAVE);
        this.actionBar.add(this.pb_CLOSE);
        this.actionBar.add(this.pb_PREVIEW);
        this.actionBar.add(this.pb_CLEAR);
        this.actionBar.add(this.pb_EDITTAGS);
    }

    private void initializeMenu() {
        this.menuBar = new MenuBar();
        this.MNU_EDIT = new Menu(Str.getStr(50));
        this.MNU_CUT = new MenuItem(Str.getStr(53));
        this.MNU_COPY = new Menu(Str.getStr(54));
        this.MNU_COPYASTEXT = new MenuItem(Str.getStr(592));
        this.MNU_PASTE = new Menu(Str.getStr(55));
        this.MNU_PASTEASTEXT = new MenuItem(Str.getStr(593));
        this.MNU_PASTEASDOC = new MenuItem(Str.getStr(594));
        this.MNU_PASTEASPRODUCT = new MenuItem(Str.getStr(595));
        this.MNU_SELECTALL = new MenuItem(Str.getStr(596));
        this.MNU_STYLES = new Menu(Str.getStr(597));
        this.MNU_HEADING = new Menu(Str.getStr(598));
        this.MNU_BODY = new Menu(Str.getStr(308));
        this.MNU_MAINHEAD = new MenuItem(Str.getStr(599));
        this.MNU_SUBHEAD = new MenuItem(Str.getStr(600));
        this.MNU_SUBSUBHEAD = new MenuItem(Str.getStr(601));
        this.MNU_DEFAULTBODY = new MenuItem(Str.getStr(602));
        this.MNU_MONOBODY = new MenuItem(Str.getStr(603));
        this.MNU_WARNINGBODY = new MenuItem(Str.getStr(604));
        this.MNU_HELP = new Menu(Str.getStr(10));
        this.MNU_STANDARDS = new MenuItem(Str.getStr(605));
        this.MNU_PASTEASTEXT.addActionListener(this);
        this.MNU_PASTEASDOC.addActionListener(this);
        this.MNU_PASTEASPRODUCT.addActionListener(this);
        this.MNU_COPYASTEXT.addActionListener(this);
        this.MNU_CUT.addActionListener(this);
        this.MNU_SELECTALL.addActionListener(this);
        this.MNU_WARNINGBODY.addActionListener(this);
        this.MNU_MONOBODY.addActionListener(this);
        this.MNU_DEFAULTBODY.addActionListener(this);
        this.MNU_SUBSUBHEAD.addActionListener(this);
        this.MNU_SUBHEAD.addActionListener(this);
        this.MNU_MAINHEAD.addActionListener(this);
        this.MNU_STANDARDS.addActionListener(this);
        this.menuBar.add(this.MNU_EDIT);
        this.MNU_EDIT.add(this.MNU_CUT);
        this.MNU_EDIT.add(this.MNU_COPY);
        this.MNU_COPY.add(this.MNU_COPYASTEXT);
        this.MNU_EDIT.add(this.MNU_PASTE);
        this.MNU_PASTE.add(this.MNU_PASTEASTEXT);
        this.MNU_PASTE.add(this.MNU_PASTEASDOC);
        this.MNU_PASTE.add(this.MNU_PASTEASPRODUCT);
        this.MNU_EDIT.add(this.MNU_SELECTALL);
        this.menuBar.add(this.MNU_STYLES);
        this.MNU_STYLES.add(this.MNU_HEADING);
        this.MNU_STYLES.add(this.MNU_BODY);
        this.MNU_HEADING.add(this.MNU_MAINHEAD);
        this.MNU_HEADING.add(this.MNU_SUBHEAD);
        this.MNU_HEADING.add(this.MNU_SUBSUBHEAD);
        this.MNU_BODY.add(this.MNU_DEFAULTBODY);
        this.MNU_BODY.add(this.MNU_MONOBODY);
        this.MNU_BODY.add(this.MNU_WARNINGBODY);
        this.menuBar.add(this.MNU_HELP);
        this.MNU_HELP.add(this.MNU_STANDARDS);
    }

    private DButton newToolBarButton(ImageIcon imageIcon) {
        DButton dButton = new DButton(imageIcon);
        dButton.setFocusPainted(false);
        dButton.addActionListener(this);
        dButton.setMargin(taskBarButtonMargin);
        return dButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        block144: {
            bl = true;
            if (actionEvent.getSource() instanceof DButton) {
                DButton dButton = (DButton)actionEvent.getSource();
                if (this.pb_CLOSE != dButton) {
                    this.changed = true;
                }
                if (dButton == this.pb_CLOSE) {
                    bl = false;
                    this.checkClose();
                } else if (dButton == this.pb_SAVE) {
                    try {
                        if (this.inPreviewMode) {
                            this.setPreviewMode(false);
                        }
                        if (PropertySystem.getBool(43)) {
                            new Thread((Runnable)this, THREAD_SAVECONTENTANDEXIT).start();
                            break block144;
                        }
                        new Thread((Runnable)this, THREAD_SAVECONTENT).start();
                    }
                    catch (Exception exception) {}
                } else if (dButton == this.pb_STAMPEDGRAPHIC) {
                    if (this.stampedGraphicDlg != null) {
                        this.stampedGraphicDlg.setVisible(true);
                        this.stampedGraphicDlg.requestFocus();
                    } else {
                        this.stampedGraphicDlg = new StampedGraphicDlg((Frame)WinUtil.getParentJFrame(this), this);
                    }
                } else if (dButton == this.pb_EDITTAGS) {
                    this.editTags(!this.editingTags);
                } else if (dButton == this.pb_RESTARTWP) {
                    this.cardPanel.remove((Component)this.wordProc);
                    this.wordProc = null;
                    this.wordProcStarted = false;
                    System.gc();
                    this.createWordProcessor();
                    this.cardPanel.add((Component)this.wordProc, "wordProc");
                    if (this.autoSaveContent != null) {
                        this.wordProc.setDocumentContentsAsHTML(this.autoSaveContent);
                        this.setPageLayout();
                    }
                    this.setVisible(true);
                } else if (this.pb_BOLD == dButton) {
                    this.setBold();
                } else if (this.pb_ITALIC == dButton) {
                    this.setItalic();
                } else if (this.pb_UNDERLINE == dButton) {
                    this.setUnderline();
                } else if (this.pb_STRIKETHROUGH == dButton) {
                    this.setStrikethrough();
                } else if (this.pb_DELCOMMENTS == dButton) {
                    if (GUISystem.printBox(8, 555)) {
                        this.removeEditorComments();
                    }
                } else if (this.pb_CENTERALIGN == dButton) {
                    this.wordProc.findSelectedTextElement().setAlignment("center");
                } else if (this.pb_LEFTALIGN == dButton) {
                    this.wordProc.findSelectedTextElement().setAlignment("left");
                } else if (this.pb_RIGHTALIGN == dButton) {
                    this.wordProc.findSelectedTextElement().setAlignment("right");
                } else if (this.pb_CLEAR == dButton) {
                    if (this.inPreviewMode) {
                        this.setPreviewMode(false);
                    }
                    if (this.editingTags) {
                        this.editTags(false);
                    }
                    if (GUISystem.printBox(8, 556)) {
                        this.clearDocument(true);
                    }
                } else if (this.pb_COMMENTS == dButton) {
                    this.insertEditorComments();
                } else if (this.pb_COPY == dButton) {
                    this.wordProc.copy();
                } else if (this.pb_PASTE == dButton) {
                    this.wordProc.paste();
                } else if (this.pb_CUT == dButton) {
                    this.wordProc.cut();
                } else if (this.pb_HORIZLINE == dButton) {
                    this.wordProc.insertHorizontalLine("line(" + System.currentTimeMillis() + ")");
                } else if (this.pb_IMPORTHTML == dButton) {
                    this.importHTML();
                } else if (this.pb_IMPORTGRAPHIC == dButton) {
                    this.importGraphic();
                } else if (this.pb_LINK == dButton) {
                    String string = new SingleEntryDlg((Frame)WinUtil.getParentJFrame(this), Str.getStr(611), Str.getStr(611), "http://", new MaskDocument(0, 254)).getResult();
                    if (string != null) {
                        this.wordProc.insertLink("l" + DateSystem.getDate(1), string);
                    }
                    bl = true;
                } else if (this.pb_LINKTARGET == dButton) {
                    String string;
                    if (GUISystem.printBox(8, 557) && (string = new SingleEntryDlg((Frame)WinUtil.getParentJFrame(this), Str.getStr(611), Str.getStr(611), "http://", new MaskDocument(0, 254)).getResult()) != null) {
                        this.wordProc.insertLink("l" + DateSystem.getDate(1), string + "_(newwin)");
                    }
                    bl = true;
                } else if (this.pb_PREVIEW == dButton) {
                    this.setPreviewMode(!this.inPreviewMode);
                    bl = !this.inPreviewMode;
                } else if (this.pb_TABLE == dButton) {
                    new TablePropertyDlg((Frame)WinUtil.getParentJFrame(this), (WordProcessor)this.wordProc, null);
                    bl = false;
                } else if (this.pb_PROPERTY == dButton) {
                    Table table = (Table)this.wordProc.findCurrentObject("Table");
                    Link link = (Link)this.wordProc.findCurrentObject("link");
                    if (link != null) {
                        String string = new SingleEntryDlg((Frame)WinUtil.getParentJFrame(this), Str.getStr(609), Str.getStr(609), link.getDestination(), new MaskDocument(0, 254)).getResult();
                        if (string != null) {
                            link.setDestination(string);
                        }
                    } else if (table != null) {
                        new TablePropertyDlg((Frame)WinUtil.getParentJFrame(this), (WordProcessor)this.wordProc, table);
                    }
                } else if (this.pb_TABLEPROP == dButton) {
                    Table table = (Table)this.wordProc.findCurrentObject("Table");
                    if (table != null) {
                        new TablePropertyDlg((Frame)WinUtil.getParentJFrame(this), (WordProcessor)this.wordProc, table);
                    } else {
                        GUISystem.printBox(7, 558);
                    }
                    bl = false;
                } else if (this.pb_INSERTROW == dButton) {
                    TableCell tableCell = (TableCell)this.wordProc.findCurrentObject("TableCell");
                    if (tableCell != null) {
                        tableCell.getTable().insertRow(tableCell.getRowIndex());
                    } else {
                        GUISystem.printBox(7, 558);
                    }
                    bl = false;
                } else if (this.pb_INSERTCOL == dButton) {
                    TableCell tableCell = (TableCell)this.wordProc.findCurrentObject("TableCell");
                    if (tableCell != null) {
                        tableCell.getTable().insertColumn(tableCell.getColumnIndex());
                    } else {
                        GUISystem.printBox(7, 558);
                    }
                    bl = false;
                } else if (this.pb_DELETEROW == dButton) {
                    TableCell tableCell = (TableCell)this.wordProc.findCurrentObject("TableCell");
                    if (tableCell != null) {
                        tableCell.getTable().deleteRow(tableCell.getRowIndex());
                    } else {
                        GUISystem.printBox(7, 558);
                    }
                    bl = false;
                } else if (this.pb_DELETECOL == dButton) {
                    TableCell tableCell = (TableCell)this.wordProc.findCurrentObject("TableCell");
                    if (tableCell != null) {
                        tableCell.getTable().deleteColumn(tableCell.getColumnIndex());
                    } else {
                        GUISystem.printBox(7, 558);
                    }
                    bl = false;
                } else if (this.pb_UNDO == dButton) {
                    this.wordProc.undo();
                } else if (this.pb_BULLETLIST == dButton) {
                    this.createBulletList();
                } else if (this.pb_NUMERICLIST == dButton) {
                    this.createOrderedList();
                } else if (this.pb_FIND == dButton) {
                    this.prevFindString = new SingleEntryDlg((Frame)WinUtil.getParentJFrame(this), Str.getStr(470), Str.getStr(610), this.prevFindString, new MaskDocument(0, 254)).getResult();
                    if (this.prevFindString != null) {
                        this.find();
                    }
                } else if (this.pb_FINDAGAIN == dButton) {
                    if (this.prevFindString == null || this.prevFindString.length() == 0) {
                        this.prevFindString = new SingleEntryDlg((Frame)WinUtil.getParentJFrame(this), Str.getStr(470), Str.getStr(610), this.prevFindString, new MaskDocument(0, 254)).getResult();
                        if (this.prevFindString != null) {
                            this.find();
                        }
                    } else {
                        this.find();
                    }
                } else if (this.pb_DOCLINK == dButton) {
                    new SelectDocDlg();
                    bl = false;
                } else if (this.pb_SPELL == dButton) {
                    if (this.inPreviewMode) {
                        this.setPreviewMode(false);
                    }
                    if (this.editingTags) {
                        this.editTags(false);
                    }
                    new Thread((Runnable)this, THREAD_SPELLCHECK).start();
                } else if (this.pb_MONO10 == dButton) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    this.curSelectedText.setFontSize(10);
                    this.curSelectedText.setFontName("Courier");
                } else if (this.pb_DEFAULT == dButton) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    this.curSelectedText.setFontSize(12);
                } else if (this.pb_HELV10 == dButton) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    this.curSelectedText.setFontSize(10);
                    this.curSelectedText.setFontName("Helvetica");
                } else if (this.pb_RED == dButton) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    this.curSelectedText.setTextColor(new Color(255, 0, 0));
                } else if (this.pb_BLUE == dButton) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    this.curSelectedText.setTextColor(new Color(0, 0, 255));
                } else if (this.pb_BLACK == dButton) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    this.curSelectedText.setTextColor(Color.black);
                }
            } else if (actionEvent.getSource() instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)actionEvent.getSource();
                if (menuItem == this.MNU_SELECTALL) {
                    this.wordProc.gotoBeginningOfDocument(false);
                    this.wordProc.gotoEndOfDocument(true);
                } else if (menuItem == this.MNU_PASTEASTEXT) {
                    this.paste();
                } else if (menuItem == this.MNU_COPYASTEXT) {
                    this.wordProc.copy();
                } else if (menuItem == this.MNU_MAINHEAD) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    Position position = this.curSelectedText.getStartPosition();
                    Position position2 = this.curSelectedText.getEndPosition();
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(new Color(0, 0, 255));
                    this.curSelectedText.setFontSize(14);
                    this.curSelectedText.setFontName("Helvetica");
                    this.curSelectedText.setBold(true);
                    this.wordProc.createTextElement(position, position2);
                    this.wordProc.setRefreshEnabled(true);
                } else if (menuItem == this.MNU_SUBHEAD) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    Position position = this.curSelectedText.getStartPosition();
                    Position position3 = this.curSelectedText.getEndPosition();
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(Color.black);
                    this.curSelectedText.setFontSize(12);
                    this.curSelectedText.setFontName("Helvetica");
                    this.curSelectedText.setBold(true);
                    this.wordProc.createTextElement(position, position3);
                    this.wordProc.setRefreshEnabled(true);
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(Color.black);
                    this.curSelectedText.setFontSize(12);
                    this.curSelectedText.setFontName("Helvetica");
                    this.curSelectedText.setBold(true);
                    this.wordProc.createTextElement(position, position3);
                    this.wordProc.setRefreshEnabled(true);
                } else if (menuItem == this.MNU_SUBSUBHEAD) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    Position position = this.curSelectedText.getStartPosition();
                    Position position4 = this.curSelectedText.getEndPosition();
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(Color.blue);
                    this.curSelectedText.setFontSize(12);
                    this.curSelectedText.setFontName("Helvetica");
                    this.curSelectedText.setBold(false);
                    this.wordProc.createTextElement(position, position4);
                    this.wordProc.setRefreshEnabled(true);
                } else if (menuItem == this.MNU_DEFAULTBODY) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    Position position = this.curSelectedText.getStartPosition();
                    Position position5 = this.curSelectedText.getEndPosition();
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(Color.black);
                    this.curSelectedText.setFontSize(12);
                    this.curSelectedText.setFontName("Helvetica");
                    this.curSelectedText.setBold(false);
                    this.curSelectedText.setItalic(false);
                    this.curSelectedText.setStrikethrough(false);
                    this.wordProc.createTextElement(position, position5);
                    this.wordProc.setRefreshEnabled(true);
                } else if (menuItem == this.MNU_MONOBODY) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    Position position = this.curSelectedText.getStartPosition();
                    Position position6 = this.curSelectedText.getEndPosition();
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(Color.black);
                    this.curSelectedText.setFontSize(12);
                    this.curSelectedText.setFontName("Courier");
                    this.curSelectedText.setBold(false);
                    this.curSelectedText.setItalic(false);
                    this.curSelectedText.setStrikethrough(false);
                    this.wordProc.createTextElement(position, position6);
                    this.wordProc.setRefreshEnabled(true);
                } else if (menuItem == this.MNU_WARNINGBODY) {
                    this.curSelectedText = this.wordProc.findSelectedTextElement();
                    Position position = this.curSelectedText.getStartPosition();
                    Position position7 = this.curSelectedText.getEndPosition();
                    this.wordProc.setRefreshEnabled(false);
                    this.curSelectedText.setTextColor(new Color(255, 0, 0));
                    this.curSelectedText.setFontSize(12);
                    this.curSelectedText.setFontName("Helvetica");
                    this.curSelectedText.setBold(true);
                    this.curSelectedText.setItalic(false);
                    this.curSelectedText.setStrikethrough(false);
                    this.wordProc.createTextElement(position, position7);
                    this.wordProc.setRefreshEnabled(true);
                }
            }
        }
        if (bl) {
            if (this.editingTags) {
                this.mle_EDITTAGS.requestFocus();
            } else {
                this.wordProc.requestFocus();
            }
        }
    }

    private boolean getCurSelectedText() {
        this.curSelectedText = this.wordProc.findSelectedTextElement();
        this.curParagraph = this.curSelectedText.getParagraphStyle();
        this.isBold = this.curSelectedText.getBold();
        this.isItalic = this.curSelectedText.getItalic();
        this.isUnderlined = this.curSelectedText.getUnderline();
        this.isStriked = this.curSelectedText.getStrikethrough();
        return this.curSelectedText != null && this.curParagraph != null;
    }

    private void setBold() {
        if (this.wordProc.getSelectedText() == null) {
            Position position = null;
            this.getCurSelectedText();
            position = this.curSelectedText.getEndPosition();
            this.curSelectedText.setBold(!this.isBold);
            position.gotoPosition(this.curSelectedText.getStartPosition());
        } else if (this.getCurSelectedText()) {
            Position position = this.curSelectedText.getStartPosition();
            Position position2 = this.curSelectedText.getEndPosition();
            this.curSelectedText.setBold(!this.curSelectedText.getBold());
            this.wordProc.createTextElement(position, position2);
        }
    }

    private void setUnderline() {
        if (this.wordProc.getSelectedText() == null) {
            Position position = null;
            this.getCurSelectedText();
            position = this.curSelectedText.getEndPosition();
            this.curSelectedText.setUnderline(false);
            position.gotoPosition(this.curSelectedText.getStartPosition());
        } else {
            this.getCurSelectedText();
            this.curSelectedText.setUnderline(false);
        }
        this.wordProc.requestFocus();
    }

    private void setStrikethrough() {
        if (this.wordProc.getSelectedText() == null) {
            Position position = null;
            this.getCurSelectedText();
            position = this.curSelectedText.getEndPosition();
            this.curSelectedText.setStrikethrough(!this.isStriked);
            position.gotoPosition(this.curSelectedText.getStartPosition());
        } else if (this.getCurSelectedText()) {
            Position position = this.curSelectedText.getStartPosition();
            Position position2 = this.curSelectedText.getEndPosition();
            this.curSelectedText.setStrikethrough(!this.curSelectedText.getStrikethrough());
            this.wordProc.createTextElement(position, position2);
        }
        this.wordProc.requestFocus();
    }

    private void setItalic() {
        if (this.wordProc.getSelectedText() == null) {
            Position position = null;
            this.getCurSelectedText();
            position = this.curSelectedText.getEndPosition();
            this.curSelectedText.setItalic(!this.isItalic);
            position.gotoPosition(this.curSelectedText.getStartPosition());
        } else if (this.getCurSelectedText()) {
            Position position = this.curSelectedText.getStartPosition();
            Position position2 = this.curSelectedText.getEndPosition();
            this.curSelectedText.setItalic(!this.curSelectedText.getItalic());
            this.wordProc.createTextElement(position, position2);
        }
        this.wordProc.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.changed = true;
        if (this.processKey) {
            switch (keyEvent.getKeyCode()) {
                case 66: {
                    if (!keyEvent.isControlDown()) break;
                    this.setBold();
                    break;
                }
                case 73: {
                    if (!keyEvent.isControlDown()) break;
                    this.setItalic();
                    break;
                }
                case 85: {
                    break;
                }
                case 83: {
                    if (!keyEvent.isControlDown()) break;
                    this.setStrikethrough();
                    break;
                }
                case 67: {
                    if (!keyEvent.isControlDown()) break;
                    this.wordProc.copy();
                    break;
                }
                case 86: {
                    if (!keyEvent.isControlDown()) break;
                    this.wordProc.paste();
                    break;
                }
                case 155: {
                    if (keyEvent.isShiftDown()) {
                        this.wordProc.paste();
                        break;
                    }
                    if (!keyEvent.isControlDown()) break;
                    this.wordProc.copy();
                    break;
                }
                case 127: {
                    if (!keyEvent.isShiftDown()) break;
                    this.wordProc.cut();
                    break;
                }
                case 88: {
                    if (!keyEvent.isControlDown()) break;
                    this.wordProc.cut();
                    break;
                }
                case 65: {
                    if (!keyEvent.isControlDown()) break;
                    this.selectAll();
                    break;
                }
            }
            this.processKey = false;
        } else {
            this.processKey = true;
        }
    }

    private void refreshData(DocRec docRec, int n, String string) {
        this.setDefaultTitle();
        this.autoSaveContent = (String)docRec.getFieldData(n);
        new Thread((Runnable)this, string).start();
        this.requestFocus();
    }

    public void refreshData(DocRec docRec, int n) {
        this.refreshData(docRec, n, THREAD_SETCONTENT);
    }

    private void createWordProcessor() {
        LogSystem.log(1, "Creating Word Processor");
        this.wordProc = new WordProcessorBean();
        WordProcUtil.addKeyListeners(this, (Container)this.wordProc);
        this.setPageLayout();
        LogSystem.log(1, "Stopped Creating Word Processor");
    }

    public void selectAll() {
        this.wordProc.gotoBeginningOfDocument(false);
        this.wordProc.gotoEndOfDocument(true);
    }

    private void setPreviewMode(boolean bl) {
        this.inPreviewMode = bl;
        if (bl) {
            String string = null;
            string = !this.editingTags ? DocRec.prepareBodyForPreview(WordProcUtil.createHTML((WordProcessorBean)this.wordProc, (DocRec)this.docRec)) : this.mle_EDITTAGS.getText();
            if (string != null) {
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "pnl_PREVIEW");
                this.pnl_PREVIEW.setPageContent(string);
                this.pb_PREVIEW.setText(Str.getStr(50));
            }
        } else {
            if (!this.editingTags) {
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "wordProc");
            } else {
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "mle_EDITTAGS");
            }
            this.pb_PREVIEW.setText(Str.getStr(75));
        }
        if (!bl && !this.editingTags) {
            this.wordProc.gotoBeginningOfDocument(false);
            this.wordProc.requestFocus();
        }
    }

    private void clearDocument(boolean bl) {
        WordProcUtil.setDocContent((WordProcessorBean)this.wordProc, (DocRec)this.docRec, (String)"<font name=\"Helvetica\" size=14> </font>");
        this.setPageLayout();
    }

    private void importHTML() {
        Window window;
        block6: {
            window = null;
            try {
                File[] fileArray = GUISystem.getFileOpen(WinUtil.getParentJFrame(this), Str.getStr(559), PropertySystem.getString(46));
                Object var3_4 = null;
                Object var4_5 = null;
                String string = null;
                if (fileArray == null || fileArray[0] == null || fileArray[1] == null) break block6;
                try {
                    window = new StatusWin(WinUtil.getParentJFrame(this));
                    ((StatusWin)window).setText(Str.getStr(525));
                    string = FileUtil.readFile(fileArray[0].getAbsolutePath());
                    PropertySystem.putString(46, string);
                    if (string != null) {
                        String string2 = PropertySystem.getString(30) + File.separator + "tmp.html";
                        FileUtil.saveFile(string2, "<p><font face=\"Helvetica, Arial\" size=3></p><p><font face=\"Helvetica, Arial\" size=3></p>");
                        this.wordProc.insertDocument("FILE:/" + string2);
                        FileUtil.saveFile(string2, string);
                        this.wordProc.insertDocument("FILE:/" + string2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        if (window != null) {
            window.dispose();
        }
    }

    private String cleanHTMLImportFile(String string) {
        HTMLParse hTMLParse = null;
        Object var3_3 = null;
        String string2 = null;
        int n = 0;
        hTMLParse = new HTMLParse(string);
        while (n < hTMLParse.tagCount()) {
            string2 = hTMLParse.getTag(n);
            if (string2 != null) {
                if ((string2 = string2.toUpperCase()).indexOf("STYLE") >= 0 || string2.indexOf("FONT") >= 0 || string2.indexOf("APPLET") >= 0 || string2.indexOf("PARAM") >= 0 || string2.indexOf("HREF") >= 0 || string2.indexOf("FRAME") >= 0 || string2.indexOf("H1") >= 0 || string2.indexOf("H2") >= 0 || string2.indexOf("H3") >= 0 || string2.indexOf("H4") >= 0 || string2.indexOf("H5") >= 0 || string2.indexOf("H6") >= 0 || string2.indexOf("IMG") >= 0 || string2.indexOf("MAILTO") >= 0 || string2.indexOf("!") >= 0 || string2.indexOf("META") >= 0 || string2.indexOf("FORM") >= 0 || string2.indexOf("SCRIPT") >= 0 || string2.indexOf("COMMENT") >= 0 || string2.indexOf("CLEAR") >= 0 || string2.indexOf("HTML") >= 0 || string2.indexOf("ARCHIVE") >= 0 || string2.indexOf("HEAD") >= 0) {
                    hTMLParse.removeTag(n);
                } else if (string2.indexOf("BGCOLOR") >= 0) {
                    string2 = Text.replaceInStr(string2, "BGCOLOR", "");
                    hTMLParse.replaceTag(n, string2);
                } else if (string2.indexOf("COLOR") >= 0) {
                    hTMLParse.removeTag(n);
                }
            }
            ++n;
        }
        string = hTMLParse.getHTMLString();
        return string;
    }

    private void importGraphic() {
        try {
            File[] fileArray = GUISystem.getFileOpen(WinUtil.getParentJFrame(this), Str.getStr(577), PropertySystem.getString(47));
            String string = null;
            String string2 = null;
            if (fileArray != null && fileArray[0] != null && fileArray[1] != null) {
                string = fileArray[0].getName();
                string2 = fileArray[1].getAbsolutePath();
                if (string != null && string2 != null) {
                    if (string.indexOf(" ") == -1) {
                        if (string.length() > 13) {
                            GUISystem.printBox(7, 560);
                        } else {
                            PropertySystem.putString(47, string2);
                            if (string.endsWith("JPG") || string.endsWith("GIF") || string.endsWith("jpg") || string.endsWith("gif")) {
                                String string3 = null;
                                string3 = this.docRec.assignExistingDocInd() + "_" + string;
                                if (QuestUtil.copyFileToTempDir(string2 + File.separator + string, string3)) {
                                    this.wordProc.insertImage(string3, "FILE:" + PropertySystem.getString(30) + string3);
                                } else {
                                    GUISystem.printBox(7, 561);
                                }
                            } else {
                                GUISystem.printBox(7, 562);
                            }
                        }
                    } else {
                        GUISystem.printBox(7, 563);
                    }
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void createOrderedList() {
        ParagraphStyle paragraphStyle = null;
        if (this.getCurSelectedText()) {
            this.curSelectedText = this.wordProc.findSelectedTextElement();
            paragraphStyle = this.curSelectedText.getParagraphStyle();
            if (!paragraphStyle.getLeaderType().equals("numeric")) {
                ParagraphStyle paragraphStyle2 = this.wordProc.createParagraphStyle("Ordered List (" + System.currentTimeMillis() + ")", "OLLI");
                paragraphStyle2.setLeaderType("numeric");
                paragraphStyle2.setNumberFormat("decimal");
                paragraphStyle2.setSpaceAfter(5);
                paragraphStyle2.setFontName("Helvetica");
                paragraphStyle2.setFontSize(12);
                this.curSelectedText.setParagraphStyle(paragraphStyle2);
                this.wordProc.gotoEndOfParagraph(false);
            } else {
                this.wordProc.gotoEndOfParagraph(false);
                this.curSelectedText = this.wordProc.findSelectedTextElement();
                paragraphStyle = this.wordProc.findParagraphStyle("Body");
                this.curSelectedText.setParagraphStyle(paragraphStyle);
                paragraphStyle.setFontName("Helvetica");
                paragraphStyle.setFontSize(12);
            }
        }
    }

    private void createBulletList() {
        ParagraphStyle paragraphStyle = null;
        if (this.getCurSelectedText()) {
            this.curSelectedText = this.wordProc.findSelectedTextElement();
            paragraphStyle = this.curSelectedText.getParagraphStyle();
            if (!paragraphStyle.getLeaderType().equals("bullet")) {
                ParagraphStyle paragraphStyle2 = this.wordProc.createParagraphStyle("Bullet List (" + System.currentTimeMillis() + ")", "ULLI");
                paragraphStyle2.setLeaderType("bullet");
                paragraphStyle2.setBulletCharacter('\u25cf');
                paragraphStyle2.setSpaceAfter(-1);
                paragraphStyle2.setFontName("Helvetica");
                paragraphStyle2.setFontSize(12);
                this.curSelectedText.setParagraphStyle(paragraphStyle2);
                this.wordProc.gotoEndOfParagraph(false);
            } else {
                this.wordProc.gotoEndOfParagraph(false);
                this.curSelectedText = this.wordProc.findSelectedTextElement();
                paragraphStyle = this.wordProc.findParagraphStyle("Body");
                this.curSelectedText.setParagraphStyle(paragraphStyle);
                paragraphStyle.setFontName("Helvetica");
                paragraphStyle.setFontSize(12);
            }
        }
    }

    public void stdDialogClosed(int n, Object object) {
        boolean bl = true;
        switch (n) {
            case 2: {
                Vector vector = (Vector)object;
                if (vector == null) break;
                DocRec docRec = (DocRec)vector.elementAt(0);
                this.createDocLink(docRec);
                break;
            }
        }
        if (bl) {
            this.wordProc.requestFocus();
        }
    }

    public void createDocLink(DocRec docRec) {
        if (docRec != null) {
            if (docRec.isDocRequest()) {
                GUISystem.printBox(6, 564);
            } else if (docRec.getFieldData(55) == null || ((String)docRec.getFieldData(55)).length() == 0) {
                GUISystem.printBox(6, 565);
            } else {
                String string = this.wordProc.getSelectedText();
                this.docRec.addDocLink(docRec);
                if (string != null) {
                    this.wordProc.insertLink("l" + DateSystem.getDate(1), docRec.getFieldData(55) + ".html");
                } else {
                    try {
                        String string2 = PropertySystem.getString(30);
                        String string3 = string2 + "tmp.html";
                        String string4 = null;
                        QuestUtil.copyFileToTempDir(string2 + File.separator + "doclink.gif");
                        string4 = "<a href=\"" + docRec.getFieldData(55) + ".html\">";
                        string4 = string4 + "<img src=\"" + string2 + "doclink.gif\" WIDTH=\"13\" HEIGHT=\"16\">";
                        string4 = string4 + "</a>";
                        FileUtil.saveFile(string3, string4);
                        this.wordProc.insertDocument("FILE:" + string3);
                        this.wordProc.gotoNextCharacter(false);
                    }
                    catch (Exception exception) {
                        LogSystem.log(1, exception);
                    }
                }
            }
        }
    }

    public boolean find() {
        if (!this.editingTags) {
            SearchOptions searchOptions = this.wordProc.getSearchOptions();
            this.curSelectedText = this.wordProc.findSelectedTextElement();
            if (searchOptions != null && this.curSelectedText != null) {
                searchOptions.setExactMatch(true);
                if (this.curSelectedText.gotoText(this.prevFindString, searchOptions)) {
                    this.wordProc.gotoEndOfWord(true);
                    this.wordProc.gotoBeginningOfWord(true);
                }
            }
        } else {
            int n;
            String string = this.mle_EDITTAGS.getText();
            int n2 = string.indexOf(this.prevFindString, n = this.mle_EDITTAGS.getSelectionEnd());
            if (n2 >= 0) {
                this.mle_EDITTAGS.setSelectionStart(n2);
                this.mle_EDITTAGS.setSelectionEnd(n2 + this.prevFindString.length());
            }
        }
        return true;
    }

    private boolean spellCheck(boolean bl) {
        return true;
    }

    private void setSelectedText(String string) {
        this.curSelectedText = this.wordProc.findSelectedTextElement();
        if (this.curSelectedText != null) {
            this.curSelectedText.setText(string);
        }
    }

    public boolean saveContent() {
        boolean bl = false;
        String string = null;
        this.currentlySaving = true;
        try {
            if (this.docRec != null) {
                if (!this.editingTags) {
                    string = WordProcUtil.createHTML((WordProcessorBean)this.wordProc, (DocRec)this.docRec);
                } else {
                    string = this.mle_EDITTAGS.getText();
                    if (string.indexOf("QuestInput") == -1) {
                        string = string + "<META NAME=Generator CONTENT=QuestInput>";
                    }
                }
                WordProcUtil.assembleGraphics((WordProcessorBean)this.wordProc, (DocRec)this.docRec);
                WordProcUtil.assembleDocLinks((WordProcessorBean)this.wordProc, (DocRec)this.docRec, (String)string);
                if (string != null) {
                    this.docRec.setFieldData(this.fieldId, string);
                    bl = true;
                }
            }
            if (bl) {
                FileUtil.saveFile("output.html", (String)this.docRec.getFieldData(this.fieldId));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        this.changed = false;
        this.currentlySaving = false;
        return bl;
    }

    private void processAutoSave() {
        this.continueAutoSave = true;
        try {
            while (this.continueAutoSave) {
                Thread.currentThread();
                Thread.sleep(120000L);
                this.autoSaveContent = this.wordProc.getDocumentContentsAsHTML();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableApp(boolean bl) {
        if (this.toolBar != null) {
            this.toolBar.setEnabled(bl);
        }
        if (this.wordProc != null) {
            this.wordProc.setEnabled(bl);
        }
        if (this.actionBar != null) {
            this.actionBar.setEnabled(bl);
        }
        this.enabled = bl;
    }

    public boolean copy(int n) {
        boolean bl = false;
        return bl;
    }

    public boolean paste(int n) {
        return false;
    }

    public boolean paste() {
        this.wordProc.paste();
        return true;
    }

    private void checkClose() {
        if (this.changed) {
            if (GUISystem.printBox(8, 452)) {
                new Thread((Runnable)this, THREAD_SAVECONTENTANDEXIT).start();
            } else {
                this.windowClosing(null);
            }
        } else {
            this.windowClosing(null);
        }
    }

    private void setDefaultTitle() {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        try {
            if (this.toolBar != null) {
                this.toolBar.revalidate();
            }
            if (this.actionBar != null) {
                this.actionBar.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setStatus(String string) {
    }

    private void setPageLayout() {
        WPEnumeration wPEnumeration = this.wordProc.enumerateParagraphStyles();
        ParagraphStyle paragraphStyle = null;
        while (wPEnumeration.hasMoreNames()) {
            paragraphStyle = this.wordProc.findParagraphStyle(wPEnumeration.nextName());
            if (paragraphStyle.getFontName().indexOf("imes") < 0) continue;
            paragraphStyle.setFontName("Helvetica");
        }
        paragraphStyle = this.wordProc.findParagraphStyle("Body");
        if (paragraphStyle != null) {
            paragraphStyle.setFontName("Helvetica");
        }
        if ((paragraphStyle = this.wordProc.findParagraphStyle("OLLI")) != null) {
            paragraphStyle.setFontName("Helvetica");
        }
        if ((paragraphStyle = this.wordProc.findParagraphStyle("ULLI")) != null) {
            paragraphStyle.setFontName("Helvetica");
        }
    }

    public void HTMLGeneratorStatus(String string) {
    }

    private void setContent() {
        this.wordProc.setDocumentContentsAsHTML(WordProcUtil.prepareHTMLForEdit((DocRec)this.docRec, (String)((String)this.docRec.getFieldData(this.fieldId))));
        this.setPageLayout();
    }

    public void setStatusValue(int n) {
    }

    public void setStatusMax(int n) {
    }

    public void setStatus(int n) {
        this.setStatus(Str.getStr(n));
    }

    private void insertEditorComments() {
        if (this.getCurSelectedText()) {
            this.curSelectedText.setFontName("Helvetica");
            this.curSelectedText.setTextColor(new Color(0, 150, 0));
            this.curSelectedText.setFontSize(14);
            this.wordProc.insertBookmark("EditorComments-" + System.currentTimeMillis());
        } else {
            String string = new SingleEntryDlg((Frame)WinUtil.getParentJFrame(this), Str.getStr(589), Str.getStr(589), "", new MaskDocument(0, 254)).getResult();
            try {
                if (string != null) {
                    String string2 = PropertySystem.getString(30) + File.separator + "editorComments.html";
                    FileUtil.saveFile(string2, "<a name=\"EditorComments (" + UserSystem.getUserName() + ") -" + System.currentTimeMillis() + "\">" + "<font face=\"Helvetica\" size=3 color=\"green\">" + string + "</font></a>");
                    this.wordProc.insertDocument("FILE:/" + string2);
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
    }

    private void removeEditorComments() {
        this.setStatus(Str.getStr(606));
        try {
            String string = this.wordProc.getDocumentContentsAsHTML();
            if (string != null && string.indexOf("EditorComments") >= 0) {
                int n = 0;
                int n2 = 0;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                while (string.indexOf("EditorComments", n) >= 0) {
                    n = string.indexOf("EditorComments", n) - 9;
                    n2 = string.indexOf("</A>", n) + 4;
                    string2 = string.substring(0, n);
                    string3 = string.substring(n2, string.length());
                    string4 = string.substring(string.indexOf("\">", n) + 2, n2 - 4);
                    if (GUISystem.printBox(8, 607)) {
                        string = string2 + string3;
                    }
                    n += 19;
                }
                this.wordProc.setDocumentContentsAsHTML(string);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        this.setStatus(null);
    }

    private void editTags(boolean bl) {
        if (bl != this.editingTags) {
            this.editingTags = bl;
            if (this.editingTags) {
                String string = WordProcUtil.createHTML((WordProcessorBean)this.wordProc, (DocRec)this.docRec);
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "mle_EDITTAGS");
                this.pb_EDITTAGS.setText(Str.getStr(608));
                if (string != null) {
                    this.mle_EDITTAGS.setText(string);
                }
            } else {
                String string = this.mle_EDITTAGS.getText();
                this.pb_EDITTAGS.setText(Str.getStr(591));
                ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "wordProc");
                this.wordProc.clear();
                string = WordProcUtil.prepareHTMLForEdit((DocRec)this.docRec, (String)string);
                this.wordProc.setDocumentContentsAsHTML(string);
            }
            this.cardPanel.setVisible(false);
            this.cardPanel.setVisible(true);
            this.toolBarPanel.setVisible(false);
            this.toolBarPanel.setVisible(true);
            this.actionBar.setVisible(false);
            this.actionBar.setVisible(true);
            this.toolBar.setVisible(false);
            this.toolBar.setVisible(true);
            this.fontBar.setVisible(false);
            this.fontBar.setVisible(true);
        }
    }

    public boolean isEditingDoc(DocRec docRec) {
        return this.docRec.getDocInd() == docRec.getDocInd();
    }

    public void stampGraphic(String string) {
        try {
            if (string != null) {
                String string2 = DateSystem.getDate(1);
                String string3 = PropertySystem.getString(30);
                string2 = Text.replaceAllStrInStr(string2, ".", "");
                string2 = Text.replaceAllStrInStr(string2, "-", "");
                QuestUtil.copyFileToTempDir(string3 + File.separator + string);
                this.wordProc.insertImage(string + string2, "FILE:" + string3 + string);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public WordProcPanel(DocRec docRec, int n) {
        this.docRec = docRec;
        this.fieldId = n;
        new Thread((Runnable)this, THREAD_INITIALIZE).start();
    }
}

