/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.wordproc;

import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentLink;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.wordproc.HTMLParse;
import com.ibm.nzna.projects.qit.wordproc.HTMLTag;
import com.ibm.nzna.projects.qit.wordproc.StampedGraphicFactory;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import lotus.wp.WordProcessor;
import lotus.wp.WordProcessorBean;
import lotus.wp.ifx.Link;
import lotus.wp.ifx.WPEnumeration;
import lotus.wp.ifx.WPImage;

public class WordProcUtil
implements AppConst,
DocConst {
    private static final Insets taskBarButtonMargin = new Insets(0, 0, 0, 0);
    private static final String metaGenerator = "<META NAME=Generator CONTENT=QuestInput>";
    private static final String defaultFontStr = "<font face=\"Helvetica, Arial\" size=2>";

    public static void destroyWordProcessor(WordProcessorBean wordProcessorBean) {
        if (wordProcessorBean != null) {
            wordProcessorBean.stop();
            wordProcessorBean.destroy();
            System.gc();
        }
    }

    public static void setPageLayout(WordProcessor wordProcessor) {
        wordProcessor.findSelectedTextElement().setFontName("Helvetica, Arial");
        wordProcessor.findSelectedTextElement().setFontSize(10);
    }

    protected static void addKeyListeners(KeyListener keyListener, Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        Component component = null;
        while (n2 < n) {
            if ((component = container.getComponent(n2++)) instanceof Container) {
                WordProcUtil.addKeyListeners(keyListener, (Container)component);
            }
            component.addKeyListener(keyListener);
        }
        container.addKeyListener(keyListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setDocContent(WordProcessorBean wordProcessorBean, DocumentDraft documentDraft, String string) {
        MainWindow.getInstance().setStatus(Str.getStr(536));
        try {
            if (wordProcessorBean != null) {
                if (string == null) {
                    string = "";
                }
                string = WordProcUtil.prepareHTMLForEdit(documentDraft, string);
                MainWindow.getInstance().setStatus(Str.getStr(537));
                wordProcessorBean.setDocumentContentsAsHTML(string);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        MainWindow.getInstance().setStatus(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String prepareHTMLForEdit(DocumentDraft documentDraft, String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            boolean bl = false;
            if (string != null) {
                FileUtil.saveFile("input.html", string);
                bl = string.indexOf(metaGenerator) != -1;
            } else {
                bl = false;
            }
            stringBuffer.append("<HTML><HEAD>\n");
            stringBuffer.append("<META NAME=Generator CONTENT=Quest Input Tool></META>\n");
            stringBuffer.append("<META NAME=Version CONTENT=1.0></META>\n");
            stringBuffer.append("<META HTTP-EQUIV=Content-Type CONTENT=text/html; charset=UTF-8></META>\n");
            stringBuffer.append("<STYLE TYPE=text/css>\n");
            stringBuffer.append("<!--\n");
            stringBuffer.append("@page {\n");
            stringBuffer.append("     size: 8.5in 11in;\n");
            stringBuffer.append("     margin-top: 1in; \n");
            stringBuffer.append("     margin-bottom: 1in; \n");
            stringBuffer.append("     margin-left: 1in; \n");
            stringBuffer.append("     margin-right: 1in; \n");
            stringBuffer.append("    }\n");
            stringBuffer.append("P {\n");
            stringBuffer.append("     font-family: Helvetica;\n");
            stringBuffer.append("     font-size: 10pt;\n");
            stringBuffer.append("    }\n");
            stringBuffer.append("-->\n");
            stringBuffer.append("</STYLE>\n");
            stringBuffer.append("</HEAD><BODY text=black BGCOLOR=white>");
            if (string != null) {
                string = Text.replaceAllStrInStr(string, "<a href=\"\"></a>", "");
            }
            if (string != null) {
                stringBuffer.append(defaultFontStr);
                stringBuffer.append(string.trim());
                stringBuffer.append("</BODY></HTML>");
            } else {
                stringBuffer.append(defaultFontStr);
                stringBuffer.append("<br></BODY></HTML>");
            }
            string2 = WordProcUtil.fixBodyTagsForEdit(documentDraft, stringBuffer.toString());
            string2 = Text.replaceAllStrInStr(string2, "<br>", "<p>");
            stringBuffer.setLength(0);
        }
        catch (Exception exception) {
        }
        System.gc();
        MainWindow.getInstance().setStatus(null);
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String createHTML(WordProcessorBean wordProcessorBean, DocumentDraft documentDraft) {
        String string = null;
        try {
            String string2 = null;
            StringWriter stringWriter = new StringWriter();
            Object var5_6 = null;
            MainWindow.getInstance().setStatus(538);
            string2 = wordProcessorBean.getDocumentContentsAsHTML();
            MainWindow.getInstance().setStatus(Str.getStr(539) + ".");
            string2 = WordProcUtil.getDocBody(string2);
            FileUtil.saveFile(PropertySystem.getString(30) + "bad.html", string2);
            MainWindow.getInstance().setStatus(539);
            string = WordProcUtil.fixBodyTagsForSave(string2);
            if (string != null) {
                string = Text.replaceAllStrInStr(string, "&#160;", "&nbsp;");
                MainWindow.getInstance().setStatus(Str.getStr(540));
                WordProcUtil.assembleGraphics(wordProcessorBean, documentDraft);
                string = metaGenerator + string;
            }
            FileUtil.saveFile(PropertySystem.getString(30) + "output.html", string);
            stringWriter.close();
            stringWriter = null;
            string2 = null;
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MainWindow.getInstance().setStatus(null);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String fixBodyTagsForEdit(DocumentDraft documentDraft, String string) {
        String string2 = string;
        try {
            String string3 = File.separator;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = null;
            String string5 = "FILE:/" + PropertySystem.getString(30) + File.separator;
            if (string == null) return string2;
            HTMLParse hTMLParse = new HTMLParse(string);
            int n = 0;
            MainWindow.getInstance().setStatus(Str.getStr(541) + " " + hTMLParse.tagCount() + " " + Str.getStr(542));
            while (true) {
                if (n >= hTMLParse.tagCount()) {
                    string2 = hTMLParse.getHTMLString();
                    hTMLParse.free();
                    hTMLParse = null;
                    System.gc();
                    return string2;
                }
                string4 = hTMLParse.getTag(n).toUpperCase();
                if (string4.equals("<UL>") || string4.equals("<OL>")) {
                    bl = true;
                } else if (string4.equals("</UL>") || string4.equals("</OL>")) {
                    bl = false;
                } else if (string4.equals("<BR>")) {
                    if (bl) {
                        hTMLParse.removeTag(n);
                    }
                } else if (string4.startsWith("<UL")) {
                    hTMLParse.replaceTag(n, "<UL>");
                } else if (string4.startsWith("<LI")) {
                    hTMLParse.replaceTag(n, "<LI>");
                } else if (string4.equals("<SUP>")) {
                    hTMLParse.replaceTag(n, "<A NAME=\"" + Str.getStr(545) + WordProcUtil.getRandomName(documentDraft) + "\"><FONT SIZE=\"1\" STYLE=\"font-size: 8pt\">");
                } else if (string4.equals("</SUP>")) {
                    hTMLParse.replaceTag(n, "</FONT></A>");
                } else if (string4.equals("<SUB>")) {
                    hTMLParse.replaceTag(n, "<A NAME=\"" + Str.getStr(546) + WordProcUtil.getRandomName(documentDraft) + "\"><FONT SIZE=\"1\" STYLE=\"font-size: 8pt\">");
                } else if (string4.equals("<ITP>")) {
                    hTMLParse.replaceTag(n, "</P>");
                } else if (string4.equals("</SUB>")) {
                    hTMLParse.replaceTag(n, "</font></a>");
                } else if (string4.startsWith("<IMG SRC=")) {
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    string4 = hTMLParse.getTag(n);
                    string6 = "<IMG SRC=\"" + string5;
                    string7 = string4.substring(string4.indexOf("\""), string4.indexOf("\"", string4.indexOf("\"") + 1));
                    string8 = string4.substring(string4.indexOf("\"", string4.indexOf("\"") + 1), string4.length());
                    string7 = string7.substring(string7.lastIndexOf("/") + 1, string7.length());
                    string7 = Text.replaceAllStrInStr(string7, "\"", "");
                    string9 = string6 + string7.substring(string7.lastIndexOf(string3) + 1, string7.length()) + string8;
                    string9 = Text.replaceAllStrInStr(string9, "###IMAGELOC###", "");
                    string9 = Text.replaceAllStrInStr(string9, "###imageloc###", "");
                    hTMLParse.replaceTag(n, string9);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return string2;
    }

    protected static void assembleDocLinks(WordProcessorBean wordProcessorBean, DocumentDraft documentDraft, String string) {
        MainWindow.getInstance().setStatus(Str.getStr(543));
        if (documentDraft != null) {
            Vector<DocumentLink> vector = documentDraft.getDocumentLinks();
            if (vector != null) {
                WPEnumeration wPEnumeration = wordProcessorBean.enumerateLinks();
                Object var5_6 = null;
                Link link = null;
                if (wPEnumeration != null && wPEnumeration.hasMoreNames()) {
                    vector.removeAllElements();
                    while (wPEnumeration.hasMoreNames()) {
                        link = wordProcessorBean.findLink(wPEnumeration.nextName());
                        if (link == null || WordProcUtil.docHasLink(vector, link)) continue;
                        vector.addElement(WordProcUtil.createDocLink(documentDraft, link));
                    }
                } else {
                    vector.removeAllElements();
                }
            } else {
                WPEnumeration wPEnumeration = wordProcessorBean.enumerateLinks();
                Object var5_7 = null;
                Link link = null;
                if (wPEnumeration != null && wPEnumeration.hasMoreNames()) {
                    vector = new Vector<DocumentLink>(10, 10);
                    while (wPEnumeration.hasMoreNames()) {
                        DocumentLink documentLink;
                        link = wordProcessorBean.findLink(wPEnumeration.nextName());
                        if (link == null || (documentLink = WordProcUtil.createDocLink(documentDraft, link)) == null) continue;
                        vector.addElement(documentLink);
                    }
                }
            }
            documentDraft.setDocumentLinks(vector);
        }
        MainWindow.getInstance().setStatus(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final DocumentLink createDocLink(DocumentDraft documentDraft, Link link) {
        DocumentLink documentLink;
        SQLMethod sQLMethod;
        block4: {
            String string = "createDocLink";
            sQLMethod = new SQLMethod(1, string, 5);
            documentLink = null;
            if (sQLMethod != null) {
                try {
                    String string2 = link.getDestination();
                    if (string2 == null || string2.indexOf(".") <= 0) break block4;
                    String string3 = string2.substring(0, string2.indexOf("."));
                    Statement statement = sQLMethod.createStatement();
                    if (string3.length() == 11 && string3.indexOf("-") == 4) {
                        ResultSet resultSet = statement.executeQuery("SELECT DOCIND, TITLE, DOCCLASSIND, LNDOCID " + "FROM TIGRIS.DOCUMENTS " + "WHERE LNDOCID = '" + string3 + "' FOR FETCH ONLY");
                        documentLink = resultSet.next() ? new DocumentLink(documentDraft.getDocInd(), resultSet.getInt(1), resultSet.getString(2).trim()) : null;
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception);
                }
            }
        }
        sQLMethod.close();
        return documentLink;
    }

    private static final boolean docHasLink(Vector vector, Link link) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void assembleGraphics(WordProcessorBean wordProcessorBean, DocumentDraft documentDraft) {
        WPEnumeration wPEnumeration = wordProcessorBean.enumerateImages();
        String string = null;
        WPImage wPImage = null;
        PersistentRec persistentRec = null;
        Vector vector = null;
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ((DocumentGraphic)vector.elementAt(n)).updateRecStatus(0);
                ((DocumentGraphic)vector.elementAt(n)).updateRecStatus(3);
                ++n;
            }
        }
        while (wPEnumeration.hasMoreNames()) {
            block9: {
                string = wPEnumeration.nextName();
                wPImage = wordProcessorBean.findImage(string);
                if (wPImage == null) continue;
                String string2 = null;
                string = wPImage.getImageName();
                string2 = string.substring(string.lastIndexOf(File.separator) + 1);
                if (!WordProcUtil.notStampedGraphic(string2)) continue;
                try {
                    if (string.indexOf("/") >= 0) {
                        string = string.substring(string.lastIndexOf("/") + 1, string.length());
                    }
                    if (string.indexOf("\\") >= 0) {
                        string = string.substring(string.lastIndexOf("\\") + 1, string.length());
                    }
                }
                catch (Exception exception) {
                    if (string.indexOf("/") >= 0) {
                        string = string.substring(string.lastIndexOf("/"), string.length());
                    }
                    if (string.indexOf("\\") < 0) break block9;
                    string = string.substring(string.lastIndexOf("\\"), string.length());
                }
            }
            if (!vector.contains(persistentRec)) {
                vector.addElement(persistentRec);
                continue;
            }
            persistentRec.updateRecStatus(2);
        }
    }

    public static String getDocBody(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = string;
        n = string2.indexOf("<BODY");
        if (n > 0) {
            n2 = string2.indexOf(">", n);
            if (n2 > 0) {
                n3 = n2 + 1;
                n4 = string2.indexOf("</BODY");
                string2 = string2.substring(n3, n4).trim();
            }
            string2 = defaultFontStr + string2 + "</font>";
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fixBodyTagsForSave(String string) {
        boolean bl = false;
        int n = 0;
        String string2 = File.separator;
        Vector<String> vector = new Vector<String>(10, 1);
        int n2 = 0;
        HTMLParse hTMLParse = null;
        HTMLTag hTMLTag = null;
        String string3 = string;
        String string4 = null;
        String string5 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        int n6 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        try {
            string = Text.replaceAllStrInStr(string, "_(newwin)\"", "\" TARGET=\"new\"");
            hTMLParse = new HTMLParse(string);
            while (n < hTMLParse.tagCount() && !bl3) {
                block38: {
                    int n7;
                    String string6;
                    block51: {
                        block50: {
                            block49: {
                                block48: {
                                    block47: {
                                        block46: {
                                            block45: {
                                                block44: {
                                                    block42: {
                                                        block43: {
                                                            block41: {
                                                                block40: {
                                                                    block39: {
                                                                        string4 = hTMLParse.getTag(n);
                                                                        if (string4 == null) break block38;
                                                                        if ((string4 = string4.toUpperCase()).indexOf("STYLE") < 0 || string4.indexOf("FONT") < 0) break block39;
                                                                        string5 = WordProcUtil.fixStyleFontTag(string4);
                                                                        if (string5 != null) {
                                                                            hTMLParse.replaceTag(n, string5);
                                                                            string5 = null;
                                                                        }
                                                                        break block38;
                                                                    }
                                                                    if (string4.indexOf("WPCOMMENT") < 0) break block40;
                                                                    hTMLParse.removeTag(n);
                                                                    break block38;
                                                                }
                                                                if (!string4.equals("</P>")) break block41;
                                                                try {
                                                                    String string7 = hTMLParse.getTag(n + 1).toUpperCase();
                                                                    string6 = hTMLParse.getTag(n - 1).toUpperCase();
                                                                    if (n6 > 0) {
                                                                        hTMLParse.removeTag(n);
                                                                        --n6;
                                                                        break block38;
                                                                    }
                                                                    if (n3 > 0 && string7.indexOf("/TD") >= 0) {
                                                                        hTMLParse.removeTag(n);
                                                                        break block38;
                                                                    }
                                                                    if (string7 != null && (string7.indexOf("OL") >= 0 || string7.indexOf("UL") >= 0)) {
                                                                        hTMLParse.removeTag(n);
                                                                        break block38;
                                                                    }
                                                                    if (string6 != null && (string6.indexOf("OL") >= 0 || string6.indexOf("UL") >= 0)) {
                                                                        hTMLParse.removeTag(n);
                                                                        break block38;
                                                                    }
                                                                    hTMLParse.replaceTag(n, "<br>");
                                                                }
                                                                catch (Exception exception) {
                                                                    hTMLParse.replaceTag(n, "<br>");
                                                                }
                                                                break block38;
                                                            }
                                                            if (!string4.startsWith("<P")) break block42;
                                                            if (string4.indexOf("ALIGN") != -1) break block43;
                                                            hTMLParse.removeTag(n);
                                                            break block38;
                                                        }
                                                        if (string4.indexOf("CENTER") >= 0 && n3 > 0) {
                                                            hTMLParse.removeTag(n);
                                                            break block38;
                                                        } else if (string4.indexOf("CLASS") >= 0) {
                                                            hTMLParse.removeTag(n);
                                                            ++n6;
                                                        }
                                                        break block38;
                                                    }
                                                    if (string4.indexOf(Str.getStr(545)) < 0) break block44;
                                                    string4 = "<sup>";
                                                    hTMLParse.replaceTag(n, string4);
                                                    hTMLParse.removeTag(n + 1);
                                                    hTMLTag = hTMLParse.getTagRec(n);
                                                    n4 = hTMLTag.getTagNum();
                                                    break block38;
                                                }
                                                if (string4.indexOf(Str.getStr(546)) < 0) break block45;
                                                string4 = "<sub>";
                                                hTMLParse.replaceTag(n, string4);
                                                hTMLParse.removeTag(n + 1);
                                                hTMLTag = hTMLParse.getTagRec(n);
                                                n5 = hTMLTag.getTagNum();
                                                break block38;
                                            }
                                            if (!string4.equals("</FONT>") || n5 <= 0 && n4 <= 0) break block46;
                                            string5 = hTMLParse.getTag(n + 1);
                                            if (string5 != null && (string5 = string5.toUpperCase()).equals("</A>")) {
                                                if (n5 > n4) {
                                                    string5 = "</sub>";
                                                    n5 = 0;
                                                } else {
                                                    string5 = "</sup>";
                                                    n4 = 0;
                                                }
                                                hTMLParse.removeTag(n + 1);
                                                hTMLParse.replaceTag(n, string5);
                                            }
                                            string5 = null;
                                            break block38;
                                        }
                                        if (!string4.startsWith("<IMG SRC=")) break block47;
                                        String string8 = "<IMG SRC=\"";
                                        string6 = null;
                                        String string9 = null;
                                        string4 = hTMLParse.getTag(n);
                                        string6 = string4.substring(string4.indexOf("\""), string4.indexOf("\"", string4.indexOf("\"") + 1));
                                        string9 = string4.substring(string4.indexOf("\"", string4.indexOf("\"") + 1), string4.length());
                                        string6 = string6.substring(string6.lastIndexOf(File.separator) + 1, string6.length());
                                        string5 = !WordProcUtil.notStampedGraphic(string6 = Text.replaceAllStrInStr(string6, File.separator, "")) ? "<img src=\"###IMAGELOC###" + string6 + "\">" : string8 + "./" + string6.substring(string6.lastIndexOf(string2) + 1, string6.length()) + string9;
                                        hTMLParse.replaceTag(n, string5);
                                        string5 = null;
                                        break block38;
                                    }
                                    if (!string4.startsWith("<TABLE")) break block48;
                                    ++n3;
                                    bl6 = false;
                                    if (string4.indexOf("CENTER") == -1) {
                                        if (string4.indexOf("LEFT") > 0) {
                                            string4 = Text.replaceInStr(string4, "LEFT", "CENTER");
                                        } else if (string4.indexOf("RIGHT") > 0) {
                                            string4 = Text.replaceInStr(string4, "RIGHT", "CENTER");
                                        }
                                    }
                                    if (string4.indexOf("COLS") >= 0) {
                                        string4 = string4.substring(0, string4.indexOf("COLS=\"")) + string4.substring(string4.indexOf("\"", string4.indexOf("COLS=\"") + 6) + 1, string4.length());
                                        hTMLParse.replaceTag(n, string4);
                                    }
                                    if (n3 > 1) {
                                        GUISystem.printBox(6, 544);
                                        bl3 = true;
                                    }
                                    break block38;
                                }
                                if (!string4.startsWith("</TABLE")) break block49;
                                if (--n3 == 0) {
                                    vector.removeAllElements();
                                    n2 = 0;
                                }
                                break block38;
                            }
                            if (!string4.startsWith("<COL")) break block50;
                            String string10 = string4.substring(4, string4.length() - 1);
                            vector.addElement(string10);
                            break block38;
                        }
                        if (!string4.startsWith("<TD")) break block51;
                        String string11 = null;
                        string6 = null;
                        String string12 = hTMLParse.getHTMLString();
                        n7 = 0;
                        if (vector.size() > n2) {
                            String string13 = (String)vector.elementAt(n2);
                            string13 = WordProcUtil.convertWidth(string13);
                            ++n2;
                            string6 = "<td " + string13 + " ";
                            string4 = string6 = string6 + string4.substring(4, string4.length());
                        } else {
                            string4 = "<td valign=\"top\"" + string4.substring(4, string4.length());
                        }
                        hTMLTag = hTMLParse.getTagRec(n);
                        string11 = string12.substring(hTMLTag.getCharPos());
                        string11 = string11.indexOf("/TD") >= 0 ? string11.substring(0, string11.indexOf("/TD")) : (string11.indexOf("/td") >= 0 ? string11.substring(0, string11.indexOf("/td")) : null);
                        if (string11 != null) {
                            if (string11.indexOf("CENTER") >= 0 || string11.indexOf("center") >= 0) {
                                hTMLParse.replaceTag(n, "<td VALIGN = \"TOP\" ALIGN=\"CENTER\" " + string4.substring(4, string4.length()));
                                break block38;
                            } else if (string11.indexOf("RIGHT") == -1) {
                                hTMLParse.replaceTag(n, "<td VALIGN = \"TOP\" ALIGN=\"LEFT\" " + string4.substring(4, string4.length()));
                            }
                        }
                        break block38;
                    }
                    if (string4.indexOf("<LI") >= 0) {
                        hTMLParse.replaceTag(n, "<LI>");
                    } else if (string4.startsWith("<A HREF")) {
                        int n8 = n + 1;
                        string6 = hTMLParse.getTag(n);
                        boolean bl7 = string6.startsWith("</A") || string6.startsWith("</a");
                        string6 = Text.replaceAllStrInStr(string6, "&AMP;AMP;", "&");
                        string6 = Text.replaceAllStrInStr(string6, "&AMP;", "&");
                        string6 = Text.replaceAllStrInStr(string6, "&amp;amp;", "&");
                        if ((string6 = Text.replaceAllStrInStr(string6, "&amp;", "&")).indexOf("WP_PART") >= 0) {
                            string6 = WordProcUtil.takeOutWPPart(string6);
                        }
                        hTMLParse.replaceTag(n, string6);
                        while (!bl7 && n8 < hTMLParse.tagCount()) {
                            if (++n8 >= hTMLParse.tagCount()) continue;
                            string6 = hTMLParse.getTag(n8).toUpperCase();
                            bl7 = string6.startsWith("</A");
                        }
                        if (bl7) {
                            int n9;
                            n7 = string4.length();
                            int n10 = hTMLParse.getTagRec(n).getCharPos();
                            if (n10 + n7 + 2 == (n9 = hTMLParse.getTagRec(n8).getCharPos()) || string4.indexOf("WP_PART") >= 0 && string4.indexOf("1OF") == -1) {
                                hTMLParse.removeTag(n);
                                hTMLParse.removeTag(n8);
                            }
                        }
                    }
                }
                ++n;
            }
            if (!bl3) {
                string3 = hTMLParse.getHTMLString();
                string3 = Text.replaceAllStrInStr(string3, "_<IMG", "<IMG");
                string3 = Text.replaceAllStrInStr(string3, "</BR>", "");
                string3 = Text.replaceAllStrInStr(string3, "</br>", "");
                string3 = Text.replaceAllStrInStr(string3, "</HR>", "");
                string3 = Text.replaceAllStrInStr(string3, "</hr>", "");
                string3 = Text.replaceAllStrInStr(string3, "</IMG>", "");
                string3 = Text.replaceAllStrInStr(string3, "</img>", "");
                string3 = Text.replaceAllStrInStr(string3, "<font>", "");
                string3 = Text.replaceAllStrInStr(string3, "<FONT>", "");
            } else {
                string3 = null;
            }
            hTMLParse.free();
            return string3;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String fixStyleFontTag(String string) {
        String string2 = null;
        int n = string.indexOf("STYLE");
        if (n < 0) return string2;
        if ((n = string.indexOf("\"", n)) < 0) return string2;
        int n2 = string.indexOf("\"", n + 1);
        if (n2 < 0) return string2;
        String string3 = null;
        int n3 = 12;
        string3 = string.substring(n += 12, n2 - 2);
        try {
            n3 = new Integer(string3);
        }
        catch (Exception exception) {
        }
        switch (n3) {
            case 10: {
                return "<font size=2>";
            }
            case 12: {
                return "<font size=3>";
            }
            case 14: {
                return "<font size=4>";
            }
        }
        return string2;
    }

    protected static String getRandomName(DocumentDraft documentDraft) {
        String string = new CDate(1).today();
        string = Text.replaceAllStrInStr(string, ".", "");
        string = Text.replaceAllStrInStr(string, "-", "");
        if (documentDraft != null) {
            string = documentDraft.getDocInd() + "_" + string;
        }
        return string;
    }

    private static final String convertWidth(String string) {
        String string2 = "";
        if (string != null && string.length() > 5) {
            int n = string.indexOf("\"") + 1;
            String string3 = string.substring(n, string.indexOf("\"", n) - 1);
            double d = 0.0;
            d = new Double(string3);
            d /= 100.0;
            string2 = "WIDTH=\"" + new Double(d *= 624.0).intValue() + "\"";
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String takeOutWPPart(String string) {
        try {
            String string2 = string;
            int n = string.indexOf("WP_PART");
            int n2 = string.lastIndexOf("\"");
            return string.substring(0, n) + string2.substring(n2 + 1, string2.length());
        }
        catch (Exception exception) {
        }
        return string;
    }

    public static boolean notStampedGraphic(String string) {
        boolean bl = true;
        if (string.indexOf("doclink") >= 0 || StampedGraphicFactory.containsImage(string)) {
            bl = false;
        }
        return bl;
    }
}

