/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.tcon;

import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class tConvert {
    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 3) {
            System.out.println("Usage: java com.ibm.nzna.projects.tcon.tConvert <databaseName> <databaseServer> <portNumber>");
            System.exit(-1);
        }
        new LogSystem(1, "tcon.out");
        if (tConvert.connectToDatabase(stringArray[0], stringArray[1], stringArray[2])) {
            new TypeCategory();
            tConvert.removePreData();
            tConvert.checkDupsInMultimedia("TIGRIS");
            tConvert.checkDupsInMultimedia("QUEST");
            if (tConvert.mergeGraphics() && tConvert.mergeFiles() && tConvert.processBrands() && tConvert.processFamilies() && tConvert.processCategories() && tConvert.mergeOldDocumentCategories()) {
                TypeCategory.writeToDatabase();
            }
            DatabaseSystem.shutdown();
        }
        System.exit(0);
    }

    private static boolean connectToDatabase(String string, String string2, String string3) {
        boolean bl = false;
        try {
            new DatabaseSystem(true, LogSystem.getInstance(), false);
            bl = DatabaseSystem.createConnection(1, string, string2, string3, "quest", "j0hnny");
            DatabaseSystem.setAutoDisconnect(false);
            DatabaseSystem.setAllowMultipleConnections(false);
            System.out.println("Connected to " + string);
            LogSystem.log(1, "Connected to database " + string + " on Server " + string2);
        }
        catch (Exception exception) {
            bl = false;
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    private static boolean processBrands() {
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "processBrands", 5);
        System.out.println("Creating Brands");
        System.out.println("-------------------------------------------");
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT BRANDIND, DESCRIPT, OWNER FROM TIGRIS.TYPEBRAND where brandind > 0");
            int n = 0;
            while (resultSet.next()) {
                LogSystem.log(1, "Creating Brand " + resultSet.getString(2).trim());
                TypeCategory.createTypeCategory(resultSet.getInt(1), 0, resultSet.getString(2).trim(), "brand", 0, "N", resultSet.getString(3).trim());
                TypeCategory.createDraftTypeCategory(resultSet.getInt(1), 0, resultSet.getString(2).trim(), "brand", 0, "N", resultSet.getString(3).trim());
                ++n;
            }
            System.out.println("    Created " + n + " Brands");
            System.out.println("-------------------------------------------\n");
            resultSet.close();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return bl;
    }

    private static boolean processFamilies() {
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "processFamilies", 5);
        System.out.println("Creating Families");
        System.out.println("-------------------------------------------");
        try {
            int n = 0;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT TYPEBRAND.DESCRIPT, TYPEGROUP.DESCRIPT,TYPEGROUP.OWNER, TYPEGROUP.GROUPIND FROM TIGRIS.TYPEBRAND TYPEBRAND,      TIGRIS.TYPEGROUP TYPEGROUP,      TIGRIS.BRANDS BRANDS WHERE TYPEBRAND.BRANDIND = BRANDS.BRANDIND AND       TYPEGROUP.GROUPIND = BRANDS.GROUPIND AND TYPEBRAND.BRANDIND > 0 ");
            while (resultSet.next()) {
                LogSystem.log(1, "Creating Family " + resultSet.getString(2).trim() + " under Brand " + resultSet.getString(1));
                TypeCategoryRec typeCategoryRec = TypeCategory.createTypeCategory(TypeCategory.getCategoryFromDescription(resultSet.getString(1).trim()).getInd(), resultSet.getString(2).trim(), "family", 0, "N", resultSet.getString(3).trim());
                TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), TypeCategory.getCategoryFromDescription(resultSet.getString(1).trim()).getInd(), resultSet.getString(2).trim(), "family", 0, "N", resultSet.getString(3).trim());
                ++n;
            }
            System.out.println("     Created " + n + " Families");
            System.out.println("-------------------------------------------\n");
            resultSet.close();
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return bl;
    }

    private static boolean processCategories() {
        SQLMethod sQLMethod = new SQLMethod(1, "processCategories", 5);
        boolean bl = false;
        System.out.println("Creating new Document Categories");
        System.out.println("-------------------------------------------");
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DESCRIPT FROM TIGRIS.TYPEDOCCAT");
            Vector vector = TypeCategory.getCategories("brand");
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (resultSet.next()) {
                n = 0;
                while (n < vector.size()) {
                    if (!((TypeCategoryRec)vector.elementAt(n)).getIsDraft()) {
                        TypeCategory.createTypeCategory(((TypeCategoryRec)vector.elementAt(n)).getInd(), resultSet.getString(1).trim(), "doccategory", 0, "N", "QUEST");
                        ++n2;
                    }
                    ++n;
                }
                ++n3;
            }
            System.out.println("     Created " + n2 + " Categories.  " + n3 + " Unique");
            System.out.println("-------------------------------------------\n");
            bl = true;
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.close();
            bl = false;
        }
        sQLMethod.close();
        return bl;
    }

    private static boolean mergeOldDocumentCategories() {
        return true;
    }

    private static boolean mergeGraphics() {
        SQLMethod sQLMethod = new SQLMethod(1, "mergeGraphics", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            System.out.println("\n\nMerging Graphics");
            statement.execute("INSERT INTO TIGNEW.GRAPHICS SELECT DISTINCT A.DOCIND, FILENAME FROM TIGRIS.DOCGRAPHIC A, TIGRIS.GRAPHICS B WHERE A.GRAPHICIND = B.GRAPHICIND");
            statement.execute("INSERT INTO QUESTNEW.GRAPHICS SELECT DISTINCT A.DOCIND, FILENAME FROM QUEST.DOCGRAPHIC A, TIGRIS.GRAPHICS B WHERE A.GRAPHICIND = B.GRAPHICIND");
            bl = true;
            LogSystem.log(1, "Graphics Merged Succesfully");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.close();
            bl = false;
        }
        sQLMethod.close();
        return bl;
    }

    private static boolean mergeFiles() {
        SQLMethod sQLMethod = new SQLMethod(1, "mergeFiles", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            System.out.println("Merging Files");
            statement.executeUpdate("INSERT INTO TIGRIS.DOCFILES SELECT DISTINCT DOCIND, FILENAME, GENINFO, SIZE, FILEURL, FILEVERSION, 0, 0 FROM TIGRIS.DOCMEDIA A, TIGRIS.MULTIMEDIA B WHERE A.MULTIMEDIAIND = B.MULTIMEDIAIND");
            statement.executeUpdate("INSERT INTO QUEST.DOCFILES SELECT DISTINCT DOCIND, FILENAME, GENINFO, SIZE, FILEURL, FILEVERSION, 0, 0 FROM QUEST.DOCMEDIA A, TIGRIS.MULTIMEDIA B WHERE A.MULTIMEDIAIND = B.MULTIMEDIAIND");
            bl = true;
            LogSystem.log(1, "Files Merged Succesfully");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.close();
            bl = false;
        }
        sQLMethod.close();
        return bl;
    }

    public static void checkDupsInMultimedia(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>(1);
        SQLMethod sQLMethod = new SQLMethod(1, "checkDupsInMultimedia", 5);
        boolean bl = false;
        System.out.println("Checking Dupliates for schema " + string);
        System.out.println("-------------------------------------------");
        try {
            Statement statement = sQLMethod.createStatement();
            int n = 0;
            ResultSet resultSet = statement.executeQuery("SELECT A.DOCIND, B.FILENAME, B.MULTIMEDIAIND FROM " + string + ".DOCMEDIA A, TIGRIS.MULTIMEDIA B where A.multimediaind = b.multimediaind");
            while (resultSet.next()) {
                String string2 = resultSet.getInt(1) + resultSet.getString(2).trim();
                if (hashtable.get(string2) != null) {
                    vector.addElement("" + resultSet.getInt(3));
                    continue;
                }
                hashtable.put(string2, string2);
                ++n;
            }
            System.out.println("     Finished sorting through schema " + string + " and " + n + " Multimedia associations were found. " + vector.size() + " duplicate(s)");
            if (vector != null && vector.size() > 0) {
                int n2 = 0;
                int n3 = vector.size();
                while (n2 < n3) {
                    statement.executeUpdate("DELETE FROM TIGRIS.DOCMEDIA where multimediaind = " + ((String)vector.elementAt(n2)).toString());
                    statement.executeUpdate("DELETE FROM QUEST.DOCMEDIA where multimediaind = " + ((String)vector.elementAt(n2)).toString());
                    statement.executeUpdate("DELETE FROM TIGRIS.MULTIMEDIA where multimediaind = " + ((String)vector.elementAt(n2)).toString());
                    ++n2;
                }
            }
            System.out.println("-------------------------------------------");
            bl = true;
            LogSystem.log(1, "Files Merged Succesfully");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.close();
            bl = false;
        }
        sQLMethod.close();
    }

    private static boolean removePreData() {
        SQLMethod sQLMethod = new SQLMethod(1, "createMiscTypes", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("DELETE FROM PRODUCT.CATEGORY");
            statement.executeUpdate("DELETE FROM PRODUCT.GEO");
            statement.executeUpdate("DELETE FROM PRODUCT.COUNTRY");
            statement.executeUpdate("DELETE FROM PRODUCT.PRODUCT");
            statement.executeUpdate("DELETE FROM PRODRAFT.CATEGORY");
            statement.executeUpdate("DELETE FROM PRODRAFT.GEO");
            statement.executeUpdate("DELETE FROM PRODRAFT.COUNTRY");
            statement.executeUpdate("DELETE FROM PRODRAFT.PRODUCT");
            statement.executeUpdate("DELETE FROM TIGRIS.DOCFILES");
            statement.executeUpdate("DELETE FROM QUEST.DOCFILES");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPECATCHILD");
            statement.executeUpdate("DELETE FROM PRODRAFT.TYPECATCHILD");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPECATEGORY");
            statement.executeUpdate("DELETE FROM PRODRAFT.TYPECATEGORY");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPEPRODUCT");
            statement.executeUpdate("DELETE FROM TIGNEW.GRAPHICS");
            statement.executeUpdate("DELETE FROM QUESTNEW.GRAPHICS");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPEOFFER' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPEOFFER', 3, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPEOFFERING");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEOFFERING values ( 0, 'Default Offering' )");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEOFFERING values ( 1, 'CTO Offering' )");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPECUST' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPECUST', 3, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPECUSTOMER");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPECUSTOMER values ( 0, 'Default Customer' )");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPECNCL' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPECNCL', 1, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODRAFT.TYPECANCEL");
            statement.executeUpdate("INSERT INTO PRODRAFT.TYPECANCEL values ( 0, 'Invalid OPIC/M Data')");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPEWARR' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPEWARR', 1, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPEWARRANTY");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEWARRANTY values ( 0, '000', 'Default Warranty/Unknown' )");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPEDATE' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPEDATE', 3, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPEDATE");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPEPROD' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPEPROD', 4, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPEPRODUCT");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEPRODUCT values ( 0, 'Default Product')");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEPRODUCT values ( 1, 'System'         )");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEPRODUCT values ( 2, 'Option'         )");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEPRODUCT values ( 3, 'Monitor'        )");
            statement.executeUpdate("INSERT INTO QIT.TYPECUSTOMVIEW  values (  7, 'Product Management - Product', 1, user, current timestamp)");
            statement.executeUpdate("DELETE FROM PRODUCT.TYPEXREF");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEXREF values ( 1, 'FRU Part')");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPEXREF values ( 2, 'CRU Part')");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'TYPECATIND' ");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'TYPECATIND', 50000, user, current timestamp)");
            statement.executeUpdate("INSERT INTO PRODUCT.TYPECATEGORY values ( 0, 'Default Brand', 0, 'brand', 0, 'N', 'quest', 'N')");
            statement.executeUpdate("INSERT INTO PRODRAFT.TYPECATEGORY values ( 0, 'Default Brand', 0, 'brand', 0, 'N', 'quest', 'N')");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'PRODRAFT' ");
            statement.executeUpdate("DELETE FROM TIGRIS.COUNTER WHERE COUNTER = 'PRODUCT'");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'PRODRAFT', 100, user, current timestamp)");
            statement.executeUpdate("INSERT INTO TIGRIS.COUNTER values ( 'PRODUCT',  50000, user, current timestamp)");
            statement.executeUpdate("DELETE FROM TIGRIS.CONSTANTS WHERE CONSTANT = 'BMP_ANNOUNCE_DAYS'");
            statement.executeUpdate("INSERT INTO TIGRIS.CONSTANTS VALUES ( 'BMP_ANNOUNCE_DAYS', 14, '', 'ProdGen', user, current timestamp)");
            statement.executeUpdate("DELETE FROM TIGRIS.CONSTANTS WHERE CONSTANT = 'PRODGEN_TIMESTAMP'");
            statement.executeUpdate("INSERT INTO TIGRIS.CONSTANTS VALUES ( 'PRODGEN_TIMESTAMP', 0, '2001-07-10-07.00.00.000000', 'ProdGen', user, current timestamp)");
            statement.executeUpdate("DELETE FROM TIGRIS.CONSTANTS WHERE CONSTANT = 'WWCATHC_TIMETSTAMP'");
            statement.executeUpdate("INSERT INTO TIGRIS.CONSTANTS values ('WWCATHC_TIMESTAMP', 0, '2001-01-01-00.00.00.000000', 'WWCatHC', 'QUEST', CURRENT TIMESTAMP)");
            statement.executeUpdate("INSERT INTO TIGRIS.TYPEPROPERTIES VALUES ( 9, 1, 'CHAR(254)', 'Checked Out By', user, current timestamp)");
            bl = true;
            LogSystem.log(1, "Database Primed Succesfully");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.close();
            bl = false;
        }
        sQLMethod.close();
        return bl;
    }

    public static void readBrands() {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        Vector vector = TypeCategory.getCategories("brand");
        if (vector != null) {
            n2 = 0;
            n = vector.size();
            while (n2 < n) {
                System.out.println(n2 + ": " + vector.elementAt(n2));
                ++n2;
            }
        }
        System.out.println("Reading Brands Took " + (System.currentTimeMillis() - l) + "(ms)");
        l = System.currentTimeMillis();
        vector = TypeCategory.getCategories("family");
        if (vector != null) {
            n2 = 0;
            n = vector.size();
            while (n2 < n) {
                System.out.println(n2 + ": " + vector.elementAt(n2));
                ++n2;
            }
        }
        System.out.println("Reading Families Took " + (System.currentTimeMillis() - l) + "(ms)");
    }
}

