/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.topic;

import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class Topic {
    private static final String OUTPUT_FILE = "opicm.out";
    private static final String CSV = "&!&";
    private String output = "OPIC/M Test Data\nDate:\n" + new CDate(2).today() + "\n\n";

    public static void main(String[] stringArray) {
        new LogSystem(1, "Topic.out");
        new Topic();
    }

    private boolean connectToOPICM() throws Exception {
        new DatabaseSystem(true, LogSystem.getInstance(), false);
        return DatabaseSystem.createConnection(3, "OPICMODS", "hyper.raleigh.ibm.com", "5703", "opicmes2", "j0hnny");
    }

    private void writeES_COUNTRY_SOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeES_COUNTRY_SOL", 5);
        Statement statement = sQLMethod.createStatement();
        this.output = this.output + "View: ES_COUNTRY_SOL (Solutions with Country associations)\n";
        this.output = this.output + "Geography" + CSV + "Country" + CSV + "Brand" + CSV + "Family" + CSV + "Series" + CSV + "Project" + CSV + "Offering Part Number" + CSV + "Country Part Number" + CSV + "Description" + CSV + "Announce Date" + CSV + "Preannounce Date" + CSV + "Availability Date" + CSV + "Withdrawn Date" + CSV + "Language (1=English)\n";
        if (statement != null) {
            ResultSet resultSet = statement.executeQuery("SELECT SUBGEOCODE, COUNTRYNAME, SUBGROUPNAME, FAMILYNAME, SERIESNAME, PROJECTNAME, OFFERINGPNUMB, PNUMB_CT, PNUMB_DESC_CT, ACT_ANN_DATE_CT, ACT_PREANN_CT, ACT_AVAIL_DATE_CT, ACT_WDRAWDATE_CT, NLSID " + "FROM OPICM.ES_COUNTRY_SOL " + "WHERE PNUMB_CT IN " + this.getPartNums() + "");
            while (resultSet.next()) {
                this.output = this.output + this.trim(resultSet.getString(1)) + CSV + this.trim(resultSet.getString(2)) + CSV + this.trim(resultSet.getString(3)) + CSV + this.trim(resultSet.getString(4)) + CSV + this.trim(resultSet.getString(5)) + CSV + this.trim(resultSet.getString(6)) + CSV + this.trim(resultSet.getString(7)) + CSV + this.trim(resultSet.getString(8)) + CSV + this.trim(resultSet.getString(9)) + CSV + this.trim(resultSet.getString(10)) + CSV + this.trim(resultSet.getString(11)) + CSV + this.trim(resultSet.getString(12)) + CSV + this.trim(resultSet.getString(13)) + CSV + resultSet.getInt(14) + "\n";
            }
        } else {
            LogSystem.log(1, "Could not create statement for writeES_COUNTRY_SOL");
        }
        this.output = this.output + "\n\n\n";
        sQLMethod.close();
    }

    private void writeES_SOL_NO_CSOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeES_SOL_NO_CSOL", 5);
        Statement statement = sQLMethod.createStatement();
        this.output = this.output + "View: ES_SOL_NO_CSOL (Solutions with Country associations)\n";
        this.output = this.output + "Geography" + CSV + "Brand" + CSV + "Family" + CSV + "Series" + CSV + "Project" + CSV + "Offering Part Number" + CSV + "Geography Part Number" + CSV + "Machine Type/Model Geography" + CSV + "Geography Marketing Description" + CSV + "Language (1=English)\n";
        if (statement != null) {
            ResultSet resultSet = statement.executeQuery("SELECT SUBGEOCODE, SUBGROUPNAME, FAMILYNAME, SERIESNAME, PROJECTNAME, OFFERINGPNUMB, PNUMB_SG, MTMPNUMB_SG, MARKETDESC_SG, NLSID " + "FROM OPICM.ES_SOL_NO_CSOL " + "WHERE PNUMB_SG IN " + this.getPartNums() + "");
            while (resultSet.next()) {
                this.output = this.output + this.trim(resultSet.getString(1)) + CSV + this.trim(resultSet.getString(2)) + CSV + this.trim(resultSet.getString(3)) + CSV + this.trim(resultSet.getString(4)) + CSV + this.trim(resultSet.getString(5)) + CSV + this.trim(resultSet.getString(6)) + CSV + this.trim(resultSet.getString(7)) + CSV + this.trim(resultSet.getString(8)) + CSV + this.trim(resultSet.getString(9)) + CSV + resultSet.getInt(10) + "\n";
            }
        } else {
            LogSystem.log(1, "Could not create statement for writeES_SOL_NO_CSOL");
        }
        this.output = this.output + "\n\n\n";
        sQLMethod.close();
    }

    private void writeES_MTM_NO_SOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeES_MTM_NO_SOL", 5);
        Statement statement = sQLMethod.createStatement();
        this.output = this.output + "View: ES_MTM_NO_SOL (Solutions with Country associations)\n";
        this.output = this.output + "Brand" + CSV + "Family" + CSV + "Series" + CSV + "Project" + CSV + "Offering Part Number" + CSV + " Marketing Description" + CSV + "Language (1=English)\n";
        if (statement != null) {
            ResultSet resultSet = statement.executeQuery("SELECT SUBGROUPNAME, FAMILYNAME, SERIESNAME, PROJECTNAME, OFFERINGPNUMB, OFWWMI, NLSID " + "FROM OPICM.ES_MTM_NO_SOL " + "WHERE OFFERINGPNUMB in " + this.getPartNums() + "");
            while (resultSet.next()) {
                this.output = this.output + this.trim(resultSet.getString(1)) + CSV + this.trim(resultSet.getString(2)) + CSV + this.trim(resultSet.getString(3)) + CSV + this.trim(resultSet.getString(4)) + CSV + this.trim(resultSet.getString(5)) + CSV + this.trim(resultSet.getString(6)) + CSV + resultSet.getInt(7) + "\n";
            }
        } else {
            LogSystem.log(1, "Could not create statement for write ES_MTM_NO_SOL");
        }
        this.output = this.output + "\n\n\n";
        sQLMethod.close();
    }

    private void writeES_CTO_REGION_ONLY() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "write ES_CTO_REGION_ONLY", 5);
        Statement statement = sQLMethod.createStatement();
        this.output = this.output + "View: ES_CTO_REGION_ONLY (CTO Solutions with Geography associations only)\n";
        this.output = this.output + "Geography" + CSV + "" + "Sub Geography" + CSV + "" + "Brand" + CSV + "" + "Family" + CSV + "" + "Series" + CSV + "" + "Project" + CSV + "" + "Country Level Part Number" + CSV + "" + "Marketing Description" + CSV + "" + "Announce Date" + CSV + "" + "Language (1=English)\n";
        if (statement != null) {
            ResultSet resultSet = statement.executeQuery("SELECT GEOCODE, SUBGEOCODE, SUBGROUPNAME, FAMILYNAME, SERIESNAME, PROJECTNAME, COFPNUMB, CTOSOLMARKETDESC, COFANNOUNCEACT, NLSID " + "FROM OPICM.ES_CTO_REGION_ONLY " + "WHERE CVSL_PNUMB in " + this.getPartNums() + "");
            while (resultSet.next()) {
                this.output = this.output + this.trim(resultSet.getString(1)) + CSV + this.trim(resultSet.getString(2)) + CSV + this.trim(resultSet.getString(3)) + CSV + this.trim(resultSet.getString(4)) + CSV + this.trim(resultSet.getString(5)) + CSV + this.trim(resultSet.getString(6)) + CSV + this.trim(resultSet.getString(7)) + CSV + this.trim(resultSet.getString(8)) + CSV + this.trim(resultSet.getString(9)) + CSV + resultSet.getInt(10) + "\n";
            }
        } else {
            LogSystem.log(1, "Could not create statement for write ES_CTO_REGION_ONLY");
        }
        this.output = this.output + "\n\n\n";
        sQLMethod.close();
    }

    private String trim(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private int getCounts(String string) throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeCounts", 5);
        ResultSet resultSet = null;
        int n = 0;
        try {
            System.out.println("Pulling Row Counts for Table: " + string);
            resultSet = sQLMethod.createStatement().executeQuery("SELECT COUNT(key) FROM OPICM." + string);
            resultSet.next();
            n = resultSet.getInt(1);
            this.output = this.output + string + CSV + n + "\n";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            sQLMethod.rollBack();
            sQLMethod.close();
            throw exception;
        }
        sQLMethod.close();
        return n;
    }

    private void writeCounts() throws Exception {
        this.output = this.output + "\n\nView Counts\nView,Number of Rows\n";
        this.getCounts("ES_COUNTRY_CPSL");
        this.getCounts("ES_COUNTRY_SOL");
        this.getCounts("ES_COUNTRY_CTO");
    }

    private void writeFullES_COUNTRY_CPSL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_COUNTRY_CPSL", 5);
        Statement statement = sQLMethod.createStatement();
        int n = 0;
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_COUNTRY_CPSL WHERE COFPNUMB IN " + this.getPartNums() + " OR CV_SOLPNUMB IN " + this.getPartNums() + " OR CVSL_PNUMB IN " + this.getPartNums());
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_COUNTRY_CPSL\n";
            int n2 = 1;
            while (n2 < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n2);
                if (n2 < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n2;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n2 = 1;
                System.out.println("Read Record " + n++);
                n2 = 1;
                while (n2 < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n2) != null ? this.output + resultSet.getString(n2).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n2;
                }
                this.output = this.output + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_CTO_REGION_ONLY() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_CTO_REGION_ONLY", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_CTO_REGION_ONLY WHERE " + "COFPNUMB IN " + this.getPartNums() + " OR " + "CVSL_PNUMB IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_CTO_REGION_ONLY\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "" + resultSet.getInt(n + 1) + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_COUNTRY_SOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_COUNTRY_SOL", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_COUNTRY_SOL WHERE " + "PNUMB_CT IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_COUNTRY_SOL\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_COUNTRY_CTO() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_COUNTRY_CTO", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_COUNTRY_CTO WHERE " + "COFPNUMB IN " + this.getPartNums() + " OR " + "CCOSOLPNUMB IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_COUNTRY_CTO\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_MTM_NO_SOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_MTM_NO_SOL", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_MTM_NO_SOL WHERE " + "OFWWMI IN " + this.getPartNums() + " OR " + "OFFERINGPNUMB IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_MTM_NO_SOL\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "" + resultSet.getInt(n + 1) + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_AAP_MTM() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_AAP_MTM", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_AAP_MTM WHERE " + "AAPSOLPNUMB IN " + this.getPartNums() + " OR " + "OFFERINGPNUMB IN " + this.getPartNums() + " OR " + "OFWWMI IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_AAP_MTM\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "" + resultSet.getInt(n + 1) + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_CTO_NO_SOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_CTO_NO_SOL", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_CTO_NO_SOL WHERE " + "COFPNUMB IN " + this.getPartNums() + "  ");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_CTO_NO_SOL\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "" + resultSet.getInt(n + 1) + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_SOL_NO_CSOL() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_SOL_NO_CSOL", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_SOL_NO_CSOL WHERE " + "MTMPNUMB_SG IN " + this.getPartNums() + " OR " + "PNUMB_SG IN " + this.getPartNums() + " OR " + "OFFERINGPNUMB IN " + this.getPartNums() + " OR " + "OFWWMI IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_SOL_NO_CSOL\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "" + resultSet.getInt(n + 1) + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private void writeFullES_REGION_PCSL_NO_CT() throws Exception {
        SQLMethod sQLMethod = new SQLMethod(3, "writeFullES_REGION_PCSL_NO_CT", 5);
        Statement statement = sQLMethod.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM OPICM.ES_REGION_PCSL_NO_CT WHERE " + "COFPNUMB IN " + this.getPartNums() + " OR " + "VARSOLPNUMB IN " + this.getPartNums() + " OR " + "CVSL_PNUMB IN " + this.getPartNums() + "");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.output = this.output + "\n\nFull Pull of all queried products against all machine/model fields for view ES_REGION_PCSL_NO_CT\n";
            int n = 1;
            while (n < resultSetMetaData.getColumnCount()) {
                this.output = this.output + resultSetMetaData.getColumnLabel(n);
                if (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = this.output + CSV;
                }
                ++n;
            }
            this.output = this.output + "\n";
            while (resultSet.next()) {
                n = 1;
                n = 1;
                while (n < resultSetMetaData.getColumnCount() - 1) {
                    this.output = resultSet.getString(n) != null ? this.output + resultSet.getString(n).trim() : this.output + "---";
                    this.output = this.output + CSV;
                    ++n;
                }
                this.output = this.output + "" + resultSet.getInt(n + 1) + "\n";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            exception.printStackTrace();
            throw exception;
        }
        sQLMethod.close();
    }

    private String getPartNums() {
        return "('MOB2CTO', 'OPT1CTO', 'OPT1CUS','NET1CUS','MOB1CUS','CDT1CUS','OPT01US','NET01US','MOB01US','CDT01US','NET1CTO','NET1CTO','MOB1CTO','CDT1CTO','266031Z', '2675CTO', '6287CCJ', '6578CTO', '266031U', '10K3780', '633307N','634431U','684910U','686778U','868212Y','6849CTO','865455U','8364CXX','86566RY')";
    }

    public Topic() {
        long l = System.currentTimeMillis();
        try {
            FileUtil.deleteFile(OUTPUT_FILE);
            if (this.connectToOPICM()) {
                LogSystem.log(1, "Connected to OPIC/M");
                System.out.println("Running ES_COUNTRY_SOL");
                this.writeES_COUNTRY_SOL();
                this.writeCounts();
                System.out.println("Getting full ES_COUNTRY_CPSL");
                this.writeFullES_COUNTRY_CPSL();
                System.out.println("Getting full ES_COUNTRY_SOL");
                this.writeFullES_COUNTRY_SOL();
                System.out.println("Getting full ES_COUNTRY_CTO");
                this.writeFullES_COUNTRY_CTO();
                FileUtil.saveFile(OUTPUT_FILE, this.output);
            } else {
                LogSystem.log(1, "Cannot Connect to OPIC/M");
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        System.out.println("Runtime: " + (System.currentTimeMillis() - l) + "(ms)");
        System.exit(0);
    }
}

