/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.db;

import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.DatabaseSystemListener;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.FontUtil;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class DatabaseDlg
extends JDialog
implements ActionListener,
DatabaseSystemListener {
    private static final Color oddLinesColor = new Color(240, 240, 240);
    private static final FontUtil fontUtil = new FontUtil();
    private String[] databaseTitles = new String[]{"", "Name", "Server", "Port", "Busy", "Secondary"};
    private String[] methodTitles = new String[]{"Method Name", "Run Seconds"};
    private MultiList cnr_DATABASES = null;
    private MultiList cnr_METHODS = null;
    private JLabel st_DATABASES = null;
    private JLabel stt_DATABASES = null;
    private JLabel st_METHODS = null;
    private JLabel stt_METHODS = null;
    private DButton pb_OK = null;
    private Database selectedDatabase = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = 18;
        super.doLayout();
        this.st_DATABASES.setBounds(n2, n, 150, n3);
        this.stt_DATABASES.setBounds(n2 + 150, n, 50, n3);
        this.cnr_DATABASES.setBounds(n2, n += n3, dimension.width - 13, n3 * 7);
        this.st_METHODS.setBounds(n2, n += n3 * 8, 150, n3);
        this.stt_METHODS.setBounds(n2 + 150, n, 50, n3);
        this.cnr_METHODS.setBounds(n2, n += n3, dimension.width - 13, dimension.height - 70 - n);
        this.pb_OK.setBounds(n2, dimension.height - 55, 70, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DatabaseSystem.removeDatabaseSystemListener(this);
        this.dispose();
    }

    private void refreshData() {
        Vector vector = DatabaseSystem.getActiveDatabases();
        if (vector != null) {
            this.cnr_DATABASES.removeAll();
            this.cnr_DATABASES.add(vector);
            this.stt_DATABASES.setText("" + vector.size());
            this.cnr_METHODS.add(DatabaseSystem.getActiveMethods());
        }
    }

    public void methodAdded(Database database, SQLMethod sQLMethod) {
        this.cnr_METHODS.add(sQLMethod);
        try {
            this.stt_METHODS.setText("" + this.cnr_METHODS.getData().size());
        }
        catch (Exception exception) {
            this.stt_METHODS.setText("0");
        }
        this.cnr_DATABASES.revalidate();
    }

    public void methodRemoved(Database database, SQLMethod sQLMethod) {
        this.cnr_METHODS.remove(sQLMethod);
        try {
            this.stt_METHODS.setText("" + this.cnr_METHODS.getData().size());
        }
        catch (Exception exception) {
            this.stt_METHODS.setText("0");
        }
        this.cnr_DATABASES.revalidate();
    }

    public void databaseAdded(Database database) {
        this.cnr_DATABASES.add(database);
        this.stt_DATABASES.setText("" + DatabaseSystem.getActiveDatabases().size());
    }

    public void databaseRemoved(Database database) {
        this.cnr_DATABASES.remove(database);
        this.stt_DATABASES.setText("" + DatabaseSystem.getActiveDatabases().size());
    }

    public void dispose() {
        super.dispose();
        ((Frame)this.getParent()).dispose();
    }

    public DatabaseDlg() {
        super(new Frame(), "Database Debug Window", false);
        Container container = this.getContentPane();
        this.cnr_DATABASES = new MultiList(fontUtil);
        this.cnr_METHODS = new MultiList(fontUtil);
        this.st_DATABASES = new JLabel("Active Databases:");
        this.stt_DATABASES = new JLabel("0");
        this.st_METHODS = new JLabel("Active Methods:");
        this.stt_METHODS = new JLabel("0");
        this.pb_OK = new DButton("Ok");
        this.stt_DATABASES.setForeground(Color.blue);
        this.stt_METHODS.setForeground(Color.blue);
        this.cnr_DATABASES.setColumnHeadings(this.databaseTitles);
        this.cnr_METHODS.setColumnHeadings(this.methodTitles);
        this.cnr_DATABASES.setBackground(Color.white);
        this.cnr_DATABASES.setOddLinesColor(oddLinesColor);
        this.cnr_METHODS.setOddLinesColor(oddLinesColor);
        this.cnr_DATABASES.setColumnWidth(0, 20);
        container.setLayout(null);
        container.add(this.cnr_DATABASES);
        container.add(this.st_DATABASES);
        container.add(this.stt_DATABASES);
        container.add(this.st_METHODS);
        container.add(this.stt_METHODS);
        container.add(this.cnr_METHODS);
        container.add(this.pb_OK);
        DatabaseSystem.addDatabaseSystemListener(this);
        this.pb_OK.addActionListener(this);
        ((Component)this).setSize(400, 400);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
        this.refreshData();
    }
}

