/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.db;

import com.ibm.nzna.shared.util.Text;

public class SQLStatement {
    public static final int STMT_QUERY = 0;
    public static final int STMT_INSERT = 1;
    public static final int STMT_UPDATE = 2;
    public static final int STMT_DELETE = 3;
    protected int stmtType = 0;
    protected String[] colNames = null;
    protected String[][] whereColNames = null;
    protected String tableName = "";
    protected Object[] colNamesData = null;
    protected Object[] whereColNamesData = null;
    protected String whereClause = "";

    public void setType(int n) {
        this.stmtType = n;
    }

    private int findColIndex(String string, String[] stringArray) {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        while (n < stringArray.length && n2 == -1) {
            if (stringArray[n].compareTo(string) == 0) {
                n2 = n;
                bl = true;
            }
            ++n;
        }
        return n2;
    }

    private int findColIndex(String string, String[][] stringArray) {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        while (n < stringArray.length && n2 == -1) {
            if (stringArray[n][0].compareTo(string) == 0) {
                n2 = n;
                bl = true;
            }
            ++n;
        }
        return n2;
    }

    public void setColumnData(String string, String string2) {
        int n = this.findColIndex(string, this.colNames);
        if (string2 == null) {
            string2 = "NULL";
        }
        this.colNamesData[n] = string2;
    }

    public void setColumnDataAbsolute(String string, String string2) {
        int n = this.findColIndex(string, this.colNames);
        if (string2 == null) {
            string2 = "NULL";
        }
        this.colNamesData[n] = "'" + string2;
    }

    public void setColumnData(String string, int n) {
        int n2 = this.findColIndex(string, this.colNames);
        this.colNamesData[n2] = new Integer(n);
    }

    public void setColumnData(String string, double d) {
        int n = this.findColIndex(string, this.colNames);
        this.colNamesData[n] = new Double(d);
    }

    public void setColumnData(String string, boolean bl) {
        int n = this.findColIndex(string, this.colNames);
        this.colNamesData[n] = bl ? new String("Y") : new String("N");
    }

    public void setColumnDate(String string, String string2) {
        int n = this.findColIndex(string, this.colNames);
        if (string2 != null && string2.length() > 6) {
            string2 = string2.replace('/', '-');
            this.colNamesData[n] = string2;
        }
    }

    public void setColumnData(int n, String string) {
        if (string == null) {
            string = "NULL";
        }
        this.colNamesData[n] = string;
    }

    public void setColumnData(int n, int n2) {
        this.colNamesData[n] = new Integer(n2);
    }

    public void setColumnData(int n, double d) {
        this.colNamesData[n] = new Double(d);
    }

    public void setColumnData(int n, boolean bl) {
        this.colNamesData[n] = bl ? new String("Y") : new String("N");
    }

    public void setColumnDate(int n, String string) {
        if (string != null && string.length() > 6) {
            string = string.replace('/', '-');
            this.colNamesData[n] = string;
        }
    }

    public void setWhereColumnNames(String[][] stringArray) {
        this.whereColNames = stringArray;
        this.whereColNamesData = new Object[stringArray.length];
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    public void setWhereData(String string, String string2) {
        int n = this.findColIndex(string, this.whereColNames);
        if (n > -1) {
            this.whereColNamesData[n] = string2;
        }
    }

    public void setWhereData(String string, int n) {
        int n2 = this.findColIndex(string, this.whereColNames);
        if (n2 > -1) {
            this.whereColNamesData[n2] = new Integer(n);
        }
    }

    public void setWhereData(String string, double d) {
        int n = this.findColIndex(string, this.whereColNames);
        if (n > -1) {
            this.whereColNamesData[n] = new Double(d);
        }
    }

    public void setWhereData(String string, boolean bl) {
        int n = this.findColIndex(string, this.whereColNames);
        if (n > -1) {
            this.whereColNamesData[n] = bl ? new String("Y") : new String("N");
        }
    }

    private String getData(Object object) {
        String string = "";
        if (object instanceof String) {
            String string2 = (String)object;
            string = !(string2.equals("CURRENT TIMESTAMP") || string2.equals("USER") || string2.equals("NULL") || string2.indexOf("(SELECT") != -1 || string2.indexOf("( SELECT") != -1 || string2.equals("?")) ? "'" + Text.replaceAllStrInStr(string2, "'", "''") + "'" : string2;
        } else if (object instanceof Integer) {
            string = "" + (Integer)object;
        } else if (object instanceof Double) {
            string = "" + (Double)object;
        } else if (object == null) {
            string = "NULL";
        }
        string = string + " ";
        return string;
    }

    private String getAllData() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = null;
        int n = 0;
        while (n < this.colNamesData.length) {
            if (this.colNames[n] != null) {
                stringBuffer.append(this.getData(this.colNamesData[n]) + ", ");
            }
            ++n;
        }
        string = stringBuffer.toString();
        string = string.substring(0, string.length() - 2) + " ";
        return string;
    }

    private String getColNames() {
        String string = "";
        int n = 0;
        while (n < this.colNames.length) {
            if (this.colNames[n] != null) {
                string = string + this.colNames[n] + ", ";
            }
            ++n;
        }
        string = string.substring(0, string.length() - 2);
        return string;
    }

    private String createWhereClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        if (this.whereColNames != null) {
            stringBuffer.append(" WHERE ");
            while (n < this.whereColNames.length) {
                if (this.whereColNames[n][0] != null && this.whereColNames[n][1] != null) {
                    stringBuffer.append(this.whereColNames[n][0]);
                    stringBuffer.append(" = ");
                    stringBuffer.append(this.getData(this.whereColNamesData[n]));
                    if (n != this.whereColNames.length - 1) {
                        stringBuffer.append(this.whereColNames[n][1]);
                    }
                    stringBuffer.append(" ");
                }
                ++n;
            }
        } else {
            return this.whereClause;
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private String createSetClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = null;
        int n = 0;
        if (this.colNames != null) {
            while (n < this.colNames.length) {
                if (this.colNames[n] != null) {
                    stringBuffer.append(this.colNames[n]);
                    stringBuffer.append("=");
                    stringBuffer.append(this.getData(this.colNamesData[n]) + ", ");
                }
                ++n;
            }
        }
        string = stringBuffer.toString();
        string = string.substring(0, string.length() - 2);
        return string;
    }

    public String toString() {
        String string = "";
        switch (this.stmtType) {
            case 0: {
                string = "SELECT " + this.getColNames() + " FROM " + this.tableName + " " + this.createWhereClause() + " FOR FETCH ONLY";
                break;
            }
            case 1: {
                string = "INSERT INTO " + this.tableName + " ( " + this.getColNames() + " ) values ( " + this.getAllData() + " ) ";
                break;
            }
            case 2: {
                string = "UPDATE " + this.tableName + " SET " + this.createSetClause() + this.createWhereClause();
                break;
            }
            case 3: {
                string = "DELETE FROM " + this.tableName + " " + this.createWhereClause();
                break;
            }
        }
        return string;
    }

    public void setColumnNames(String[] stringArray) {
        this.colNames = stringArray;
        this.colNamesData = new Object[stringArray.length];
    }

    public void setColumnNames(int n) {
        this.colNames = new String[n];
        this.colNamesData = new Object[n];
    }

    public void setColumnName(int n, String string) {
        this.colNames[n] = string;
    }

    public void setWhereColumnNames(int n) {
        this.whereColNames = new String[n][2];
        this.whereColNamesData = new Object[n];
    }

    public void setWhereColumnName(int n, String string, String string2) {
        this.whereColNames[n][0] = string;
        this.whereColNames[n][1] = string2;
    }

    public void setWhereData(int n, String string) {
        if (n > -1) {
            this.whereColNamesData[n] = string;
        }
    }

    public void setWhereData(int n, int n2) {
        if (n > -1) {
            this.whereColNamesData[n] = new Integer(n2);
        }
    }

    public void setWhereData(int n, double d) {
        if (n > -1) {
            this.whereColNamesData[n] = new Double(d);
        }
    }

    public void setWhereData(int n, boolean bl) {
        if (n > -1) {
            this.whereColNamesData[n] = bl ? new String("Y") : new String("N");
        }
    }

    public void setColumnData(int n, String string, String string2) {
        this.colNames[n] = string;
        if (string2 == null || string2.length() == 0) {
            string2 = "NULL";
        }
        this.colNamesData[n] = string2;
    }

    public void setColumnData(int n, String string, int n2) {
        this.colNames[n] = string;
        this.colNamesData[n] = new Integer(n2);
    }

    public void setColumnData(int n, String string, double d) {
        this.colNames[n] = string;
        this.colNamesData[n] = new Double(d);
    }

    public void setColumnData(int n, String string, boolean bl) {
        this.colNames[n] = string;
        this.colNamesData[n] = bl ? new String("Y") : new String("N");
    }

    public void setColumnDate(int n, String string, String string2) {
        this.colNames[n] = string;
        if (string2 != null && string2.length() > 6) {
            string2 = string2.replace('/', '-');
            this.colNamesData[n] = string2;
        }
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public int getType() {
        return this.stmtType;
    }

    public SQLStatement() {
    }

    public SQLStatement(String string) {
        this.tableName = string;
    }

    public SQLStatement(int n, String string) {
        this.stmtType = n;
        this.tableName = string;
    }

    public SQLStatement(int n, String string, String[] stringArray) {
        this.stmtType = n;
        this.tableName = string;
        this.setColumnNames(stringArray);
    }

    public SQLStatement(int n, String string, String[] stringArray, String[][] stringArray2) {
        this.stmtType = n;
        this.tableName = string;
        this.setColumnNames(stringArray);
        this.setWhereColumnNames(stringArray2);
    }
}

