/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp.FTP;

import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FTP.StreamTransfer;
import com.ibm.nzna.shared.ftp.FTP.TransferEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.SocketException;

public class StreamGet
extends StreamTransfer {
    protected void before() throws IOException {
        if (!this.restart && this.localFile.exists()) {
            this.localFile.delete();
        }
        this.raf = new RandomAccessFile(this.localFile, "rw");
        if (this.restart) {
            this.raf.seek(this.total);
            this.ftp.command("REST " + this.total);
        }
    }

    protected void doIt() throws IOException {
        InputStream inputStream = null;
        try {
            block10: {
                inputStream = this.dataSocket.getInputStream();
                this.state = new TransferEvent(this.ftp, 1, this.remoteName, this.getHostFileSize());
                if (this.restart) {
                    this.state.setStartsize(this.total);
                }
                this.lastEvent = this.start = System.currentTimeMillis();
                this.ftp.fireTransferStartedEvent(this.state);
                try {
                    if (this.ftp.getType() == 'A') {
                        this.asciiGet(inputStream);
                    } else {
                        this.binaryGet(inputStream);
                    }
                }
                catch (SocketException socketException) {
                    if (this.aborted) break block10;
                    throw socketException;
                }
            }
            this.state.update(this.total, System.currentTimeMillis() - this.start);
            this.state.setState(this.aborted ? 3 : 2);
            this.ftp.fireTransferEndedEvent(this.state);
        }
        finally {
            Object var3_3 = null;
            if (this.raf != null) {
                this.raf.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected void binaryGet(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.ftp.getBufferSize()];
        while ((n = inputStream.read(byArray)) > -1) {
            this.raf.write(byArray, 0, n);
            this.total += (long)n;
            if (System.currentTimeMillis() <= this.lastEvent + 1000L) continue;
            this.lastEvent = System.currentTimeMillis();
            this.state.update(this.total, this.lastEvent - this.start);
            this.ftp.fireTransferProgressEvent(this.state);
        }
    }

    protected void asciiGet(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.ftp.getBufferSize()];
        while ((n = inputStream.read(byArray)) > -1) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                switch (byArray[n4]) {
                    case 13: {
                        if (n3 > 0) {
                            this.raf.write(byArray, n2, n3);
                        }
                        this.raf.write(LINESEP);
                        n3 = 0;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        if (n3++ != 0) break;
                        n2 = n4;
                    }
                }
                ++n4;
            }
            if (n3 > 0) {
                this.raf.write(byArray, n2, n3);
            }
            this.total += (long)n;
            if (System.currentTimeMillis() <= this.lastEvent + 1000L) continue;
            this.lastEvent = System.currentTimeMillis();
            this.state.update(this.total, this.lastEvent - this.start);
            this.ftp.fireTransferProgressEvent(this.state);
        }
    }

    public StreamGet(Ftp ftp, File file, String string) {
        super(ftp, file, string, "RETR " + string);
    }
}

