/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp.FTP;

import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FTP.StreamTransfer;
import com.ibm.nzna.shared.ftp.FTP.TransferEvent;
import com.ibm.nzna.shared.ftp.FtpError;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.SocketException;

public class StreamPut
extends StreamTransfer {
    protected void before() throws FtpError, IOException {
        this.raf = new RandomAccessFile(this.localFile, "r");
        if (this.restart) {
            this.total = this.ftp.size(this.remoteName);
            this.raf.seek(this.total);
            this.ftp.command("REST " + this.total);
        }
    }

    protected void doIt() throws IOException {
        OutputStream outputStream;
        block12: {
            outputStream = null;
            try {
                block11: {
                    outputStream = this.dataSocket.getOutputStream();
                    this.state = new TransferEvent(this.ftp, 2, this.localFile.getName(), this.localFile.length());
                    if (this.restart) {
                        this.state.setStartsize(this.total);
                    }
                    this.lastEvent = this.start = System.currentTimeMillis();
                    this.ftp.fireTransferStartedEvent(this.state);
                    try {
                        if (this.ftp.getType() == 'A') {
                            this.asciiPut(outputStream);
                        } else {
                            this.binaryPut(outputStream);
                        }
                    }
                    catch (SocketException socketException) {
                        if (this.aborted) break block11;
                        throw socketException;
                    }
                }
                this.state.update(this.total, System.currentTimeMillis() - this.start);
                this.state.setState(this.aborted ? 3 : 2);
                this.ftp.fireTransferEndedEvent(this.state);
                if (this.aborted) break block12;
                this.dataSocket.close();
                this.dataSocket = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                if (this.raf != null) {
                    this.raf.close();
                }
                throw throwable;
            }
        }
        Object var3_3 = null;
        if (outputStream != null) {
            outputStream.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }

    protected void binaryPut(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.ftp.getBufferSize()];
        while ((n = this.raf.read(byArray)) > -1) {
            outputStream.write(byArray, 0, n);
            this.total += (long)n;
            if (System.currentTimeMillis() <= this.lastEvent + 1000L) continue;
            this.lastEvent = System.currentTimeMillis();
            this.state.update(this.total, this.lastEvent - this.start);
            this.ftp.fireTransferProgressEvent(this.state);
        }
    }

    protected void asciiPut(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            int n = this.raf.read();
            while (n != -1) {
                switch (n) {
                    case 13: {
                        break;
                    }
                    case 10: {
                        bufferedOutputStream.write(CRLF);
                        this.total += 2L;
                        if (System.currentTimeMillis() <= this.lastEvent + 1000L) break;
                        this.lastEvent = System.currentTimeMillis();
                        this.state.update(this.total, this.lastEvent - this.start);
                        this.ftp.fireTransferProgressEvent(this.state);
                        break;
                    }
                    default: {
                        bufferedOutputStream.write(n);
                        ++this.total;
                    }
                }
                n = this.raf.read();
            }
        }
        finally {
            Object var4_4 = null;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }

    public StreamPut(Ftp ftp, File file, String string, boolean bl) {
        super(ftp, file, string, (bl ? "APPE " : "STOR ") + string);
    }

    public StreamPut(Ftp ftp, File file, boolean bl) {
        this(ftp, file, file.getName(), bl);
    }
}

