/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp.FTP;

import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FTP.TransferEvent;
import com.ibm.nzna.shared.ftp.FtpError;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class Transfer {
    protected static final int CR = 13;
    protected static final int LF = 10;
    static final byte[] CRLF = new byte[]{13, 10};
    protected static final byte[] LINESEP = System.getProperty("line.separator", "\n").getBytes();
    protected static final int PROGRESS_INTERVAL = 1000;
    protected Ftp ftp;
    protected Socket dataSocket;
    protected String command;
    protected boolean aborted;
    TransferEvent state;

    public void start() throws FtpError, IOException {
        this.aborted = false;
        ServerSocket serverSocket = null;
        try {
            this.before();
            serverSocket = this.openDataConnection();
            this.ftp.command(this.command);
            this.dataSocket = serverSocket.accept();
            int n = this.ftp.getTimeout();
            if (n > 0) {
                this.dataSocket.setSoTimeout(n);
            }
            this.doIt();
            if (this.aborted) {
                this.checkAborted();
            }
            this.ftp.readReply();
            int n2 = this.ftp.getReply().getType();
            if (n2 == 4 || n2 == 5) {
                throw new FtpError(this.ftp.getReply());
            }
            this.after();
        }
        finally {
            Object var3_4 = null;
            if (this.dataSocket != null) {
                this.dataSocket.close();
            }
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
    }

    public void abort() {
        this.aborted = true;
        try {
            this.dataSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataSocket = null;
    }

    protected ServerSocket openDataConnection() throws FtpError, IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int n = this.ftp.getTimeout();
        if (n > 0) {
            serverSocket.setSoTimeout(n);
        }
        String string = this.ftp.controlSocket.getLocalAddress().getHostAddress();
        int n2 = serverSocket.getLocalPort();
        this.ftp.command("PORT " + string.replace('.', ',') + "," + ((n2 & 0xFF00) >> 8) + "," + (n2 & 0xFF));
        return serverSocket;
    }

    protected void before() throws FtpError, IOException {
    }

    protected void after() throws FtpError, IOException {
    }

    protected abstract void doIt() throws IOException;

    protected void checkAborted() throws FtpError, IOException {
        if (this.aborted) {
            try {
                this.ftp.command("ABOR");
            }
            catch (FtpError ftpError) {
                // empty catch block
            }
        }
    }

    public Transfer(Ftp ftp, String string) {
        this.ftp = ftp;
        this.command = string;
    }
}

