/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp;

import com.ibm.nzna.shared.pom.PersistentRec;
import java.io.File;

public class FTPFile
extends PersistentRec {
    public static final int PENDING = 0;
    public static final int COMPLETE = 1;
    public static final int ERROR = 2;
    public static final int REC_MOVE_TO_FTP = 10;
    public static final int REC_MOVE_FROM_FTP = 11;
    public static final int REC_COPY_TO_FTP = 12;
    public static final int REC_COPY_FROM_FTP = 13;
    private String remoteFilename = null;
    private String localFilename = null;
    private String remoteDirectory = null;
    private String localDirectory = null;
    private int ftpStatus = 0;
    private long size = 0L;

    public void setRemoteDirectory(String string) {
        this.remoteDirectory = string;
        this.ftpStatus = 0;
    }

    public void setRemoteFilename(String string) {
        this.remoteFilename = string;
        this.ftpStatus = 0;
    }

    public void setLocalDirectory(String string) {
        this.localDirectory = string;
        this.ftpStatus = 0;
    }

    public void setLocalFilename(String string) {
        this.localFilename = string;
        this.ftpStatus = 0;
    }

    public void setSize(long l) {
        this.size = l;
        this.ftpStatus = 0;
    }

    public String getRemoteFilename() {
        return this.remoteFilename;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public String getLocalFilename() {
        return this.localFilename;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public long getSize() {
        return this.size;
    }

    public String getAbsoluteRemote() {
        return this.getRemoteDirectory() + "/" + this.getRemoteFilename();
    }

    public String getAbsoluteLocal() {
        return this.getLocalDirectory() + File.separator + this.getLocalFilename();
    }

    public boolean validForFTP() {
        return this.remoteFilename != null && this.remoteDirectory != null;
    }

    public FTPFile() {
    }

    public FTPFile(String string, String string2) {
        this.setRemoteFilename(string);
        this.setRemoteDirectory(string2);
    }

    public FTPFile(File file) {
        try {
            String string;
            if (!file.isDirectory()) {
                string = file.getAbsolutePath();
                if (string.indexOf(File.separator) >= 0) {
                    string = string.substring(0, string.lastIndexOf(File.separator));
                }
            } else {
                throw new IllegalArgumentException("Cannot FTP a directory");
            }
            this.setLocalFilename(file.getName());
            this.setLocalDirectory(string);
            this.setSize(file.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

