/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.gui.DetailColumnHeader;
import com.ibm.nzna.shared.gui.DetailList;
import com.ibm.nzna.shared.gui.DetailTreeCellRenderer;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListSorter;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DetailJTree
extends JPanel
implements Runnable,
MouseListener,
TreeModelListener,
DetailList {
    private static final String THREAD_RESORT = "RESORT";
    private static final String THREAD_FIRE_ACTION = "FIRE";
    private JScrollPane scrollPane = null;
    private JTree tree = null;
    private DetailColumnHeader titlePanel = null;
    private int columnCount = 0;
    private Vector headings = null;
    private int sortColumn = 0;
    private Panel pnl_SPLIT = null;
    private int sortType = 0;
    private boolean wordWrap = false;
    private Vector actionListeners = new Vector(1);

    private void initialize() {
        if (this.tree == null) {
            this.tree = new JTree();
        }
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setBorder(null);
        this.pnl_SPLIT = new Panel();
        this.setLayout(null);
        this.add(this.scrollPane);
        this.add(this.pnl_SPLIT);
        this.pnl_SPLIT.setVisible(false);
        this.pnl_SPLIT.setBackground(Color.black);
        this.tree.addMouseListener(this);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        super.doLayout();
        this.scrollPane.setBounds(0, 0, dimension.width, dimension.height);
    }

    public JTree getJTree() {
        return this.tree;
    }

    public void setJTree(JTree jTree) {
        this.remove(this.scrollPane);
        this.tree = jTree;
        this.scrollPane = new JScrollPane(jTree);
        this.add(this.scrollPane);
        this.revalidate();
        jTree.getModel().addTreeModelListener(this);
    }

    public void setColumnHeadings(Vector vector) {
        int n = 0;
        int n2 = 0;
        this.titlePanel = new DetailColumnHeader(this);
        this.titlePanel.setPadding(35);
        if (vector == null) {
            this.titlePanel.removeAll();
        } else {
            this.scrollPane.setColumnHeaderView(this.titlePanel);
            n2 = vector.size();
            this.headings = vector;
            while (n < n2) {
                this.titlePanel.addColumn(vector.elementAt(n));
                ++n;
            }
            this.columnCount = n2;
        }
        if (this.tree.getCellRenderer() instanceof DetailTreeCellRenderer) {
            DetailTreeCellRenderer detailTreeCellRenderer = (DetailTreeCellRenderer)this.tree.getCellRenderer();
            detailTreeCellRenderer.setColumnCount(this.columnCount);
        }
    }

    public void setTitlePadding(int n) {
        this.titlePanel.setPadding(n);
    }

    public void setColumnHeadings(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            Vector<Object> vector = new Vector<Object>(objectArray.length);
            while (n < objectArray.length) {
                vector.addElement(objectArray[n++]);
            }
            this.setColumnHeadings(vector);
        }
    }

    public void setColumnHeadingBorder(Border border) {
        this.titlePanel.setColumnHeadingBorder(border);
    }

    public Vector getColumnHeadings() {
        return this.headings;
    }

    public void setSort(int n) {
        if (n == 1 || n == 2) {
            this.sortType = n;
        }
    }

    public void switchSortType() {
        this.sortType = this.sortType == 1 ? 2 : 1;
    }

    public int getSortType() {
        return this.sortType;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int n) {
        this.sortColumn = n;
        this.resort();
    }

    public void showDivider(int n) {
        this.pnl_SPLIT.setVisible(true);
        this.pnl_SPLIT.setBounds(n, 0, 2, this.getSize().height);
    }

    public void hideDivider() {
        this.pnl_SPLIT.setVisible(false);
    }

    public void setColumnWidth(int n, int n2) {
        this.titlePanel.setColumnWidth(n, n2);
        if (this.tree.getCellRenderer() instanceof DetailTreeCellRenderer) {
            DetailTreeCellRenderer detailTreeCellRenderer = (DetailTreeCellRenderer)this.tree.getCellRenderer();
            detailTreeCellRenderer.setPreferredWidth(this.titlePanel.getPreferredSize().width);
            detailTreeCellRenderer.setColumnWidth(n, n2);
        }
        this.refreshExtendedColumnWidths();
        this.refreshColumns();
    }

    private void refreshExtendedColumnWidths(int n, int n2) {
        Vector vector = this.getData();
        int n3 = 0;
        int n4 = vector.size();
        while (n3 < n4) {
            if (vector.elementAt(n3) instanceof ExtendedMultiListRow) {
                ((ExtendedMultiListRow)vector.elementAt(n3)).columnSized(n, n2);
            }
            ++n3;
        }
    }

    public Vector getData() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreeNode treeNode = (TreeNode)defaultTreeModel.getRoot();
        Vector vector = new Vector(10, 100);
        this.getDataFromNode(treeNode, vector);
        return vector;
    }

    private void getDataFromNode(TreeNode treeNode, Vector vector) {
        int n = treeNode.getChildCount();
        if (treeNode != null && n > 0) {
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(treeNode.getChildAt(n2));
                try {
                    this.getDataFromNode(treeNode.getChildAt(n2), vector);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public void refreshExtendedColumnWidths() {
        try {
            Vector vector = this.getData();
            int n = 0;
            int n2 = vector.size();
            int n3 = 0;
            int n4 = this.headings.size();
            while (n < n4) {
                if (this.tree.getCellRenderer() instanceof DetailTreeCellRenderer) {
                    ((DetailTreeCellRenderer)this.tree.getCellRenderer()).setColumnWidth(n, this.getColumnWidth(n));
                }
                ++n;
            }
            n = 0;
            while (n < n2) {
                Object object;
                if (vector.elementAt(n) instanceof MutableTreeWrapper && (object = ((MutableTreeWrapper)vector.elementAt(n)).getDataObject()) instanceof ExtendedMultiListRow) {
                    n3 = 0;
                    while (n3 < n4) {
                        ((ExtendedMultiListRow)object).columnSized(n3, this.getColumnWidth(n3));
                        ++n3;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refreshColumns() {
        try {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            this.refreshColumns(defaultTreeModel, (DefaultMutableTreeNode)defaultTreeModel.getRoot());
            this.invalidate();
            this.scrollPane.invalidate();
            this.scrollPane.revalidate();
            this.revalidate();
            this.scrollPane.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setWordWrap(boolean bl) {
        if (this.tree.getCellRenderer() instanceof DetailTreeCellRenderer) {
            this.wordWrap = bl;
            ((DetailTreeCellRenderer)this.tree.getCellRenderer()).setWordWrap(bl);
        }
    }

    public int getColumnWidth(int n) {
        return this.titlePanel.getColumnWidth(n);
    }

    public int getColumnCount() {
        if (this.titlePanel != null) {
            return this.titlePanel.getColumnCount();
        }
        return 0;
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.refreshExtendedColumnWidths();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.refreshExtendedColumnWidths();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void reset() {
        this.tree.getModel().removeTreeModelListener(this);
        this.tree.getModel().addTreeModelListener(this);
        ((DetailTreeCellRenderer)this.tree.getCellRenderer()).setWordWrap(this.wordWrap);
        if (!this.wordWrap) {
            this.tree.setRowHeight(18);
        } else {
            this.tree.setRowHeight(0);
        }
    }

    private void resort() {
        new Thread((Runnable)this, THREAD_RESORT).start();
    }

    public void resortThread() {
        try {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            this.resort(defaultTreeModel, (DefaultMutableTreeNode)defaultTreeModel.getRoot());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resort(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) throws Exception {
        int n = defaultTreeModel.getChildCount(defaultMutableTreeNode);
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            if (defaultTreeModel.getChildCount(defaultTreeModel.getChild(defaultMutableTreeNode, n2)) > 0) {
                this.resort(defaultTreeModel, (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n2));
                bl = false;
            } else if (!bl) {
                this.resortChildren(defaultTreeModel, defaultMutableTreeNode);
                bl = true;
            }
            ++n2;
        }
    }

    private void resortChildren(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        Vector<Object> vector = new Vector<Object>(n);
        int[] nArray = new int[n];
        while (n2 < n) {
            if (((DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n2)).getChildCount() != 0) continue;
            vector.addElement(defaultTreeModel.getChild(defaultMutableTreeNode, n2++));
        }
        n2 = 1;
        while (n2 < n) {
            ((MutableTreeNode)vector.elementAt(n2++)).removeFromParent();
        }
        new MultiListSorter(vector, this.sortColumn, this.sortType);
        n2 = 0;
        while (n2 < n) {
            defaultMutableTreeNode.add((MutableTreeNode)vector.elementAt(n2));
            nArray[n2] = n2;
            ++n2;
        }
        defaultTreeModel.nodesChanged(defaultMutableTreeNode, nArray);
    }

    private void refreshColumns(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) throws Exception {
        int n = defaultTreeModel.getChildCount(defaultMutableTreeNode);
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            if (defaultTreeModel.getChildCount(defaultTreeModel.getChild(defaultMutableTreeNode, n2)) > 0) {
                this.refreshColumns(defaultTreeModel, (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n2));
                bl = false;
            } else if (!bl) {
                this.refreshColumnsChildren(defaultTreeModel, defaultMutableTreeNode);
                bl = true;
            }
            ++n2;
        }
    }

    private void refreshColumnsChildren(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        Vector<Object> vector = new Vector<Object>(n);
        int[] nArray = new int[n];
        while (n2 < n) {
            if (((DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n2)).getChildCount() != 0) continue;
            vector.addElement(defaultTreeModel.getChild(defaultMutableTreeNode, n2++));
        }
        n2 = 1;
        while (n2 < n) {
            ((MutableTreeNode)vector.elementAt(n2++)).removeFromParent();
        }
        n2 = 0;
        while (n2 < n) {
            defaultMutableTreeNode.add((MutableTreeNode)vector.elementAt(n2));
            nArray[n2] = n2;
            ++n2;
        }
        defaultTreeModel.nodesChanged(defaultMutableTreeNode, nArray);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_RESORT)) {
            this.resortThread();
        } else if (string.equals(THREAD_FIRE_ACTION)) {
            ActionEvent actionEvent = new ActionEvent(this, 0, "");
            int n = 0;
            int n2 = this.actionListeners.size();
            while (n < n2) {
                ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    public void removeActionListener(ActionEvent actionEvent) {
        this.actionListeners.removeElement(actionEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            new Thread((Runnable)this, THREAD_FIRE_ACTION).start();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public JScrollPane getJScrollPane() {
        return this.scrollPane;
    }

    public DetailJTree() {
        this.initialize();
    }

    public DetailJTree(JTree jTree) {
        this.tree = jTree;
        jTree.getModel().addTreeModelListener(this);
        this.initialize();
    }
}

