/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.InfoBoxLayoutMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoBoxPanel
extends JPanel {
    public static final int ACTION_UNDEFINED = 0;
    public static final int ACTION_OK = 1;
    public static final int ACTION_CANCEL = 2;
    public static final int ACTION_YES = 3;
    public static final int ACTION_NO = 4;
    public static final int ICON_INFO = 1;
    public static final int ICON_QUESTION = 2;
    public static final int ICON_ERROR = 3;
    private JButton pb_OK = null;
    private JButton pb_CANCEL = null;
    private JLabel st_DESCRIPT = null;
    private JLabel st_IMAGE = null;
    private String description = null;
    private int iconType = 1;
    private ImageIcon imageIcon = null;
    private String str_OK = "Ok";
    private String str_CANCEL = "Cancel";
    private String str_NO = "No";
    private String str_YES = "Yes";
    private InfoBoxLayoutMgr layoutMgr = null;

    public void createControls() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.setLayout(new BorderLayout(5, 5));
        this.pb_OK = new JButton(this.str_OK);
        buttonPanel.add(this.pb_OK);
        this.pb_CANCEL = new JButton(this.str_CANCEL);
        buttonPanel.add(this.pb_CANCEL);
        this.st_DESCRIPT = new JLabel();
        this.st_IMAGE = new JLabel("");
        this.st_DESCRIPT.setMinimumSize(new Dimension(300, 125));
        this.add((Component)this.st_DESCRIPT, "Center");
        this.add((Component)buttonPanel, "South");
        this.add((Component)this.st_IMAGE, "West");
        this.st_IMAGE.setVerticalAlignment(1);
        this.st_DESCRIPT.setVerticalAlignment(1);
    }

    public void addActionListener(ActionListener actionListener) {
        this.pb_OK.addActionListener(actionListener);
        this.pb_CANCEL.addActionListener(actionListener);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setIconType(int n) {
        this.iconType = n;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.imageIcon.setImage(image);
        }
    }

    public void setImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.imageIcon = imageIcon;
        }
    }

    public void updateDisplay() {
        switch (this.iconType) {
            case 2: {
                this.pb_OK.setText(this.str_YES);
                this.pb_CANCEL.setText(this.str_NO);
                this.pb_CANCEL.setVisible(true);
                break;
            }
            default: {
                this.pb_OK.setText(this.str_OK);
                this.pb_CANCEL.setVisible(false);
                break;
            }
        }
        this.st_DESCRIPT.setText("<html><body><font size=3 face=\"Arial, Helvetica\">" + this.description + "</font></body></html>");
        if (this.imageIcon != null) {
            this.st_IMAGE.setIcon(this.imageIcon);
        }
        this.invalidate();
    }

    public void setYes(String string) {
        this.str_YES = string;
    }

    public void setNo(String string) {
        this.str_NO = string;
    }

    public void setOk(String string) {
        this.str_OK = string;
    }

    public void setCancel(String string) {
        this.str_CANCEL = string;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public int actionEventToBoolean(ActionEvent actionEvent) {
        int n = 0;
        if (actionEvent.getSource() == this.pb_OK) {
            n = 1;
        }
        if (actionEvent.getSource() == this.pb_CANCEL) {
            n = 2;
        }
        if (this.iconType == 2) {
            n += 2;
        }
        return n;
    }

    public InfoBoxPanel() {
        this.createControls();
    }

    public InfoBoxPanel(String string) {
        this.setDescription(string);
        this.createControls();
    }

    public InfoBoxPanel(String string, Image image) {
        this.setDescription(this.description);
        this.setImage(image);
        this.createControls();
    }
}

