/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.spell;

import com.ibm.nzna.shared.spell.JSpellErrorInfo;
import com.ibm.nzna.shared.spell.JSpellToolkit;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;

public class JSpellTestApp
extends Frame {
    Button checkIt = new Button("Check Spelling (GUI)");
    Button rawCheck = new Button("Check Spelling (no GUI)");
    TextArea text = new TextArea("Type your text here", 24, 80);
    JSpellToolkit jst;

    public static void main(String[] stringArray) {
        JSpellTestApp jSpellTestApp = new JSpellTestApp();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                if (event.target == this.checkIt) {
                    this.setTitle("Checking Spelling");
                    this.jst.check(this.text);
                    this.setTitle("Spelling Test Driver");
                }
                if (event.target == this.rawCheck) {
                    JSpellErrorInfo jSpellErrorInfo;
                    this.setTitle("Checking Spelling (no GUI)");
                    System.out.println("Starting Spell Check");
                    this.jst.initRawCheck(this.text.getText());
                    do {
                        if ((jSpellErrorInfo = this.jst.rawCheck()) == null) continue;
                        System.out.println("Misspelled Word: " + jSpellErrorInfo.word);
                        System.out.println("    At Position: " + jSpellErrorInfo.position);
                        System.out.print("    Suggestions: ");
                        if (jSpellErrorInfo.suggestions[0] == null) {
                            System.out.print("None");
                        } else {
                            int n = 0;
                            while (n < 10 && jSpellErrorInfo.suggestions[n] != null) {
                                System.out.print(jSpellErrorInfo.suggestions[n] + " ");
                                ++n;
                            }
                        }
                        System.out.println();
                        System.out.println();
                    } while (jSpellErrorInfo != null);
                    System.out.println("Finished Checking");
                    this.setTitle("Spelling Test Driver");
                }
                return true;
            }
            case 201: {
                this.dispose();
                System.exit(0);
                break;
            }
        }
        return super.handleEvent(event);
    }

    public JSpellTestApp() {
        super("Spelling Client Test Driver");
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(this.checkIt);
        panel.add(this.rawCheck);
        this.add("North", panel);
        this.add("Center", this.text);
        this.pack();
        this.jst = new JSpellToolkit();
        this.show();
    }
}

