/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.spell;

import com.ibm.nzna.shared.spell.Node_D;
import com.ibm.nzna.shared.spell.Node_R;
import com.ibm.nzna.shared.spell.Node_S;
import com.ibm.nzna.shared.spell.j_util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;

public class SpellIndex {
    public static final String version = "sndspell1.0\u001a";
    public static final String defaultName = "SNDSPELL.JDX";
    public static int baseOffset = "sndspell1.0\u001a".length() + 4;
    boolean locked = false;
    File indexFile;
    RandomAccessFile jdx;
    boolean indexReady = false;
    String indexName;
    byte[] nullNode = new byte[28];
    int logicalOffset;
    Hashtable nodeBuffer;
    Hashtable dataBuffer;
    int bufferCapacity = 5;
    int dataBufferCap = 3;
    int dataBufferLimit = 1;
    float totalhits;
    float buffertime;
    int bufferNumber = 0;
    Node_R root;
    boolean verbose = true;

    public final boolean isIndexReady() {
        return this.indexReady;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final boolean add(String string, String string2, Node_S node_S) {
        if (string2.length() > 0) {
            char c = string2.charAt(0);
            int n = c - 48;
            if (node_S.child[n] == 0) {
                node_S.child[n] = this.logicalOffset;
                this.newNode(node_S.child[n]);
                this.updateNode(node_S, n);
            }
            this.add(string, string2.substring(1), this.readNode(node_S.child[n]));
        } else {
            this.addDataNode(node_S, string);
        }
        return true;
    }

    public final boolean add(String string, String string2, Node_R node_R) {
        if (string2.length() > 0) {
            char c = string2.charAt(0);
            int n = c - 65;
            if (node_R.child[n] == 0) {
                node_R.child[n] = this.logicalOffset;
                this.newNode(node_R.child[n]);
                this.updateNode(node_R, n);
            }
            this.add(string, string2.substring(1), this.readNode(node_R.child[n]));
        } else {
            this.updateNode(node_R);
        }
        return true;
    }

    private final void addNode_D(Node_D node_D) throws IOException {
        ++this.bufferNumber;
        node_D.lastAccess = this.bufferNumber;
        this.addNode_DBuffer(node_D);
        this.jdx.seek(baseOffset + node_D.nodeOffset);
        this.jdx.writeUTF(node_D.dataElement);
        this.jdx.writeInt(node_D.nextNodeOffset);
    }

    private final Node_D getNode_D(int n) throws IOException {
        Node_D node_D = new Node_D();
        if (this.dataBuffer.containsKey(new Integer(n))) {
            node_D = (Node_D)this.dataBuffer.get(new Integer(n));
        } else {
            this.jdx.seek(baseOffset + n);
            node_D = new Node_D();
            node_D.nodeOffset = n;
            node_D.dataElement = this.jdx.readUTF();
            node_D.nextNodeOffset = this.jdx.readInt();
            ++this.bufferNumber;
            node_D.lastAccess = this.bufferNumber;
            this.addNode_DBuffer(node_D);
        }
        return node_D;
    }

    private final void addNode_DBuffer(Node_D node_D) {
        if (this.dataBuffer.size() < this.dataBufferCap) {
            this.dataBuffer.put(new Integer(node_D.nodeOffset), node_D);
        } else {
            Enumeration enumeration = this.dataBuffer.keys();
            int n = 0;
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                Node_D node_D2 = (Node_D)this.dataBuffer.get(n3);
                if (node_D2.lastAccess < (long)(this.bufferNumber - this.dataBufferLimit)) {
                    this.dataBuffer.remove(n3);
                    ++n2;
                    continue;
                }
                node_D2.lastAccess = ++n;
            }
            this.bufferNumber = n;
        }
    }

    public final boolean addDataNode(Node_S node_S, String string) {
        try {
            Node_D node_D = null;
            int n = node_S.dataOffset;
            boolean bl = false;
            while (n != 0 && !bl) {
                node_D = this.getNode_D(n);
                if (node_D.dataElement.equals(string)) {
                    bl = true;
                    continue;
                }
                n = node_D.nextNodeOffset;
            }
            if (!bl) {
                if (node_S.dataOffset == 0) {
                    node_S.dataOffset = this.logicalOffset;
                    node_S.lastAccess = System.currentTimeMillis();
                    this.updateNode(node_S);
                } else {
                    node_D.nextNodeOffset = this.logicalOffset;
                    this.addNode_D(node_D);
                }
                Node_D node_D2 = new Node_D();
                node_D2.nodeOffset = this.logicalOffset;
                node_D2.dataElement = string;
                node_D2.nextNodeOffset = 0;
                this.addNode_D(node_D2);
                this.logicalOffset = (int)(this.jdx.getFilePointer() - (long)baseOffset);
                this.writeOffset();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return true;
    }

    public boolean remove(String string) {
        return true;
    }

    public boolean search(String string, String string2, String[] stringArray) throws IOException {
        char c = string.charAt(0);
        int n = c - 65;
        int n2 = 1;
        boolean bl = false;
        if (this.root.child[n] != 0) {
            Node_S node_S = this.readNode(this.root.child[n]);
            while (n2 < string.length() && node_S.child[string.charAt(n2) - 48] != 0) {
                node_S = this.readNode(node_S.child[string.charAt(n2) - 48]);
                ++n2;
            }
            if (node_S.dataOffset != 0) {
                int n3 = 0;
                Node_D node_D = this.getNode_D(node_S.dataOffset);
                if (node_D.dataElement.toUpperCase().equals(string2.toUpperCase())) {
                    bl = true;
                } else if (j_util.eqscore(node_D.dataElement, string2) >= 0.6) {
                    stringArray[0] = node_D.dataElement;
                }
                while (node_D.nextNodeOffset != 0 && !bl) {
                    node_D = this.getNode_D(node_D.nextNodeOffset);
                    if (node_D.dataElement.toUpperCase().equals(string2.toUpperCase())) {
                        bl = true;
                        continue;
                    }
                    if (!(j_util.eqscore(node_D.dataElement, string2) >= 0.6) || n3 >= stringArray.length) continue;
                    stringArray[n3] = node_D.dataElement;
                    ++n3;
                }
            }
        }
        return bl;
    }

    public final boolean build(String string) {
        this.indexFile.delete();
        int n = 0;
        int n2 = 0;
        this.initIndex();
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            while (dataInputStream.available() > 0) {
                String string2 = dataInputStream.readLine();
                this.add(string2, j_util.soundex(string2), this.root);
                if (!this.verbose) continue;
                ++n2;
                if (++n != 100) continue;
                System.out.println("Word " + n2 + " " + string2);
                n = 0;
            }
            dataInputStream.close();
            this.indexReady = true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(0);
        }
        return true;
    }

    public final void initIndex() {
        try {
            this.jdx = new RandomAccessFile(this.indexFile, "rw");
            this.jdx.seek(0L);
            this.jdx.writeBytes(version);
            this.logicalOffset = 0;
            this.writeOffset();
            this.root = new Node_R();
            this.root.nodeOffset = 0;
            try {
                this.jdx.seek(baseOffset);
                int n = 0;
                while (n < 26) {
                    this.jdx.writeInt(0);
                    ++n;
                }
                this.logicalOffset += 104;
                this.writeOffset();
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public final boolean updateNode(Node_R node_R, int n) {
        try {
            this.jdx.seek(baseOffset + node_R.nodeOffset + n * 4);
            this.jdx.writeInt(node_R.child[n]);
        }
        catch (Exception exception) {
            System.out.println("updateNode: " + exception);
            System.out.println(node_R.toString());
            exception.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean updateNode(Node_R node_R) {
        try {
            this.jdx.seek(baseOffset + node_R.nodeOffset);
            int n = 0;
            while (n < 26) {
                this.jdx.writeInt(node_R.child[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("updateNode: " + exception);
            System.out.println(node_R.toString());
            exception.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean updateNode(Node_S node_S, int n) {
        try {
            this.jdx.seek(baseOffset + node_S.nodeOffset + n * 4);
            this.jdx.writeInt(node_S.child[n]);
        }
        catch (Exception exception) {
            System.out.println("updateNode: " + exception);
            System.out.println(node_S.toString());
            exception.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean updateNode(Node_S node_S) {
        try {
            this.jdx.seek(baseOffset + node_S.nodeOffset);
            int n = 0;
            while (n < 7) {
                this.jdx.writeInt(node_S.child[n]);
                ++n;
            }
            this.jdx.writeInt(node_S.dataOffset);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean newNode(int n) {
        try {
            this.jdx.seek(baseOffset + n);
            this.jdx.write(this.nullNode);
            this.jdx.writeInt(0);
            this.logicalOffset += 32;
            this.writeOffset();
        }
        catch (Exception exception) {
            System.out.println("NEW NODE: " + exception);
            exception.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public Node_S readNode(int n) {
        Node_S node_S;
        if (this.nodeBuffer.containsKey(new Integer(n))) {
            node_S = (Node_S)this.nodeBuffer.get(new Integer(n));
            this.totalhits += 1.0f;
            this.buffertime += (float)(System.currentTimeMillis() - node_S.lastAccess);
            node_S.lastAccess = System.currentTimeMillis();
        } else {
            node_S = new Node_S();
            try {
                this.jdx.seek(baseOffset + n);
                int n2 = 0;
                while (n2 < 7) {
                    node_S.child[n2] = this.jdx.readInt();
                    ++n2;
                }
                node_S.dataOffset = this.jdx.readInt();
                node_S.nodeOffset = n;
            }
            catch (IOException iOException) {
                System.out.println("READ NODE: " + iOException);
                System.out.println("Trying to read logical offset " + Integer.toHexString(n));
                System.out.println("Trying to read actual offset " + Integer.toHexString(baseOffset + n));
                iOException.printStackTrace();
                System.exit(-1);
            }
            node_S.lastAccess = System.currentTimeMillis();
            if (this.nodeBuffer.size() < this.bufferCapacity) {
                this.nodeBuffer.put(new Integer(n), node_S);
            } else {
                Enumeration enumeration = this.nodeBuffer.keys();
                int n3 = 0;
                while (enumeration.hasMoreElements()) {
                    Integer n4 = (Integer)enumeration.nextElement();
                    if (!((float)(System.currentTimeMillis() - ((Node_S)this.nodeBuffer.get((Object)n4)).lastAccess) > this.buffertime / this.totalhits * 2.0f)) continue;
                    this.nodeBuffer.remove(n4);
                    ++n3;
                }
                this.buffertime = 0.0f;
                this.totalhits = 0.0f;
            }
        }
        return node_S;
    }

    public final void writeOffset() {
        try {
            this.jdx.seek(baseOffset - 4);
            this.jdx.writeInt(this.logicalOffset);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public SpellIndex() {
        this(defaultName);
    }

    public SpellIndex(String string) {
        int n = 0;
        while (n < 28) {
            this.nullNode[n] = 0;
            ++n;
        }
        this.nodeBuffer = new Hashtable(this.bufferCapacity);
        this.dataBuffer = new Hashtable(this.dataBufferCap);
        this.totalhits = 0.0f;
        this.buffertime = 0.0f;
        this.indexFile = new File(defaultName);
        if (this.indexFile.exists()) {
            try {
                this.jdx = new RandomAccessFile(this.indexFile, "rw");
                this.jdx.seek(baseOffset - 4);
                this.logicalOffset = this.jdx.readInt();
                this.root = new Node_R();
                this.root.nodeOffset = 0;
                try {
                    this.jdx.seek(baseOffset);
                    n = 0;
                    while (n < 26) {
                        this.root.child[n] = this.jdx.readInt();
                        ++n;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    exception.printStackTrace();
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
            this.indexReady = true;
        } else {
            this.indexReady = false;
        }
        if (this.indexReady) {
            this.indexName = defaultName;
        }
    }
}

