/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.spell;

import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.spell.JSpellErrorInfo;
import com.ibm.nzna.shared.spell.JSpellToolkit;
import com.ibm.nzna.shared.spell.SpellChecker;
import com.ibm.nzna.shared.spell.SpellPanelListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpellPanel
extends JPanel
implements Runnable,
ListSelectionListener,
ActionListener {
    private JLabel st_SPELL = null;
    private JLabel st_SPELL_CHECKING = null;
    private JLabel st_REPLACE_WITH = null;
    private DButton pb_REPLACE = null;
    private DButton pb_IGNORE = null;
    private DButton pb_IGNORE_ALL = null;
    private DButton pb_LEARN = null;
    private DButton pb_STOP = null;
    private JList lb_SUGGESTIONS = null;
    private JScrollPane scr_SUGGESTIONS = null;
    private JTextField ef_REPLACE_WITH = null;
    private JPanel buttonPanel = null;
    private JSpellToolkit spellToolkit = null;
    private Dimension prefSize = new Dimension(200, 58);
    private Vector listeners = null;
    private String currentText = null;
    private boolean controlsEnabled = false;
    private JSpellErrorInfo errorInfo = null;
    private boolean foundErrors = false;

    private void initializeGUI() {
        this.st_SPELL = new JLabel("Spell Checker");
        this.st_SPELL_CHECKING = new JLabel("Checking the spelling");
        this.st_REPLACE_WITH = new JLabel("Replace With:");
        this.ef_REPLACE_WITH = new JTextField("");
        this.pb_REPLACE = new DButton("Replace");
        this.pb_IGNORE = new DButton("Ignore");
        this.pb_IGNORE_ALL = new DButton("Ignore All");
        this.pb_LEARN = new DButton("Learn");
        this.pb_STOP = new DButton("Stop");
        this.lb_SUGGESTIONS = new JList();
        this.scr_SUGGESTIONS = new JScrollPane(this.lb_SUGGESTIONS);
        this.buttonPanel = new JPanel();
        this.pb_LEARN.addActionListener(this);
        this.pb_IGNORE_ALL.addActionListener(this);
        this.pb_REPLACE.addActionListener(this);
        this.pb_IGNORE.addActionListener(this);
        this.pb_STOP.addActionListener(this);
        this.lb_SUGGESTIONS.addListSelectionListener(this);
        this.ef_REPLACE_WITH.addActionListener(this);
        this.st_SPELL.setFont(new Font("Helv", 1, 12));
        this.buttonPanel.setBorder(new BevelBorder(1));
        this.buttonPanel.setBackground(new Color(150, 150, 150));
        this.setOpaque(false);
        this.setLayout(null);
        this.add(this.st_SPELL);
        this.add(this.ef_REPLACE_WITH);
        this.add(this.st_REPLACE_WITH);
        this.add(this.scr_SUGGESTIONS);
        this.add(this.st_SPELL_CHECKING);
        this.add(this.buttonPanel);
        this.buttonPanel.setLayout(new GridLayout(3, 2, 2, 2));
        this.buttonPanel.add(this.pb_REPLACE);
        this.buttonPanel.add(this.pb_LEARN);
        this.buttonPanel.add(this.pb_IGNORE);
        this.buttonPanel.add(this.pb_IGNORE_ALL);
        this.buttonPanel.add(this.pb_STOP);
        this.enableControls(false);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 2;
        int n2 = 2;
        super.doLayout();
        this.st_SPELL.setBounds(n, n2, 150, 18);
        this.st_REPLACE_WITH.setBounds(n, n2 + 18, 150, 18);
        this.ef_REPLACE_WITH.setBounds(n, n2 + 36, 150, 18);
        this.scr_SUGGESTIONS.setBounds(n += 155, n2, 200, 54);
        this.buttonPanel.setBounds(n += 210, n2, 200, 54);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ef_REPLACE_WITH || actionEvent.getSource() == this.pb_REPLACE) {
            this.notifyReplaceWord(this.errorInfo.getWord(), this.ef_REPLACE_WITH.getText(), this.errorInfo.getPosition());
            this.currentText = this.currentText.substring(0, this.errorInfo.getPosition()) + this.ef_REPLACE_WITH.getText() + this.currentText.substring(this.errorInfo.getPosition() + this.errorInfo.getWord().length());
            this.spellToolkit.initRawCheck(this.currentText);
            new Thread(this).start();
        } else if (actionEvent.getSource() == this.pb_LEARN) {
            if (this.errorInfo.getWord() != null) {
                this.spellToolkit.addLearned(this.errorInfo.getWord());
            }
            new Thread(this).start();
        } else if (actionEvent.getSource() == this.pb_STOP) {
            this.stopSpellCheck();
        } else if (actionEvent.getSource() == this.pb_IGNORE || actionEvent.getSource() == this.pb_IGNORE_ALL) {
            if (this.errorInfo.getWord() != null) {
                this.spellToolkit.addIgnore(this.errorInfo.getWord());
            }
            new Thread(this).start();
        }
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void enableControls(boolean bl) {
        this.st_SPELL.setEnabled(bl);
        this.st_SPELL_CHECKING.setEnabled(bl);
        this.st_REPLACE_WITH.setEnabled(bl);
        this.pb_REPLACE.setEnabled(bl);
        this.pb_IGNORE.setEnabled(bl);
        this.pb_IGNORE_ALL.setEnabled(bl);
        this.pb_LEARN.setEnabled(bl);
        this.pb_STOP.setEnabled(bl);
        this.lb_SUGGESTIONS.setEnabled(bl);
        this.scr_SUGGESTIONS.setEnabled(bl);
        this.ef_REPLACE_WITH.setEnabled(bl);
        this.buttonPanel.setEnabled(bl);
        this.controlsEnabled = bl;
    }

    public void addSpellPanelListener(SpellPanelListener spellPanelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(spellPanelListener);
    }

    public void removeSpellPanelListener(SpellPanelListener spellPanelListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(spellPanelListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public void spellCheck(String string) {
        if (this.currentText != null) {
            this.stopSpellCheck();
        }
        this.currentText = string;
        this.startSpellCheck();
        new Thread(this).start();
    }

    public void run() {
        if (this.controlsEnabled) {
            this.enableControls(false);
        }
        this.errorInfo = this.spellToolkit.rawCheck();
        if (this.errorInfo != null) {
            this.foundErrors = true;
            this.notifySpellCheckWord(this.errorInfo.getWord(), this.errorInfo.getPosition(), this.errorInfo.getEndPosition());
            this.lb_SUGGESTIONS.setListData(this.errorInfo.getSuggestions());
            this.ef_REPLACE_WITH.setText(this.errorInfo.getWord());
            this.enableControls(true);
        } else {
            this.stopSpellCheck();
        }
    }

    private void stopSpellCheck() {
        this.lb_SUGGESTIONS.setListData(new Vector(1));
        this.ef_REPLACE_WITH.setText("");
        this.enableControls(false);
        this.spellToolkit = null;
        this.currentText = null;
        this.notifySpellCheckComplete(this.foundErrors);
    }

    private void startSpellCheck() {
        new SpellChecker();
        this.spellToolkit = SpellChecker.getToolkit();
        this.foundErrors = false;
        this.spellToolkit.initRawCheck(this.currentText);
    }

    private void notifySpellCheckWord(String string, int n, int n2) {
        if (this.listeners != null) {
            int n3 = 0;
            int n4 = this.listeners.size();
            while (n3 < n4) {
                ((SpellPanelListener)this.listeners.elementAt(n3)).spellCheckWord(string, n, n2);
                ++n3;
            }
        }
    }

    private void notifyReplaceWord(String string, String string2, int n) {
        if (this.listeners != null) {
            int n2 = 0;
            int n3 = this.listeners.size();
            while (n2 < n3) {
                ((SpellPanelListener)this.listeners.elementAt(n2)).replaceWord(string, string2, n);
                ++n2;
            }
        }
    }

    private void notifySpellCheckComplete(boolean bl) {
        if (this.listeners != null) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((SpellPanelListener)this.listeners.elementAt(n)).spellCheckComplete(bl);
                ++n;
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.ef_REPLACE_WITH.setText((String)this.lb_SUGGESTIONS.getSelectedValue());
        }
    }

    public SpellPanel() {
        this.initializeGUI();
    }
}

