/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.spell;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;

public class j_util {
    public static byte i;
    public static byte curchar;
    public static byte decompChar;
    public static byte accumulator;
    public static byte aCurbit;
    public static byte wCurbit;
    public static int inLen;
    public static String out;
    public static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final char[] SoundexTable;

    public static void centerDialog(Dialog dialog, Frame frame) {
        Dimension dimension = frame.getToolkit().getScreenSize();
        int n = dialog.bounds().width;
        int n2 = dialog.bounds().height;
        int n3 = frame.location().x + frame.bounds().width / 2 - n / 2;
        int n4 = frame.location().y + frame.bounds().height / 2 - n2 / 2;
        if (n3 < 0) {
            n3 = 10;
        }
        if (n4 < 0) {
            n4 = 10;
        }
        if (n3 + n > dimension.width) {
            n3 = dimension.width - n - 10;
        }
        if (n4 + n2 > dimension.height) {
            n4 = dimension.height - n2 - 10;
        }
        dialog.reshape(n3, n4, n, n2);
    }

    public static String compWord(String string) {
        out = "";
        accumulator = 0;
        aCurbit = (byte)7;
        string = string.toUpperCase();
        inLen = string.length();
        i = 0;
        while (i < inLen) {
            curchar = (byte)string.charAt(i);
            if (curchar < 65 || curchar > 90) {
                return "";
            }
            curchar = (byte)(curchar - 64);
            wCurbit = (byte)4;
            while (wCurbit >= 0) {
                if (aCurbit < 0) {
                    out = out + (char)accumulator;
                    accumulator = 0;
                    aCurbit = (byte)7;
                }
                accumulator = (byte)(accumulator + ((int)Math.pow(2.0, aCurbit) * ((int)Math.pow(2.0, wCurbit) & curchar) >>> wCurbit));
                aCurbit = (byte)(aCurbit - 1);
                wCurbit = (byte)(wCurbit - 1);
            }
            i = (byte)(i + 1);
        }
        if (accumulator != 0) {
            out = out + (char)accumulator;
        }
        return out;
    }

    public static String decompWord(String string) {
        out = "";
        accumulator = 0;
        aCurbit = (byte)4;
        inLen = string.length();
        i = 0;
        while (i < inLen) {
            decompChar = (byte)string.charAt(i);
            wCurbit = (byte)7;
            while (wCurbit >= 0) {
                if (aCurbit < 0 && accumulator != 0) {
                    out = out + (char)(accumulator + 64);
                    accumulator = 0;
                    aCurbit = (byte)4;
                }
                accumulator = (byte)(accumulator + ((int)Math.pow(2.0, aCurbit) * ((int)Math.pow(2.0, wCurbit) & decompChar) >>> wCurbit));
                aCurbit = (byte)(aCurbit - 1);
                wCurbit = (byte)(wCurbit - 1);
            }
            i = (byte)(i + 1);
        }
        if (accumulator != 0) {
            out = out + (char)(accumulator + 64);
        }
        return out;
    }

    public static double soundexsim(String string, String string2) {
        return j_util.eqscore(j_util.soundex(string, false), j_util.soundex(string2, false));
    }

    public static double eqscore(String string, String string2) {
        return j_util.eqscore(string, string2, 'E');
    }

    public static double eqscore(String string, String string2, char c) {
        double d = 0.0;
        if ((string = string.toUpperCase().trim()).equals(string2 = string2.toUpperCase().trim())) {
            d = 1.0;
        } else if (string.equals("") || string2.equals("")) {
            d = 0.0;
        } else {
            CharSequence charSequence;
            double d2 = 0.0;
            double d3 = 0.0;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string.length() > string2.length()) {
                charSequence = new String(string);
                string = string2;
                string2 = charSequence;
                charSequence = null;
            }
            charSequence = new StringBuffer(string);
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n4 = ((StringBuffer)charSequence).length();
            int n5 = stringBuffer.length();
            d2 = j_util.addseries(n5);
            int n6 = 0;
            while (n6 < n4) {
                if (c == 'F') {
                    d3 = (double)(n5 - n6) / d2;
                } else if (c == 'E') {
                    d3 = 1.0 / (double)n5;
                }
                if (((StringBuffer)charSequence).charAt(n6) == stringBuffer.charAt(n6)) {
                    ++n;
                    d += d3;
                } else if (n4 - 1 > n6 && n4 != n5 && ((StringBuffer)charSequence).charAt(n6) == stringBuffer.charAt(n6 + 1) && ((StringBuffer)charSequence).charAt(n6 + 1) != stringBuffer.charAt(n6 + 1)) {
                    ++n2;
                    ((StringBuffer)charSequence).insert(n6, stringBuffer.charAt(n6 + 1));
                    ++n4;
                } else if (n4 - 1 > n6 && (((StringBuffer)charSequence).charAt(n6 + 1) == stringBuffer.charAt(n6) || stringBuffer.charAt(n6 + 1) == ((StringBuffer)charSequence).charAt(n6))) {
                    if (((StringBuffer)charSequence).charAt(n6 + 1) == stringBuffer.charAt(n6) && stringBuffer.charAt(n6 + 1) == ((StringBuffer)charSequence).charAt(n6)) {
                        d += d3 / 2.0;
                    }
                    ++n3;
                    char c2 = ((StringBuffer)charSequence).charAt(n6);
                    ((StringBuffer)charSequence).setCharAt(n6, ((StringBuffer)charSequence).charAt(n6 + 1));
                    ((StringBuffer)charSequence).setCharAt(n6 + 1, c2);
                }
                ++n6;
            }
        }
        return d;
    }

    public static double factorial(int n) {
        return n > 1 ? (double)n * j_util.factorial(n - 1) : 1.0;
    }

    public static double addseries(int n) {
        return n > 1 ? (double)n + j_util.addseries(n - 1) : 1.0;
    }

    public static String soundex(String string) {
        return j_util.soundex(string, true);
    }

    public static String soundex(String string, boolean bl) {
        int n = 0;
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer("    ");
        String string2 = string.toUpperCase();
        int n2 = 0;
        while (n2 < string2.length() && n < 4) {
            char c2 = string2.charAt(n2);
            if (!Character.isLetter(c2)) break;
            char c3 = SoundexTable[alphabet.indexOf(c2)];
            if (n == 0) {
                stringBuffer.setCharAt(n, c2);
                ++n;
                c = ' ';
            } else {
                if (c3 != c && c3 != '0') {
                    stringBuffer.setCharAt(n, c3);
                    ++n;
                }
                c = c3;
            }
            ++n2;
        }
        if (bl) {
            while (n < 4) {
                stringBuffer.setCharAt(n, '0');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        int n = (int)(j_util.eqscore(stringArray[0], stringArray[1]) * 100.0);
        int n2 = (int)(j_util.soundexsim(stringArray[0], stringArray[1]) * 100.0);
        int n3 = (n + n2) / 2;
        System.out.println("   Plain Similarity: " + n);
        System.out.println("Phonetic Similarity: " + n2);
        System.out.println(" Average Similarity: " + n3);
    }

    static {
        SoundexTable = new char[]{'0', '1', '2', '3', '0', '1', '2', '0', '0', '2', '2', '4', '5', '5', '0', '1', '2', '6', '2', '3', '0', '1', '0', '2', '0', '2'};
    }
}

