/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.util;

import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.Log;
import com.ibm.nzna.shared.util.LogSystemStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class LogSystem {
    private static String defaultLogFile = null;
    private static int logDebugLevel = 0;
    private static LogSystem instance = null;
    private static boolean provideGUI = true;
    private static Vector alias = null;
    private boolean errRedirect = false;
    private boolean outRedirect = false;

    public static void log(int n, String string) {
        if (LogSystem.getInstance() == null) {
            System.out.println(string);
        } else if (n == 0) {
            Log.log(defaultLogFile, string + "\n");
            LogSystem.logAlias(string + "\n");
        } else if (logDebugLevel <= n) {
            Log.log(defaultLogFile, string + "\n");
            LogSystem.logAlias(string + "\n");
        }
    }

    public static void log(int n, Exception exception) {
        String string = "";
        if (LogSystem.getInstance() == null) {
            exception.printStackTrace();
        } else {
            try {
                if (logDebugLevel <= n) {
                    string = Log.log(defaultLogFile, exception);
                    LogSystem.logAlias(exception);
                    Log.log(defaultLogFile, "-----------------------------------------\n");
                    LogSystem.logAlias("-----------------------------------------\n");
                }
            }
            catch (Exception exception2) {
                System.out.println("Could not log Message:\n----------------------------------");
                exception.printStackTrace();
                System.out.println("\n\nReceived Exception during log:\n");
                exception2.printStackTrace();
            }
        }
    }

    public static void log(int n, Exception exception, boolean bl) {
        String string = "";
        if (LogSystem.getInstance() == null) {
            exception.printStackTrace();
        } else {
            try {
                if (logDebugLevel <= n) {
                    string = Log.log(defaultLogFile, exception);
                    LogSystem.logAlias(exception);
                    Log.log(defaultLogFile, "-----------------------------------------\n");
                    LogSystem.logAlias("-----------------------------------------\n");
                }
            }
            catch (Exception exception2) {
                System.out.println("Could not log Message:\n----------------------------------");
                exception.printStackTrace();
                System.out.println("\n\nReceived Exception during log:\n");
                exception2.printStackTrace();
            }
        }
    }

    public static void beginLogSection(String string) {
        if (LogSystem.getInstance() != null) {
            String string2 = Log.beginLogSection(defaultLogFile, string);
            LogSystem.logAlias(string2);
        }
    }

    public static void endLogSection() {
        if (LogSystem.getInstance() != null) {
            String string = Log.endLogSection(defaultLogFile);
            Log.log(defaultLogFile, "\n\n\n");
            LogSystem.logAlias(string + "\n\n\n");
        }
    }

    public static LogSystem getInstance() {
        return instance;
    }

    public static void setDebugLevel(int n) {
        logDebugLevel = n;
    }

    public void setLogFile(int n, String string) {
        defaultLogFile = string;
        Log.clearLogFile(string);
        instance = this;
        if (this.errRedirect) {
            this.setErr();
        }
        if (this.outRedirect) {
            this.setOut();
        }
    }

    public static void setProvideGUI(boolean bl) {
        provideGUI = bl;
    }

    public static void showLogWindow(boolean bl) {
    }

    public static int getDebugLevel() {
        return logDebugLevel;
    }

    public void setErr() {
        System.setErr(new LogSystemStream(this));
        this.errRedirect = true;
    }

    public void setOut() {
        System.setOut(new LogSystemStream(this));
        this.outRedirect = true;
    }

    public static void addAlias(String string) {
        if (LogSystem.getInstance() != null) {
            if (alias == null) {
                alias = new Vector(1);
            }
            alias.addElement(string);
        }
    }

    public static void removeAlias(String string) {
        if (LogSystem.getInstance() != null && alias != null) {
            alias.removeElement(string);
            if (alias.size() == 0) {
                alias = null;
            }
        }
    }

    public static void logAlias(String string) {
        if (LogSystem.getInstance() != null && alias != null) {
            int n = 0;
            int n2 = alias.size();
            while (n < n2) {
                Log.log((String)alias.elementAt(n), string);
                ++n;
            }
        }
    }

    public static void logAlias(Exception exception) {
        if (LogSystem.getInstance() != null && alias != null) {
            int n = 0;
            int n2 = alias.size();
            while (n < n2) {
                Log.log((String)alias.elementAt(n), exception);
                ++n;
            }
        }
    }

    public static void logExceptionToFile(Throwable throwable, String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        FileUtil.saveFile(string, string2);
    }

    public LogSystem(int n, String string) {
        this.setLogFile(n, string);
        instance = this;
    }

    public LogSystem() {
    }
}

