/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.CommandLineListener;
import com.ibm.wizard.platform.linux.JProcessCommand;
import com.ibm.wizard.platform.linux.LinuxCalderaCommands;
import com.ibm.wizard.platform.linux.LinuxRedHatCommands;
import com.ibm.wizard.platform.linux.LinuxSuseCommands;
import com.ibm.wizard.platform.linux.LinuxTurboCommands;
import com.ibm.wizard.platform.linux.UnixCrypt;
import com.installshield.util.LibraryLoader;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.IOException;
import java.net.URL;

public class GenericLinuxCommands {
    protected static String sh = "sh";
    protected static String c = "-c";
    protected static String[] distributions;
    protected static String[] versions;
    public static final int GETFILEATTRIBUTES = 0;
    public static final int GETFILEOWNER = 1;
    public static final int GETFILEOWNERGROUP = 2;
    public static final int GETFILESIZE = 3;
    protected static CommandLineListener commandListener;
    protected static String[] cmdArray;
    protected static JProcessCommand process;
    UnixCrypt encryptPassword;
    LinuxCalderaCommands lcc;

    protected native void addUser(String var1, String var2, int var3, int var4, String var5, String var6);

    public void changeFileGroup(String string, String string2) {
        this.chown(string2, null, string);
    }

    public void changeFileOwner(String string, String string2) {
        this.chown(string2, string, null);
    }

    public void changeFilePermissions(int n, String string) {
        this.chmod(string, n);
    }

    protected native void chmod(String var1, int var2);

    protected native void chown(String var1, String var2, String var3);

    public void copyFiles(String string, String string2, String string3) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("cp " + string3 + " " + string + " " + string2);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string4 = commandListener.getOutput();
    }

    public void createGroup(GroupSpecification groupSpecification) {
        String string = "groupadd ";
        string = String.valueOf(string) + groupSpecification.getGroupName();
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray(string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string2 = commandListener.getOutput();
    }

    public void createUser(UserSpecification userSpecification) {
        String string;
        String[] stringArray = new String[1];
        String string2 = null;
        String string3 = "useradd ";
        String string4 = userSpecification.getHomeDirectory();
        if (string4 != null) {
            string3 = String.valueOf(string3) + "-d " + string4 + " ";
        }
        if ((string = userSpecification.getUserFullName()) != null) {
            string3 = String.valueOf(string3) + "-c \"" + string + "\" ";
        }
        string3 = String.valueOf(string3) + "-m ";
        String string5 = userSpecification.getPassword();
        if (string5 != null) {
            string2 = UnixCrypt.crypt((String)this.getRandomSalt(), (String)string5);
            if (!LinuxCalderaCommands.isValidDistribution()) {
                string3 = String.valueOf(string3) + "-p " + string2 + " ";
            }
        }
        string3 = String.valueOf(string3) + userSpecification.getUserName();
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray(string3);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string6 = commandListener.getOutput();
    }

    public void createUserHomeDirectory(String string, String string2, String string3) {
        this.copyFiles("/etc/skel", "/home/skel/", "-r");
        this.moveFiles("/home/skel", string, "");
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("chown -R " + string2 + "." + string3 + " " + string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string4 = commandListener.getOutput();
    }

    public void deleteGroup(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("groupdel \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void deleteUser(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("userdel \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public boolean doesRPMPackageExist(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -qa | grep -x \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string2 = commandListener.getOutput();
        if (string2.indexOf(10) != -1) {
            string2 = string2.substring(0, string2.lastIndexOf(10));
        }
        return string2.equals(string);
    }

    public String doesUserExist(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("cat /etc/passwd | grep \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String fileSystemInfo(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("df " + string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String fileSystemType(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("df -T " + string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String findRPMPackage(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -qa | grep -x \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string2 = commandListener.getOutput();
        if (string2.indexOf(10) != -1) {
            return string2.substring(0, string2.lastIndexOf(10));
        }
        return string2;
    }

    protected static String[] getCommandArray(String string) {
        String[] stringArray = new String[]{sh, c, string};
        return stringArray;
    }

    public String getEnvVariable(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("echo $" + string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String getKernelVersion() {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("uname -r");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String getRPMName(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -qp \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    protected String getRandomSalt() {
        int[] nArray = new int[62];
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 48;
        while (n3 < 58) {
            nArray[n++] = n3++;
        }
        int n4 = 65;
        while (n4 < 91) {
            nArray[n++] = n4++;
        }
        int n5 = 97;
        while (n5 < 123) {
            nArray[n++] = n5++;
        }
        n2 = (int)(Math.random() * 62.0);
        stringBuffer.append((char)nArray[n2]);
        n2 = (int)(Math.random() * 62.0);
        stringBuffer.append((char)nArray[n2]);
        return stringBuffer.toString();
    }

    public void initialized(URL uRL) throws IOException {
        LibraryLoader.loadLibrary(uRL, "libgenericlinuxcommands.so");
    }

    public CommandLineListener installRPMPackage(String string, String string2) {
        commandListener = new CommandLineListener();
        if (string2 == null) {
            string2 = "";
        }
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -i " + string2 + " \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener;
    }

    public static boolean isValidDistribution() {
        return true;
    }

    public void kpanelRestart() {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("kwmcom kpanel:restart");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public String listContents(String string, int n) {
        switch (n) {
            case 0: {
                int n2 = this.statGetAttributes(string);
                return new Integer(n2).toString();
            }
            case 1: {
                return this.statGetFileOwner(string);
            }
            case 2: {
                return this.statGetFileOwnerGroup(string);
            }
            case 3: {
                long l = this.statGetFileSize(string);
                return new Long(l).toString();
            }
        }
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("ls -A1 " + string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String locateExecutable(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("type -path \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string2 = commandListener.getOutput();
        if (string2.indexOf(10) != -1) {
            string2 = string2.substring(0, string2.lastIndexOf(10));
        }
        return string2;
    }

    public void makeDirectory(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("mkdir -p \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void modifyUserPassword(String string, String string2) {
    }

    public String mountInfo() {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("mount");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public void moveFiles(String string, String string2, String string3) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("mv " + string3 + " " + string + " " + string2);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String string4 = commandListener.getOutput();
    }

    public void removeFiles(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rm -rf \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public CommandLineListener removeRPMPackage(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -e --allmatches \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener;
    }

    public final GenericLinuxCommands returnCorrectDistribution() {
        if (LinuxRedHatCommands.isValidDistribution()) {
            return new LinuxRedHatCommands();
        }
        if (LinuxTurboCommands.isValidDistribution()) {
            return new LinuxTurboCommands();
        }
        if (LinuxCalderaCommands.isValidDistribution()) {
            return new LinuxCalderaCommands();
        }
        if (LinuxSuseCommands.isValidDistribution()) {
            return new LinuxSuseCommands();
        }
        return null;
    }

    public void runRpmspec(String string) {
        String string2 = this.locateExecutable("rpmspec");
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray(String.valueOf(string2) + " \"" + string + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    protected native void setFileModified(String var1, long var2);

    public native void sleep(int var1);

    public void source(String string) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("source " + string);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    protected native int statGetAttributes(String var1);

    protected native String statGetFileOwner(String var1);

    protected native String statGetFileOwnerGroup(String var1);

    protected native long statGetFileSize(String var1);

    public void touchFile(long l, String string) {
        this.setFileModified(string, l);
    }
}

