/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.installshield.util.FileAttributes;
import com.installshield.util.LibraryLoader;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinuxFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    private static String UX = "u+x";
    private static int S_ISUID = 2048;
    private static int S_ISGID = 1024;
    private static int S_ISVTX = 512;
    private static int S_IRWXU = 448;
    private static int S_IRUSR = 256;
    private static int S_IWUSR = 128;
    private static int S_IXUSR = 64;
    private static int S_IRWXG = 56;
    private static int S_IRGRP = 32;
    private static int S_IWGRP = 16;
    private static int S_IXGRP = 8;
    private static int S_IRWXO = 7;
    private static int S_IROTH = 4;
    private static int S_IWOTH = 2;
    private static int S_IXOTH = 1;
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();

    public int deleteDirectory(String string) throws ServiceException {
        return super.deleteDirectory(string);
    }

    public int deleteDirectory(String string, boolean bl, boolean bl2) throws ServiceException {
        return super.deleteDirectory(string, bl, bl2);
    }

    private static FileAttributes getAttributeObject(int n) {
        FileAttributes fileAttributes = new FileAttributes();
        if ((n & S_IRUSR) == S_IRUSR) {
            fileAttributes.setAttributeState(1, true);
        }
        if ((n & S_IRGRP) == S_IRGRP) {
            fileAttributes.setAttributeState(8, true);
        }
        if ((n & S_IROTH) == S_IROTH) {
            fileAttributes.setAttributeState(64, true);
        }
        if ((n & S_IWUSR) == S_IWUSR) {
            fileAttributes.setAttributeState(2, true);
        }
        if ((n & S_IWGRP) == S_IWGRP) {
            fileAttributes.setAttributeState(16, true);
        }
        if ((n & S_IWOTH) == S_IWOTH) {
            fileAttributes.setAttributeState(128, true);
        }
        if ((n & S_IXUSR) == S_IXUSR) {
            fileAttributes.setAttributeState(4, true);
        }
        if ((n & S_IXGRP) == S_IXGRP) {
            fileAttributes.setAttributeState(32, true);
        }
        if ((n & S_IXOTH) == S_IXOTH) {
            fileAttributes.setAttributeState(256, true);
        }
        return fileAttributes;
    }

    private String getCalendarField(Calendar calendar, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 2) {
            stringBuffer.append(calendar.get(n) + 1);
        } else {
            stringBuffer.append(calendar.get(n));
        }
        if (n != 1 && stringBuffer.length() < 2) {
            stringBuffer.insert(0, 0);
        }
        return stringBuffer.toString();
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        String string2 = this.commandLineInterface.listContents(string, 0);
        int n = Integer.parseInt(string2);
        return LinuxFileServiceImpl.getAttributeObject(n);
    }

    public String getFileOwner(String string) throws ServiceException {
        String string2 = this.commandLineInterface.listContents(string, 1);
        return string2;
    }

    public String getFileOwnerGroup(String string) throws ServiceException {
        String string2 = this.commandLineInterface.listContents(string, 2);
        return string2;
    }

    private static int getMode(FileAttributes fileAttributes) {
        int n = 0;
        if (fileAttributes.getAttributeState(1)) {
            n |= S_IRUSR;
        }
        if (fileAttributes.getAttributeState(8)) {
            n |= S_IRGRP;
        }
        if (fileAttributes.getAttributeState(64)) {
            n |= S_IROTH;
        }
        if (fileAttributes.getAttributeState(2)) {
            n |= S_IWUSR;
        }
        if (fileAttributes.getAttributeState(16)) {
            n |= S_IWGRP;
        }
        if (fileAttributes.getAttributeState(128)) {
            n |= S_IWOTH;
        }
        if (fileAttributes.getAttributeState(4)) {
            n |= S_IXUSR;
        }
        if (fileAttributes.getAttributeState(32)) {
            n |= S_IXGRP;
        }
        if (fileAttributes.getAttributeState(256)) {
            n |= S_IXOTH;
        }
        return n;
    }

    public String getName() {
        return "LinuxFileServiceImpl";
    }

    public String getNamedDirectory(String string) throws ServiceException {
        if (string.equals("home")) {
            return System.getProperty("user.home");
        }
        if (string.equals("install")) {
            return "/opt";
        }
        if (string.equals("lib")) {
            return "/usr/lib";
        }
        if (string.equals("log")) {
            return "/var/log";
        }
        if (string.equals("temp")) {
            return "/tmp";
        }
        if (string.equals("timestamp")) {
            return String.valueOf(new Date().getTime());
        }
        return super.getNamedDirectory(string);
    }

    public String getPartitionFormat(String string) throws ServiceException {
        String string2 = this.commandLineInterface.fileSystemType(string);
        int n = string2.indexOf(10);
        return this.getToken(string2.substring(n), " ", 2);
    }

    public long getPartitionFreeSpace(String string) throws ServiceException {
        String string2 = this.commandLineInterface.fileSystemInfo(string);
        int n = string2.indexOf(10);
        try {
            String string3 = this.getToken(string2.substring(n), " ", 4);
            return Long.valueOf(string3) * 1024L;
        }
        catch (Exception exception) {
            throw new ServiceException(200, exception.getMessage());
        }
    }

    public String[] getPartitionNames() throws ServiceException {
        Object object;
        String string = this.commandLineInterface.mountInfo();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(10);
        while (n2 != -1) {
            object = string.substring(n, n2);
            if (object.startsWith("/")) {
                vector.addElement(this.getToken((String)object, " ", 3));
            }
            n = n2 + 1;
            n2 = string.indexOf(10, n);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public int getPartitionType(String string) throws ServiceException {
        return 0;
    }

    public String getSeparator() {
        return "/";
    }

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (LinuxPlatform.isCompatibleWith(1, 0)) {
                this.commandLineInterface = this.commandLineInterface.returnCorrectDistribution();
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private String getToken(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return string3;
    }

    protected void initialized() {
        super.initialized();
        try {
            LibraryLoader.loadLibrary(this.getResource("linuxppk/libgenericlinuxcommands.so"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
            throw error;
        }
    }

    public boolean isPartitionWritable(String string) throws ServiceException {
        String string2 = this.commandLineInterface.mountInfo();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = string2.indexOf(10);
        while (n2 != -1 && !bl) {
            String string3 = string2.substring(n, n2);
            if (this.getToken(string3, " ", 3).compareTo(string) == 0) {
                bl = true;
                if (this.getToken(string3, " ", 6).indexOf(119) != -1) {
                    bl2 = true;
                }
            }
            n = n2 + 1;
            n2 = string2.indexOf(10, n);
        }
        return bl2;
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        int n = LinuxFileServiceImpl.getMode(fileAttributes);
        this.commandLineInterface.changeFilePermissions(n, string);
    }

    public void setFileCreated(String string, long l) throws ServiceException {
        throw new ServiceException(305);
    }

    public void setFileExecutable(String string) throws ServiceException {
        FileAttributes fileAttributes = this.getFileAttributes(string);
        int n = 292;
        fileAttributes.setAttributeState(n, true);
        this.commandLineInterface.changeFilePermissions(LinuxFileServiceImpl.getMode(fileAttributes), string);
    }

    public void setFileModified(String string, long l) throws ServiceException {
        this.commandLineInterface.touchFile(l, string);
    }

    public void setFileOwner(String string, String string2) throws ServiceException {
        this.commandLineInterface.changeFileOwner(string2, string);
    }

    public void setFileOwnerGroup(String string, String string2) throws ServiceException {
        this.commandLineInterface.changeFileGroup(string2, string);
    }

    public void setFileTimes(String string, long l, long l2, long l3) throws ServiceException {
        this.setFileModified(string, l3);
    }

    public boolean supportsLongFileNames(String string) throws ServiceException {
        try {
            File file = new File(String.valueOf(string) + "\\Longfilename.test.temporary");
            if (!file.exists()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.close();
                file.delete();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

