/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.LinuxProductComponentExtra;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionListener;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.actions.Files;
import com.installshield.product.iterators.ProductComponentTreeIterator;
import com.installshield.product.service.product.ProductServiceImplementor;
import com.installshield.product.service.product.PureJavaProductServiceImpl;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinuxProductServiceImpl
extends PureJavaProductServiceImpl
implements ProductServiceImplementor,
ProductActionListener {
    private static String specFileDir = "/tmp/specFile/";
    private static String SPEC = ".spec";
    private static Vector installedFiles = new Vector();
    private static String uninstallSource = null;
    private static int nameCounter = 0;
    private static String packageName = new String();
    private static String SUCCESS = "The installation completed without errors.";
    private static Vector specFiles = new Vector();
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();

    private void createSpecFile(ProductComponent productComponent) {
        Vector vector = this.getComponentInfo(productComponent);
        try {
            File file = new File(packageName);
            FileWriter fileWriter = new FileWriter(String.valueOf(specFileDir) + file + SPEC);
            int n = 0;
            while (n < vector.size()) {
                fileWriter.write((String)vector.elementAt(n));
                fileWriter.write("\n");
                ++n;
            }
            if (installedFiles.size() != 0) {
                fileWriter.write("\n%files\n");
                int n2 = 0;
                while (n2 < installedFiles.size()) {
                    File file2 = (File)installedFiles.elementAt(n2);
                    fileWriter.write(file2.getAbsolutePath());
                    fileWriter.write("\n");
                    ++n2;
                }
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            this.getServices().logEvent(this, "wrn", "Could not create SPEC File");
        }
        specFiles.addElement(String.valueOf(specFileDir) + packageName + SPEC);
    }

    private Vector getComponentInfo(ProductComponent productComponent) {
        Object object;
        Object object2;
        Dictionary dictionary = productComponent.getExtendedProperties();
        LinuxProductComponentExtra linuxProductComponentExtra = new LinuxProductComponentExtra();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = dictionary.get(object2);
            if (!object2.equals("linux") || !(object instanceof LinuxProductComponentExtra)) continue;
            linuxProductComponentExtra = (LinuxProductComponentExtra)object;
        }
        packageName = String.valueOf(this.getFullPackageName(productComponent)) + "-" + this.getPackageVersion(productComponent) + "-" + this.getPackageRelease(productComponent);
        object2 = this.getPackageVendor(productComponent);
        object = this.getPackageWebsite(productComponent);
        Vector<String> vector = new Vector<String>();
        vector.addElement("Name: " + this.getFullPackageName(productComponent));
        vector.addElement("Version: " + this.getPackageVersion(productComponent));
        vector.addElement("Release: " + this.getPackageRelease(productComponent));
        if (linuxProductComponentExtra.getSummary() != null && !linuxProductComponentExtra.getSummary().equals("") && !linuxProductComponentExtra.getSummary().equals("Required")) {
            vector.addElement("Summary: " + linuxProductComponentExtra.getSummary());
        } else {
            vector.addElement("Summary: NA");
        }
        if (linuxProductComponentExtra.getCopyright() != null && !linuxProductComponentExtra.getCopyright().equals("") && !linuxProductComponentExtra.getCopyright().equals("Required")) {
            vector.addElement("Copyright: " + linuxProductComponentExtra.getCopyright());
        } else {
            vector.addElement("Copyright: NA");
        }
        if (linuxProductComponentExtra.getGroup() != null && !linuxProductComponentExtra.getGroup().equals("") && !linuxProductComponentExtra.getGroup().equals("Required")) {
            vector.addElement("Group: " + linuxProductComponentExtra.getGroup());
        } else {
            vector.addElement("Group: NA");
        }
        if (!((String)object2).equals("") || object2 == null) {
            vector.addElement("Vendor: " + this.getPackageVendor(productComponent));
        }
        if (!((String)object).equals("") || object == null) {
            vector.addElement("URL: " + this.getPackageWebsite(productComponent));
        }
        if (!linuxProductComponentExtra.getDistribution().equals("") && linuxProductComponentExtra.getDistribution() != null) {
            vector.addElement("Distribution: " + linuxProductComponentExtra.getDistribution());
        }
        if (!linuxProductComponentExtra.getPackager().equals("") && linuxProductComponentExtra.getPackager() != null) {
            vector.addElement("Packager: " + linuxProductComponentExtra.getPackager());
        }
        if (!linuxProductComponentExtra.getProvides().equals("") && linuxProductComponentExtra.getProvides() != null) {
            vector.addElement("Provides: " + linuxProductComponentExtra.getProvides());
        }
        if (linuxProductComponentExtra.getAutoReqProv()) {
            vector.addElement("AutoReqProv: Yes");
        } else if (!linuxProductComponentExtra.getAutoReqProv()) {
            vector.addElement("AutoReqProv: No");
        }
        if (!linuxProductComponentExtra.getSource().equals("") && linuxProductComponentExtra.getSource() != null) {
            vector.addElement("Source: " + linuxProductComponentExtra.getSource());
        }
        if (!linuxProductComponentExtra.getPatch().equals("") && linuxProductComponentExtra.getPatch() != null) {
            vector.addElement("Patch: " + linuxProductComponentExtra.getPatch());
        }
        vector.addElement("\n%description\n" + linuxProductComponentExtra.getDescription());
        return vector;
    }

    private String getFullPackageName(ProductComponent productComponent) {
        Object object;
        Object object2;
        Dictionary dictionary = productComponent.getExtendedProperties();
        LinuxProductComponentExtra linuxProductComponentExtra = new LinuxProductComponentExtra();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = dictionary.get(object2);
            if (!object2.equals("linux") || !(object instanceof LinuxProductComponentExtra)) continue;
            linuxProductComponentExtra = (LinuxProductComponentExtra)object;
        }
        object2 = this.getPackageVersion(productComponent);
        object = this.getPackageName(productComponent);
        String string = this.getPackageRelease(productComponent);
        return object;
    }

    public String getName() {
        return "LinuxProductServiceImpl";
    }

    private String getPackageName(ProductComponent productComponent) {
        SoftwareObjectKey softwareObjectKey = productComponent.getKey();
        String string = softwareObjectKey.getUID();
        return string.replace(' ', '_');
    }

    private String getPackageRelease(ProductComponent productComponent) {
        SoftwareObjectKey softwareObjectKey = productComponent.getKey();
        SoftwareVersion softwareVersion = softwareObjectKey.getVersion();
        String string = null;
        if (softwareVersion.getMaintenance().equals("")) {
            GenericSoftwareObject genericSoftwareObject = productComponent.getParent();
            softwareObjectKey = genericSoftwareObject.getKey();
            softwareVersion = softwareObjectKey.getVersion();
            if (softwareVersion.getMaintenance().equals("")) {
                if ((genericSoftwareObject = genericSoftwareObject.getParent()) != null && (softwareVersion = (softwareObjectKey = genericSoftwareObject.getKey()).getVersion()).getMaintenance().equals("")) {
                    string = softwareVersion.getMaintenance();
                }
            } else {
                string = softwareVersion.getMaintenance();
            }
        } else {
            string = softwareVersion.getMaintenance();
        }
        if (string == null || string.equals("")) {
            string = "1";
        }
        return string;
    }

    private String getPackageVendor(ProductComponent productComponent) {
        GenericSoftwareObject genericSoftwareObject;
        String string = productComponent.getVendor();
        if (string == null && (string = (genericSoftwareObject = productComponent.getParent()).getVendor()) == null && (genericSoftwareObject = genericSoftwareObject.getParent()) != null) {
            string = genericSoftwareObject.getVendor();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String getPackageVersion(ProductComponent productComponent) {
        SoftwareObjectKey softwareObjectKey = productComponent.getKey();
        SoftwareVersion softwareVersion = softwareObjectKey.getVersion();
        String string = null;
        if (softwareVersion.getMajor().equals("") && softwareVersion.getMinor().equals("")) {
            GenericSoftwareObject genericSoftwareObject = productComponent.getParent();
            softwareObjectKey = genericSoftwareObject.getKey();
            softwareVersion = softwareObjectKey.getVersion();
            if (softwareVersion.getMajor().equals("") && softwareVersion.getMinor().equals("")) {
                if ((genericSoftwareObject = genericSoftwareObject.getParent()) != null && !(softwareVersion = (softwareObjectKey = genericSoftwareObject.getKey()).getVersion()).getMajor().equals("") && !softwareVersion.getMinor().equals("")) {
                    string = String.valueOf(softwareVersion.getMajor()) + "." + softwareVersion.getMinor();
                }
            } else {
                string = String.valueOf(softwareVersion.getMajor()) + "." + softwareVersion.getMinor();
            }
        } else {
            string = String.valueOf(softwareVersion.getMajor()) + "." + softwareVersion.getMinor();
        }
        if (string == null || string.equals("")) {
            string = "1.0";
        }
        return string;
    }

    private String getPackageWebsite(ProductComponent productComponent) {
        GenericSoftwareObject genericSoftwareObject;
        String string = productComponent.getVendorWebsite();
        if (string == null && (string = (genericSoftwareObject = productComponent.getParent()).getVendorWebsite()) == null && (genericSoftwareObject = genericSoftwareObject.getParent()) != null) {
            string = genericSoftwareObject.getVendorWebsite();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (LinuxPlatform.isCompatibleWith(1, 0)) {
                this.commandLineInterface.returnCorrectDistribution();
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private String getToken(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return string3;
    }

    private String locateRpmspec() {
        String string = this.commandLineInterface.locateExecutable("rpmspec");
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    protected void postInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        super.postInstallProduct(productTree, productActionSupport);
        boolean bl = false;
        String string = this.locateRpmspec();
        try {
            if (string != null && !string.equals("")) {
                productActionSupport.getOperationState().setStatusDescription(LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "LinuxProductServiceImpl.updatingRPMDatabase"));
                int n = 0;
                while (n < specFiles.size()) {
                    boolean bl2 = false;
                    int n2 = 0;
                    String string2 = (String)specFiles.elementAt(n);
                    String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
                    String string4 = this.commandLineInterface.findRPMPackage(string3);
                    if (string4.indexOf(45) == -1) {
                        while (!bl2) {
                            this.commandLineInterface.runRpmspec(string2);
                            String string5 = this.commandLineInterface.findRPMPackage(string3);
                            if (n2 == 12) {
                                String string6 = "The following RPM package could not be installed into RPM: " + string3;
                                this.getServices().logEvent(this, "wrn", string6);
                                bl = true;
                                bl2 = true;
                            }
                            if (string5.indexOf(45) != -1) {
                                bl2 = true;
                            } else {
                                Thread.sleep(1000L);
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {}
        if (bl) {
            String string7 = "The install could not successfully add the product information into the RPM database. Installation will continue as this is not critical to the installation of the product.";
            this.getServices().logEvent(this, "wrn", string7);
        }
        boolean bl3 = string != null && !string.equals("");
        specFiles.removeAllElements();
    }

    protected void postUninstallProduct(ProductActionSupport productActionSupport, String string) throws ServiceException {
        productActionSupport.getOperationState().setStatusDescription(LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "LinuxProductServiceImpl.removingFromRPMDatabase"));
        try {
            StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(this.getProductTree(uninstallSource).getRoot());
            ProductComponentTreeIterator productComponentTreeIterator = new ProductComponentTreeIterator(standardProductTreeIterator);
            ProductBean productBean = productComponentTreeIterator.getNext(productComponentTreeIterator.begin());
            while (productBean != productComponentTreeIterator.end()) {
                int n = 0;
                boolean bl = false;
                boolean bl2 = false;
                String string2 = String.valueOf(this.getFullPackageName((ProductComponent)productBean)) + "-" + this.getPackageVersion((ProductComponent)productBean) + "-" + this.getPackageRelease((ProductComponent)productBean);
                this.commandLineInterface.removeRPMPackage(string2);
                while (!bl) {
                    if (!(productBean instanceof ProductComponent)) continue;
                    if (!this.commandLineInterface.doesRPMPackageExist(string2)) {
                        bl = true;
                    } else if (n >= 20) {
                        String string3 = "The following RPM package could not be removed from RPM: " + string2;
                        this.getServices().logEvent(this, "wrn", string3);
                        bl2 = true;
                        bl = true;
                    } else {
                        Thread.sleep(1000L);
                    }
                    ++n;
                }
                productBean = productComponentTreeIterator.getNext(productBean);
            }
        }
        catch (ServiceException serviceException) {
            this.getServices().logEvent(this, "wrn", "Error: Could not create tree iterator");
        }
        catch (Exception exception) {}
    }

    protected void preInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        super.preInstallProduct(productTree, productActionSupport);
        this.commandLineInterface.makeDirectory(specFileDir);
    }

    protected boolean preInstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        String string;
        installedFiles = new Vector();
        productBean.getProductTree().addProductActionListener(this);
        boolean bl = super.preInstallProductComponent(productBean, productActionSupport);
        productBean.getProductTree().removeProductActionListener(this);
        if (productBean instanceof ProductComponent && (string = this.locateRpmspec()) != null && !string.equals("")) {
            this.createSpecFile((ProductComponent)productBean);
        }
        return bl;
    }

    public void productActionPerformed(ProductActionEvent productActionEvent) {
        Object object = productActionEvent.getSource();
        if (object instanceof Files && productActionEvent.getCommand().equals("createFile")) {
            installedFiles.addElement(productActionEvent.getData());
        }
    }

    public OperationKey uninstallProduct(ProductTree productTree) throws ServiceException {
        OperationKey operationKey = super.uninstallProduct(productTree);
        return operationKey;
    }

    public OperationKey uninstallProduct(String string) throws ServiceException {
        uninstallSource = string;
        OperationKey operationKey = super.uninstallProduct(string);
        return operationKey;
    }
}

