/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxFileServiceImpl;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;

public class LinuxSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    private static String EXPORT = "export ";
    private static String SETENV = "setenv ";
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();

    public void deleteEnvironmentVariable(String string) throws ServiceException {
        this.setEnvironmentVariable(string, null);
    }

    public String getEnvironmentVariable(String string) throws ServiceException {
        return this.commandLineInterface.getEnvVariable(string);
    }

    public String getName() {
        return "systemUtilService";
    }

    public String getOSServiceLevel() throws ServiceException {
        return this.commandLineInterface.getKernelVersion();
    }

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (LinuxPlatform.isCompatibleWith(1, 0)) {
                this.commandLineInterface = this.commandLineInterface.returnCorrectDistribution();
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public void setEnvironmentVariable(String string, String string2) throws ServiceException {
        String string3 = System.getProperty("user.home");
        String string4 = String.valueOf(EXPORT) + string + "=" + string2;
        String string5 = String.valueOf(SETENV) + string + " " + string2;
        this.updateSrcFile(String.valueOf(string3) + "/.shrc", string4);
        this.updateSrcFile(String.valueOf(string3) + "/.bashrc", string4);
        this.updateSrcFile(String.valueOf(string3) + "/.kshrc", string4);
        this.updateSrcFile(String.valueOf(string3) + "/.zshrc", string4);
        this.updateSrcFile(String.valueOf(string3) + "/.cshrc", string5);
        this.updateSrcFile(String.valueOf(string3) + "/.tcshrc", string5);
    }

    private void updateSrcFile(String string, String string2) throws ServiceException {
        File file = new File(string);
        LinuxFileServiceImpl linuxFileServiceImpl = new LinuxFileServiceImpl();
        String[] stringArray = new String[]{string2};
        linuxFileServiceImpl.appendToAsciiFile(string, stringArray);
        this.commandLineInterface.source(string);
    }
}

