/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ArchiveEntry;
import com.installshield.archive.URLResourceReader;
import com.installshield.archive.ZipEntryResourceReader;
import com.installshield.util.FileUtils;
import com.installshield.util.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveReader {
    private String archiveHome;
    private String openedZipFileName = null;

    public ArchiveReader(String string) throws FileNotFoundException {
        this(string, null);
    }

    public ArchiveReader(String string, String string2) throws FileNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("archiveName cannot be null");
        }
        File file = new File(string);
        if (file.exists()) {
            this.archiveHome = file.getAbsolutePath();
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            this.archiveHome = null;
            while (stringTokenizer.hasMoreTokens() && this.archiveHome == null) {
                file = new File(FileUtils.normalizeFileName(stringTokenizer.nextToken()));
                if (!file.isFile() || !file.getName().equals(string)) continue;
                this.archiveHome = file.getAbsolutePath();
            }
            if (this.archiveHome == null) {
                throw new FileNotFoundException("cannot find archive " + string + " in " + string2);
            }
        }
    }

    private void addFileEntries(File file, int n, Vector vector) throws IOException {
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory()) {
                this.addFileEntries(file2, n, vector);
            }
            if (file2.isFile() || file2.isDirectory()) {
                String string = this.format(file2);
                vector.addElement(new ArchiveEntry(string.substring(n), new URLResourceReader(new URL("file", "", -1, string))));
            }
            ++n2;
        }
    }

    public void close() throws IOException {
        if (this.openedZipFileName != null) {
            ZipEntryResourceReader.closeOpenZipFile(this.openedZipFileName);
            this.openedZipFileName = null;
        }
    }

    public Enumeration entries() throws IOException {
        Vector<ArchiveEntry> vector = new Vector<ArchiveEntry>();
        File file = new File(this.archiveHome);
        if (file.isFile()) {
            if (!ZipUtils.isZipEmpty(this.archiveHome)) {
                ZipFile zipFile = new ZipFile(file);
                this.openedZipFileName = this.archiveHome;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    vector.addElement(new ArchiveEntry(zipEntry.getName(), new ZipEntryResourceReader(zipFile.getName(), zipEntry.getName())));
                }
                zipFile.close();
            }
        } else if (file.isDirectory()) {
            String string = file.getAbsolutePath();
            int n = string.length();
            if (!string.endsWith("/") && !string.endsWith(File.separator)) {
                ++n;
            }
            this.addFileEntries(file, n, vector);
        }
        return vector.elements();
    }

    private String format(File file) {
        String string = file.getAbsolutePath();
        if (file.isDirectory() && !string.endsWith("/") && !string.endsWith(File.separator)) {
            return String.valueOf(string) + File.separator;
        }
        return string;
    }
}

