/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceWriter;
import com.installshield.archive.ResourceWriterFactory;
import com.installshield.archive.UnknownResourceTypeException;
import com.installshield.util.ClassUtils;
import java.io.File;
import java.io.IOException;

public abstract class DefaultResourceWriterFactory
implements ResourceWriterFactory {
    private String root;
    private String resourceRoot;

    public DefaultResourceWriterFactory(String string, String string2) throws IOException {
        this.root = string;
        this.resourceRoot = string2;
    }

    public ResourceWriter createClassResourceWriter(String string) {
        return this.createResourceWriter(this.createFileName(this.root, string));
    }

    public ResourceWriter createClassWriter(String string) {
        String string2 = this.createFileName(this.root, ClassUtils.getClassFileName(string));
        return this.createResourceWriter(string2);
    }

    public ResourceWriter createDefinitionWriter(String string) {
        return this.createResourceWriter(this.createFileName(this.root, String.valueOf(this.resourceRoot) + File.separatorChar + string));
    }

    protected String createFileName(String string, String string2) {
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + File.separator + string2;
    }

    public ResourceWriter createFileResourceWriter(String string) {
        return this.createResourceWriter(this.createFileName(this.root, String.valueOf(this.resourceRoot) + File.separatorChar + string));
    }

    public ResourceWriter createOtherWriter(String string, Object object) throws UnknownResourceTypeException {
        throw new UnknownResourceTypeException(string);
    }

    protected abstract ResourceWriter createResourceWriter(String var1);

    public String getResourceRoot() {
        return this.resourceRoot;
    }

    public String getRoot() {
        return this.root;
    }
}

