/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceReader;
import com.installshield.util.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipEntryResourceReader
implements ResourceReader {
    private static Hashtable openZipFiles = new Hashtable();
    private String fileName;
    private String entryName;
    private ZipFile file = null;
    private ZipEntry entry = null;

    public ZipEntryResourceReader(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        this.fileName = string;
        if (string2 == null) {
            throw new IllegalArgumentException("entryName cannot be null");
        }
        this.entryName = ZipUtils.cleanZipEntry(string2);
    }

    public void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    public static void closeOpenZipFile(String string) throws IOException {
        ZipFile zipFile = (ZipFile)openZipFiles.get(string);
        if (zipFile != null) {
            zipFile.close();
            openZipFiles.remove(string);
        }
    }

    public Date getDate() {
        return null;
    }

    public String getId() {
        return String.valueOf(this.fileName) + "!/" + this.entryName;
    }

    public int getSize() throws IOException {
        this.verifyMembers();
        return (int)Math.min(this.entry.getSize(), Integer.MAX_VALUE);
    }

    public static String getTypeDescription() {
        return "file resources";
    }

    public InputStream open() throws IOException {
        this.verifyMembers();
        return this.file.getInputStream(this.entry);
    }

    public static Enumeration openZipFileNames() {
        return openZipFiles.keys();
    }

    private void verifyMembers() throws IOException {
        if (this.file == null) {
            this.file = (ZipFile)openZipFiles.get(this.fileName);
            if (this.file == null) {
                this.file = new ZipFile(this.fileName);
                openZipFiles.put(this.fileName, this.file);
            }
            this.entry = this.file.getEntry(this.entryName);
            if (this.entry == null) {
                throw new IOException("entry " + this.entryName + " does not exist in " + this.file.getName());
            }
        }
    }
}

