/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.ijar;

import com.installshield.archive.ijar.IJAREntry;
import com.installshield.archive.ijar.IJARIndexReader;
import com.installshield.util.FileAttributes;
import com.installshield.util.MD5;
import com.installshield.util.ZipUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IJARReader {
    ZipFile zipFile;
    IJARIndexReader index;
    IJAREntry entry = null;
    int curEntry = -1;

    public IJARReader(String string) throws IOException {
        this.zipFile = new ZipFile(string);
        ZipEntry zipEntry = this.zipFile.getEntry("index");
        if (zipEntry == null) {
            throw new IOException("missing index zip entry in " + string);
        }
        this.index = new IJARIndexReader(ZipUtils.createZipInputStream(this.zipFile.getInputStream(zipEntry)));
    }

    public FileAttributes getAttributes(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.attributes;
    }

    public byte[] getDigest(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.digest;
    }

    public byte[] getExtra(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.extra;
    }

    public String getFileName(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.fileName;
    }

    public InputStream getInputStream(int n) throws IOException {
        String string = MD5.toHex(this.getDigest(n));
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        if (zipEntry == null) {
            throw new FileNotFoundException("missing entry for index " + n);
        }
        return ZipUtils.createZipInputStream(this.zipFile.getInputStream(zipEntry));
    }

    public long getLastModified(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.lastModified;
    }

    public long getSize(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.size;
    }

    public int getType(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.type;
    }
}

