/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.ijar;

import com.installshield.archive.ijar.IJAREntry;
import com.installshield.archive.ijar.IJARIndexWriter;
import com.installshield.util.FileAttributes;
import com.installshield.util.MD5;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class IJARWriter {
    private IJARIndexWriter index = new IJARIndexWriter();
    private ZipOutputStream zipOut;
    private int currentOffset = 0;
    private int lineDelimiter = 2;

    public IJARWriter(OutputStream outputStream) {
        this.zipOut = new ZipOutputStream(outputStream);
    }

    public IJAREntry addFile(String string, int n, String string2, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        return this.addFile(new URL("file", "", -1, string), n, string2, fileAttributes, l, byArray);
    }

    public IJAREntry addFile(URL uRL, int n, String string, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        IJAREntry iJAREntry;
        block5: {
            int n2;
            InputStream inputStream = uRL.openStream();
            MD5 mD5 = new MD5();
            byte[] byArray2 = new byte[5120];
            long l2 = 0L;
            while ((n2 = inputStream.read(byArray2)) != -1) {
                mD5.write(byArray2, 0, n2);
                l2 += (long)n2;
                if (n != 2) {
                    this.examineBytesForLineDelimiter(byArray2, 0, byArray2.length);
                    continue;
                }
                this.lineDelimiter = 2;
            }
            n = this.lineDelimiter;
            inputStream.close();
            byte[] byArray3 = mD5.toHash();
            iJAREntry = new IJAREntry(byArray3, string, n, l2, fileAttributes, l, byArray);
            String string2 = MD5.toHex(byArray3);
            ZipEntry zipEntry = new ZipEntry(string2);
            try {
                this.zipOut.putNextEntry(zipEntry);
                inputStream = uRL.openStream();
                while ((n2 = inputStream.read(byArray2)) != -1) {
                    this.zipOut.write(byArray2, 0, n2);
                }
                this.zipOut.closeEntry();
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("duplicate")) break block5;
                throw zipException;
            }
        }
        this.index.addEntry(iJAREntry);
        ++this.currentOffset;
        return iJAREntry;
    }

    public void close() throws IOException {
        ZipEntry zipEntry = new ZipEntry("index");
        this.zipOut.putNextEntry(zipEntry);
        this.index.write(this.zipOut);
        this.zipOut.closeEntry();
        this.zipOut.close();
    }

    public int currentOffset() {
        return this.currentOffset;
    }

    private void examineBytesForLineDelimiter(byte[] byArray, int n, int n2) {
        boolean bl = true;
        int n3 = n;
        boolean bl2 = false;
        while (bl && n3 < n + n2) {
            byte by = byArray[n3];
            if (by < 0 || by > 127) {
                bl = false;
                this.lineDelimiter = 2;
            } else if (!bl2) {
                if (by == 13) {
                    if (n3 < n + n2 - 1 && byArray[n3 + 1] == 10) {
                        this.lineDelimiter = 1;
                        ++n3;
                        bl2 = true;
                    }
                } else if (by == 10) {
                    this.lineDelimiter = 0;
                    bl2 = true;
                }
            }
            ++n3;
        }
    }
}

